/*
 * $Id: ilp.h,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


#ifndef __ILP__
#define __ILP__

/*
  Author:  Mikhail Posypkin

  Last Modification Date:  Apr 16 1999

  Description: methods for implementing instruction level parallelism features
               for both elementwise and reductive expressions
               

  Comments: 
  Usage:
*/

#include"Tree.h"
#include"IlpTree.h"

#define DEFAULT_REGISTER_WINDOW 4   /* default number of registers for holding one vector operand */

extern int unroll_4_assign ;         /* number of registers for holding one vector operand */

extern int register_window;         /* number of registers for holding one vector operand */


extern int  isIlp4AssignPossible(tTree); /* checks whether it is possible to use ilp techniques in
                                            assignement expressions */

extern tIlpTree constructIlpTree(tTree); /* translates tTree to more convinient for ilp tIlpTree
                                            representation */

extern void setRegs(tIlpTree);          /* sets registers in ilp tree constructed erlier */

extern void printRegisterTable();       /* prints register table (for debugging) */

extern void declOuterRegs();            /* declares registers that should be declared out of inner loop
                                           in nested loops system */

extern void calcOuterRegs();            /* assignes initial values to registers which should be initialized out
                                           of nested loops system */

extern void printBody(tIlpTree);        /* prints body of systems of nested loops */
#endif
