/*
 * $Id: VarDecl_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* code generation for MPC_VarDecl, MPC_Function and correspond nodes */
/* Coded by A.Kalinov 10.95 - */

#include "be_print.h"
static void print_Initializer(tTree , tTree);
static void set_net_fun_params(tTree );
static int InitLine(tTree );
/*int net_topology(tTree );*/

static tTree pCurInit;
static tTree pCurInitList;
static int last_init;
static int right_braces;
static int left_braces;

void print_VarDecl(tTree pVarDecl) {
  tTree pDeclSpec;
  tTree pVar;
  int old_in_var_decl=in_var_decl;
  tTree old_pCurParamList=pCurParamList;
  tTree old_pCurExprs=pCurExprs;
  if(prt) printf("VarDecl generation is started \n");
  in_var_decl=1;
  PointerControl(pVarDecl);
  pDeclSpec=pVarDecl->MPC_VarDecl.DeclSpecifier;
  PointerControl(pDeclSpec);
  pVar=pVarDecl->MPC_VarDecl.Var;
  PointerControl(pVar);
  /*c_blank;*/
  print_VarStorageClass(pVarDecl->MPC_VarDecl.Flag);
  pCurDeclSpec=NoTree;
  if(pVar->Kind == kMPC_FreeNode) print_base_type=1;
  print_Type(pDeclSpec);
  if(pVar->Kind == kMPC_FreeNode) print_base_type=0;
  pCurDeclSpec=pDeclSpec;
  {
    while(pVar->Kind != kMPC_FreeNode) {
      set_net_fun_params(pVar);
      print_Var(pVar);
      pCurParamList=old_pCurParamList;
      pCurExprs=old_pCurExprs;
      pVar=pVar->MPC_Var.Next;
      PointerControl(pVar);
      if(pVar->Kind != kMPC_FreeNode) {
	fputs(",",file);
	cur_pos++;
      }
    }
  }
  pCurDeclSpec=NoTree;
  in_var_decl=old_in_var_decl;
  if(prt) printf("VarDecl generation is ended \n");
}

void print_VarStorageClass(tDeclFlags flag) {
  char* ClassName[3]={"extern","static","register"};
  int i,j=-1;
  i=flag.Auto+flag.Static+flag.Register+flag.Extern+flag.Exported;
  if(i == 0) return;
  if(i>1) {
    fprintf(stderr,"invalid declaration flag \n");
    fprintf(stderr,"Auto=%u Static=%u Register=%u Extern=%u Exported=%u\n",
	   flag.Auto,flag.Static,flag.Register,flag.Extern,flag.Exported);
    internal_error();
  }
  if(flag.Auto || flag.Exported) return;
  if(flag.Extern) j=0;
  if(flag.Static) j=1;
  if(flag.Register) j=2;
  cur_pos+=fprintf(file,"%s ",ClassName[j]);
}


static char aux_pointer[64];
 
char* AuxPointerName(tTree pVar, tTree pCompound)
{
char buf[5]="";
aux_pointer[0]=0;
strcat(aux_pointer,AUX_POINTER);
sprintf(buf,"%d",pCompound->MPC_Compound.UniqueNumber); 
strcat(aux_pointer,buf);
strcat(aux_pointer,"_");
strcat(aux_pointer,VarName(pVar));
return aux_pointer; 
}

void print_Var(tTree pVar) {
  tTree pType,pInit;
  if(prt) printf("  Var generation is started \n");
  PointerControl(pVar);
  /*Position=pVar->MPC_Var.Pos;*/
  pType=pVar->MPC_Var.Type;
  PointerControl(pType);
  print_LeftType(pType,NoTree);
  if(prt) printf("topo_fun_code=%d MAIN=%d NOT_TOPO_FUN=%d is_topo_fun=%d\n",
         topo_fun_code,MAIN,NOT_TOPO_FUN,is_topo_fun);
  fprintf(file,VarName(pVar));
  print_RightType(pType,NoTree);
  pInit=pVar->MPC_Var.Init;
  if(pInit != NoTree && pInit->Kind != kMPC_FreeNode) {
    print_Initializer(pVar->MPC_Var.Init,pType);
   }
  if((is_dynamic_type(pType)==DYNAMIC_ARRAY)&&(!in_net_param_list))
    {
    fprintf(file,",");
    print_LeftType(pType,NoTree);
    fprintf(file,"* %s",AuxPointerName(pVar,cur_block));
    print_RightType(pType,NoTree);
    fprintf(file," = &%s",VarName(pVar));
    }
 if(prt) printf("Var generation is ended \n");
}

static void  fill_interval(tTree pElementType) {
  be_error
    ("sorry, initialization of the array with step > 1 isn't supported now");
/*  PointerControl(pElementType);
  switch(pElementType->Kind) {
  case kMPC_BasicType:
  case kMPC_EnumType:
    if(last_init) 
      cur_pos+=fputs(",0",file);
    else 
      cur_pos+=fputs("0,",file);
    break;
  case kMPC_Typedef:
    {
      tTree pType=pElementType->MPC_Typedef.Type;
      PointerControl(pType);
      fill_interval(pType);
    }
    break;
  case kMPC_ArrayType:
    {
      int Num=pElementType->MPC_ArrayType.NumberOfComponents;
      tTree pType=pElementType->MPC_ArrayType.ElementType;
      int i;
      PointerControl(pType);
      for(i=0; i<Num; i++) {
        fill_interval(pType);
      }
    }
    break;
  case kMPC_PointerType:
    if(last_init) 
      cur_pos+=fputs(",NULL",file);
    else 
      cur_pos+=fputs("NULL,",file);
    break;
  case kMPC_StructType:
    {
      tTree pMemberDecls=pElementType->MPC_StructType.MemberDecls;
      PointerControl(pMemberDecls);
      while(pMemberDecls->Kind != kMPC_FreeNode) {
        tTree pMember=pMemberDecls->MPC_SU_MemberDecl.Member;
        tTree pMemberType;
        PointerControl(pMember);
        while(pMember->Kind != kMPC_FreeNode) {
          pMemberType=pMember->MPC_SU_Member.Type;
          PointerControl(pMemberType);
          fill_interval(pMemberType);
          pMember=pMember->MPC_SU_Member.Next;
          PointerControl(pMember);
        }
        pMemberDecls=pMemberDecls->MPC_SU_MemberDecl.Next;
        PointerControl(pMemberDecls);
      }
    }
    break;
  case kMPC_UnionType:
    be_error("sorry, interval of the union type isn't supported now");
    break;
  default:
    fprintf(stderr,"wrong type in InitList with step != 1\n");
    internal_error();
    break;
  }*/
}

static tTree NextInit(tTree pInit) {
  PointerControl(pInit);
  switch (pInit->Kind) {
  case kMPC_SimpleInit:
    pInit=pInit->MPC_SimpleInit.Next;
    if(pInit == NoTree || pInit->Kind == kMPC_SimpleInit) break;
    while(pInit->Kind == kMPC_FreeNode) {
      pInit=pInit->MPC_FreeNode.Parent;
      right_braces++;
      /*cur_pos+=fputs("}",file);*/
      PointerControl(pInit);
      /* I did not understand why the following line was deleted */
      if(pInit->Kind==kMPC_InitList) {
        /* */
        pInit=pInit->MPC_InitList.Next;
      }
      if(pInit == NoTree) break;
    }
    if(pInit == NoTree) break;
  case kMPC_InitList:
    while(pInit->Kind == kMPC_InitList) {
      left_braces++;
      /*cur_pos+=fputs("{",file);*/
      pInit=pInit->MPC_InitList.List;
      PointerControl(pInit);
    }
    break;
  }
  last_init=pInit == NoTree || pInit->Kind == kMPC_FreeNode;
  return pInit;
}
  
static void print_Init(tTree pType) {
  if(prt) printf("print_Init pCurInit=%p pCurInit->Kind=%d\n",
                 pCurInit,pCurInit->Kind);
  PointerControl(pType);
  switch(pType->Kind) {
  case kMPC_ArrayType:
    if(prt) printf("print_Init array begin pType=%p",pType); 
    {
      int Step=pType->MPC_ArrayType.Step;
      int Num=pType->MPC_ArrayType.NumberOfComponents;
      tTree pElementType=pType->MPC_ArrayType.ElementType;
      int i,j;
      PointerControl(pElementType);
      if(prt) printf(" Num=%d Step=%d ElemType=%p\n",
                     Num,Step,pElementType);
      /*for(i=0; i<Num; i++) {*/
      i=0;
      while(Num == UNDEFINED ? !last_init : i<Num) {
        if(pCurInit->Kind == kMPC_FreeNode) break;
        print_Init(pElementType);
        if(last_init) break;
        for(j=1; j<Step; j++) {
          fill_interval(pElementType);
        }
        i++;
      }
    }
    if(prt) printf("print_Init array end pType=%p\n",pType); 
    break;
  case kMPC_StructType:
    if(prt) printf("print_Init struct begin pType=%p",pType); 
    {
      tTree pMemberDecls=pType->MPC_StructType.MemberDecls;
      tTree pEquivType;
      pEquivType=pType;
      while(pMemberDecls == NoTree) {
        pEquivType=pEquivType->MPC_StructType.EquivType;
        pMemberDecls=pEquivType->MPC_StructType.MemberDecls;
      }
      PointerControl(pMemberDecls);
      while(pMemberDecls->Kind != kMPC_FreeNode) {
        tTree pMember=pMemberDecls->MPC_SU_MemberDecl.Member;
        tTree pMemberType;
        PointerControl(pMember);
        while(pMember->Kind != kMPC_FreeNode) {
          pMemberType=pMember->MPC_SU_Member.Type;
          PointerControl(pMemberType);
          if(pCurInit->Kind == kMPC_FreeNode) break;
          print_Init(pMemberType);
          if(last_init) break;
          pMember=pMember->MPC_SU_Member.Next;
          PointerControl(pMember);
        }
        if(last_init) break;
        pMemberDecls=pMemberDecls->MPC_SU_MemberDecl.Next;
        PointerControl(pMemberDecls);
      }
    }
    if(prt) printf("print_Init struct end pType=%p\n",pType); 
    break;
  case kMPC_UnionType:
    if(prt) printf("print_Init union begin pType=%p",pType); 
    {
      tTree pMemberDecls=pType->MPC_UnionType.MemberDecls;
      tTree pEquivType;
      pEquivType=pType;
      while(pMemberDecls == NoTree) {
        pEquivType=pEquivType->MPC_UnionType.EquivType;
        pMemberDecls=pEquivType->MPC_UnionType.MemberDecls;
      }
      PointerControl(pMemberDecls);
      /*while(pMemberDecls->Kind != kMPC_FreeNode)*/ {
        tTree pMember=pMemberDecls->MPC_SU_MemberDecl.Member;
        tTree pMemberType;
        PointerControl(pMember);
        /*while(pMember->Kind != kMPC_FreeNode)*/ {
          pMemberType=pMember->MPC_SU_Member.Type;
          PointerControl(pMemberType);
          if(pCurInit->Kind == kMPC_FreeNode) break;
          print_Init(pMemberType);
          if(last_init) break;
          pMember=pMember->MPC_SU_Member.Next;
          PointerControl(pMember);
        }
        if(last_init) break;
        pMemberDecls=pMemberDecls->MPC_SU_MemberDecl.Next;
        PointerControl(pMemberDecls);
      }
    }
    if(prt) printf("print_Init union end pType=%p\n",pType); 
    break;
  case kMPC_Typedef:
    if(prt) printf("print_Init typedef begin pType=%p",pType); 
    {
      tTree pElementType=pType->MPC_Typedef.Type;
      PointerControl(pElementType);
      print_Init(pElementType);
    }
    if(prt) printf("print_Init typedef end pType=%p",pType); 
    break;
  default:
    if(prt) printf("print_Init other begin pType=%p",pType);
    {
      int cur_line;
      cur_line=InitLine(pCurInit);
      print_Expr(pCurInit->MPC_SimpleInit.Expr);
      pCurInit=NextInit(pCurInit);
      for( ; right_braces>0; right_braces--) {
        cur_pos+=fputs("}",file);
      }      
      if(pCurInit != NoTree && pCurInit->Kind != kMPC_FreeNode) {
        cur_pos+=fputs(",",file);
        if(cur_line != InitLine(pCurInit)) {
          cur_pos+=fputs("\n  ",file);
          c_blank;
        }
      }
    }
    for( ; left_braces>0; left_braces--) {
      cur_pos+=fputs("{",file);
    }      
    if(prt) printf("print_Init other end pType=%p\n",pType); 
    break;
  }
}
  
static void print_Initializer(tTree pInit, tTree pType) {
  int old_not_check=not_check;
  PointerControl(pInit);
  PointerControl(pType);
  not_check=1;
  last_init=0;
  cur_pos+=fputs("=",file);
  if(pInit->Kind == kMPC_SimpleInit) {
    pCurInitList=NoTree;
    pCurInit=pInit;
  }
  else {
    pCurInit=NextInit(pInit);
    for( ; left_braces>0; left_braces--) {
      cur_pos+=fputs("{",file);
    }      
  }
  PointerControl(pCurInit);
  print_Init(pType);
  not_check=old_not_check;
}

static int InitLine(tTree pCurInit) {
  tPosition Position;
  PointerControl(pCurInit);
  Position=pCurInit->MPC_Initializer.Pos;
  return RealPosition(Position).Line;
}

static int set_main_function(tTree pVar) {
  tIdent Ident;
  int ret=0;
  PointerControl(pVar);
  Ident=pVar->MPC_Var.Ident;
  if(Ident != NoIdent) {
    GetString(Ident,IdentBuf);
    ret=(strcmp(IdentBuf,"main")==0);
  }
  return ret;
}

static int network_fun_kind(tTree pFun) {
  int ret=0;
  tTree pName,pType;
  PointerControl(pFun);
  pName=pFun->MPC_Function.Name;
  PointerControl(pName);
  pType=pName->MPC_Var.Type;
  PointerControl(pType);
  if(pType->MPC_FunctionType.Kind == NETWORK) {
    tTree pNetParamType=pType->MPC_FunctionType.NetParamType;
    ret++;
    if(pNetParamType != NoTree &&
       pNetParamType->Kind != kMPC_FreeNode) {
      tTree pArgList=pNetParamType->MPC_NetTypeSpecifier.ArgList;
      ret++;
      if(pArgList != NoTree &&
         pArgList->Kind != kMPC_FreeNode) ret++;
    }
  }
  if(prt) printf("network_fun_kind pFun=%p ret=%d\n",pFun,ret);
  return ret;
}

static void print_ArrayLen(tTree pType) {
  int NumberOfComponents;
  PointerControl(pType);
  if(pType->Kind != kMPC_ArrayType) {
    fprintf(stderr,"not array type %p (Kind=%d)\n",pType,pType->Kind);
    internal_error();
  }
  NumberOfComponents=pType->MPC_ArrayType.NumberOfComponents;
  while(pType->Kind == kMPC_ArrayType) {
    if(NumberOfComponents == UNDEFINED || NumberOfComponents == 0) {
      tTree pSize=pType->MPC_ArrayType.ArraySize;
      PointerControl(pSize);
      cur_pos+=fprintf(file,"(");
      if(prt) printf("\nbefore size pSize->Kind=%d\n\n",pSize->Kind);
      print_Expr(pSize);
      cur_pos+=fprintf(file,")");
    }
    else {
      cur_pos+=fprintf(file,"%d",NumberOfComponents);
    }
    pType=pType->MPC_ArrayType.ElementType;
    PointerControl(pType);
    if(pType->Kind == kMPC_ArrayType) {
      cur_pos+=fprintf(file,"*");
    }
  }
}

void print_ParamNumber(tTree pVar, int num) {
  int n=0;
  tTree old_parent_expr=parent_expr;
  int old_change_net=not_change_net;
  tTree old_pCurExprs=pCurExprs;
  int old_real_param=real_param;
  PointerControl(pVar);
  parent_expr=NoTree;
  not_change_net=1;
  if(num == 0) {
    cur_pos+=fprintf(file,"0");
    return;
  }
  pCurExprs=pVar;
  while(pVar->Kind != kMPC_FreeNode) {
    tTree pType=NoTree;
    switch(pVar->Kind) {
    case kMPC_Var:
      pType=pVar->MPC_Var.Type;
      break;
    case kMPC_Exprs:
      {
        tTree pExpr=pVar->MPC_Exprs.Expr;
        PointerControl(pExpr);
        pType=pExpr->MPC_Expr.Type;
      }
      break;
    default:
      fprintf(stderr,"invalid kind of the topology list element\n");
      internal_error();
      break;
    }
    PointerControl(pType);
    if(prt) {
      printf("print_ParamNumber Type->Kind=%d\n",pType->Kind);
      fflush(stdout);
    }
    if(n != 0) {
      cur_pos+=fprintf(file,"+");
    }
    switch(pType->Kind) {
    case kMPC_BasicType:
      cur_pos+=fprintf(file,"1");
      break;
    case kMPC_ArrayType:
      real_param=1;
      print_ArrayLen(pType);
      real_param=old_real_param;
      break;
    default:
      fprintf(stderr,"invalid type of the topology parameter\n");
      internal_error();
      break;
    }
    if(n++ == num-1) return; 
    else {
      pVar=pVar->Kind == kMPC_Var ? pVar->MPC_Var.Next :
            pVar->MPC_Exprs.Next;
      PointerControl(pVar);
    }
  }
  not_change_net=old_change_net;
  parent_expr=old_parent_expr;
  pCurExprs=old_pCurExprs;
}

int all_known_len(tTree pVar) {
  int ret=0;
  PointerControl(pVar);
  while(pVar->Kind != kMPC_FreeNode) {
    tTree pType=NoTree;
    switch(pVar->Kind) {
    case kMPC_Var:
      pType=pVar->MPC_Var.Type;
      break;
    case kMPC_Exprs:
      {
        tTree pExpr=pVar->MPC_Exprs.Expr;
        PointerControl(pExpr);
        pType=pExpr->MPC_Expr.Type;
      }
      break;
    default:
      fprintf(stderr,"Invalid kind of the topology list element\n");
      internal_error();
      break;
    }
    PointerControl(pType);
    if(prt) printf("all_known_len Type->Kind=%d\n",pType->Kind);
    ret+=variable_len_array(pType);
    pVar=pVar->Kind == kMPC_Var ? pVar->MPC_Var.Next :
      pVar->MPC_Exprs.Next;
    PointerControl(pVar);
  }
  return ret;
}

void print_CopyParams(tTree pNet, tTree pNetType, tTree pVar) {
  int num=0;
  int old_change_net=not_change_net;
  tTree pParamList;
  tTree pArgList=pVar;
  tTree old_pCurParamList=pCurParamList;
  tTree old_pCurExprs=pCurExprs;
  int old_real_param=real_param;
  PointerControl(pNet);
  PointerControl(pNetType);
  PointerControl(pVar);
  not_change_net=1;
  parent_expr=NoTree;
  pParamList=pNetType->MPC_NetType.ParamList;
  PointerControl(pParamList);
  pCurParamList=pParamList;
  pCurExprs=pVar;
  if(all_known_len(pParamList) > 0) {
    int pos;
    c_blank;
    pos=cur_blank+fprintf(file,"%s_params=",VarName(pNet/*Type*/));
    pos+=fprintf(file,"(MPC_Parameters*)MPC_Malloc(");
    fprintf(file,"sizeof(MPC_Parameters)*\n");
    blank(pos);
    fprintf(file,"%s.count);\n",VarName(pNet));
  }
  c_blank;
  fprintf(file,"%s.params=",VarName(pNet));
  fprintf(file,"%s_params;\n",VarName(pNet/*Type*/));
  if(pVar->Kind != kMPC_FreeNode) {
    c_blank;
    fprintf(file,"{\n");
    cur_blank+=SKIP;
    {
      tTree pVarList=pVar;
      if(pVarList != NoTree) {
        while(pVarList->Kind != kMPC_FreeNode) {
          tTree pType;
          pType=pVarList->Kind == kMPC_Var ? pVarList->MPC_Var.Type :
            pVarList->MPC_Exprs.Expr->MPC_Expr.Type;
          PointerControl(pType);
          if(pType->Kind ==kMPC_ArrayType) {
            c_blank;
            fprintf(file,"int MPC_ind,MPC_bound;\n");
            break;
          }
          pVarList=pVarList->Kind == kMPC_Var ? pVarList->MPC_Var.Next :
            pVarList->MPC_Exprs.Next;
          PointerControl(pVarList);
        }
      }
    }
    while(pVar->Kind != kMPC_FreeNode) {
      tTree pType,pArgVar,pTerminalType;
      int cast;
      pArgVar=pVar->Kind == kMPC_Var ? pVar :
        pVar->MPC_Exprs.Expr;
      PointerControl(pArgVar);
      pType=pVar->Kind == kMPC_Var ? pVar->MPC_Var.Type :
        pVar->MPC_Exprs.Expr->MPC_Expr.Type;
      PointerControl(pType);
      if(prt) printf("pVar=%p pType=%p pType->Kind=%d pArgVar->Kind=%d\n",
             pVar,pType,pType->Kind,pArgVar->Kind);
      /* 17.03.99 bench changes begin */
      pTerminalType=get_TerminalType(pType);
      PointerControl(pTerminalType);
      if(pTerminalType->Kind != kMPC_BasicType) {
        fprintf(stderr,"terminal type of the topo parameters is not BasicType Kind=%d \n",pTerminalType->Kind); 
        internal_error();
      }
      cast=pTerminalType->MPC_BasicType.TypeConstructor != -7;
      /* 17.03.99 bench changes end */
      c_blank;
      switch(pType->Kind) {
      case kMPC_ArrayType:
        fprintf(file,"MPC_bound=");
        real_param=1;
        print_ArrayLen(pType);
        real_param=old_real_param;
        fprintf(file,";\n");
        c_blank;
        fprintf(file,"for(MPC_ind=0;MPC_ind<MPC_bound;MPC_ind++)\n");
        c_blank;
        fprintf(file,"  %s_params[",VarName(pNet));
        print_ParamNumber(pArgList,num++);
        fprintf(file,"+MPC_ind]=%s(%s(",cast ? "(int)" : "",
                cast ? "MPC_FIXPOINT_SCALE*" : "");
        fprintf(file,"%s",cast ? "(double*)" : "(int*)");
        if(pArgVar->Kind == kMPC_Var) {
          /*fprintf(file,"+MPC_ind]=((int*)%s)[MPC_ind];\n",VarName(pArgVar));*/
          fprintf(file,"%s",VarName(pArgVar));
        }
        else {
          /*fprintf(file,"+MPC_ind]=%s(%s(",cast ? "(int)" : "",
                  cast ? "MPC_FIXPOINT_SCALE*" : "");*/
          print_Expr(pArgVar);
          /*fprintf(file,"))[MPC_ind];\n");*/
        }
        fprintf(file,")[MPC_ind]);\n");
        break;
      case kMPC_BasicType:
        fprintf(file,"%s_params[",VarName(pNet));
        print_ParamNumber(pArgList,num++);
        fprintf(file,"]=");
        fprintf(file,"%s(",cast ? "MPC_FIXPOINT_SCALE*" : "");
        if(pArgVar->Kind == kMPC_Var) {
          if(ordinar_var(pArgVar)) {
            fprintf(file,"%s",VarName(pArgVar));
          }
          else {
            tTree pInit=pVar->MPC_Var.Init;
            PointerControl(pInit);
            print_Expr(pInit);
          }
        }
        else {
          print_Expr(pArgVar);
        }  
        fprintf(file,");\n");
        break;
      default:
        fprintf(stderr,"invalid type of the topology parameter\n");
        internal_error();
        break;
      }
      pVar=pVar->Kind == kMPC_Var ? pVar->MPC_Var.Next :
        pVar->MPC_Exprs.Next;
      PointerControl(pVar);
    }
    b_end;
  }
  not_change_net=old_change_net;
  pCurParamList=old_pCurParamList;
  pCurExprs=old_pCurExprs;
  if(prt) printf("end of the print_CopyParams\n");
}

static void print_NetworkFunctionHead(tTree pFun) {
  tTree pName,pType,pNet,pNetParamType,pNetworkParamList,pStat;
  tDeclFlags flag;
  PointerControl(pFun);
  pName=pFun->MPC_Function.Name;
  PointerControl(pName);
  pType=pName->MPC_Var.Type;
  PointerControl(pType);
  pNet=pType->MPC_FunctionType.NetParam;
  PointerControl(pNet);
  if(pNet->MPC_NetOrSubnet.pGen == NoGen) {
    tGen pNetNode;
    tGen pSingleNodeGen=SINGLE_NODE->MPC_Net.pGen;
    tGen pChild;
    GenControl(pSingleNodeGen);
    pChild=pSingleNodeGen->Net.Children;
    pStat=pFun->MPC_Function.Stats;
    PointerControl(pStat);

    pNetNode=mNet(DYNAMIC/*net_topology(pNet)*/,UNKNOWN,
                  pNet->MPC_NetOrSubnet.SingleNode,
                  pNet->Kind == kMPC_Net ? 0 : 1, 1,
                  pNet,1,1,0,
                  pStat,0,make_string(""),
                  NoGen,pSingleNodeGen,0,
                  pStat->MPC_Compound.UniqueNumber,NoTree,1);
    pNet->MPC_NetOrSubnet.pGen=pNetNode;
    pSingleNodeGen->Net.Children=mNets(pNetNode,
                                   pSingleNodeGen->Net.Children);
  }
  pNetParamType=pType->MPC_FunctionType.NetParamType;
  pNetworkParamList=pType->MPC_FunctionType.NetworkParamList;
  pCurExprs=pNetworkParamList;
  real_param=1;
  if(pNetParamType != NoTree &&
       pNetParamType->Kind != kMPC_FreeNode) {
    tTree pNetType,pNetTypeSpec;
    int pos;
    flag.Auto=1;
    flag.Extern=0;
    flag.Static=0;
    pNetTypeSpec=pNet->MPC_Net.NetType;
    PointerControl(pNetTypeSpec);
    pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
    pCurParamList=pNetType->MPC_NetType.ParamList;
    /*PointerControl(pCurParamList);*/
    var_fun_net=pNet;
    var_fun_net_type=pNetType;
    var_fun_net_paramlist=pNetworkParamList;
    var_fun_net_paramtype=pNetParamType;
    cur_pos+=fprintf(file,"{\n");
    cur_blank+=SKIP;
    print_CoordArray(pNet,pNetType,flag);
    if(pNetworkParamList != NoTree &&
       pNetworkParamList->Kind != kMPC_FreeNode) {
      c_blank;
      if(all_known_len(pNetworkParamList) == 0) {
        fprintf(file,"MPC_Parameters %s_params[",VarName(pNet));
        print_ParamNumber(pNetworkParamList,-1);
        fprintf(file,"];\n");
      }
      else {
        var_param_net=pNet;
        fprintf(file,"MPC_Parameters* %s_params;\n",VarName(pNet));
      }
    }
    c_blank;
    pos=cur_pos+fprintf(file,"MPC_Net %s",VarName(pNet));
    pos+=fputs("={",file);
    fprintf(file,"NULL,\n");
    blank(pos);
    fprintf(file,"&%s,\n",VarName(pNetType));
    blank(pos);
    fputs("0,NULL,MPC_AUTO_NET,NULL,0,\n",file);
    blank(pos);
    fprintf(file,"MPC_INIT_POWER,NULL,NULL,0,0,\n");
    blank(pos);
    fprintf(file,"NULL,NULL,NULL,NULL,NULL,NULL,\n");
    fprintf(file,"%s,0,NULL,NULL};\n",(pNetType->MPC_NetType.Bench == 1) ?
            "MPC_BENCH" : "MPC_NOT_BENCH");
  }
}

void void_fun(tTree yyt) {
  if(prt) printf("void_fun yyt=%p Kind=%d",yyt,yyt->Kind);
  if(yyt->Kind == kMPC_FreeNode) {
    if(prt) printf(" parent=%p\n",yyt->MPC_FreeNode.Parent);
  }
  else {
    if(prt) printf("\n") ;
  }
}

static void stat_numering(tTree yyt) {
  if(yyt != NoTree && Tree_IsType(yyt,kMPC_Stat)) {
    yyt->MPC_Stat.UniqueNumber=++stat_num;
  }
}

void print_Function(tTree pFun) {
  tTree old_cur_act=cur_act_net;
  int old_in_var_decl=in_var_decl;
  tTree pVar;
  tTree pStats;
  tTree pDistribution;
  PointerControl(pFun);
  function_kind=pFun->MPC_Function.Kind;
  var_param_net=NoTree;
  var_fun_net=NoTree;
  if(prt) printf("\n print_Function pFun=%p Kind=%d\n\n",pFun,function_kind);
  Stat_stack_Init();
  /*  fputs("\n",file);*/
  pVar=pFun->MPC_Function.Name;
  PointerControl(pVar);
  pStats=pFun->MPC_Function.Stats;
  PointerControl(pStats);
  {
    tTree pCurStat=pStats->MPC_Compound.Stats;
    tTree pNext;
    while(pCurStat != NoTree && pCurStat->Kind != kMPC_FreeNode) {
      pNext=pCurStat->MPC_Stats.Next;
      if(pNext != 0 && pNext->Kind == kMPC_FreeNode &&
         pCurStat->Kind == kMPC_Return) {
        the_last_is_return=1;
        break;
      }
      pCurStat=pNext;
    }
  }
  cur_blank=0;
  cur_pos=0;
  pDistribution=pFun->MPC_Function.Distribution;
  PointerControl(pDistribution);
  cur_act_net=pDistribution->MPC_NetOrSubnet.MyList;
  fun_distr=pDistribution;
  if(pDistribution == HOST) {
    host_function=1;
    /*host_stat=1;*/
  }
  if(prt) printf("host_function=%d\n",host_function);
  in_var_decl=1;
  not_check=1;
  if(pFun->MPC_Function.Flag.Static) cur_pos+=fprintf(file,"static ");
  is_main_function=set_main_function(pVar);
  if(is_main_function) {
    tTree pType=pVar->MPC_Var.Type;
    tTree pResultType;
    PointerControl(pType);
    pResultType=pType->MPC_FunctionType.ResultType;
    PointerControl(pResultType);
    print_base_type=1;
    print_Type(pResultType);
    print_base_type=0;
    cur_pos+=fprintf(file," main(int argc, char **argv)");
  }
  else {
    print_Var(pVar);
  }
  in_var_decl=old_in_var_decl;
  if(function_kind == BASIC) {
    first_waiting_point_in_function=1;
  }
  cur_pos+=fputs(" ",file);
  blank_is_necessary=0;
  in_function=1;
  stat_num=0;
  if(prt) printf("before stat_numering\n");
  /*TraverseTreeTD(pFun,stat_numering);*/
  Stat_traverse(pStats,stat_numering);
  if(prt) printf("after stat_numering\n");
  if(host_function && pass_number > 1) {
    fprintf(file,"{ ; }\n");
  }
  else {
    if(network_fun_kind(pFun) > 1) {
      print_NetworkFunctionHead(pFun);
    }
    not_check=0;
    c_blank;
    Stats_print(pStats);
    if(function_kind == NETWORK) {
      if(var_param_net != NoTree) {
        c_blank; 
        fprintf(file,"MPC_Free(%s_params);\n",VarName(var_param_net));
        var_param_net=NoTree;
      }
      if(var_fun_net != NoTree) {
        if(!the_last_is_return) {
          c_blank;
          fprintf(file,"%s->oldroot=%s.oldroot;\n",
                  NET_PARAMETER,VarName(var_fun_net));
        }
        {
          /*tGen p_net=var_fun_net->MPC_NetOrSubnet.pGen;
          if(p_net !=  NoGen) {
            tGen pSingleNodeGen=SINGLE_NODE->MPC_Net.pGen;
            tGen pChild;
            GenControl(pSingleNodeGen);
            pChild=pSingleNodeGen->Net.Children;
            GenControl(pChild);
            if(p_net != pChild->Nets.Net) {
              fprintf(stderr,
                      "var_fun_net is not only child of the SINGLE_NODE\n");
            }
            else {
              pSingleNodeGen->Net.Children=NoGen;
            }
          }*/
          var_fun_net=NoTree;
          b_end;
        }
      }
    }
  }
  not_check=0;
  host_function=0;
  host_stat=0;
  in_function=0;
  state_kind=KNOWN;
  cur_block=pRoot;
  Stat_stack_Free();
  cur_act_net=old_cur_act;
  fun_distr=NoTree;
  pCurParamList=NoTree;
  pCurExprs=NoTree;
  real_param=0;
  the_last_is_return=0;
}

static void set_net_fun_params(tTree pVar) {
  tTree pType;
  PointerControl(pVar);
  pType=pVar->MPC_Var.Type;
  PointerControl(pType);
  if(pType->Kind == kMPC_FunctionType && 
     pType->MPC_FunctionType.Kind == NETWORK) {
    tTree pNetParamType=pType->MPC_FunctionType.NetParamType;
    tTree pNetworkParamList=pType->MPC_FunctionType.NetworkParamList;
    if(pNetParamType != NoTree &&
       pNetParamType->Kind != kMPC_FreeNode) {
      tTree pNetType=pNetParamType->MPC_NetTypeSpecifier.NetType;
      PointerControl(pNetType);
      pCurParamList=pNetType->MPC_NetType.ParamList;
      pCurExprs=pNetworkParamList;
    }
  }
}
  
