/*
 * $Id: Type_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* code generation for MPC_Type and correspond nodes */
/* Coded by A.Kalinov 10.95 - */

#include "be_print.h"

void print_EnumTypeName(tTree );
void print_StructTypeName(tTree );
void print_UnionTypeName(tTree );
void print_TypedefName(tTree );
void print_SU_MemberDecl(tTree );
void print_EnumList(tTree );
int spec_is_necessary(tTree );
int is_undefined_array(tTree );

int in_net_param_list=0;
static int undef_len_array=0;


static char* BasicTypeName[13]=
{ "void ",
  "char ","signed char ","unsigned char ",
  "short ","unsigned short ",
  "int ","unsigned ",
  "long ","unsigned long ",
  "float ","double ","long double "};

char*  BasicType_4_Num(int type_num) {
  int type_constr=-type_num;
  if((type_constr<1)||(type_constr>14)) internal_error();
  return BasicTypeName[type_constr-1];
}

void print_Type(tTree pType) {
  if(prt) printf("Type generation is started \n");
  if(pType == NoTree) {
    fprintf(stderr,"Type pointer is Null\n");
    internal_error();
  }
  else {
    tTypeFlags flag=pType->MPC_Type.Flag;
    if(prt) printf("pType=%p Kind=%d flag.DynArray=%d\n",
           pType,pType->Kind,flag.DynArray);
    if(1) {
      switch(pType->Kind) {
      case kMPC_BasicType:
      case kMPC_EnumType:
      case kMPC_Typedef:
      case kMPC_StructType:
      case kMPC_UnionType:
        print_SourceType(pType);
        break;
      default:
        print_LeftType(pType,NoTree);
        if(!source_only) {
          print_RightType(pType,NoTree);
        }
      }
    }
  }
  if(prt) printf("Type generation is ended \n");
}
  
void print_BasicTypeName(tTree pType) {
  int type_constr;
  PointerControl(pType);
  print_TypeFlag(pType,1);
  type_constr=-pType->MPC_BasicType.TypeConstructor;
  if(prt) printf(" type_constr=%d TypeName[type_constr-1]=%s\n",
	 type_constr,BasicTypeName[type_constr-1]);
  cur_pos+=fputs(BasicTypeName[type_constr-1],file);
}

void print_EnumTypeName(tTree pType) {
  tIdent Ident;
  PointerControl(pType);
  Ident=pType->MPC_EnumType.EnumTag;
  print_TypeFlag(pType,1);
  cur_pos+=fputs("enum ",file);
  if(Ident != NoIdent) {
    GetString(Ident,IdentBuf);
    cur_pos+=fprintf(file,"%s ",IdentBuf);
  }
}

void print_EnumList(tTree pMember) {
  PointerControl(pMember);
  if(pMember->Kind != kMPC_FreeNode) {
    cur_pos+=fputs("{",file);
    while(pMember->Kind != kMPC_FreeNode) {
      GetString(pMember->MPC_EnumConst.Name,IdentBuf);
      cur_pos+=fprintf(file,"%s",IdentBuf);
      if(pMember->MPC_EnumConst.Value != UNDEFINED) {
	cur_pos+=fprintf(file,"=%d",
			 pMember->MPC_EnumConst.Value);
      }
      pMember=pMember->MPC_EnumConst.Next;
      PointerControl(pMember);
      if(pMember->Kind != kMPC_FreeNode) {
	cur_pos+=fputs(",",file);
      }
    }
    cur_pos+=fputs("}",file);
  }
}

void print_SU_MemberDecl(tTree pMemberDecl) {
  int old_in_type=in_type;
  int old_source_only=source_only;
  int old_print_base_type=print_base_type;
  PointerControl(pMemberDecl);
  if(pMemberDecl->Kind != kMPC_FreeNode) {
    cur_pos+=fputs("{\n",file);
    cur_blank+=SKIP;
    in_type=1;
    while(pMemberDecl->Kind != kMPC_FreeNode) {
      tTree pMember,pType;
      pMember=pMemberDecl->MPC_SU_MemberDecl.Member;
      PointerControl(pMember);
      pType=pMember->MPC_SU_Member.Type;
      c_blank;
      if(pType != NoTree) {
        source_only=1;
        print_base_type=1;
        print_Type(pType);
        source_only=0;
        print_base_type=0;
      }
     while(pMember->Kind != kMPC_FreeNode) {
        tIdent Ident=pMember->MPC_SU_Member.Name;
        IdentControl(Ident);
        pType=pMember->MPC_SU_Member.Type;
        print_LeftType(pType,NoTree);
        GetString(Ident,NameBuf);
        cur_pos+=fprintf(file,"%s",NameBuf);
        if(pMember->MPC_SU_Member.BitFieldSize != NoTree) {
          cur_pos+=fputs(":",file);
          print_Expr(pMember->MPC_SU_Member.BitFieldSize);
        }
        print_RightType(pType,NoTree);
	pMember=pMember->MPC_SU_Member.Next;
	PointerControl(pMember);
	if(pMember->Kind != kMPC_FreeNode) { 
	  cur_pos+=fputs(",",file);
	}
      } 
      cur_pos+=fputs(";\n",file);
      pMemberDecl=pMemberDecl->MPC_SU_MemberDecl.Next;
      PointerControl(pMemberDecl);
    }
    cur_blank-=SKIP;
    c_blank;
    cur_pos+=fputs("}",file);
    in_type=old_in_type;
    source_only=old_source_only;
    print_base_type=old_print_base_type;
    if(!in_type && is_not_parameter && !in_var_decl)
      cur_pos+=fputs(";\n",file);
    else
      cur_pos+=fputs(" ",file);
  }
}

void print_StructTypeName(tTree pType) {
  tIdent Ident;
  PointerControl(pType);
  Ident=pType->MPC_StructType.SU_Tag;
  print_TypeFlag(pType,1);
  cur_pos+=fputs("struct ",file);
  if(Ident != NoIdent) {
    GetString(Ident,IdentBuf);
    cur_pos+=fprintf(file,"%s ",IdentBuf);
  }
}
  
void print_UnionTypeName(tTree pType) {
  tIdent Ident;
  PointerControl(pType);
  Ident=pType->MPC_UnionType.SU_Tag;
  print_TypeFlag(pType,1);
  cur_pos+=fputs("union ",file);
  if(Ident != NoIdent) {
    GetString(Ident,IdentBuf);
    cur_pos+=fprintf(file,"%s ",IdentBuf);
  }
}

void print_TypedefName(tTree pType) {
  tTypeFlags flag;
  PointerControl(pType);
  flag=pType->MPC_Type.Flag;
  print_TypeFlag(pType,0);
  GetString(pType->MPC_Typedef.TypedefName,IdentBuf);
  cur_pos+=fprintf(file,"%s ",IdentBuf);
}

void print_SourceType(tTree pType) {
  PointerControl(pType);
  switch(pType->Kind) {
  case kMPC_BasicType:
    print_BasicTypeName(pType);
    break;
  case kMPC_EnumType:
    print_EnumTypeName(pType);
    if(pType->MPC_EnumType.EnumList != NoTree && !not_members) {
      print_EnumList(pType->MPC_EnumType.EnumList);
    }
    cur_pos+=fputs(" ",file);
    break;
  case kMPC_StructType:
    print_StructTypeName(pType);
    if(!(in_sizeof && (pType->MPC_StructType.SU_Tag!=NoIdent))) {
      if((pType->MPC_StructType.MemberDecls == NoTree)&&(pType->MPC_StructType.SU_Tag==NoIdent))
        internal_error();
      if(pType->MPC_StructType.MemberDecls != NoTree && !not_members) {
        print_SU_MemberDecl(pType->MPC_StructType.MemberDecls);
      }
    }
    break;
  case kMPC_UnionType:
    print_UnionTypeName(pType);
    if(pType->MPC_UnionType.MemberDecls != NoTree && !not_members) {
      print_SU_MemberDecl(pType->MPC_UnionType.MemberDecls);
    }
    break;
  case kMPC_Typedef:
    if(prt)
      printf("Typedef=%p .Type=%p TypeList=%d in_var_decl=%d source_only=%d\n",
             pType,pType->MPC_Typedef.Type,
             pType->MPC_Typedef.Flag.TypedefList,
             in_var_decl,source_only);
    if(pType->MPC_Typedef.Type != NoTree && !in_var_decl) {
      int old_print_base_type=print_base_type;
      int old_in_var_decl=in_var_decl;
      int old_source_only=source_only;
      tTree pDeclSpec=pType->MPC_Typedef.Type;
      tTree pNext=pType->MPC_Typedef.Next;
      PointerControl(pNext);
      if(!source_only) {
        if(pType->MPC_Typedef.Flag.TypedefList) break;
        cur_pos+=fputs("typedef ",file);
        in_type=1;
        in_var_decl=1;
        print_base_type=1;
        pCurDeclSpec=NoTree;
        source_only=1;
        print_Type(pDeclSpec);
        source_only=old_source_only;
        print_base_type=0;
        pCurDeclSpec=pDeclSpec;
        print_LeftType(pType->MPC_Typedef.Type,NoTree);
      }
      print_TypedefName(pType);
      if(!source_only) {
        print_RightType(pType->MPC_Typedef.Type,NoTree);
        if(pNext->Kind == kMPC_Typedef &&
           pNext->MPC_Typedef.Flag.TypedefList) {
          cur_pos+=fputs(",",file);
        }
        while(pNext->Kind == kMPC_Typedef &&
              pNext->MPC_Typedef.Flag.TypedefList) {
          print_LeftType(pNext->MPC_Typedef.Type,NoTree);
          print_TypedefName(pNext);
          print_RightType(pNext->MPC_Typedef.Type,NoTree);
          pNext=pNext->MPC_Typedef.Next;
          PointerControl(pNext);
          if(pNext->Kind == kMPC_Typedef &&
             pNext->MPC_Typedef.Flag.TypedefList) {
            cur_pos+=fputs(",",file);
          }
        }
        if(is_not_parameter) {
          cur_pos+=fputs(";\n",file);
        }
        in_type=0;
      }
      in_var_decl=old_in_var_decl;
      print_base_type=old_print_base_type;
    }
    else {
      print_TypedefName(pType);
    }
    break;
  default:
    break;
  }
}

void print_TypeFlag(tTree pType, int kind) {
  tTypeFlags flag;
  PointerControl(pType);
  flag=pType->MPC_Type.Flag;
  if(not_const == 0) {
    if(flag.Const && kind)
      cur_pos+=fputs("const ",file);
  }
  else {
    not_const=0;
  }
  if(flag.Volatile && kind) 
    cur_pos+=fputs("volatile ",file);
}

int spec_is_necessary(tTree pType) {
  PointerControl(pType);
  return pType->Kind == kMPC_ArrayType ||
    pType->Kind == kMPC_VectorType ||
    pType->Kind == kMPC_PointerType ||
    pType->Kind == kMPC_FunctionType;
}

int type_priority(tTree pType) {
  PointerControl(pType);
  switch(pType->Kind) {
  case kMPC_FunctionType:
    return /*1*/4;
  case kMPC_PointerType:
    return 2;
  case kMPC_ArrayType:
    /*if(is_undefined_array(pType)) return 2;*/
    return 3;
  case kMPC_VectorType:
    /*if(gen_mode == C_MODE)
      return 2;
    else*/
    return 3;
  default:
    return 0;
  }
}
    
int bracket_is_necessary(tTree pType,tTree pNext,int order) {
  int spec,t_pr,n_pr,ret;
  PointerControl(pType);
  if(prt) printf("bracket_is_necessary pType=%p pNext=%p order=%d",
         pType,pNext,order);
  spec=pNext != NoTree ? spec_is_necessary(/*pNext*/pType) : 0;
  if((pNext != NoTree)&&is_pointer_on_dynamic(pNext)) spec=0;
  t_pr=type_priority(pType);
  n_pr=pNext != NoTree ? type_priority(pNext) : 0;
  if(pNext == NoTree) {
    ret=0;
  }
  else {
     if(spec)
       ret=t_pr > n_pr;
     else
       ret=0;
  }
  if(prt) printf(" spec=%d t_pr=%d n_pr=%d ret=%d\n",spec,t_pr,n_pr,ret);
  return ret;
}

int ordinar_var(tTree pVar) {
  tTree pInit;
  PointerControl(pVar);
  pInit=pVar->MPC_Var.Init;
  return !(pVar->MPC_Var.Ident == NoIdent &&
           pInit != NoTree);
}

tTree next_type(tTree pType) {
  PointerControl(pType);
  switch(pType->Kind) {
  case kMPC_FunctionType:
    return pType->MPC_FunctionType.ResultType;
  case kMPC_ArrayType:
    return pType->MPC_ArrayType.ElementType;
  case kMPC_VectorType:
    return pType->MPC_VectorType.ElementType;
  case kMPC_PointerType:
    return pType->MPC_PointerType.ElementType;
  default:
    break;
  }
  return NoTree;
}

void print_LeftType(tTree pType,tTree pParentType) {
 
 
   
  if(prt) printf("print_LeftType started \n"
                 "Type=(%p,%d) Parent=(%p,%d) print_base_type=%d"
                 "pCurDeclSpec=%p\n",
                 pType,pType != NoTree ? pType->Kind : 0,
                 pParentType,pParentType != NoTree ? pParentType->Kind : 0,
                 print_base_type,pCurDeclSpec);
  
  PointerControl(pType);
  if(spec_is_necessary(pType)) {
    tTree pNext;
    pNext= next_type(pType);
   if(!(pCurDeclSpec != NoTree && pCurDeclSpec->Kind == kMPC_Typedef &&
         (pCurDeclSpec->MPC_Typedef.Type == pType ||
         pCurDeclSpec->MPC_Typedef.Type == pNext))) {
      print_LeftType(pNext,pType);
     
    }
  }
  else {
    if(print_base_type) print_SourceType(pType);
  }
  if(!source_only) {
    if(bracket_is_necessary(pType,pParentType,0)) 
      cur_pos+=fputs("(",file);
    switch(pType->Kind) {
    case kMPC_PointerType:
      if(gen_mode == C_MODE) {
        if(!is_pointer_on_dynamic(pType))
          cur_pos+=fputs("*",file);
      }
      else {
        if(pType->MPC_PointerType.Step == 1) {
          cur_pos+=fputs("*",file);
        }
        else {
          cur_pos+=fprintf(file,"*:%d",pType->MPC_PointerType.Step);
        }
      }
      print_TypeFlag(pType,1);
      break;
    case kMPC_ArrayType:
      if(is_undefined_array(pType)) {
        undef_len_array=1;
      }
      if(gen_mode == C_MODE) {
        if(is_dynamic_type(pType)&&
           (!IS_DYN_ARRAY_OR_VECTOR(element_type(pType))))
          cur_pos+=fputs("(*",file);
     }
       
    break;
    case kMPC_VectorType:
      if(gen_mode == C_MODE) {
        if(is_dynamic_type(pType)&&
           (!IS_DYN_ARRAY_OR_VECTOR(element_type(pType))))
          cur_pos+=fputs("(*",file);
     }
/* 
        if(gen_mode == C_MODE) {
        cur_pos+=fputs("*",file);
        }
*/
    break;

    default:
      break;
    }
  }
  
  if(prt) printf("print_LeftType generation is ended \n");
}    

int is_ParamList(tTree pParam) {
  int ret=0;
  if(pParam != NoTree && pParam->Kind != kMPC_FreeNode) {
    tTree pVar=pParam->MPC_VarDecl.Var;
    tTree pDeclSpec=pParam->MPC_VarDecl.DeclSpecifier;
    PointerControl(pVar);
    PointerControl(pDeclSpec);
    if(!(pVar->Kind == kMPC_FreeNode &&
         (pDeclSpec->Kind == kMPC_BasicType &&
          pDeclSpec->MPC_BasicType.TypeConstructor == VOID))) ret=1;
  }
  return ret;
}

void print_RightType(tTree pType,tTree pParentType) {
  int old_is_not_parameter=is_not_parameter;
  
  

  if(prt) printf("print_RightType started Type=(%p,%d) Parent=(%p,%d)\n",
         pType,pType != NoTree ? pType->Kind : 0,
         pParentType,pParentType != NoTree ? pParentType->Kind : 0);
  PointerControl(pType);
  if(!(pCurDeclSpec != NoTree && pCurDeclSpec->Kind == kMPC_Typedef &&
       pCurDeclSpec->MPC_Typedef.Type == pType)) {
    if(undef_len_array) {
      cur_pos+=fputs("[]",file);
      undef_len_array=0;
    }
    else {
     if(bracket_is_necessary(pType,pParentType,1)) 
        cur_pos+=fputs(")",file);
     switch(pType->Kind) {
     case kMPC_ArrayType:
       {
         int NumberOfComponents=pType->MPC_ArrayType.NumberOfComponents;
         int Step=pType->MPC_ArrayType.Step;
          if(Step < 0) {
            fprintf(stderr,
                    "Sorry, negative step of the array isn't supported now\n");
            internal_error();
          }
          if(gen_mode == C_MODE) {
            if(NumberOfComponents == UNDEFINED) {
              cur_pos+=fputs("[]",file);
            }
            else if(is_dynamic_type(pType)) {
              if(!IS_DYN_ARRAY_OR_VECTOR(element_type(pType))) {
                cur_pos+=fputs(")",file);
              }
            }
            else {
              int i=(NumberOfComponents-1)*abs(Step)+1;
              cur_pos+=fprintf(file,"[%d]",i);
            }
            /*else if(NumberOfComponents == 0 && pSize != NoTree) {
              cur_pos+=fputs("[",file);*/
              /*print_Expr(pSize);*/
            /*cur_pos+=fputs("]",file);
            }*/
          }
          else {
            if(Step == 1 && is_not_parameter) {
              if(NumberOfComponents == UNDEFINED) {
                cur_pos+=fputs("[]",file);
              }
              else {
                cur_pos+=
                  fprintf(file,"[%d]",
                          NumberOfComponents);
              }
            }
            else {
              if(NumberOfComponents == UNDEFINED) {
                cur_pos+=
                  fprintf(file,"[:%d]",
                          Step);
              }
              else {
                cur_pos+=
                  fprintf(file,"[%d:%d]",
                          NumberOfComponents,
                          Step);
              }
            }
          }
        }
        break;
     case kMPC_VectorType:
       if(is_dynamic_type(pType)) {
         if(!IS_DYN_ARRAY_OR_VECTOR(element_type(pType))) {
           cur_pos+=fputs(")",file);
         }
       }
       else cur_pos+=fprintf(file,"[%d]",  pType->MPC_VectorType.NumberOfComponents);
       break;
     case kMPC_FunctionType:
        {
          tTree pParam=pType->MPC_FunctionType.ParamList;
          int old_print_base_type=print_base_type;
          print_base_type=1;
          PointerControl(pParam);
          cur_pos+=fputs("(",file);
          is_not_parameter=0;
          if(pType->MPC_FunctionType.Kind == NETWORK) {
            tTree pNetParam=pType->MPC_FunctionType.NetParam;
            tTree pNetParamType=pType->MPC_FunctionType.NetParamType;
            tTree pNetworkParamList=pType->MPC_FunctionType.NetworkParamList;
            int pos=cur_pos+strlen(NameBuf);
            PointerControl(pNetParam);
            if(pNetParamType != NoTree &&
               pNetParamType->Kind != kMPC_FreeNode) {
              cur_pos+=fprintf(file,"%s %s",
                               NET_POINTER_TYPE,NET_PARAMETER);
              if(pNetParamType->Kind != kMPC_NetTypeSpecifier) {
                fprintf(stderr,"pNetParamType isn't NetTypeSpecifier\n");
                internal_error();
              }
              if(pNetworkParamList != NoTree &&
                 pNetworkParamList->Kind != kMPC_FreeNode) {
                cur_pos+=fprintf(file,",\n");
                if(prt) printf("Function pos=%d\n",pos);
                blank(pos);
                in_net_param_list=1;
                {
                  tTree pVar=pNetworkParamList;
                  tTree pNetType=pNetParamType->MPC_NetTypeSpecifier.NetType;
                  tTree pParamList;
                  tTree old_pCurParamList=pCurParamList;
                  tTree old_pCurExprs=pCurExprs;
                  int old_real_param=real_param;
                  PointerControl(pNetType);
                  pParamList=pNetType->MPC_NetType.ParamList;
                  PointerControl(pParamList);
                  pCurParamList=pParamList;
                  pCurExprs=pNetworkParamList;
                  real_param=1;  
                  while(pVar->Kind != kMPC_FreeNode) {
                    if(ordinar_var(pVar)) {
                      print_Var(pVar);
                    }
                    pVar=pVar->MPC_Var.Next;
                    PointerControl(pVar);
                    if(pVar->Kind != kMPC_FreeNode && ordinar_var(pVar)) {
                      cur_pos+=fputs(",",file);
                    }
                  }
                  pCurParamList=old_pCurParamList;
                  pCurExprs=old_pCurExprs;
                  real_param=old_real_param;  
                }
                in_net_param_list=0;
              }
              if(is_ParamList(pParam)) {
                cur_pos+=fprintf(file,",\n");
                blank(pos);
              }
            }
          }
          if(is_ParamList(pParam)) {
            while(pParam->Kind != kMPC_FreeNode) {
              print_Decls(pParam);
              pParam=pParam->MPC_Decls.Next;
              if(pParam->Kind !=  kMPC_FreeNode) {
                cur_pos+=fputs(",",file);
              }
            }
          }
          /*is_not_parameter=1;*/
          cur_pos+=fputs(")",file);
          print_base_type=old_print_base_type;
        }
        break;
      default:
        break;
      }
      if(spec_is_necessary(pType)) {
        tTree pNext;
        pNext= next_type(pType);
        /*if(!(pCurDeclSpec != NoTree && pCurDeclSpec->Kind == kMPC_Typedef &&
             pCurDeclSpec->MPC_Typedef.Type == pNext)) {*/
          print_RightType(pNext,pType);
          /*}*/
      }
    }
  }
  is_not_parameter=old_is_not_parameter;
  
  if(prt) printf("print_RightType generation is ended \n");
}    

int is_undefined_array(tTree pType) {
  PointerControl(pType);
  return (in_net_param_list &&
          pType->Kind == kMPC_ArrayType &&
          (pType->MPC_ArrayType.NumberOfComponents == UNDEFINED /*||
           pType->MPC_ArrayType.NumberOfComponents == 0*/));
}

