# ifndef yyType
# define yyType

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# include <stdio.h>
# line 10 "Type.ast"

#include <Tree.h>


# ifndef bool
# define bool char
# endif
# define NoType (tType) 0L
# define kTypes 1
# define kType 2

typedef unsigned char Type_tKind;
typedef unsigned short Type_tMark;
typedef unsigned short Type_tLabel;
typedef union Type_Node * tType;
typedef void (* Type_tProcTree) ARGS((tType));

# ifndef Type_NodeHead
# define Type_NodeHead
# endif
typedef struct { Type_tKind yyKind; Type_tMark yyMark; Type_NodeHead } Type_tNodeHead;
typedef struct { Type_tNodeHead yyHead; tType Type; tType Next; } yTypes;
typedef struct { Type_tNodeHead yyHead; tTree Origin; tType Parent; int Number; tType Children; int Gen; int Used; int MemCopy; tType EquivType; tType VectorType; tType PointerType; } yType;

union Type_Node {
 Type_tKind Kind;
 Type_tNodeHead yyHead;
 yTypes Types;
 yType Type;
};

extern tType TypeRoot;
extern unsigned long Type_HeapUsed;
extern char * Type_PoolFreePtr, * Type_PoolMaxPtr;
extern unsigned short Type_NodeSize [2 + 1];
extern char * Type_NodeName [2 + 1];

extern void (* Type_Exit) ();
extern tType Type_Alloc ();
extern tType MakeType ARGS((Type_tKind yyKind));
extern bool Type_IsType ARGS((register tType yyt, register Type_tKind yyKind));

extern tType nTypes ();
extern tType nType ();

extern tType mTypes ARGS((tType pType, tType pNext));
extern tType mType ARGS((tTree pOrigin, tType pParent, int pNumber, tType pChildren, int pGen, int pUsed, int pMemCopy));

extern void ReleaseType ARGS((tType yyt));
extern void WriteType ARGS((FILE * yyyf, tType yyt));
extern void TraverseTypeTD ARGS((tType yyt, Type_tProcTree yyyProc));
extern void TraverseTypeBU ARGS((tType yyt, Type_tProcTree yyyProc));
extern tType CopyType ARGS((tType yyt));
extern void BeginType ();
extern void CloseType ();

# endif
