/*
 * $Id: Traverse.c,v 3.2 1999/11/10 14:54:53 scheme Exp $
 */


/* functions for MPC_Tree traverse */
/* Coded by A.Kalinov 10.95 - 04.96*/

#include "be_print.h"

#define Traverse(struct,field) {yyn=yyt->struct.field; \
  if(yyn != NoTree) Decls_traverse(yyn,proc);}

#define StatTraverse(struct,field) {yyn=yyt->struct.field; \
  if(yyn != NoTree) Stat_traverse(yyn,proc);}

#define ExprTraverse(struct,field) {yyn=yyt->struct.field; \
  if(yyn != NoTree) Expr_traverse(yyn,proc);}

#define ExprPieceTraverse(struct,field) {yyn=yyt->struct.field; \
  if(yyn != NoTree) ExprPiece_traverse(yyt,yyn,proc);}

#define PredExprTraverse(struct,field) {yyn=yyt->struct.field; \
  if(yyn != NoTree) PredExpr_traverse(yyn,proc);}

void Decls_traverse(tTree yyt,void (* proc)(tTree)) {
  if(yyt != NoTree) {
    tTree yyn;
    if(prt) printf("Decls_traverse begin yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind); 
    if(Tree_IsType(yyt,kMPC_Stats)) {
      switch(yyt->Kind) {
      case kMPC_If:
        Traverse(MPC_If,Stats);
        break;
      case kMPC_IfElse:
        Traverse(MPC_IfElse,Then);
        Traverse(MPC_IfElse,Else);
        break;
      case kMPC_Switch:
        Traverse(MPC_Switch,Stats);
        break;
      case kMPC_While:
        Traverse(MPC_While,Stats);
        break;
      case kMPC_DoWhile:
        Traverse(MPC_DoWhile,Stats);
        break;
      case kMPC_For:
        Traverse(MPC_For,Stats);
        break;
      case kMPC_ParScheme:
        Traverse(MPC_ParScheme,Stats);
        break;
      case kMPC_Compound:
        {
          tTree old_cur_block=cur_block;
          /*      block_number=yyt->MPC_Compound.UniqueNumber; */
          cur_block=yyt;
          Traverse(MPC_Compound,Decls);
          Traverse(MPC_Compound,Stats);
          cur_block=old_cur_block;
        }
        break;
      default:
        break;
      }
      Traverse(MPC_Stats,Next);
    }
    if(Tree_IsType(yyt,kMPC_Decls)) {
      proc(yyt);
      if(yyt->Kind == kMPC_Function) {
        Traverse(MPC_Function,Stats);
      }
      Traverse(MPC_Decls,Next);
    }
    if(prt) printf("Decls_traverse end yyt=%p\n",yyt); 
  }
}

void Stat_traverse(tTree yyt,void (* proc)(tTree)) {
  if(yyt != NoTree) {
    tTree yyn;
    if(prt) printf("Stat_traverse begin yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind); 
    if(Tree_IsType(yyt,kMPC_Stats)) {
      proc(yyt);
      switch(yyt->Kind) {
      case kMPC_If:
        StatTraverse(MPC_If,Stats);
        break;
      case kMPC_IfElse:
        StatTraverse(MPC_IfElse,Then);
        StatTraverse(MPC_IfElse,Else);
        break;
      case kMPC_Switch:
        StatTraverse(MPC_Switch,Stats);
        break;
      case kMPC_While:
        StatTraverse(MPC_While,Stats);
        break;
      case kMPC_DoWhile:
        StatTraverse(MPC_DoWhile,Stats);
        break;
      case kMPC_For:
        StatTraverse(MPC_For,Stats);
        break;
      case kMPC_ParScheme:
        StatTraverse(MPC_ParScheme,Stats);
        break;
      case kMPC_Compound:
        {
          StatTraverse(MPC_Compound,Stats);
        }
        break;
      default:
        break;
      }
      StatTraverse(MPC_Stats,Next);
    }
    /*if(Tree_IsType(yyt,kMPC_Decls)) {
      proc(yyt);
      if(yyt->Kind == kMPC_Function) {
        StatTraverse(MPC_Function,Stats);
      }
      StatTraverse(MPC_Decls,Next);
    }*/
    if(prt) printf("Stat_traverse end yyt=%p\n",yyt); 
  }
}

void Expr_traverse(tTree yyt,void (* proc)(tTree)) {
  if(yyt != NoTree) {
    tTree yyn;
    PointerControl(yyt);
    if(prt) printf("Expr_traverse begin yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind); 
    if(yyt->Kind == kMPC_Exprs) {
      if(yyt->Kind != kMPC_FreeNode) {

        /* warning this place is changed 21.10.97 without full testing */

        /*proc(yyt);*/
        Expr_traverse(yyt->MPC_Exprs.Expr,proc);

        /* end warning */
        ExprTraverse(MPC_Exprs,Next);
      }
    }
    if(Tree_IsType(yyt,kMPC_Expr)) {
      proc(yyt);
      switch(yyt->Kind) {
      case kMPC_CastExpr:
        ExprTraverse(MPC_CastExpr,Operand);
        break;
      case kMPC_NetCastExpr:
        ExprTraverse(MPC_NetCastExpr,Operand);
        break;
      case kMPC_CoordExpr:
        ExprTraverse(MPC_CoordExpr,Operand);
        break;
      case kMPC_Size_Of_Value:
        if(!in_post_gen) {
          ExprTraverse(MPC_Size_Of_Value,Operand);
        }
        break;
      case kMPC_UnaryExpr:
        ExprTraverse(MPC_UnaryExpr,Operand);
        break;
      case kMPC_BinaryExpr:
        ExprTraverse(MPC_BinaryExpr,Loperand);
        ExprTraverse(MPC_BinaryExpr,Roperand);
        break;
      case kMPC_TernaryExpr:
        ExprTraverse(MPC_TernaryExpr,Foperand);
        ExprTraverse(MPC_TernaryExpr,Soperand);
        ExprTraverse(MPC_TernaryExpr,Toperand);
        break;
      case kMPC_QuaternaryExpr:
	ExprTraverse(MPC_QuaternaryExpr,Operand1);
	ExprTraverse(MPC_QuaternaryExpr,Operand2);
	ExprTraverse(MPC_QuaternaryExpr,Operand3);
	ExprTraverse(MPC_QuaternaryExpr,Operand4);
	break;
      case kMPC_CallExpr:
        ExprTraverse(MPC_CallExpr,Function);
        ExprTraverse(MPC_CallExpr,ArgList);
        ExprTraverse(MPC_CallExpr,NetworkArgList);
        break;
      default:
        break;
      }
    }
  }
  if(prt) printf("Expr_traverse end yyt=%p\n",yyt); 
}

void ExprPiece_traverse(tTree yyp,tTree yyt,void (* proc)(tTree,tTree)) {
  if(yyt != NoTree) {
    tTree yyn;
    PointerControl(yyt);
    
    if(prt) printf("ExprPiece_traverse begin yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind); 
    if(yyt->Kind == kMPC_Exprs) {

    }
    
    if(Tree_IsType(yyt,kMPC_Expr)) {
      proc(yyp,yyt);
      if(strcmp(yyt->MPC_Expr.TmpName,"")&&((yyt->MPC_Expr.Flag.Generated)||(yyt->Kind==kMPC_Expr)))
        return;
     switch(yyt->Kind) {
     case kMPC_CastExpr:
       ExprPieceTraverse(MPC_CastExpr,Operand);
       break;
     case kMPC_NetCastExpr:
       ExprPieceTraverse(MPC_NetCastExpr,Operand);
       break;
     case kMPC_CoordExpr:
       ExprPieceTraverse(MPC_CoordExpr,Operand);
       break;
     case kMPC_Size_Of_Value:
       if(!in_post_gen) ExprPieceTraverse(MPC_Size_Of_Value,Operand);
       break;
     case kMPC_UnaryExpr:
       ExprPieceTraverse(MPC_UnaryExpr,Operand);
       break;
     case kMPC_BinaryExpr:
       ExprPieceTraverse(MPC_BinaryExpr,Loperand);
       ExprPieceTraverse(MPC_BinaryExpr,Roperand);
       break;
     case kMPC_TernaryExpr:
       ExprPieceTraverse(MPC_TernaryExpr,Foperand);
       ExprPieceTraverse(MPC_TernaryExpr,Soperand);
       ExprPieceTraverse(MPC_TernaryExpr,Toperand);
       break;
     case kMPC_QuaternaryExpr:
       ExprPieceTraverse(MPC_QuaternaryExpr,Operand1);
       ExprPieceTraverse(MPC_QuaternaryExpr,Operand2);
       ExprPieceTraverse(MPC_QuaternaryExpr,Operand3);
       ExprPieceTraverse(MPC_QuaternaryExpr,Operand4);
       break;
     case kMPC_CallExpr:
       ExprPieceTraverse(MPC_CallExpr,Function);
       ExprPieceTraverse(MPC_CallExpr,ArgList);
       ExprPieceTraverse(MPC_CallExpr,NetworkArgList);
       break;
     default:
       break;
     }
    }
  }
  if(prt) printf("ExprPiece_traverse end yyt=%p\n",yyt); 
}


void PredExpr_traverse(tTree yyt,void (* proc)(tTree)) {
  if(yyt != NoTree) {
    tTree yyn;
    PointerControl(yyt);
    if(prt) printf("PredExpr_traverse begin yyt=%p yyt->Kind=%d\n",yyt,yyt->Kind); 
    if(yyt->Kind == kMPC_Exprs) {
      if(yyt->Kind != kMPC_FreeNode) {
        PredExpr_traverse(yyt->MPC_Exprs.Expr,proc);
        PredExprTraverse(MPC_Exprs,Next);
      }
    }
    if(Tree_IsType(yyt,kMPC_Expr)) {
      if(yyt->MPC_Expr.Pass == 0) {
        switch(yyt->Kind) {
        case kMPC_CastExpr:
          PredExprTraverse(MPC_CastExpr,Operand);
          break;
        case kMPC_NetCastExpr:
          PredExprTraverse(MPC_NetCastExpr,Operand);
          break;
        case kMPC_CoordExpr:
          PredExprTraverse(MPC_CoordExpr,Operand);
          break;
        case kMPC_Size_Of_Value:
          PredExprTraverse(MPC_Size_Of_Value,Operand);
          break;
        case kMPC_UnaryExpr:
          PredExprTraverse(MPC_UnaryExpr,Operand);
          if(!pred_gen_is_necessary(yyn)) {
            proc(yyt);
          }
          break;
        case kMPC_BinaryExpr:
          PredExprTraverse(MPC_BinaryExpr,Loperand);
          PredExprTraverse(MPC_BinaryExpr,Roperand);
          break;
        case kMPC_TernaryExpr:
          PredExprTraverse(MPC_TernaryExpr,Foperand);
          PredExprTraverse(MPC_TernaryExpr,Soperand);
          PredExprTraverse(MPC_TernaryExpr,Toperand);
          break;
	case kMPC_QuaternaryExpr:
	  PredExprTraverse(MPC_QuaternaryExpr,Operand1);
	  PredExprTraverse(MPC_QuaternaryExpr,Operand2);
	  PredExprTraverse(MPC_QuaternaryExpr,Operand3);
	  PredExprTraverse(MPC_QuaternaryExpr,Operand4);
	  break;
        case kMPC_CallExpr:
          PredExprTraverse(MPC_CallExpr,Function);
          PredExprTraverse(MPC_CallExpr,ArgList);
          PredExprTraverse(MPC_CallExpr,NetworkArgList);
          break;
        default:
          break;
        }
      }
    }
  }
  if(prt) printf("PredExpr_traverse end yyt=%p\n",yyt); 
}

void StateDecls_traverse(tTree pState,void (* proc)(tTree)) {
  tTree pDecls;
  PointerControl(pState);
  pDecls=pState->MPC_Compound.Decls;
  if(pDecls != NoTree) {
/*  if(prt) printf("pDecls=%p pDecls->Kind=%d\n",
	 pDecls,pDecls->Kind);*/
    while(pDecls->Kind != kMPC_FreeNode) {
      proc(pDecls);
      pDecls=pDecls->MPC_Decls.Next;
      PointerControl(pDecls);
    }
  }
}

void Net_traverse(tTree pDecls,void (* proc)(tTree)) {
  tTree pNetOrSubnet;
  if(pDecls != NoTree) {
  if(prt) printf("Net_traverse pDecls=%p pDecls->Kind=%d\n",
	 pDecls,pDecls->Kind);
    while(pDecls->Kind != kMPC_FreeNode) {
      if(pDecls->Kind == kMPC_NetDecl || 
	 pDecls->Kind == kMPC_SubnetDecl) {
	cur_Decl=pDecls;
	if(prt) printf("Net_traverse cur_Decl=%p pDecls->Kind=%d\n",
	       cur_Decl,pDecls->Kind);
	pNetOrSubnet=pDecls->Kind == kMPC_NetDecl ? 
	  pDecls->MPC_NetDecl.Net :
	  pDecls->MPC_SubnetDecl.Subnet;
	PointerControl(pNetOrSubnet);
	while(pNetOrSubnet->Kind != kMPC_FreeNode) {
	  proc(pNetOrSubnet);
	  pNetOrSubnet=pDecls->Kind == kMPC_NetDecl ? 
            pNetOrSubnet->MPC_Net.Next :
            pNetOrSubnet->MPC_Subnet.Next;
          if(prt) printf("Net_traverse Next pNetOrSubnet=%p pNetOrSubnet->Kind=%d\n",
	       pNetOrSubnet,pNetOrSubnet->Kind);
	  PointerControl(pNetOrSubnet);
	}
      }
      pDecls=pDecls->MPC_Decls.Next;
      PointerControl(pDecls);
    }
  }
}

void FileDecls_traverse(void (* proc)(tTree)) {
  tTree pDecls;
  PointerControl(pRoot);
  PointerControl(cur_FileDecls);
  pDecls=pRoot->MPC_Root.Decls;
  PointerControl(pDecls);
  while(pDecls != cur_FileDecls) {
    proc(pDecls);
    pDecls=pDecls->MPC_Decls.Next;
    PointerControl(pDecls);
  }
}

void ArrayType_traverse(tTree pType, void (* proc) (tTree))
{
PointerControl(pType);

if(pType->Kind==kMPC_ArrayType)
  {
  proc(pType);
  ArrayType_traverse(pType->MPC_ArrayType.ElementType,proc);
  }

}

void TypeTree_traverse(tType yyt,void (* proc)(tType ), int first) {
  if(yyt != NoType) {
    if(yyt->Kind == kTypes) {
      while(yyt != NoType) {
        TypeTree_traverse(yyt->Types.Type,proc,0);
        yyt=yyt->Types.Next;
      }
    }
    else if(yyt->Kind == kType) {
      tTree pType=yyt->Type.Origin;
      tTypeFlags flag;
      PointerControl(pType);
      flag=pType->MPC_Type.Flag;
      /*printf("traverse pType=%p Kind=%d flag.DynArray=%d\n",
             pType,pType->Kind,flag.DynArray);*/
      if(!in_assign && is_dynamic_type(pType))
        return;
      /*if(pType->Kind == kMPC_Typedef && !first) return;*/
      proc(yyt);
      TypeTree_traverse(yyt->Type.Children,proc,0);
    }
  }
}


void AllTypeTree_traverse(tType yyt,void (* proc)(tType )) {

/*printf("AllTypeTree_traverse on   entry\n");*/

   if(yyt != NoType) {
    if(yyt->Kind == kTypes) {
/*     printf("AllTypeTree_traverse on Types entry\n");*/
 
      while(yyt != NoType) {
        AllTypeTree_traverse(yyt->Types.Type,proc);
        yyt=yyt->Types.Next;
      }
    }
    else if(yyt->Kind == kType) {
/*      printf("AllTypeTree_traverse on Type entry\n");*/

      proc(yyt);
      AllTypeTree_traverse(yyt->Type.Children,proc);
    }
  }
}
                          
void VarDecl_traverse(tTree pDecls, void (*proc) (tTree))
{
if(pDecls->Kind != kMPC_VarDecl) 
  {
  printf("VarDecl_traverse: Not var decl \n");
  exit(1);
  }
else
  {
  tTree pVar=pDecls->MPC_VarDecl.Var;
  PointerControl(pVar);
  while(pVar->Kind != kMPC_FreeNode) {
    proc(pVar);
    pVar=pVar->MPC_Var.Next;
    PointerControl(pVar);
    } 
  } 
}











