/*
 * $Id: Stats_prin/usr/local/mpc/ka/v17-x.x.x-mt.c,v 3.4 1999/11/12 16:56:39 ka Exp ka $
 */


/* code generation for MPC_Stats and correspond nodes */
/* Coded by A.Kalinov 10.95 - */
/* version with waiting point to every block with net declaration 08.97 - */

#include "be_print.h"

void set_net_uncreated(tGen  );
static void print_For(tTree );
static void print_While(tTree );
static void print_DoWhile(tTree );
static void print_Compound(tTree );
static void print_If(tTree );
static void print_IfElse(tTree );
static void print_Switch(tTree );
static void print_ExprStat(tTree );
static void print_Goto(tTree );
static void print_Return(tTree );
static void RTS_Param_Declare(tTree);
static void RTS_Param_Init(tTree);
static void RTS_NetParam_Declare(tTree);
static void RTS_NetParam_Init(tTree);
static void print_CompScheme(tTree);
static void print_CommScheme(tTree);
static void print_ParScheme(tTree);

void fill_ActualExecNet(tTree );
/*int print_stat_begin(tTree , tTree );*/
void print_stat_with_braces(tTree , int);
void print_stat_end(int , int );
void print_propagation(tTree ,tTree );
int calc_ctrl_send(tTree , tTree);
void calc_and_prop_ctrl(tTree , tTree , int );
tTree next_stat();
void find_net_decl(tTree );
int is_begin_VoteSection(tTree );
int NotFlexibleAndNumber(tTree );
int CountsNetInNetList(tTree );
int print_MembersList(tTree , int );
void set_PropNet(tTree , tTree , tTree* );
void add_NetList_to_NetList(tTree , tTree* );
tTree find_root_net(tTree , tTree );
static void sets_free_all_captured(tTree );
/*static void hitch_subnet(tTree );*/
static void print_NetworkFunctionHead_action();
/*static int look_for_break(tTree );*/
static void look_for_screened(tTree );
void calculate_coord_var(tTree pExpr,int coord_num);

void print_BreakVoteExit();
void print_EndVoteExit();
void print_CommonVoteExit();

static int the_last_return=0;
static int return_num=0;

static tIdent LookIdent;
static tPosition IdentPos;
static tTree CurrentDecls=NoTree;

void print_Stat(tTree pStat) {
  char* StatName[17]= {"ExprStat","If","IfElse","Switch","While",
                       "DoWhile","For","Goto","Continue","Break",
                       "BreakFan","Return","Compound",
                       "Fan","Par","Pipe","MBMStat"};
  PointerControl(pStat);
  if(prt) {
    printf("\n\nprint_Stat %s pStat=%p cr_sec_beg=%p cr_sec_end=%p host_stat=%d\n",
           StatName[pStat->Kind-kMPC_ExprStat],pStat,
           creation_section_begin,creation_section_end,host_stat);
    fflush(stdout);
  }
  Stat_stack_Push(&(pStat->MPC_Stats.Next));
  cur_stat=pStat;
  switch(pStat->Kind) {
  case kMPC_ExprStat:
    print_ExprStat(pStat);
    break;
  case kMPC_If:
    print_If(pStat);
    break;
  case kMPC_IfElse:
    print_IfElse(pStat);
    break;
  case kMPC_Switch:
    print_Switch(pStat);
    break;
  case kMPC_While:
    print_While(pStat);
    break;
  case kMPC_DoWhile:
    print_DoWhile(pStat);
    break;
  case kMPC_For:
    print_For(pStat);
    break;
  case kMPC_ParScheme:
    print_ParScheme(pStat);
    break;
  case kMPC_Compound:
    print_Compound(pStat);
    break;
  case kMPC_Goto:
    print_Goto(pStat);
    break;
  case kMPC_Continue:
    c_blank;
    fprintf(file,"continue;\n");
    break;
  case kMPC_Break:
    c_blank;
    Break_free(pStat);
    fprintf(file,"break;\n");
    break;
  case kMPC_Return:
    print_Return(pStat);
    break;
  case kMPC_CompScheme:
    print_CompScheme(pStat);
    break;
  case kMPC_CommScheme:
    print_CommScheme(pStat);
    break;
  default:
    fprintf(stderr,
            "Sorry, this kind of the statement isn't supported now Kind=%d\n",
            pStat->Kind);
    internal_error();
  }
  pStat->MPC_Stat.ActualExecNet=NoTree;
  pStat->MPC_Stat.RootNet=NoTree;
  pStat->MPC_Stat.PropNet=NoTree;
  if(prt) printf("end print_Stat  pStat=%p\n\n",pStat);
}

void print_Label(tTree pStat) {
  char* LabelName[3]= {"IdentLabel","CaseLabel","Default"};
  tIdent Ident;
  tTree pExpr;
  PointerControl(pStat);
  if(prt) {
    printf("\n\nprint_Label  %s pStat=%p \n",
           LabelName[pStat->Kind-kMPC_IdentLabel],pStat);
    fflush(stdout);
  }
  in_condition=1;
  Stat_stack_Push(&(pStat->MPC_Stats.Next));
  switch(pStat->Kind) {
  case kMPC_IdentLabel:
    Ident=pStat->MPC_IdentLabel.Ident;
    IdentControl(Ident);
    GetString(Ident,NameBuf);
    fprintf(file,"%s:\n",NameBuf);
    Label_alloc(pStat);
    break;
  case kMPC_CaseLabel:
    pExpr=pStat->MPC_CaseLabel.Expr;
    PointerControl(pExpr);
    {
      if(pExpr->MPC_Expr.EvalNet == NoTree ||
         pExpr->MPC_Expr.StoreNet == NoTree) {
        fprintf(stderr," Store=%p Eval=%p\n",
                pExpr->MPC_Expr.StoreNet,pExpr->MPC_Expr.EvalNet);
        internal_error();
      }
    }
    blank(cur_blank-SKIP);
    fprintf(file,"case ");
    print_Expr(pExpr);
    fprintf(file,":\n");
    break;
  case kMPC_Default:
    blank(cur_blank-SKIP);
    fprintf(file,"default:\n");
    break;
  default:
    fprintf(stderr,"wrong kind of the label Kind=%d\n",pStat->Kind);
    internal_error();
  }
  in_condition=0;
  if(prt) printf("end print_Label  pStat=%p\n",pStat);
}
    
static int is_it_host_only(tTree pNetList) {
  int ret=0;
  PointerControl(pNetList);
  if(pNetList->MPC_NetList.Net == HOST) {
    tTree pNext=pNetList->MPC_NetList.Next;
    PointerControl(pNext);
    if(pNext->Kind == kMPC_FreeNode) ret=1;
  }
  return ret;
}

void Stats_print(tTree pStats) {
  tTree old_cur_act_net=cur_act_net;
  tTree prev_act_net=cur_act_net;
  int old_host_stat=host_stat;
  int i;
  int braces;
  tTree pStat=pStats;
  Net_stack scope_stack;
  Net_rec cur_scope;
  cur_scope.Net=cur_act_net;
  cur_scope.braces=0;
  PointerControl(pStats);
  Position=pStats->MPC_Stats.Pos;
  if(prt) printf("Stats_print  pStats=%p\n",pStats);
  PointerControl(old_cur_act_net);
  Net_stack_Init(&scope_stack);
  while(pStat->Kind != kMPC_FreeNode) {
    parent_expr=NoTree;
    if(Tree_IsType(pStat,kMPC_Stat)) {
      fill_ActualExecNet(pStat);
      PrintNet(pStat->MPC_Stat.RootNet,"RootNet");
      PrintNetList(pStat->MPC_Stat.ActualExecNet,0,"ActualExecNet");
      cur_act_net=pStat->MPC_Stat.ActualExecNet;
      PointerControl(cur_act_net);
      if(is_it_host_only(cur_act_net)) {
        if(prt) printf("set host_stat to 1\n");
        host_stat=1;
      }
      else {
        if(prt) printf("set host_stat to 0\n");
        host_stat=0;
      }
      tmp_num=0;
      if(prt) printf("cur_act_net=%p prev_act_net=%p \n",
             cur_act_net,prev_act_net);
      if(!((function_kind == NETWORK || function_kind == NODAL) &&
           pStat->Kind == kMPC_Compound &&
           pStat->MPC_Compound.FunctionBody)) {
        while(1) {
          if(!SameList(cur_act_net,prev_act_net)) {
            if(SubList(cur_act_net,prev_act_net)) {
              braces=print_Members(cur_act_net);
              cur_scope.Net=prev_act_net;
              cur_scope.braces=braces;
              Net_stack_Push(&scope_stack,&cur_scope);
              prev_act_net=cur_act_net;
              if(prt) printf("braces before =%d\n",braces);
              break;
            }
            else {
              if(Net_stack_Is_empty(&scope_stack)) {
                fprintf(stderr,"Invalid network scope of the statement\n");
                internal_error();
              }
              else {
                tTree old_prev_net=prev_act_net;
                cur_scope=Net_stack_Pop(&scope_stack);
                prev_act_net=cur_scope.Net;
                braces=cur_scope.braces;
                if(prt) printf("braces after 1 =%d\n",braces);
                {
                  int old_host_stat=host_stat;
                  PointerControl(old_prev_net);
                  if(is_it_host_only(old_prev_net)) {
                    host_stat=1;
                  }
                  else {
                    host_stat=0;
                  }
                  for(i=0; i<braces; i++) {
                    if(prt) printf(" 1 cur_act_net=%p prev_act_net=%p old_prev_net=%p host_stat=%d\n",
                           cur_act_net,prev_act_net,old_prev_net,host_stat);
                    b_end;
                  }
                  host_stat=old_host_stat;
                }
              }
            }
          }
          else {
            break;
          }
        }
      }
      if(not_created_num &&
         SameList(COMPUTING_SPACE_LIST,cur_act_net)) {
        if(prt && function_kind == BASIC) printf("print_VoteExit 3\n");
        is_break++;
        if(is_break == 1) {
          print_BreakVoteExit();
        }
      }
      if(pStat->MPC_Stat.Benchmark) {
        tPosition real_pos;
        real_pos=RealPosition(pStat->MPC_Stat.Pos);
        c_blank;
        fprintf(file,"MPC_Source_position_set(%d,%d);\n",
          real_pos.Column,real_pos.Line);
        c_blank;
        fprintf(file,"/* benchmark code begin */\n");
        c_blank;
        cur_pos+=fputs("{\n",file);
        cur_blank+=SKIP;
        c_blank;
        fprintf(file,"double MPC_bench_time;\n");
        c_blank;
        fprintf(file,"MPC_bench_time=MPC_Wtime();\n");
        if(pStat->Kind == kMPC_ExprStat &&
           pStat->MPC_ExprStat.Expr == NoTree) {
          c_blank;
          fprintf(file,"MPC_Benchmark();\n");
        }
      }
      print_Stat(pStat);
      if(pStat->MPC_Stat.Benchmark) {
        c_blank;
        fprintf(file,"MPC_bench_time=MPC_Wtime()-MPC_bench_time;\n");
        c_blank;
        fprintf(file,"MPC_Update_Processors_info(MPC_bench_time);\n");
        b_end;
        c_blank;
        fprintf(file,"/* benchmark code end*/\n");
      }
    }
    else if(Tree_IsType(pStat,kMPC_Label)) {
      print_Label(pStat);
    }
    else {
      fprintf(stderr,"MPC_Stats isn't MPC_Stat or MPC_Label Kind=%d\n",
              pStat->Kind);
      internal_error();
    }
    Stat_stack_Pop();
    pStat=pStat->MPC_Stat.Next;
    PointerControl(pStat);
  }
  while(!Net_stack_Is_empty(&scope_stack)) {
    cur_scope=Net_stack_Pop(&scope_stack);
    prev_act_net=cur_scope.Net;
    braces=cur_scope.braces;
    if(prt) printf("braces after 2 =%d\n",braces);
    {
      int old_host_stat=host_stat;
      PointerControl(cur_act_net);
      if(is_it_host_only(cur_act_net)) {
        host_stat=1;
      }
      else {
        host_stat=0;
      }
      for(i=0; i<braces; i++) {
        if(prt) printf(" 2 cur_act_net=%p prev_act_net=%p host_stat=%d\n",
               cur_act_net,prev_act_net,host_stat);
        b_end;
      }
      host_stat=old_host_stat;
    }
    cur_act_net=prev_act_net;
  }
  cur_act_net=old_cur_act_net;
  host_stat=old_host_stat;
  Net_stack_Free(&scope_stack);
  if(prt) printf("end Stats_print  pStats=%p\n",pStats);
}

void set_net_uncreated(tGen yyt) {
  if(yyt != NoGen) {
    if(yyt->Kind == kNet &&
       (yyt->Net.pNet != SINGLE_NODE &&
        yyt->Net.pNet != COMPUTING_SPACE)) yyt->Net.Created=0;
  }
}

int end_is_needed(tTree pExpr) {
  PointerControl(pExpr);
  if((pExpr->Kind == kMPC_BinaryExpr &&
       (pExpr->MPC_BinaryExpr.OpCode >= ASSIGN &&
        pExpr->MPC_BinaryExpr.OpCode <= INCL_OR_ASSIGN))/* ||
     post_gen*/) {
    return 0;
  }
  return 1;
}

static void print_ExprStat(tTree pStats) {
  tTree old_cur_act_net=cur_act_net;
  tTree pExpr=pStats->MPC_ExprStat.Expr;
  end_statement_is_needed=1;
  index_depth=0;
  not_pecul=1;
  if(pExpr != NoTree) {
    parent_expr=pExpr;
    pred_print_Expr_begin(pExpr);
    /*not_change_net=1;*/
    print_Expr(pExpr);
    not_change_net=0;
    if(prt) printf("end_statement_is_needed=%d end_is_needed(pExpr)=%d\n",
           end_statement_is_needed,end_is_needed(pExpr));
    if(end_statement_is_needed/* || end_is_needed(pExpr)*/) fputs(";\n",file);
    end_statement_is_needed=1;
    pred_print_Expr_end(pExpr);
  }
  else {
    c_blank;
    fputs(";\n",file);
    end_statement_is_needed=1;
  }
  cur_act_net=old_cur_act_net;
}

static tTree Funcion_Of_Function_Body(tTree pStats)
{
tTree pFree,pFunction;
PointerControl(pStats);
pFree=pStats->MPC_Stats.Next;
PointerControl(pFree);

if(pFree->Kind!=kMPC_FreeNode) 
  {
  fprintf(stderr,"Funcion_Of_Function_Body : Free Node not found failed.\n");
  internal_error();
  }

pFunction=pFree->MPC_FreeNode.Parent;
PointerControl(pFunction);

if(pFunction->Kind!=kMPC_Function) 
  {
  fprintf(stderr,"Funcion_Of_Function_Body : Function  not found failed.\n");
  internal_error();
  }

return pFunction;
}


static void  RTS_Param_Declare(tTree pFunction)
{
tTree pVar,pType,pDecl;
/*printf("RTS_Param_Declare entry.\n");*/
PointerControl(pFunction);
pType=pFunction->MPC_Function.Type;
PointerControl(pType);
if(pType->Kind!=kMPC_FunctionType) 
  {
  fprintf(stderr,"RTS_Param_Declare : Function  type not found .\n");
  internal_error();  
  }
pDecl=pType->MPC_FunctionType.ParamList;
PointerControl(pDecl);
while(pDecl->Kind!=kMPC_FreeNode) {
  pVar=pDecl->MPC_VarDecl.Var;
  PointerControl(pVar);
  print_RTSNodeDeclare(pVar);
  pDecl=pDecl->MPC_Decls.Next;
  PointerControl(pDecl);
}
}
 
static void  RTS_Param_Init(tTree pFunction)
{
tTree pVar,pType,pDecl;
/*printf("RTS_Param_Init entry.\n");*/
PointerControl(pFunction);
pType=pFunction->MPC_Function.Type;
PointerControl(pType);
if(pType->Kind!=kMPC_FunctionType) 
  {
  fprintf(stderr,"RTS_NetParam_Init : Function  type not found.\n");
  internal_error();  
  }
pDecl=pType->MPC_FunctionType.ParamList;
PointerControl(pDecl);
while(pDecl->Kind!=kMPC_FreeNode) {
  pVar=pDecl->MPC_VarDecl.Var;
  PointerControl(pVar);
  print_RTSNodeInit(pVar);
  pDecl=pDecl->MPC_Decls.Next;
  PointerControl(pDecl);
}
}

static void  RTS_NetParam_Declare(tTree pFunction)
{
tTree pVar,pType;
/*printf("RTS_NetParam_Declare entry.\n");*/
PointerControl(pFunction);
if(pFunction->MPC_Function.Kind!=NETWORK) return;
/*printf("RTS_NetParam_Declare : Network function detected.\n");*/
pType=pFunction->MPC_Function.Type;
PointerControl(pType);
if(pType->Kind!=kMPC_FunctionType) 
  {
  fprintf(stderr,"RTS_NetParam_Declare : Function  type not found .\n");
  internal_error();  
  }
pVar=pType->MPC_FunctionType.NetworkParamList;
PointerControl(pVar);
print_RTSNodeDeclare(pVar);
}
 
static void  RTS_NetParam_Init(tTree pFunction)
{
tTree pVar,pType;
/*printf("RTS_NetParam_Init entry.\n");*/
PointerControl(pFunction);
if(pFunction->MPC_Function.Kind!=NETWORK) return;

/*printf("RTS_NetParam_Init : Network function detected.\n");*/
pType=pFunction->MPC_Function.Type;
PointerControl(pType);
if(pType->Kind!=kMPC_FunctionType) 
  {
  fprintf(stderr,"RTS_NetParam_Init : Function  type not found.\n");
  internal_error();  
  }
pVar=pType->MPC_FunctionType.NetworkParamList;
PointerControl(pVar);
print_RTSNodeInit(pVar);
}


static void print_Compound(tTree pStats) {
  int old_blank_is_necessary=blank_is_necessary;
  tTree old_cur_block=cur_block;
  tTree pDecl,pStat,pFunction=NoTree;
  tTree old_cur_act_net=cur_act_net;
  int old_not_created_num=not_created_num;
  int old_is_break=is_break;
  /*int old_cur_screened_var=cur_screened_var;*/
  int pos;
  if(prt) printf("print_Compound  pStats=%p is_topo_fun=%d \n",
         pStats,is_topo_fun);
  cur_block=pStats;
  point_num=pStats->MPC_Compound.UniqueNumber;
  is_break=0;
  not_created_num=0;
  /* definition tmp for screened topology actual parameters */
  StateDecls_traverse(pStats,look_for_screened);
  if(!(pStats->MPC_Compound.FunctionBody && var_fun_net != NoTree)) {
    if(blank_is_necessary) c_blank;
    blank_is_necessary=0;
    cur_pos+=fputs("{\n",file);
    cur_blank+=SKIP;
  }

  if(!CBRACKETS) {
    if(pStats->MPC_Compound.FunctionBody && !is_topo_fun &&
       !is_main_function) {
      c_blank;
      fprintf(file,"char* MPC_old_file_name=MPC_Debug_source_name;\n");
    }
  }
  
  StateDecls_traverse(pStats,print_NetOrSubnet);
  if(pStats->MPC_Compound.FunctionBody)
    {
    pFunction=Funcion_Of_Function_Body(pStats);
    RTS_NetParam_Declare(pFunction);
    RTS_Param_Declare(pFunction);
    }
  pDecl=pStats->MPC_Compound.Decls;  
  if(pStats->MPC_Compound.FunctionBody) Stat_traverse(pStats,print_Alloc_Flags);
    
  if(pDecl != NoTree) Decls_print(pDecl);
    
  if(in_mapping  && pStats->MPC_Compound.FunctionBody) {
    c_blank;
    fprintf(file,"double %s%d=0.0;\n",ESTIMATION,in_mapping);
  }  
  if(pStats->MPC_Compound.FunctionBody) {
    RTS_NetParam_Init(pFunction);
    RTS_Param_Init(pFunction);
  }
 
  if(var_fun_net != NoTree && pStats->MPC_Compound.FunctionBody) {
    print_NetworkFunctionHead_action();
  }
  if(pDecl != NoTree) RTS_init_print(pDecl);
  if(pDecl != NoTree) Decls_alloc(pStats);
   
  StateDecls_traverse(pStats,set_params);
  if(!CBRACKETS) {
    if(pStats->MPC_Compound.FunctionBody && !is_topo_fun) {
      c_blank;
      fprintf(file,"MPC_Debug_source_name=MPC_file_name;\n");
    }
    if(pStats->MPC_Compound.FunctionBody &&
       is_main_function) {
      c_blank;
      pos=cur_pos+fprintf(file,"MPC_Init(");
      fprintf(file,"&argc,&argv,\n");
      blank(pos);
      if(!null_init) {
        fprintf(file,"MPC_The_init_strategy,\n");
        blank(pos);
        fprintf(file,"MPC_Trivial_error_print,\n"); 
        blank(pos);
        fprintf(file,"MPC_The_get_env,\n");
        blank(pos);
        fprintf(file,"MPC_The_strategy,\n");
        blank(pos);
        fprintf(file,"MPC_The_topology_data,\n");
        blank(pos);
        fprintf(file,"MPC_The_processors_info");
      }
      else {
        fprintf(file,"NULL,NULL,NULL,NULL,NULL,NULL");
      }      
      fprintf(file,");\n");
    }
  }
  cur_block=pStats;
  if((function_kind == BASIC/* &&
     NetEqList(COMPUTING_SPACE,cur_act_net)*/) ||
     function_kind == NETWORK) {
    print_VoteSection(pStats);
  }
  {
    TraverseGenTD(int_gen_tree,net_create);
  }
  blank_is_necessary=1;
  /*is_break=look_for_break(pStats);*/
  pStat=pStats->MPC_Compound.Stats;
  if(pStat != NoTree && pStat->Kind != kMPC_FreeNode) {
    Stats_print(pStat);
  }
  if(prt) printf("Compound num=%d not_created_num=%d is_break=%d the_last_return=%d\n",
         pStats->MPC_Compound.UniqueNumber,not_created_num,is_break,
         the_last_return);
  if(!the_last_return) {
    if(function_kind == BASIC) {
      if(not_created_num) {
        if(!is_break) {
          print_CommonVoteExit();
        }
        else {
          print_EndVoteExit();
        }
      }
    }
    if(function_kind == NETWORK) {
      print_NetRelease();
    }
 
  if(pDecl != NoTree) Decls_free(pStats);

  }
  the_last_return=0;
  /*if(not_created_num && !is_break) {
    if(prt) printf("print_VoteExit 2\n");
    print_VoteExit();
  }*/
  if(pStats->MPC_Compound.FunctionBody) {
    traverse_gen_tree(int_gen_tree->Net.Children,
                      set_net_uncreated);
  }
  close_gen_block();
  if(!CBRACKETS) {
    if(pStats->MPC_Compound.FunctionBody) {
      if(is_main_function && !the_last_is_return) {
        c_blank;
        fprintf(file,"MPC_Exit(0);\n");
      }
      else if(!is_topo_fun && !the_last_is_return) {
        c_blank;
        fprintf(file,"MPC_Debug_source_name=MPC_old_file_name;\n");
      }
    }
    if(in_mapping && pStats->MPC_Compound.FunctionBody) {
      c_blank;
      fprintf(file,"return %s%d;\n",ESTIMATION,in_mapping);
    }
  }
  if(!(pStats->MPC_Compound.FunctionBody && var_fun_net != NoTree)) {
    b_end;
  }
  cur_block=old_cur_block;
  blank_is_necessary=old_blank_is_necessary;
  cur_act_net=old_cur_act_net;
  not_created_num=old_not_created_num;
  is_break=old_is_break;
  /*cur_screened_var=old_cur_screened_var;*/
  if(prt) printf("end print_Compound  pStats=%p\n",pStats);
}

static void print_If(tTree pStats) {
  tTree pExpr;
  tTree pThen;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  pExpr=pStats->MPC_If.Expr;
  pThen=pStats->MPC_If.Stats;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExpr);
  PointerControl(pThen);
  PointerControl(pExecNetList);
  ctrl_send=calc_ctrl_send(pExpr,pStats);
  in_condition=1;
  if(ctrl_send) {
    c_blank;
    fprintf(file,"{\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"int %s;\n",CtrlName(pStats));
  }
  calc_and_prop_ctrl(pStats,pExpr,ctrl_send);
  in_condition=0;
  braces=check_enclosed_net(pExecNetList,cur_act_net);
  cur_act_net=pExecNetList;
  c_blank;
  if(ctrl_send) {
    fprintf(file,"if(%s) {\n",CtrlName(pStats));
  }
  else {
    cur_pos+=fputs("if(",file);
    print_Expr(pExpr);
    cur_pos+=fputs(") {\n",file);
    end_statement_is_needed=1;
  }
  cur_blank+=SKIP;
  c_blank;
  print_stat_with_braces(pThen,1);
  print_stat_end(braces,ctrl_send);
  b_end;
  cur_act_net=old_cur_act_net;
  blank_is_necessary=1;
}

static void print_IfElse(tTree pStats) {
  tTree pExpr;
  tTree pThen;
  tTree pElse;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  pExpr=pStats->MPC_IfElse.Expr;
  pThen=pStats->MPC_IfElse.Then;
  pElse=pStats->MPC_IfElse.Else;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExpr);
  PointerControl(pThen);
  PointerControl(pElse);
  PointerControl(pExecNetList);
  ctrl_send=calc_ctrl_send(pExpr,pStats);
  in_condition=1;
  if(ctrl_send) {
    c_blank;
    fprintf(file,"{\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"int %s;\n",CtrlName(pStats));
  }
  calc_and_prop_ctrl(pStats,pExpr,ctrl_send);
  in_condition=0;
  braces=check_enclosed_net(pExecNetList,cur_act_net);
  cur_act_net=pExecNetList;
  c_blank;
  if(ctrl_send) {
    fprintf(file,"if(%s) {\n",CtrlName(pStats));
  }
  else {
    cur_pos+=fputs("if(",file);
    print_Expr(pExpr);
    cur_pos+=fputs(") {\n",file);
    end_statement_is_needed=1;
  }
  cur_blank+=SKIP;
  Stat_stack_Pop();
  Stat_stack_Push(&pElse);
  c_blank;
  print_stat_with_braces(pThen,1);
  Stat_stack_Pop();
  b_end;
  c_blank;
  cur_pos+=fputs("else {\n",file);
  cur_blank+=SKIP;
  Stat_stack_Push(&(pStats->MPC_Stats.Next));
  c_blank;
  print_stat_with_braces(pElse,1);
  print_stat_end(braces,ctrl_send);
  b_end;
  cur_act_net=old_cur_act_net;
  blank_is_necessary=1;
}

static void print_Switch(tTree pStats) {
  tTree pExpr;
  tTree pStat;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send;
  int i;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  pExpr=pStats->MPC_Switch.Expr;
  pStat=pStats->MPC_Switch.Stats;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExpr);
  PointerControl(pStat);
  PointerControl(pExecNetList);
  ctrl_send=calc_ctrl_send(pExpr,pStats);
  in_condition=1;
  if(ctrl_send) {
    c_blank;
    fprintf(file,"{\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"int %s;\n",CtrlName(pStats));
  }
  calc_and_prop_ctrl(pStats,pExpr,ctrl_send);
  in_condition=0;
  braces=check_enclosed_net(pExecNetList,cur_act_net);
  cur_act_net=pExecNetList;
  c_blank;
  if(ctrl_send) {
    fprintf(file,"switch(%s) {\n",CtrlName(pStats));
  }
  else {
    cur_pos+=fputs("switch(",file);
    print_Expr(pExpr);
    cur_pos+=fputs(") {\n",file);
    end_statement_is_needed=1;
  }
  cur_blank+=SKIP;
  
  if(pStat != NoTree) {
    if(prt) printf("pStat->Kind=%d\n",pStat->Kind);
    if(pStat->Kind != kMPC_Compound) {
      fprintf(stderr,"first MPC_Stats in Switch isn't MPC_Compound\n");
      internal_error();
    }
    pStat=pStat->MPC_Compound.Stats;
    if(pStat != NoTree) {
      if(prt) printf("pStat->Kind=%d\n",pStat->Kind);
      if(!Tree_IsType(pStat,kMPC_Label)) {
        fprintf(stderr,
                "first MPC_Stats in Switch compound isn't MPC_Label\n");
        internal_error();
      }
      Stats_print(pStat);
    }
  }
  b_end;
  for(i=0; i<braces; i++) {
    b_end;
  }
  if(ctrl_send) {
    b_end;
  }
  cur_act_net=old_cur_act_net;
  blank_is_necessary=1;
}

static void print_While(tTree pStats) {
  tTree pExpr;
  tTree pThen;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  pExpr=pStats->MPC_While.Expr;
  pThen=pStats->MPC_While.Stats;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExpr);
  PointerControl(pThen);
  PointerControl(pExecNetList);
  ctrl_send=calc_ctrl_send(pExpr,pStats);
  in_condition=1;
  c_blank;
  if(ctrl_send) {
    fprintf(file,"while(1) {\n");
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"int %s;\n",CtrlName(pStats));
    calc_and_prop_ctrl(pStats,pExpr,ctrl_send);
    in_condition=0;
  }
  else {
    fprintf(file,"while(");
    print_Expr(pExpr);
    fprintf(file,") ");
  }
  braces=check_enclosed_net(pExecNetList,cur_act_net);
  cur_act_net=pExecNetList;
  if(ctrl_send) {
    c_blank;
    fprintf(file,"if(!%s) break;\n",CtrlName(pStats));
    c_blank;
    fprintf(file,"else ");
  }
  print_stat_with_braces(pThen,1);
  print_stat_end(braces,ctrl_send);
  cur_act_net=old_cur_act_net;
  blank_is_necessary=1;
}

static void print_DoWhile(tTree pStats) {
  tTree pExpr;
  tTree pThen;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  pExpr=pStats->MPC_DoWhile.Expr;
  pThen=pStats->MPC_DoWhile.Stats;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExpr);
  PointerControl(pThen);
  PointerControl(pExecNetList);
  ctrl_send=calc_ctrl_send(pExpr,pStats);
  c_blank;
  fprintf(file,"do {\n");
  cur_blank+=SKIP;
  if(ctrl_send) {
    c_blank;
    fprintf(file,"int %s;\n",CtrlName(pStats));
  }
  braces=check_enclosed_net(pExecNetList,cur_act_net);
  cur_act_net=pExecNetList;
  print_stat_with_braces(pThen,0);
  cur_stat=pStats;
  print_stat_end(braces,0);
  cur_act_net=old_cur_act_net;
  if(ctrl_send) {
    in_condition=1;
    calc_and_prop_ctrl(pStats,pExpr,ctrl_send);
    in_condition=0;
  }
  if(ctrl_send) {
    c_blank;
    fprintf(file,"if(!%s) break;\n",CtrlName(pStats));
    b_end;
    c_blank;
    fprintf(file,"while(1);\n");
  }
  else {
    b_end;
    c_blank;
    fprintf(file,"while(");
    print_Expr(pExpr);
    fprintf(file,");\n");
  }
  cur_act_net=old_cur_act_net;
  blank_is_necessary=1;
}

static void print_For(tTree pStats) {
  tTree pStat,pInit,pCond,pReinit;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send=0;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  pStat=pStats->MPC_For.Stats;
  pInit=pStats->MPC_For.Init;
  pCond=pStats->MPC_For.Cond;
  pReinit=pStats->MPC_For.Reinit;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExecNetList);
  in_condition=1;
  ctrl_send=calc_ctrl_send(pInit,pStats);
  if(!ctrl_send) ctrl_send=calc_ctrl_send(pCond,pStats);
  if(!ctrl_send) ctrl_send=calc_ctrl_send(pReinit,pStats);
  if(!(pred_gen_is_necessary(pInit) || 
       pred_gen_is_necessary(pCond) ||
       pred_gen_is_necessary(pReinit) || ctrl_send)) {
    c_blank;
    cur_pos+=fputs("for(",file);
    parent_expr=NoTree;
    if(pInit != NoTree) print_Expr(pInit); 
    /*if(end_statement_is_needed)*/ cur_pos+=fputs(";",file);
    if(pCond != NoTree) print_Expr(pCond); 
    cur_pos+=fputs(";",file);
    if(pReinit != NoTree) print_Expr(pReinit); 
    in_condition=0;
    if(pStat != NoTree) {
      cur_pos+=fputs(") {\n",file);
      cur_blank+=SKIP;
      Stats_print(pStat);
      b_end;
    }
    else {
      c_blank;
      cur_pos+=fputs(";\n",file);
    }
  }
  else {
    c_blank;
    fputs("{\n",file);
    cur_blank+=SKIP;
    if(pInit != NoTree) {
      pred_print_Expr_begin(pInit);
      parent_expr=pInit;
      print_Expr(pInit);
      if(end_statement_is_needed) fputs(";\n",file);
      end_statement_is_needed=1;
      pred_print_Expr_end(pInit);
    }
    in_condition=1;
    c_blank;
    if(ctrl_send) {
      fprintf(file,"while(1) {\n");
      cur_blank+=SKIP;
      c_blank;
      fprintf(file,"int %s;\n",CtrlName(pStats));
      calc_and_prop_ctrl(pStats,pCond,ctrl_send);
      in_condition=0;
    }
    else {
      fprintf(file,"while(");
      if(pCond != NoTree) print_Expr(pCond);
      fprintf(file,") ");
    }
    braces=check_enclosed_net(pExecNetList,cur_act_net);
    cur_act_net=pExecNetList;
    if(ctrl_send) {
      c_blank;
      fprintf(file,"if(!%s) break;\n",CtrlName(pStats));
      c_blank;
      fprintf(file,"else ");
    }
    print_stat_with_braces(pStat,1);
    print_stat_end(braces,0);
    cur_act_net=old_cur_act_net;
    if(pReinit != NoTree) {
      pred_print_Expr_begin(pReinit);
      parent_expr=pReinit;
      print_Expr(pReinit);
      if(end_statement_is_needed) fputs(";\n",file);
      end_statement_is_needed=1;
      pred_print_Expr_end(pReinit);
    }
    b_end;
    if(ctrl_send) {
      b_end;
    }
  }
    /*fprintf(stderr,"Sorry, this kind of the for-loop isn't supported now\n");
    internal_error();*/
  cur_act_net=old_cur_act_net;
  blank_is_necessary=1;
}

static void print_Goto(tTree pStat) {
  tIdent Ident;
  PointerControl(pStat);
  Goto_free(pStat);
  Ident=pStat->MPC_Goto.Ident;
  IdentControl(Ident);
  GetString(Ident,NameBuf);
  c_blank;
  fprintf(file,"goto %s;\n",NameBuf);
}

void print_ActualExecNet(tTree pStat) {
  tTree pActualExecNet;
  PointerControl(pStat);
  pActualExecNet=pStat->MPC_Stat.ActualExecNet;
  PrintNetList(pActualExecNet,0,"retuarn pActualExecNet");
}
  
static void print_Return(tTree pStat) {
  tTree pExpr;
  if(prt) printf("Return stuff begin\n");
  in_return=1;
  is_return=++return_num;
  PointerControl(pStat);
  print_ActualExecNet(pStat);
  pExpr=pStat->MPC_Return.Expr;
  if(pExpr != NoTree) {
    pred_print_Expr_begin(pExpr);
    parent_expr=NoTree;
  }
  if(prt) printf("Return not_created_num=%d break=%d\n",
         not_created_num,is_break);
  sets_free_all_captured(pStat);
  Return_free(pStat);
  if(function_kind == NETWORK && var_fun_net != NoTree) {
    c_blank;
    fprintf(file,"%s->oldroot=%s.oldroot;\n",
            NET_PARAMETER,VarName(var_fun_net));
  }
  if(!CBRACKETS) {
    if(!is_topo_fun && !is_main_function) {
      c_blank;
      fprintf(file,"MPC_Debug_source_name=MPC_old_file_name;\n");
    }
  }
  
  if(pExpr != NoTree) {
    c_blank;
    if(is_main_function&&(!CBRACKETS)) fprintf(file,"MPC_Exit(");
    else fprintf(file,"return ");
    print_Expr(pExpr);
    if(is_main_function) fprintf(file,")");
    fprintf(file,";\n");
    end_statement_is_needed=1;
    pred_print_Expr_end(pExpr);
  }
  else {
    c_blank;
    if(is_main_function&&(!CBRACKETS)) fprintf(file,"MPC_Exit(0);\n");
    else fprintf(file,"return;\n");
  }
  is_return=0;
  in_return=0;
}
      
static void print_CompScheme(tTree pStat) {
  tTree pExpr,pNode,pNetType,pNodeExpr,pExprs;
  int coord_num,icoord;
  PointerControl(pStat);
  if(cur_net_type == NoTree || cur_net_type->Kind != kMPC_NetType || in_mapping == 0 ) {
    fprintf(stderr,"invalid external variables for _CompScheme\n");
    internal_error();
  }
  pNetType=cur_net_type;
  coord_num=coord_number(pNetType);
  c_blank;
  fprintf(file,"{\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"int %s[%d],MPC_rank;\n",NODE_COORD,coord_num);
  pExpr=pStat->MPC_CompScheme.Expr;
  PointerControl(pExpr);
  pred_print_Expr_begin(pExpr);
  parent_expr=pExpr;
  pNode=pStat->MPC_CompScheme.Node;
  PointerControl(pNode);
  pExprs=pNode;
  for(icoord=0; pExprs->Kind != kMPC_FreeNode && icoord < coord_num; icoord++) {
    pNodeExpr=pExprs->MPC_Exprs.Expr;
    PointerControl(pNodeExpr);
    /* printf("pNodeExpr->Kind=%d\n",pNodeExpr->Kind);*/
    pred_print_Expr_begin(pNodeExpr);
    parent_expr=pNodeExpr;
    /*c_blank;*/
    calculate_coord_var(pNodeExpr,icoord);
    pred_print_Expr_end(pNodeExpr);
    pExprs=pExprs->MPC_Exprs.Next;
    PointerControl(pExprs);
  }
  c_blank;
  fprintf(file,"MPC_rank=%s(",TopoFunName(pNetType,NUMBER));
  fprintf(file,"%s,ppar,ppower,pnodes,plinks);\n",NODE_COORD);
  c_blank;
  if(in_mapping > 1) {
    fprintf(file,"%s%d[MPC_actions%d]",ESTIMATION,in_mapping,in_mapping);
  }
  else {
    fprintf(file,"%s%d",ESTIMATION,in_mapping);
  }
  fprintf(file,"+=MPC_Part_comp_est((double)(");
  print_Expr(pExpr);
  fprintf(file,"),root[MPC_rank]);\n");
  pred_print_Expr_end(pExpr);  
  if(in_mapping > 1) {
    c_blank;
    fprintf(file,"MPC_involved_VPs%d[MPC_actions%d][MPC_rank]=1;\n",
            in_mapping,in_mapping);
  }
  b_end;
  
}
      
static void print_CommScheme(tTree pStat) {
  tTree pExpr,pFrom,pTo,pNetType,pNodeExpr,pExprs;
  int coord_num,icoord;
  PointerControl(pStat);
  if(cur_net_type == NoTree || cur_net_type->Kind != kMPC_NetType || in_mapping == 0 ) {
    fprintf(stderr,"invalid external variables for _CompScheme\n");
    internal_error();
  }
  pNetType=cur_net_type;
  coord_num=coord_number(pNetType);
  c_blank;
  fprintf(file,"{\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"int %s[%d],MPC_rank_from,MPC_rank_to;\n",NODE_COORD,coord_num);
  pExpr=pStat->MPC_CommScheme.Expr;
  PointerControl(pExpr);
  pred_print_Expr_begin(pExpr);
  parent_expr=pExpr;
  pFrom=pStat->MPC_CommScheme.From;
  PointerControl(pFrom);
  pExprs=pFrom;
  for(icoord=0; pExprs->Kind != kMPC_FreeNode && icoord < coord_num; icoord++) {
    pNodeExpr=pExprs->MPC_Exprs.Expr;
    PointerControl(pNodeExpr);
    /* printf("pNodeExpr->Kind=%d\n",pNodeExpr->Kind);*/
    pred_print_Expr_begin(pNodeExpr);
    parent_expr=pNodeExpr;
    /*c_blank;*/
    calculate_coord_var(pNodeExpr,icoord);
    pred_print_Expr_end(pNodeExpr);
    pExprs=pExprs->MPC_Exprs.Next;
    PointerControl(pExprs);
  }
  c_blank;
  fprintf(file,"MPC_rank_from=%s(",TopoFunName(pNetType,NUMBER));
  fprintf(file,"%s,ppar,ppower,pnodes,plinks);\n",NODE_COORD);
  pTo=pStat->MPC_CommScheme.To;
  PointerControl(pTo);
  pExprs=pTo;
  for(icoord=0; pExprs->Kind != kMPC_FreeNode && icoord < coord_num; icoord++) {
    pNodeExpr=pExprs->MPC_Exprs.Expr;
    PointerControl(pNodeExpr);
    /* printf("pNodeExpr->Kind=%d\n",pNodeExpr->Kind);*/
    pred_print_Expr_begin(pNodeExpr);
    parent_expr=pNodeExpr;
    /*c_blank;*/
    calculate_coord_var(pNodeExpr,icoord);
    pred_print_Expr_end(pNodeExpr);
    pExprs=pExprs->MPC_Exprs.Next;
    PointerControl(pExprs);
  }
  c_blank;
  fprintf(file,"MPC_rank_to=%s(",TopoFunName(pNetType,NUMBER));
  fprintf(file,"%s,ppar,ppower,pnodes,plinks);\n",NODE_COORD);
  c_blank;
  if(in_mapping > 1) {
    fprintf(file,"%s%d[MPC_actions%d]",ESTIMATION,in_mapping,in_mapping);
  }
  else {
    fprintf(file,"%s%d",ESTIMATION,in_mapping);
  }
  fprintf(file,"+=MPC_Part_comm_est((double)(",ESTIMATION,in_mapping);
  print_Expr(pExpr);
  fprintf(file,"),root[MPC_rank_from],root[MPC_rank_to]);\n");
  pred_print_Expr_end(pExpr); 
  b_end;  
}
#define MAX_EST "MPC_Max_estimation"

static void print_par1() {
  c_blank;
  fprintf(file,"MPC_involved_VPs%d[MPC_actions%d]=(char *)calloc(ppower,sizeof(char));\n",
          in_mapping,in_mapping);
}
static void print_par2() {
  c_blank;
  fprintf(file,"MPC_actions%d++;\n",in_mapping);
  b_end;
}
static void print_par3() {
  
}
/*static void print_par3() {
  c_blank;
  fprintf(file,"MPC_sorted_actions=(int *)malloc(MPC_actions*sizeof(int));\n");
  c_blank;
  fprintf(file,"{\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"int MPC_t0,MPC_t1,MPC_t2,MPC_comp_num,MPC_VPs_num,MPC_prc_num;\n");
  c_blank;
  fprintf(file,"double MPC_one_comp_est;\n");
  c_blank;
  fprintf(file,"for(MPC_t0=0; MPC_t0<MPC_actions; MPC_t0++) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"MPC_sorted_actions[MPC_t0]=MPC_t0;\n");
  b_end;
  c_blank;
  fprintf(file,"MPC_Sort_absolute_weights(MPC_actions,%s%d,MPC_sorted_actions);\n",
          ESTIMATION,in_mapping);
  c_blank;
  fprintf(file,"MPC_comp_num=MPC_get_number_of_computers();\n");
  c_blank;
  fprintf(file,"for(MPC_t0=0; MPC_t0<MPC_comp_num; MPC_t0++) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"MPC_VPs_num=MPC_Get_number_of_VPs(MPC_t0,ppower);\n");
  c_blank;
  fprintf(file,"MPC_prc_num=MPC_Get_scalability(MPC_t0);\n");
  c_blank;
  fprintf(file,"MPC_t2=0;\n");
  c_blank;
  fprintf(file,"MPC_one_comp_est=0.0;\n");
  c_blank;
  fprintf(file,"for(MPC_t1=0; MPC_t2<MPC_Upper(MPC_VPs_num,MPC_prc_num) && MPC_t1<MPC_actions; MPC_t1++) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"if(MPC_Computes_on(MPC_involved_VPs[MPC_sorted_actions[MPC_t1]],ppower,MPC_t0)) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"MPC_one_comp_est+=%s%d[MPC_t1];\n",
          ESTIMATION,in_mapping);
  c_blank;
  fprintf(file,"MPC_t2++;\n");
  b_end;
  b_end;
  c_blank;
  fprintf(file,"if(MPC_one_comp_est > %s%d) {\n",
          MAX_EST,in_mapping);
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"%s%d=MPC_one_comp_est;\n",
          MAX_EST,in_mapping);
  b_end;
  b_end;
  c_blank;
  fprintf(file,"for(MPC_t1=0; MPC_t1<MPC_actions; MPC_t1++) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"for(MPC_t0=0; MPC_t0<MPC_comp_num; MPC_t0++) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"if(MPC_Computes_on(MPC_involved_VPs[MPC_sorted_actions[MPC_t1]],ppower,MPC_t0)) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"break;\n");
  b_end;
  c_blank;
  fprintf(file,"if(MPC_t0 == MPC_comp_num && %s%d[MPC_t1] > %s%d) {\n",
          ESTIMATION,in_mapping,
          MAX_EST,in_mapping);
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"%s%d=%s%d[MPC_t1];\n",  
          MAX_EST,in_mapping,
          ESTIMATION,in_mapping);
  b_end;
  b_end;
  b_end;
  c_blank;
  fprintf(file,"for(MPC_t1=0; MPC_t1<MPC_actions; MPC_t1++) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"if(MPC_involved_VPs[MPC_t1]) {\n");
  cur_blank+=SKIP;
  c_blank;
  fprintf(file,"free(MPC_involved_VPs[MPC_t1]);\n");
  b_end;
  b_end;
  c_blank;
  fprintf(file,"free(MPC_involved_VPs);\n");
  c_blank;
  fprintf(file,"free(%s%d);\n",
          ESTIMATION,in_mapping);
  b_end;
}*/

static void print_ParScheme(tTree pStats) {
  int old_in_mapping=in_mapping;
  int old_in_par=in_par;
  tTree pStat,pInit,pCond,pReinit;
  tTree pExecNetList;
  int braces=0;
  int ctrl_send;
  tTree old_cur_act_net=cur_act_net;
  PointerControl(pStats);
  c_blank;
  fprintf(file,"{\n");
  cur_blank+=SKIP;
  in_mapping++;
  in_par=1;
  c_blank;
  fprintf(file,"double *%s%d,%s%d=0.0;\n",
          ESTIMATION,in_mapping,MAX_EST,in_mapping);  
  c_blank;
  fprintf(file,"int MPC_actions%d=0,*MPC_sorted_actions;\n",in_mapping);
  c_blank;
  fprintf(file,"char **MPC_involved_VPs%d;\n",in_mapping);
  c_blank;
  fprintf(file,"%s%d=(double *)calloc(ppower*(ppower+1),sizeof(double));\n",
          ESTIMATION,in_mapping);  
  c_blank;
  fprintf(file,"MPC_involved_VPs%d=(char **)calloc(ppower*(ppower+1),sizeof(char *));\n",
          in_mapping);  
  pStat=pStats->MPC_ParScheme.Stats;
  pInit=pStats->MPC_ParScheme.Init;
  pCond=pStats->MPC_ParScheme.Cond;
  pReinit=pStats->MPC_ParScheme.Reinit;
  pExecNetList=pStats->MPC_Stat.ExecNet;
  PointerControl(pExecNetList);
  in_condition=1;
  ctrl_send=calc_ctrl_send(pInit,pStats);
  if(!ctrl_send) ctrl_send=calc_ctrl_send(pCond,pStats);
  if(!ctrl_send) ctrl_send=calc_ctrl_send(pReinit,pStats);
  if(!(pred_gen_is_necessary(pInit) || 
       pred_gen_is_necessary(pCond) ||
       pred_gen_is_necessary(pReinit) || ctrl_send)) {
    c_blank;
    cur_pos+=fputs("for(",file);
    parent_expr=NoTree;
    if(pInit != NoTree) print_Expr(pInit); 
    /*if(end_statement_is_needed)*/ cur_pos+=fputs(";",file);
    if(pCond != NoTree) print_Expr(pCond); 
    cur_pos+=fputs(";",file);
    if(pReinit != NoTree) print_Expr(pReinit); 
    in_condition=0;
    if(pStat != NoTree) {
      cur_pos+=fputs(") {\n",file);
      cur_blank+=SKIP;
      print_par1();
      Stats_print(pStat);
      print_par2();
      print_par3();
    }
    else {
      c_blank;
      cur_pos+=fputs(";\n",file);
    }
  }
  else {
    c_blank;
    fputs("{\n",file);
    cur_blank+=SKIP;
    if(pInit != NoTree) {
      pred_print_Expr_begin(pInit);
      parent_expr=pInit;
      print_Expr(pInit);
      if(end_statement_is_needed) fputs(";\n",file);
      end_statement_is_needed=1;
      pred_print_Expr_end(pInit);
    }
    in_condition=1;
    c_blank;
    if(ctrl_send) {
      fprintf(file,"while(1) {\n");
      cur_blank+=SKIP;
      c_blank;
      fprintf(file,"int %s;\n",CtrlName(pStats));
      calc_and_prop_ctrl(pStats,pCond,ctrl_send);
      in_condition=0;
    }
    else {
      fprintf(file,"while(");
      if(pCond != NoTree) print_Expr(pCond);
      fprintf(file,") ");
    }
    braces=check_enclosed_net(pExecNetList,cur_act_net);
    cur_act_net=pExecNetList;
    if(ctrl_send) {
      c_blank;
      fprintf(file,"if(!%s) break;\n",CtrlName(pStats));
      c_blank;
      fprintf(file,"else ");
    }
    print_par1();
    print_stat_with_braces(pStat,1);
    print_stat_end(braces,0);
    print_par2();
    cur_act_net=old_cur_act_net;
    if(pReinit != NoTree) {
      pred_print_Expr_begin(pReinit);
      parent_expr=pReinit;
      print_Expr(pReinit);
      if(end_statement_is_needed) fputs(";\n",file);
      end_statement_is_needed=1;
      pred_print_Expr_end(pReinit);
    }
    print_par3();
    if(ctrl_send) {
      b_end;
    }
  }
  c_blank;
  if(in_mapping > 2) {
    fprintf(file,"%s%d[MPC_actions%d]",ESTIMATION,in_mapping-1,in_mapping-1);
  }
  else {
    fprintf(file,"%s%d",ESTIMATION,in_mapping-1);
  }
  fprintf(file,"+=MPC_Par_estimation(ppower,MPC_actions%d,%s%d,MPC_involved_VPs%d,",
          in_mapping,ESTIMATION,in_mapping,in_mapping);
  if(in_mapping > 2) {
    fprintf(file,"MPC_involved_VPs%d[MPC_actions%d]);\n",
            in_mapping-1,in_mapping-1);
  }
  else {
    fprintf(file,"NULL);\n");
  }
  b_end;
  cur_act_net=old_cur_act_net;
  in_par=old_in_par;
  in_mapping=old_in_mapping;
  blank_is_necessary=1;
}

int print_Members(tTree pNetList) {
  int ret=0;
  PointerControl(pNetList);
  if(pNetList == SINGLE_NODE_LIST) return 0;
  if(IsSingleRegion(pNetList)) {
    tTree pNet;
    pNet=SingleRegion(pNetList);
    c_blank;
    ret=print_MemberAndPredicate(pNet);
  }
  else {
    int num;
    num=CountsNetInNetList/*NotFlexibleAndNumber*/(pNetList);
    if(num != 0) {
      ret=print_MembersList(pNetList,num);
      c_blank;
      fprintf(file,"if(MPC_Is_member_of_anynet(%s,%d)) {\n",NET_MEMBERS,num);
      cur_blank+=SKIP;
    }
    else {
      fprintf(stderr,
              "Sorry, flexible subnetwork in NetList isn't supported now\n");
      internal_error();
    }
  }
  return ret+1;
}

void fill_ActualExecNet(tTree pStat) {
  tTree pExpr;
  tTree pExecNetList;
  tTree pEvalNetList=NoTree;
  tStatFlags flag;
  tTree pStoreNet;
  tTree pRootNet;
  PointerControl(pStat);
  flag=pStat->MPC_Compound.Flag;
  if(prt) printf("fill_ActualExecNet begin pStat=%p RootNet=%p ActualExecNet=%p\n",
         pStat,pStat->MPC_Stat.RootNet,pStat->MPC_Stat.ActualExecNet);
  if(pStat->MPC_Stat.ActualExecNet != NoTree) return;
  switch(pStat->Kind) {
  case kMPC_If:
    pExpr=pStat->MPC_If.Expr;
    break;
  case kMPC_IfElse:
    pExpr=pStat->MPC_IfElse.Expr;
    break;
  case kMPC_Switch:
    pExpr=pStat->MPC_Switch.Expr;
    break;
  case kMPC_While:
    pExpr=pStat->MPC_While.Expr;
    break;
  case kMPC_DoWhile:
    pExpr=pStat->MPC_DoWhile.Expr;
    break;
  case kMPC_For:
    pExpr=pStat->MPC_For.Cond;
    break;
  case kMPC_ParScheme:
    pExpr=pStat->MPC_ParScheme.Cond;
    break;
  default:
    pExpr=NoTree;
    break;
  }
  if(prt) printf(" Stat=%p ExecNet=%p\n",pStat,pStat->MPC_Stat.ExecNet);
  pExecNetList=pStat->MPC_Stat.ExecNet;
  PointerControl(pExecNetList);
  PrintNetList(pExecNetList,0,"ExecNetList");
  pStat->MPC_Stat.ActualExecNet=NetEqList(CONST_NET,pExecNetList) ?
    cur_act_net : pExecNetList;
  pRootNet=NoTree;
  if(pExpr != NoTree)  {
    pStoreNet=pExpr->MPC_Expr.StoreNet;
    PointerControl(pStoreNet);
    pRootNet=pStoreNet;
    pEvalNetList=ExprEvalNet(pExpr);
    if(pStoreNet->MPC_NetOrSubnet.SingleNode &&
       pStoreNet != CONST_NET &&
       !NetEqList(pStoreNet,pExecNetList)/* && !flag.Asynchr*/) {
      pRootNet=find_root_net(pStoreNet,pExecNetList);
    }
  }
  PrintNet(pRootNet,"RootNet found");
  pStat->MPC_Stat.RootNet=pRootNet;
  pStat->MPC_Stat.PropNet=pStat->MPC_Stat.ActualExecNet;
  if(prt) printf("fill_ActualExecNet end  pStat=%p RootNet=%p ActualExecNet=%p\n",
         pStat,pStat->MPC_Stat.RootNet,pStat->MPC_Stat.ActualExecNet);
}
  
int check_enclosed_net(tTree cur_net_list, tTree prev_net_list) {
  int braces=0;
  int same;
  PointerControl(cur_net_list);
  PointerControl(prev_net_list);
  if(prt) printf("\n----before SameList------ not_check=%d\n",not_check);
  same=SameList(cur_net_list,prev_net_list);
  if(prt) printf(" --check_enclosed_net-- cur_net_list=%p prev_net_list=%p same=%d SubListOrParent(cur_net_list,prev_net_list)=%d \n",
         cur_net_list,prev_net_list,
         same,
         SubListOrParent(cur_net_list,prev_net_list));
  PrintNetList(cur_net_list,0,"cur_net_list");  
  PrintNetList(prev_net_list,0,"prev_net_list");  
  if(!same) {
    if(SubListOrParent(cur_net_list,prev_net_list)) {
      braces=print_Members(cur_net_list);
    }
    else {
      int subnet,single_prev,single_cur,parent;
      tTree cur_net,prev_net;
      single_prev=IsSingleRegion(prev_net_list);
      single_cur=IsSingleRegion(prev_net_list);
      prev_net=prev_net_list->MPC_NetList.Net;
      cur_net=cur_net_list->MPC_NetList.Net;
      PointerControl(cur_net);
      PointerControl(prev_net);
      subnet=is_subnet(prev_net,cur_net);
      parent=is_parent(cur_net,prev_net);
      if(prt) printf("check_enclosed_net not subnet single_cur=%d subnet=%d parent=%d\n",
             single_cur,subnet,parent);
      if(single_cur && subnet){
        braces=0;
      }
      else {
        fprintf(stderr,"cur_net_list isn't subset of the prev_net_list\n");
        internal_error();
      }
    }
  }
  return braces;
}

static int print_ctrl_cast(tTree pExpr) {
  tTree pType;
  int ret=0;
  PointerControl(pExpr);
  pType=pExpr->MPC_Expr.Type;
  PointerControl(pType);
  if(!(pType->Kind == kMPC_BasicType &&
       pType->MPC_BasicType.TypeConstructor == INT)) {
    fprintf(file,"(int)(");
    ret=1;
  }
  return ret;
}

void calc_and_prop_ctrl(tTree pStats, tTree pExpr, int ctrl_send) {
  if(pExpr != NoTree) {
    tTree old_act_net=cur_act_net;
    int old_not_change=not_change_net;
    int braces;
    int cast;
    int i;
    tTree pExecNet=cur_act_net;
    tTree pEvalNet;
    tTree pStoreNet;
    PointerControl(pStats);
    pStoreNet=pExpr->MPC_Expr.StoreNet;
    pEvalNet=pExpr->MPC_Expr.EvalNet;
    PointerControl(pEvalNet);
    if(prt) printf("calc_and_prop_ctrl ExecNet=%p EvalNet=%p ctrl_send=%d\n",
                   pExecNet,pEvalNet,ctrl_send);
    if(is_it_host_only(pEvalNet)) {
      if(prt) printf("set host_stat to 1\n");
      host_expr=1;
    }
    braces=check_enclosed_net(pEvalNet,cur_act_net);
    cur_act_net=pEvalNet;
    {
      int braces;
      parent_expr=pExpr;
      braces=pred_print_Expr_begin(pExpr);
      parent_expr=NoTree;
      if(ctrl_send) {
        int braces;
        tTree prev_act_net=cur_act_net;
        /*PrintNetList(cur_act_net,0,"cur_act_net before ");*/
        PointerControl(pStoreNet);
        cur_act_net=pStoreNet->MPC_NetOrSubnet.MyList;
        pExpr->MPC_Expr.ActualEvalNet=cur_act_net;
        /*PrintNetList(cur_act_net,0,"cur_act_net after StoreNet");*/
        PointerControl(cur_act_net);
        braces=check_enclosed_net(cur_act_net,prev_act_net);
        /*PrintNetList(cur_act_net,0,"cur_act_net after set_cur_act_net");*/
        c_blank;
        fprintf(file,"%s=",CtrlName(pStats));
        cast=print_ctrl_cast(pExpr);
        parent_expr=NoTree;
        not_change_net=1;
        print_Expr(pExpr);
        fprintf(file,"%s;\n",cast ? ")" : "");
        for(i=0; i<braces; i++) {
          b_end;
        }
        pred_print_Expr_end(pExpr);
        cur_act_net=prev_act_net;
      }
      for(i=0; i<braces; i++) {
        b_end;
      }
    }
    for(i=0; i<braces; i++) {
      b_end;
    }
    cur_act_net=old_act_net;
    not_change_net=old_not_change;
    host_expr=0;
    if(prt) printf(" before prop cur_act_net=%p host_stat=%d\n",
                   cur_act_net,host_stat);
    if(pStats->MPC_Stat.Flag.CtrlSend) print_propagation(pStats,pExpr);
  }
}

int calc_ctrl_send(tTree pExpr, tTree pStat) {
  tTree pEvalNet,pStoreNet,pStoreNetList;
  int ret;
  PointerControl(pStat);
  if(pExpr != NoTree) {
    pEvalNet=pExpr->MPC_Expr.EvalNet;
    PointerControl(pEvalNet);
    pStoreNet=pExpr->MPC_Expr.StoreNet;
    PointerControl(pStoreNet);
    pStoreNetList=pStoreNet->MPC_NetOrSubnet.MyList;
    PointerControl(pStoreNetList);
    ret=!SameList(pEvalNet,cur_act_net) ||
      (pred_gen_is_necessary(pExpr));
    pStat->MPC_Stat.Flag.CtrlSend=!SameList(pStoreNetList,cur_act_net);
  }
  else {
    ret=0;
    pStat->MPC_Stat.Flag.CtrlSend=ret;
  }
  return ret;
}
  

void print_stat_with_braces(tTree pStat, int print_braces) {
  if(pStat != NoTree) {
    blank_is_necessary=1;
    if(pStat->Kind != kMPC_Compound && print_braces) {
      cur_pos+=fputs("{\n",file);
      cur_blank+=SKIP;
    }
    Stats_print(pStat);
    if(pStat->Kind != kMPC_Compound && print_braces) {
      b_end;
    }
  }
}

void print_stat_end(int braces, int ctrl_send) {
  int i;
  for(i=0; i<braces; i++) {
    b_end;
  }
  if(ctrl_send) {
    b_end;
  }
}

void add_host_to_NetList(tTree pNetList) {
  PointerControl(pNetList);
  if(!IsInList(HOST,pNetList)) {
    while(pNetList->Kind != kMPC_FreeNode) {
      tTree pNet=pNetList->MPC_NetList.Net;
      PointerControl(pNet);
      if(pNet->MPC_NetOrSubnet.Distribution == HOST) {
        add_NetList_to_NetList(HOST_LIST,&pNetList);
        break;
      }
      pNetList=pNetList->MPC_NetList.Next;
      PointerControl(pNetList);
    }
  }
}

tTree ExprEvalNet(tTree pExpr) {
  tExprFlags flag;
  tTree pEvalNetList;
  PointerControl(pExpr);
  flag=pExpr->MPC_Expr.Flag;
  if(prt) printf("ExprEvalNet pExpr=%p Asynchr=%d SideEffects=%d\n",
                 pExpr,flag.Asynchr,flag.SideEffects);
  if(flag.Asynchr && !flag.SideEffects && !StoreEqEval(pExpr)) {
    tTree pStoreNet=pExpr->MPC_Expr.StoreNet;
    PointerControl(pStoreNet);
    pEvalNetList=pStoreNet->MPC_NetOrSubnet.MyList;
  }
  else {
    pEvalNetList=pExpr->MPC_Expr.EvalNet;
  }
  return pEvalNetList;
}

tTree get_parent_stat(tTree pStat) {
  PointerControl(pStat);
  if(prt)  printf("get_parent_stat pStat->Kind=%d\n",
            pStat->Kind);
  if(!Tree_IsType(pStat,kMPC_Stats)) {
    fprintf(stderr,"wrong kind of the argument of get_parent_stat =%d\n",
            pStat->Kind);
    internal_error();
  }
  while(pStat->Kind != kMPC_FreeNode) {
    pStat=pStat->MPC_Stats.Next;
    PointerControl(pStat);
  }
  pStat=pStat->MPC_FreeNode.Parent;
  PointerControl(pStat);
  return pStat;  
}

static tTree get_parent_block(tTree pStat) {
  int i=0;
  PointerControl(pStat);
  if(prt)  printf("get_parent_block pStat->Kind=%d\n",
            pStat->Kind);
  while(1) {
    pStat=get_parent_stat(pStat);
    i++;
    if(prt) printf("get_parent_block i=%d pStat->Kind=%d\n",
           i,pStat->Kind);
    if(pStat->Kind == kMPC_Compound) break;
  }
  return pStat;
}

static void sets_free_all_captured(tTree pStat) {
  tTree old_cur_block=cur_block;
  int out_needed=0;
  PointerControl(pStat);
  if(function_kind == BASIC || function_kind == NETWORK) {
  fprintf(file,"/* ReturnExit begin */\n");
    if(var_param_net != NoTree) {
      c_blank;
      fprintf(file,"MPC_Free(%s_params);\n",VarName(var_param_net));
    }
    the_last_return=0;
    if(!is_main_function) {
      tTree pNext=pStat->MPC_Stats.Next;
      PointerControl(pNext);
      if(pNext->Kind == kMPC_FreeNode) {
        tTree pBlock=pNext->MPC_FreeNode.Parent;
        PointerControl(pBlock);
        if(pBlock->Kind == kMPC_Compound &&
           pBlock->MPC_Compound.FunctionBody) {
          the_last_return=1;
        }
      }
      if(prt) printf("sets_free_all_captured the_last_return=%d\n",
                     the_last_return);
      if(!the_last_return) return_free=1;
      print_NetRelease();
      out_needed+=closing_needed;
      if(!the_last_return) {
        do {
          pStat=get_parent_block(pStat);
          PointerControl(pStat);
          if(prt) printf("sets_free_all_captured pStat=%p cur_block=%p\n",
                         pStat,cur_block); 
          if(pStat != cur_block) {
            cur_block=pStat;
            print_NetRelease();
            out_needed+=closing_needed;
          }
        }
        while(!pStat->MPC_Compound.FunctionBody);
      }
      if(out_needed) {
        print_host_out();
        b_end;
        fprintf(file,"%s_%d:\n",
                RETURN_POINT,is_return);
        print_EmptyOffer();
      }
    }
    fprintf(file,"/* ReturnExit end */\n");
  }
  cur_block=old_cur_block;
  return_free=0;
}


static void print_NetworkFunctionHead_action() {
  tTree pNet=var_fun_net;
  tTree pNetType=var_fun_net_type;
  tTree pNetworkParamList=var_fun_net_paramlist;
  tTree pNetParamType=var_fun_net_paramtype;
  if(pNetParamType != NoTree &&
       pNetParamType->Kind != kMPC_FreeNode) {
    c_blank;
    fprintf(file,"%s.pweb=%s->pweb;\n",
            VarName(pNet),NET_PARAMETER);
    c_blank;
    if(pNetworkParamList != NoTree &&
       pNetworkParamList->Kind != kMPC_FreeNode) {
      fprintf(file,"%s.count=",
              VarName(pNet));
      print_ParamNumber(pNetworkParamList,-1);
      fputs(";\n",file);
      c_blank;
      fprintf(file,"%s.params=%s_params;\n",
              VarName(pNet),VarName(pNet));
    }
    c_blank;
    fprintf(file,"%s.coord=%s_coord;\n",
            VarName(pNet),VarName(pNet));
    c_blank;
    fprintf(file,"%s.rank=%s->rank;\n",
            VarName(pNet),NET_PARAMETER);
    c_blank;
    fprintf(file,"%s.oldroot=%s->oldroot;\n",
            VarName(pNet),NET_PARAMETER);
    if(pNetworkParamList != NoTree &&
       pNetworkParamList->Kind != kMPC_FreeNode) {
      print_CopyParams(pNet,pNetType,pNetworkParamList);
    }
    c_blank;
    fprintf(file,"%s.power=MPC_Power(&%s);\n",
            VarName(pNet),VarName(pNet));
    c_blank;
    fprintf(file,"MPC_Coord_set(&%s,%s.rank);\n",
            VarName(pNet),VarName(pNet));
  }
}


static void look_for_screening_var(tTree yyt) {
  if(yyt != NoTree && yyt->Kind == kMPC_VarDecl) {
    tTree pVar=yyt->MPC_VarDecl.Var;
    PointerControl(pVar);
    while(pVar->Kind != kMPC_FreeNode) {
      if(LookIdent == pVar->MPC_Var.Ident) {
        tPosition VarPos=pVar->MPC_Var.Pos;
        if(prt) printf("the same ident Look=(%d) Var=(%s,%d)\n",
               LookIdent,VarName(pVar),pVar->MPC_Var.Ident);
        GetString(LookIdent,NameBuf);
        fprintf(stderr,
                "error in %s: the value of variable (%d,%d)->%s  \n", 
               SourceFile(IdentPos),RealPosition(IdentPos).Line,
               RealPosition(IdentPos).Column,NameBuf);
        fprintf(stderr,
                "         %s: will be replaced by the value of variable \n",
               SourceFile(IdentPos));
        fprintf(stderr,"         %s: (%d,%d)->%s \n",
               SourceFile(IdentPos),RealPosition(VarPos).Line,
                RealPosition(VarPos).Column, VarName(pVar));
        Position=IdentPos;
        fprintf(stderr,"         %s: Sorry, it is not supported now\n",
                SourceFile(IdentPos));
        delete_c_file();
        exit(1);
      }
      pVar=pVar->MPC_Var.Next;
      PointerControl(pVar);
    }
  }
}

static void look_for_screening(tTree yyt) {
  if(yyt != NoTree &&
     (yyt->Kind == kMPC_Ident || yyt->Kind == kMPC_Exprs)) {
    tTree pDecls=CurrentDecls;
    tTree pExpr;
    tIdent Ident;
    if(yyt->Kind == kMPC_Exprs) {
      pExpr=yyt->MPC_Exprs.Expr;
      PointerControl(pExpr);
      if(pExpr->Kind != kMPC_Ident) {
        return;
      }
    }
    else {
        pExpr=yyt;
    }
    Ident=pExpr->MPC_Ident.Ident;
    IdentControl(Ident);
    GetString(Ident,NameBuf);
    LookIdent=Ident;
    IdentPos=pExpr->MPC_Ident.Pos;
        if(prt) printf(" Look=(%s,%d)\n",
               NameBuf,LookIdent);
    PointerControl(pDecls);
    while(pDecls->Kind != kMPC_FreeNode) {
      look_for_screening_var(pDecls);
      pDecls=pDecls->MPC_Decls.Next;
      PointerControl(pDecls);
    }
  }
}

    
  
static void look_for_screened(tTree pDecls) {
  if(pDecls != NoTree && Tree_IsType(pDecls,kMPC_Decls)) {
    if(prt) printf(" look_for_screened pDecls=%p Kind=%d\n",
           pDecls,pDecls->Kind);
    CurrentDecls=pDecls;
    switch(pDecls->Kind) {
    case kMPC_NetDecl:
      {
        tTree pNetTypeSpec=pDecls->MPC_NetDecl.NetTypeSpecifier;
        tTree pArgList;
        PointerControl(pNetTypeSpec);
        pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
        PointerControl(pArgList);
        Expr_traverse(pArgList,look_for_screening);
      }
      break;
    case kMPC_SubnetDecl:
      {
        tTree pSubnet=pDecls->MPC_SubnetDecl.Subnet;
        PointerControl(pSubnet);
        while(pSubnet->Kind != kMPC_FreeNode) {
          tTree pPredicate=pSubnet->MPC_Subnet.Predicate;
          PointerControl(pPredicate);
          Expr_traverse(pPredicate,look_for_screening);
          pSubnet=pSubnet->MPC_Subnet.Next;
          PointerControl(pSubnet);
        }
      }
      break;
    default:
      break;
    }
  }
}
