/*
 * $Id: PredExpr_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp ka $
 */


/* code generation for c[] pecularity and sinchro dependences */
/* Coded by A.Kalinov 11.95 - 12.95 */

#include "be_print.h"
#include "ress.h"

void print_Reduce(tTree pExpr, tTree parent_expr);
void print_Linear(tTree pExpr, tTree parent_expr);
void pred_var_decl(tTree pExpr, int level, void (*) (tTree));
void gen_TmpName(tTree pExpr);
void gen_TmpAlloc(tTree pExpr);
void gen_TmpFree(tTree pExpr);
int parent_is_good_assign(tTree old_parent_expr);
void calculate_tmp_var(tTree pExpr);
int is_enything_to_do;
void find_something_to_do(tTree );
int was_peculiarity=0;


int StoreEqEval(tTree pExpr) {
  tTree pStoreNet,pEvalNet;
  PointerControl(pExpr);
  pStoreNet=pExpr->MPC_Expr.StoreNet;
  PointerControl(pStoreNet);
  pEvalNet=pExpr->MPC_Expr.EvalNet;
  PointerControl(pEvalNet);
  return pStoreNet == pEvalNet->MPC_NetList.Net;
}


int pred_gen_is_necessary(tTree pExpr) {
  tExprFlags flag;
  if(pExpr == NoTree) return 0;
  flag=pExpr->MPC_Expr.Flag;
  if(flag.Peculiarity) return 1;
  if(flag.SideEffects && !StoreEqEval(pExpr)/*&& (!StoreEqEval(pExpr) || was_peculiarity)*/) return 1;
  if(function_kind == NODAL) return 0;
  return !flag.Asynchr;
}


static int dynamic_expr;

void is_dynamic_expr_p(tTree pExpr)
{
if(is_dynamic_type(pExpr->MPC_Expr.Type)) dynamic_expr=1;
}

int is_dynamic_expr(tTree pExpr)
{
dynamic_expr=0;
Expr_traverse(pExpr,is_dynamic_expr_p);
return dynamic_expr;
}


int pred_print_Expr_begin(tTree pExpr) {
  int braces=0;
  was_peculiarity=0;
  PointerControl(pExpr);
  Position=pExpr->MPC_Expr.Pos;
  set_defer_atribute(pExpr);
   
  if(in_return&&is_dynamic_expr(pExpr)) 
    {
    pExpr->MPC_Expr.Flag.Defer=0;
    pExpr->MPC_Expr.Flag.Peculiarity=1;
    }
  if(pred_gen_is_necessary(pExpr) ) {
    tTree pEvalNetList=pExpr->MPC_Expr.EvalNet;
    tTree prev_act_net=cur_act_net;
    PointerControl(pEvalNetList);
    c_blank;
    cur_pos+=fputs("{\n",file);
    cur_blank+=SKIP;
    cur_pos=cur_blank;
    pred_var_decl(pExpr,1,declareNewVectorTypes);
    pred_var_decl(pExpr,1,gen_TmpName);
    pred_var_decl(pExpr,1,initNewVectorTypes);
    pred_var_decl(pExpr,1,gen_TmpAlloc);


    if(!not_change_net) cur_act_net=pEvalNetList;
    not_pecul=!(pExpr->MPC_Expr.Flag.Peculiarity ||
      pExpr->MPC_Expr.Flag.SideEffects);

    if(in_return&&is_dynamic_expr(pExpr)) 
        {
        pred_print_Expr(pExpr,0);
        }
    else  pred_print_Expr(pExpr,1);
    in_return=0; 

    cur_act_net=prev_act_net;
  }
  return braces;
}

void pred_print_Expr(tTree pExpr, int level) {
  tTree pOperand;
  tTree pLop,pRop;
  tTree pFop,pSop,pTop;
  tExprFlags flag;
  tTree old_parent_expr=parent_expr;
  tTree prev_act_net=cur_act_net;
  int old_change_net=not_change_net;
  int old_not_check=not_check;
  int old_was_peculiarity=was_peculiarity;
  int i;
  int braces;
  tTree pExprCheck;
  if(prt) printf("\npred_print_Expr pExpr=%p",pExpr);
  PointerControl(pExpr);
  flag=pExpr->MPC_Expr.Flag;
  if(prt) printf(" kind=%d Defer=%d level=%d tmp_name=\"%s\"",
         pExpr->Kind,flag.Defer,level,pExpr->MPC_Expr.TmpName);
  if(prt) printf(" Asyn=%d Pec=%d\n",flag.Asynchr,flag.Peculiarity);
  if(flag.Peculiarity || flag.SideEffects) post_gen=0;
  was_peculiarity+=flag.Peculiarity;
  if(!pred_gen_is_necessary(pExpr) &&
     (!flag.Defer || !level) &&
     !strcmp(pExpr->MPC_Expr.TmpName,"")) {
    if(prt) printf("   nothing to be predgenerated pred_gen_is_necessary=%d\n",
                   pred_gen_is_necessary(pExpr));
    return;
  }
  pExprCheck=pExpr;
  if(pExpr->Kind == kMPC_NetCastExpr) {
    tTree pOp=pExpr->MPC_NetCastExpr.Operand;
    PointerControl(pOp);
    pExprCheck=pOp;
  }
  if(pExprCheck->Kind == kMPC_UnaryExpr &&
     pExprCheck->MPC_UnaryExpr.OpCode == BRACKETS) {
    tTree pOp=pExprCheck->MPC_UnaryExpr.Operand;
    PointerControl(pOp);
    if(!pred_gen_is_necessary(pOp))
      return;
  }
  parent_expr=pExpr;
  if(!flag.Generated) {
    fill_ActualEvalNet(pExpr);
    cur_act_net=pExpr->MPC_Expr.ActualEvalNet;
    PointerControl(cur_act_net);
  }
  braces=0;
  if(flag.Asynchr) not_check=1;
  braces=check_enclosed_net(cur_act_net,prev_act_net);
  /*if((was_peculiarity || flag.SideEffects) &&
     pExpr->MPC_Expr.Pass == 0) {
    PredExpr_traverse(pExpr,pred_expr_gen);
  }*/ 
  {
    tTree prev_act_net=cur_act_net;
    int braces=0;
    switch(pExpr->Kind) {
    case kMPC_CastExpr:
      pOperand=pExpr->MPC_CastExpr.Operand;
      PointerControl(pOperand);
      pred_print_Expr(pOperand,0);
      break;
    case kMPC_NetCastExpr:
      if(is_NetCast_asynch(pExpr)) {
        pOperand=pExpr->MPC_NetCastExpr.Operand;
        PointerControl(pOperand);
        pred_print_Expr(pOperand,0);
      }
      else {
        fprintf(stderr,"Sorry, not asynchr NetCast isn't supported \n");
        internal_error();
      }
      break;
    case kMPC_CoordExpr:
    case kMPC_Size_Of_Type:
    case kMPC_Size_Of_Value:
       break;
    case kMPC_TimeofExpr:
      {
	tTree pNetDecl=pExpr->MPC_TimeofExpr.NetDecl;
        tTree p_net;
	PointerControl(pNetDecl);
	print_NetDecl(pNetDecl);
        p_net=pNetDecl->MPC_NetDecl.Net;
        PointerControl(p_net);
        if(p_net->MPC_Net.Topology != CONST) {
          tTree pNetTypeSpec=p_net->MPC_Net.NetType;
          tTree pNetType,pArgList,pParamList;
          tTree old_pCurParamList=pCurParamList;
          tTree old_pCurExprs=pCurExprs;
          PointerControl(pNetTypeSpec);
          pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
          PointerControl(pNetType);
          pParamList=pNetType->MPC_NetType.ParamList;
          PointerControl(pParamList);
          pCurParamList=pParamList;
          pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
          PointerControl(pArgList);
          pCurExprs=pArgList;
          if(pParamList->Kind != kMPC_FreeNode) {
            c_blank;
            fprintf(file,"%s.count=",VarName(p_net));
            print_ParamNumber(pArgList,-1);
            fprintf(file,";\n");
            print_CopyParams(p_net,pNetType,pArgList);
            /*print_topo_params(p_net);*/
          }
          pCurParamList=old_pCurParamList;
          pCurExprs=old_pCurExprs;
        }
      }
      break;
    case kMPC_UnaryExpr:
      if(prt) printf("Unary_Expr pExpr=%p OpCode=%d\n",
                     pExpr,pExpr->MPC_UnaryExpr.OpCode);
      pOperand=pExpr->MPC_UnaryExpr.Operand;
      PointerControl(pOperand);
      pred_print_Expr(pOperand,0);
      if(pExpr->MPC_UnaryExpr.OpCode>DISTRIBUTED) {
        tTree pType=pExpr->MPC_UnaryExpr.Type;
        PointerControl(pType);
        c_blank;
        fprintf(file,"{\n");
        cur_blank+=SKIP;
        print_rts_type(pType,1);            
        print_Reduce(pExpr,old_parent_expr);
        b_end;
        pExpr->MPC_UnaryExpr.Flag.Generated=1;
      }
      else if(pExpr->MPC_UnaryExpr.OpCode>LINEAR) {
        print_Linear(pExpr,old_parent_expr);
        pExpr->MPC_UnaryExpr.Flag.Generated=1;
      }
      else if(pExpr->MPC_UnaryExpr.OpCode == PRE_INC ||
              pExpr->MPC_UnaryExpr.OpCode == PRE_DEC ||
              pExpr->MPC_UnaryExpr.OpCode == POST_INC ||
              pExpr->MPC_UnaryExpr.OpCode == POST_DEC) {
        if(prt) printf("!flag.Defer=%d !level=%d pExpr=%p\n",!flag.Defer,!level,pExpr);
        if(!flag.Defer && !level) {
          calculate_tmp_var(pExpr);
        }
      }
      break;
    case kMPC_BinaryExpr:
      pLop=pExpr->MPC_BinaryExpr.Loperand;
      PointerControl(pLop);
      pred_print_Expr(pLop,0);
      pRop=pExpr->MPC_BinaryExpr.Roperand;
      PointerControl(pRop);
      pred_print_Expr(pRop,0);
      if(pExpr->MPC_BinaryExpr.OpCode == ASSIGN &&
         (!is_Assign_asynch(pExpr))) {
        print_PredAssign(pExpr);
      }
      if(prt) printf("!flag.Defer=%d !level=%d pExpr=%p\n",!flag.Defer,!level,pExpr);
      if(!flag.Defer && !level) {
        calculate_tmp_var(pExpr);
      }      
      break;
    case kMPC_TernaryExpr:
      pFop=pExpr->MPC_TernaryExpr.Foperand;
      PointerControl(pFop);
      pred_print_Expr(pFop,0);
      pSop=pExpr->MPC_TernaryExpr.Soperand;
      PointerControl(pSop);
      pred_print_Expr(pSop,0);
      pTop=pExpr->MPC_TernaryExpr.Toperand;
      PointerControl(pTop);
      pred_print_Expr(pTop,0);
      if(!flag.Defer && !level) {
        calculate_tmp_var(pExpr);
      }      
      break;
    case kMPC_CallExpr:
      {
        tTree pFun=pExpr->MPC_CallExpr.Function;
        tTree pArgList=pExpr->MPC_CallExpr.ArgList;
        tTree pNetworkArgList=pExpr->MPC_CallExpr.NetworkArgList;
        PointerControl(pFun);
        pred_print_Expr(pFun,0);
        if(pArgList != NoTree) {
          while(pArgList->Kind != kMPC_FreeNode) {
            tTree pEx=pArgList->MPC_Exprs.Expr;
            PointerControl(pEx);
            pred_print_Expr(pEx,0);
            pArgList=pArgList->MPC_Exprs.Next;
            PointerControl(pArgList);
          }
        }
        if(pNetworkArgList != NoTree) {
          while(pNetworkArgList->Kind != kMPC_FreeNode) {
            tTree pEx=pNetworkArgList->MPC_Exprs.Expr;
            PointerControl(pEx);
            pred_print_Expr(pEx,0);
            pNetworkArgList=pNetworkArgList->MPC_Exprs.Next;
            PointerControl(pNetworkArgList);
          }
        }
      }
      if(!flag.Defer && !level) {
        calculate_tmp_var(pExpr);
      }      
      break;
    default:
      break;
    }
    for(i=0; i<braces; i++) {
      b_end;
    }
    cur_act_net=prev_act_net;
  }
  post_gen=1;
  parent_expr=old_parent_expr;
  for(i=0; i<braces; i++) {
    b_end;
  }
  cur_act_net=prev_act_net;
  not_change_net=old_change_net;
  not_check=old_not_check;
  was_peculiarity=old_was_peculiarity;
  if(prt) printf("\npred_print_Expr end  pExpr=%p",pExpr);
}
  
void clear_expr(tTree yyt) {
  if(yyt != NoTree) {
    if(prt) printf("clear_expr yyt=%p Kind=%d\n",yyt,yyt->Kind);
    if(Tree_IsType(yyt,kMPC_Expr)) {
      yyt->MPC_Expr.TmpName="";
      yyt->MPC_Expr.Flag.Generated=0;
      yyt->MPC_Expr.Flag.Defer=0;
      yyt->MPC_Expr.Pass=0;
      yyt->MPC_Expr.ActualEvalNet=NoTree;
    }
  }
}

void pred_print_Expr_end(tTree pExpr) {
  tExprFlags flag;
  PointerControl(pExpr);
  flag=pExpr->MPC_Expr.Flag;
  if(prt) printf("pred_print_Expr_end begin pExpr=%p Pass=%d post_gen=%d not_pecul=%d SideEff=%d\n",
         pExpr,pExpr->MPC_Expr.Pass,post_gen,not_pecul,flag.SideEffects);
  if(pred_gen_is_necessary(pExpr)) {
    pred_var_decl(pExpr,1,gen_TmpFree);  
    b_end;
  }
  was_peculiarity=0;
  not_pecul=1;
  /*TraverseTreeTD*/Expr_traverse(pExpr,clear_expr);
  if(prt) printf("pred_print_Expr_end end\n");
}

tTree base_type(tTree pType) {
  PointerControl(pType);
  while(pType->Kind != kMPC_BasicType) {
    pType=next_type(pType);
    if(pType == NoTree) {
      fprintf(stderr,"wrong base type in reduction\n");
      internal_error();
    }
  }
  return pType;
}
    
static char* ReduceName[9]={
  "MPC_PROD","MPC_MAX","MPC_MIN","MPC_SUM","MPC_BAND",
  "MPC_BOR","MPC_BXOR","MPC_LAND","MPC_LOR"};

void print_Reduce(tTree pExpr, tTree parent_expr) {
  int code=0;
  PointerControl(pExpr);
  
  /*PointerControl(parent_expr);*/
  if(prt) printf("Reduce begin pExpr=%p\n",pExpr);
  switch(pExpr->MPC_UnaryExpr.OpCode) {
  case DISTR_LIN_MULT:
    code=0;
    break;
  case DISTR_LIN_MAX:
    code=1;
    break;
  case DISTR_LIN_MIN:
    code=2;
    break;
  case DISTR_LIN_PLUS:
    code=3;
    break;
  case DISTR_LIN_AND:
    code=4;
    break;
  case DISTR_LIN_EXCL_OR:
    code=5;
    break;
  case DISTR_LIN_INCL_OR:
    code=6;
    break;
  case DISTR_LIN_LOG_AND:
    code=7;
    break;
  case DISTR_LIN_LOG_OR:
    code=8;
    break;
    /*  case DISTR_ASS_CALL:
  case DISTR_COMM_CALL:*/
  default:
    fprintf(stderr,"Sorry, this kind of the reduce isn't supported now\n");
    internal_error();
    break;
  }
  {
    tTree pNet=pExpr->MPC_Expr.StoreNet;
    tTree pType,pBaseType;
    tTree pOperand=pExpr->MPC_UnaryExpr.Operand;
    int pos;
    PointerControl(pNet);
    PointerControl(pOperand);
    pType=tmp_var_type(pExpr);
    PointerControl(pType);
    pBaseType=base_type(pType);
    PointerControl(pBaseType);
    c_blank;
    pos=cur_pos+fprintf(file,"MPC_Reduce(");
    fprintf(file,"&%s,",VarName(pNet));
    print_Address(pOperand,0);
    is_argument=1;
    print_Expr(pOperand);
    fprintf(file,",");
    print_Address(pExpr,0);
    if(parent_is_good_assign(parent_expr)) {
      tTree pLop=parent_expr->MPC_BinaryExpr.Loperand;
      PointerControl(pLop);
      print_Expr(pLop);
      parent_expr->MPC_Expr.Flag.Generated=1;
    }
    else {
      fprintf(file,"%s",
              pExpr->MPC_Expr.TmpName);
    }
    is_argument=0;
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(%s)(&%s),\n",
            DATATYPE,DataVarName(pType));
    blank(pos);
    fprintf(file,"(%s)(&%s),%s);\n",
            DATATYPE,DataVarName(pBaseType),ReduceName[code]);
    pExpr->MPC_Expr.Type=pType;
  }
  if(prt) printf("Reduce end pExpr=%p\n",pExpr);
  /*end_statement_is_needed=0;*/
}

tTree tmp_var_type(tTree pExpr) {
  tTree pType=NoTree;
  if(prt) printf("pExpr=%p",pExpr);
  PointerControl(pExpr);
  switch (pExpr->Kind) {
  case kMPC_UnaryExpr:
    if(pExpr->MPC_UnaryExpr.OpCode > DISTRIBUTED) {
      tTree pOperand=pExpr->MPC_UnaryExpr.Operand;
      PointerControl(pOperand);
      pType=pOperand->MPC_Expr.Type;
      PointerControl(pType);
    }
    break;
  default:
    break;
  }
  if(pType == NoTree) {
    pType=pExpr->MPC_Expr.Type;
    PointerControl(pType);
  }
  return pType;
}

void gen_TmpName(tTree pExpr) {
  tTree pType;
  int old_source_only=source_only;
  int old_print_base_type=print_base_type;
  if(prt) printf("gen_TmpName MPC_tmp%d pExpr=%p\n",tmp_num,pExpr);
  sprintf(NameBuf,"MPC_tmp%d",tmp_num++);
  PointerControl(pExpr);
  pExpr->MPC_Expr.TmpName=malloc(strlen(NameBuf)+1);
  strcpy(pExpr->MPC_Expr.TmpName,NameBuf);
  c_blank;
  pType=tmp_var_type(pExpr);
  if(prt) printf(" Expr->Kind=%d old Type=%p new pType=%p Type->kind=%d\n",
         pExpr->Kind,pExpr->MPC_Expr.Type,pType,pType->Kind);
  PointerControl(pType);
  not_const=1;
  source_only=1;
  print_base_type=1;
  print_Type(pType);
  not_const=0;
  source_only=0;
  print_base_type=0;
  print_LeftType(pType,NoTree);
  cur_pos+=fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
  print_RightType(pType,NoTree);
  cur_pos+=fprintf(file,";\n");
  source_only=old_source_only;
  print_base_type=old_print_base_type;
}

void gen_TmpAlloc(tTree pExpr) {
  tTree pType;
  int old_print_base_type=print_base_type;
  if(prt) printf("gen_TmpAlloc MPC_tmp%d pExpr=%p\n",tmp_num,pExpr);
 
  pType=tmp_var_type(pExpr);
  if((is_dynamic_type(pType)==DYNAMIC_ARRAY)||(is_dynamic_type(pType)==DYNAMIC_VECTOR))
    {
    c_blank;
    if(prt) printf(" Expr->Kind=%d old Type=%p new pType=%p Type->kind=%d\n",
         pExpr->Kind,pExpr->MPC_Expr.Type,pType,pType->Kind);
    PointerControl(pType);
    fprintf(file,"if(!(%s=(void*)",pExpr->MPC_Expr.TmpName);
    
    fprintf(file,"malloc(%s.Base.Size))) %s(\"\\\"%s\\\" temporary variable allocaltion failed.\"),%s(1);\n",
            DataVarName(pType),CBRACKETS ? "printf":"MPC_Printf",pExpr->MPC_Expr.TmpName,CBRACKETS ? "exit":"MPC_Exit");
    print_base_type=old_print_base_type;
    }
}

void gen_TmpFree(tTree pExpr) {
  tTree pType;
 
  if(prt) printf("gen_TmpFree MPC_tmp%d pExpr=%p\n",tmp_num,pExpr);
  pType=tmp_var_type(pExpr);
  if((is_dynamic_type(pType)==DYNAMIC_ARRAY)||(is_dynamic_type(pType)==DYNAMIC_VECTOR))
    {
    c_blank;
    if(prt) printf(" Expr->Kind=%d old Type=%p new pType=%p Type->kind=%d\n",
         pExpr->Kind,pExpr->MPC_Expr.Type,pType,pType->Kind);
    PointerControl(pType);
    fprintf(file,"free(%s);\n",pExpr->MPC_Expr.TmpName);
    }
}


int parent_is_good_assign(tTree old_parent_expr) {
  if(old_parent_expr != NoTree &&
     old_parent_expr->Kind == kMPC_BinaryExpr &&
     (old_parent_expr->MPC_BinaryExpr.OpCode >= ASSIGN &&
      old_parent_expr->MPC_BinaryExpr.OpCode <=INCL_OR_ASSIGN)) {
    tTree pLop=old_parent_expr->MPC_BinaryExpr.Loperand;
    tTree pRop=old_parent_expr->MPC_BinaryExpr.Roperand;
    PointerControl(pLop);
    PointerControl(pRop);
    if(pLop->MPC_Expr.StoreNet == pRop->MPC_Expr.StoreNet) {
      if(pLop->MPC_Expr.Type == pRop->MPC_Expr.Type)
        return 1;
      else if((pRop->Kind==kMPC_UnaryExpr)&& IS_LINEAR_OPER(pRop->MPC_UnaryExpr.OpCode))
        return 1;
    }
  }
  return 0;
}


void pred_var_decl(tTree pExpr, int level, void (*decl_function) (tTree)) {
  PointerControl(pExpr);
  if(pExpr->Kind == kMPC_Exprs) {
    tTree pExprs=pExpr;
    while(pExprs->Kind != kMPC_FreeNode) {
      tTree pExp=pExprs->MPC_Exprs.Expr;
      PointerControl(pExp);
      pred_var_decl(pExp,0,decl_function );
      pExprs=pExprs->MPC_Exprs.Next;
      PointerControl(pExprs);
    }
  }
  else if(Tree_IsType(pExpr,kMPC_Expr)) {
    tTree pOperand;
    tTree pLop,pRop;
    tTree pFop,pSop,pTop;
    tExprFlags flag;
    tTree old_parent_expr=parent_expr;
    int old_was_peculiarity=was_peculiarity;
    flag=pExpr->MPC_Expr.Flag;
    if(prt) printf("pred_var_decl pExpr=%p level=%d Kind=%d ",
           pExpr,level,pExpr->Kind);
    was_peculiarity+=flag.Peculiarity;
    if(prt) printf("Defer=%d\n",
           flag.Defer);
    if(!pred_gen_is_necessary(pExpr) && flag.Defer) return;
    parent_expr=pExpr;
    switch(pExpr->Kind) {
    case kMPC_CastExpr:
      pOperand=pExpr->MPC_CastExpr.Operand;
      PointerControl(pOperand);
      pred_var_decl(pOperand,0,decl_function);
      break;
    case kMPC_NetCastExpr:
      if(is_NetCast_asynch(pExpr)) {
        pOperand=pExpr->MPC_NetCastExpr.Operand;
        PointerControl(pOperand);
        pred_var_decl(pOperand,0,decl_function);
      }
      else {
        fprintf(stderr,
                "Sorry, tmp_var to the not asynchr NetCast isn't supported\n");
        internal_error();
      }
      break;
    case kMPC_CoordExpr:
    case kMPC_Size_Of_Type:
      break;
    case kMPC_Size_Of_Value:
      if(pExpr->MPC_Size_Of_Value.CompileTime) {
        break;
      }
      pOperand=pExpr->MPC_Size_Of_Value.Operand;
      PointerControl(pOperand);
      pred_var_decl(pOperand,0,decl_function);
      break;
    case kMPC_UnaryExpr:
      pOperand=pExpr->MPC_UnaryExpr.Operand;
      PointerControl(pOperand);
      pred_var_decl(pOperand,0,decl_function);
      if(prt) printf("pred_var_decl kMPC_UnaryExpr OpCode=%d level=%d\n",
             pExpr->MPC_UnaryExpr.OpCode,level);
      if(pExpr->MPC_UnaryExpr.OpCode>LINEAR || !flag.Defer) { 
        /*PointerControl(old_parent_expr);*/
        if(in_condition || !parent_is_good_assign(old_parent_expr)) {
          decl_function(pExpr);
        }
      }
      break;
    case kMPC_BinaryExpr:
      pLop=pExpr->MPC_BinaryExpr.Loperand;
      PointerControl(pLop);
      pred_var_decl(pLop,0,decl_function);
      pRop=pExpr->MPC_BinaryExpr.Roperand;
      PointerControl(pRop);
      pred_var_decl(pRop,0,decl_function);
      if(prt) printf("Defer=%d parent_is_good_assign(old_parent_expr)=%d pExpr != old_parent_expr=%d\n",
             flag.Defer,parent_is_good_assign(old_parent_expr),pExpr != old_parent_expr);
      if(!flag.Defer && pExpr != old_parent_expr) {
        decl_function(pExpr);
      }      
      break;
    case kMPC_TernaryExpr:
      pFop=pExpr->MPC_TernaryExpr.Foperand;
      PointerControl(pFop);
      pred_var_decl(pFop,0,decl_function);
      pSop=pExpr->MPC_TernaryExpr.Soperand;
      PointerControl(pSop);
      pred_var_decl(pSop,0,decl_function);
      pTop=pExpr->MPC_TernaryExpr.Toperand;
      PointerControl(pTop);
      pred_var_decl(pTop,0,decl_function);
      if(!flag.Defer && !parent_is_good_assign(old_parent_expr) &&
         pExpr != old_parent_expr) {
        decl_function(pExpr);
      }      
      break;
    case kMPC_CallExpr:
      {
        tTree pFun=pExpr->MPC_CallExpr.Function;
        tTree pArgList=pExpr->MPC_CallExpr.ArgList;
        tTree pNetworkArgList=pExpr->MPC_CallExpr.NetworkArgList;
        PointerControl(pFun);
        pred_var_decl(pFun,0,decl_function);
        if(pArgList != NoTree) pred_var_decl(pArgList,0,decl_function);
        if(pNetworkArgList != NoTree) pred_var_decl(pNetworkArgList,0,decl_function);
      }
      if(!flag.Defer && pExpr != old_parent_expr) {
        decl_function(pExpr);
      }      
      break;
    default:
      break;
    }
    parent_expr=old_parent_expr;
    was_peculiarity=old_was_peculiarity;
  }
}  

static char* lin_oper[9]= {"*=","<",">","+=","&=","^=","|=","&&=","||="};
char* lin_oper_code(int code) {
  switch(code) {
  case LIN_MULT:    return lin_oper[0];
  case LIN_MAX:     return lin_oper[1];
  case LIN_MIN:     return lin_oper[2];
  case LIN_PLUS:    return lin_oper[3];
  case LIN_AND:     return lin_oper[4];
  case LIN_EXCL_OR: return lin_oper[5];
  case LIN_INCL_OR: return lin_oper[6];
  case LIN_LOG_AND: return lin_oper[7];
  case LIN_LOG_OR:  return lin_oper[8];
  default:
    fprintf(stderr,"wrong OpCode of the linear operator = %d\n",code);
    internal_error();
    break;
  }
  return "___";
}


 

void print_Linear(tTree pExpr, tTree parent_expr) {
  int l_index;
  tTree pOperand;
  tTree pOpType;
  int old_in_sideeff;
  old_in_sideeff=in_sideeff;
  in_sideeff=1;
  if(prt) printf("print_Linear pExpr=%p parent_expr=%p\n",pExpr,parent_expr);
  PointerControl(pExpr);
  /*PointerControl(parent_expr);*/
  pOperand=pExpr->MPC_UnaryExpr.Operand;
  PointerControl(pOperand);
  pOpType=pOperand->MPC_Expr.Type;
  PointerControl(pOpType);
  l_index=index_level(pOpType);
  if(l_index == 0) {
    fprintf(stderr,"wrong kind of the linear operation\n");
    internal_error();
  }
  else {
    int i_index=0;
    int good_parent=parent_is_good_assign(parent_expr);
    int max_min_linear=(pExpr->MPC_UnaryExpr.OpCode == LIN_MAX ||
                        pExpr->MPC_UnaryExpr.OpCode == LIN_MIN);
    int apply_tiling=0;
    
    tTree pParentLop=NoTree;
    boundary_num=0;
    if(max_min_linear) post_gen=0;
    index_boundary=malloc(sizeof(struct INDEX_BOUNDARY)*l_index);
    steps=malloc(sizeof(int)*l_index);
    set_index_boundary(pOpType);
    if(good_parent) ExprPiece_traverse(NoTree,parent_expr,set_tmp_slots);
    else ExprPiece_traverse(NoTree,pExpr,set_tmp_slots);
    if(l_index!=1) apply_tiling=calc_apply_tiling(pExpr);
    /*QueryTree(pExpr);*/

    
    c_blank;
    fprintf(file,"{\n");
    cur_blank+=SKIP;

    declareNewVectorTypes(pOperand);
    
    if(apply_tiling) {
      i_index=l_index-1;
      c_blank;
      fprintf(file,"int " TILE_SIZE ";\n");
      c_blank;
      fprintf(file,"int %s=0;\n",TILE_PREFIX);
      initNewVectorTypes(pOperand);
      c_blank;
      fprintf(file,TILE_SIZE "=");
      TileSize_print(pExpr);
      c_blank;
      if(index_boundary[i_index].NumberOfComponents)
        fprintf(file,"for(;%s<%d;%s+=" TILE_SIZE ") {\n",
                TILE_PREFIX,
                index_boundary[i_index].NumberOfComponents,
                TILE_PREFIX);
      else 
        {
          fprintf(file,"for(;%s<",TILE_PREFIX);
          fprintf(file,"%s.Number;",DataVarName(index_boundary[i_index].Type));
          fprintf(file,"%s+=" TILE_SIZE ") {\n",TILE_PREFIX);
        }
      cur_blank+=SKIP;
      c_blank;
      fprintf(file,"int %s;\n",INDEX_BOUND_PREFIX);
    }
    
    i_index=0;
    
    /*if(apply_tiling==0){
      c_blank;
      fprintf(file,"{\n");
      cur_blank+=SKIP;
    }*/
    c_blank;
    fprintf(file,"int %s=0;\n",index_name(0));
    global_index_level=0;
    if(good_parent) {
      global_shift=1;
      ExprPiece_traverse(NoTree,parent_expr->MPC_BinaryExpr.Loperand,declare_tmp_slots);
      global_shift=0;
    }
    ExprPiece_traverse(NoTree,pExpr,declare_tmp_slots);

    initNewVectorTypes(pOperand);

    if(good_parent) {
      global_shift=1;
      use_slots=1;
      ExprPiece_traverse(NoTree,parent_expr->MPC_BinaryExpr.Loperand,calc_tmp_slots);
      use_slots=0;
      global_shift=0;
    }

    use_slots=1;
    ExprPiece_traverse(NoTree,pExpr,calc_tmp_slots);
    use_slots=0;
    
    c_blank;
    if(apply_tiling!=0) {
      fprintf(file,"%s=",INDEX_BOUND_PREFIX);
      if(index_boundary[i_index].NumberOfComponents)
        fprintf(file,"((%d)<(%s+" TILE_SIZE "))?(%d):(%s+" TILE_SIZE ");\n",
                index_boundary[l_index-1].NumberOfComponents,
                TILE_PREFIX,
                index_boundary[l_index-1].NumberOfComponents,
                TILE_PREFIX);
      else
        fprintf(file,"((%s.Number)<(%s+" TILE_SIZE "))?(%s.Number):(%s+" TILE_SIZE ");\n",
                DataVarName(index_boundary[l_index-1].Type),
                TILE_PREFIX,
                DataVarName(index_boundary[l_index-1].Type),
                TILE_PREFIX);
    c_blank;
    }
    
    if(l_index==1) {
      global_index_level=1;
      if(good_parent) {
        pParentLop=parent_expr->MPC_BinaryExpr.Loperand;
        global_shift=1;
        use_slots=1;
        print_Expr(pParentLop);
        use_slots=0;
        global_shift=0;
      }
      else {
        use_slots=1;
        if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
          if(global_index_level>=2) {
            if(global_index_level==2)  cur_pos+=fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
            else fprintf(file,"%s%d",TMP_SLOT_PREFIX,current_slot_number+global_index_level-1);
            print_index(pExpr->MPC_Expr.Type,0,1);
          }
          else {
            fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
          }
          
        }
        else {
          fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
          internal_error();
        }
        use_slots=0;
      }
      fprintf(file,"=");
      use_slots=1;
      print_Expr(pOperand);
      use_slots=0;
      fprintf(file,";\n");
      c_blank;
      global_index_level=0;
      fprintf(file,"%s=1;\n",index_name(0));
      c_blank;
    }
      
    if(index_boundary[i_index].NumberOfComponents)
      fprintf(file,"for(;%s<%d;%s++) {\n",
              index_name(i_index),
              index_boundary[i_index].NumberOfComponents,
              index_name(i_index));
    else 
      {
        fprintf(file,"for(;%s<",index_name(i_index));
        fprintf(file,"%s.Number;",DataVarName(index_boundary[i_index].Type));
        fprintf(file,"%s++) {\n",index_name(i_index));
      }
    cur_blank+=SKIP; 

   for(i_index=1; i_index<l_index; i_index++) {
      c_blank;
      fprintf(file,"int %s;\n",index_name(i_index));
      global_index_level=i_index;
      if(good_parent) {
        global_shift=1;
        ExprPiece_traverse(NoTree,parent_expr->MPC_BinaryExpr.Loperand,declare_tmp_slots);
        global_shift=0;
      }
      else {
        use_slots=1;
        if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
          if(global_index_level>=2) {
            tTree pType;
            pType=get_type_pattern(pExpr->MPC_Expr.Type,global_index_level-1);
            declare_slot(pType,current_slot_number+global_index_level);
          }
        }
        else {
          fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
          internal_error();
        }
        use_slots=0;
      }

      ExprPiece_traverse(NoTree,pExpr,declare_tmp_slots);
      
      if(good_parent) {
        global_shift=1;
        use_slots=1;
        ExprPiece_traverse(NoTree,parent_expr->MPC_BinaryExpr.Loperand,calc_tmp_slots);
        use_slots=0;
        global_shift=0;
      }
      else {
        use_slots=1;
        if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
          if(global_index_level>=2) {
            c_blank;
            fprintf(file,"%s%d=",TMP_SLOT_PREFIX,current_slot_number+global_index_level);
            if(global_index_level==2)  cur_pos+=fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
            else fprintf(file,"%s%d",TMP_SLOT_PREFIX,current_slot_number+global_index_level-1);
            print_index(pExpr->MPC_Expr.Type,0,1);
            fprintf(file,";\n");
          }
          
        }
        else {
          fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
          internal_error();
        }
        use_slots=0;
      }
       
      use_slots=1;
      ExprPiece_traverse(NoTree,pExpr,calc_tmp_slots);
      use_slots=0;


      c_blank;
      if(apply_tiling&&(i_index==(l_index-1))) 
        fprintf(file,"%s=%s;\n",index_name(i_index),TILE_PREFIX);
      else 
        fprintf(file,"%s=0;\n",index_name(i_index));
      c_blank;
      if(i_index==1) {
        fprintf(file,"if(%s==0) ",index_name(0));
      }
        
        
      if(apply_tiling&&(i_index==(l_index-1))) {
        fprintf(file,"for(;%s<%s;%s++) {\n",
                index_name(i_index),
                INDEX_BOUND_PREFIX,
                index_name(i_index));
      }
      else {
        if(index_boundary[i_index].NumberOfComponents)
          fprintf(file,"for(;%s<%d;%s++) {\n",
                  index_name(i_index),
                  index_boundary[i_index].NumberOfComponents,
                  index_name(i_index));
        else{
          fprintf(file,"for(;%s<",index_name(i_index));
          fprintf(file,"%s.Number;",DataVarName(index_boundary[i_index].Type));
          fprintf(file,"%s++) {\n",index_name(i_index));
        }
      }
      
      cur_blank+=SKIP; 
   }
   if(l_index!=1) {
     c_blank;
     global_index_level++;
     if(good_parent) {
       pParentLop=parent_expr->MPC_BinaryExpr.Loperand;
       global_shift=1;
       use_slots=1;
       print_Expr(pParentLop);
       use_slots=0;
       global_shift=0;
     }
     else {
       use_slots=1;
       if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
         if(global_index_level>=2) {
           if(global_index_level==2)  cur_pos+=fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
           else fprintf(file,"%s%d",TMP_SLOT_PREFIX,current_slot_number+global_index_level-1);
           print_index(pExpr->MPC_Expr.Type,0,1);
         }
         else {
           fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
         }
       }
       else {
         fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
         internal_error();
       }
       use_slots=0;
     }
     fprintf(file,"=");
     use_slots=1;
     print_Expr(pOperand);
     use_slots=0;
     fprintf(file,";\n");
   }
    /*end_statement_is_needed=0;*/
    for(i_index=1; i_index<l_index; i_index++) {
      b_end;
    }
    
    clear_level=1;
    if(good_parent) ExprPiece_traverse(NoTree,parent_expr,clear_generated);
    else ExprPiece_traverse(NoTree,pExpr,clear_generated);
    
    global_index_level=0;
    for(i_index=1; i_index<l_index; i_index++) {
      global_index_level=i_index;
      if(i_index!=1) {
        c_blank;
        fprintf(file,"int %s;\n",index_name(i_index));
        if(good_parent) {
          global_shift=1;
          ExprPiece_traverse(NoTree,parent_expr->MPC_BinaryExpr.Loperand,declare_tmp_slots);
          global_shift=0;
        }
        else {
          use_slots=1;
          if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
            if(global_index_level>=2) {
              tTree pType;
              pType=get_type_pattern(pExpr->MPC_Expr.Type,global_index_level-1);
              declare_slot(pType,current_slot_number+global_index_level);
            }
          }
          else {
            fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
            internal_error();
          }
          use_slots=0;
        }
        
        ExprPiece_traverse(NoTree,pExpr,declare_tmp_slots);

        if(good_parent) {
          global_shift=1;
          use_slots=1;
          ExprPiece_traverse(NoTree,parent_expr->MPC_BinaryExpr.Loperand,calc_tmp_slots);
          use_slots=0;
          global_shift=0;
        }
        else {
          use_slots=1;
          if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
            if(global_index_level>=2) {
              c_blank;
              fprintf(file,"%s%d=",TMP_SLOT_PREFIX,current_slot_number+global_index_level);
              if(global_index_level==2)  cur_pos+=fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
              else fprintf(file,"%s%d",TMP_SLOT_PREFIX,current_slot_number+global_index_level-1);
              print_index(pExpr->MPC_Expr.Type,0,1);
              fprintf(file,";\n");
            }
            
          }
          else {
            fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
            internal_error();
          }
          use_slots=0;
        }
        
        use_slots=1;
        ExprPiece_traverse(NoTree,pExpr,calc_tmp_slots);
        use_slots=0;
        c_blank;
        if(apply_tiling&&(i_index==(l_index-1))) 
          fprintf(file,"%s=%s;\n",index_name(i_index),TILE_PREFIX);
        else 
          fprintf(file,"%s=0;\n",index_name(i_index));

      }
      
      c_blank;
      if(i_index==1) {
        fprintf(file,"else ");
      }
      
      if(apply_tiling&&(i_index==(l_index-1))) {
        fprintf(file,"for(;%s<%s;%s++) {\n",
                index_name(i_index),
                INDEX_BOUND_PREFIX,
                index_name(i_index));
          
      }
      else {
        if(index_boundary[i_index].NumberOfComponents)
          fprintf(file,"for(;%s<%d;%s++) {\n",
                  index_name(i_index),
                  index_boundary[i_index].NumberOfComponents,
                  index_name(i_index));
        else{
          fprintf(file,"for(;%s<",index_name(i_index));
          fprintf(file,"%s.Number;",DataVarName(index_boundary[i_index].Type));
          fprintf(file,"%s++) {\n",index_name(i_index));
        }
      }
      cur_blank+=SKIP; 
    }
    global_index_level++;
    c_blank;
    if(max_min_linear) {
      fprintf(file,"if(");
    }
    if(good_parent) {
      pParentLop=parent_expr->MPC_BinaryExpr.Loperand;
      global_shift=1;
      use_slots=1;
      print_Expr(pParentLop);
      use_slots=0;
      global_shift=0;
      if(!max_min_linear) parent_expr->MPC_Expr.Flag.Generated=1;
    }
    else {
      /*
      fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
      print_index(pExpr->MPC_Expr.Type,0,1);
      */
      use_slots=1;
      if(strcmp(pExpr->MPC_Expr.TmpName,"")) {
        if(global_index_level>=2) {
          if(global_index_level==2)  cur_pos+=fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
          else fprintf(file,"%s%d",TMP_SLOT_PREFIX,current_slot_number+global_index_level-1);
          print_index(pExpr->MPC_Expr.Type,0,1);
        }
        else {
          fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
        }
        
      }
      else {
        fprintf(stderr,"print_Linear : TmpVar missing!!!\n");
        internal_error();
      }
      use_slots=0;
    }
    fprintf(file,"%s",lin_oper_code(pExpr->MPC_UnaryExpr.OpCode));
    
    use_slots=1;
    print_Expr(pOperand);
    use_slots=0;
    
    if(max_min_linear) {
      fprintf(file,") \n");
      blank(cur_blank+SKIP);
      post_gen=1;
      if(good_parent) {
        print_Expr(pParentLop);
        parent_expr->MPC_Expr.Flag.Generated=1;
      }
      else {
        fprintf(file,"%s",pExpr->MPC_Expr.TmpName);
      print_index(/*pOpType*/pExpr->MPC_Expr.Type,/*1*/0,1);
      }
      fprintf(file,"=");
      print_Expr(pOperand);
    }
    fprintf(file,";\n");
    /*end_statement_is_needed=0;*/
    for(i_index=0; i_index<l_index; i_index++) {
      b_end;
    }
    b_end;
    if(apply_tiling) {b_end;}
    /*c_blank;*/
    free(steps);
    free(index_boundary);
  }
  in_sideeff=old_in_sideeff;

}


void calculate_tmp_var(tTree pExpr) {
  int old_not_check=not_check;
  tTree old_parent_expr=parent_expr;
  tTree pTmpType;
  tTree pStoreNet=pExpr->MPC_Expr.StoreNet;
  if(prt) printf("calculate_tmp_var pExpr=%p \n",pExpr);
  not_check=0;
  tmp_var_expr->MPC_BinaryExpr.StoreNet=pStoreNet;

  /* !!!!!
  tmp_var_expr->MPC_BinaryExpr.EvalNet=cur_act_net;
  tmp_var_expr->MPC_BinaryExpr.ActualEvalNet=cur_act_net;
  !!!!! */
  tmp_var_expr->MPC_BinaryExpr.EvalNet=pStoreNet->MPC_Net.MyList;
  tmp_var_expr->MPC_BinaryExpr.ActualEvalNet=pStoreNet->MPC_Net.MyList;
  
  tmp_var_expr->MPC_BinaryExpr.Roperand=pExpr;
  tmp_var_expr->MPC_BinaryExpr.Type=pExpr->MPC_Expr.Type;
  tmp_var_expr->MPC_BinaryExpr.Flag=pExpr->MPC_Expr.Flag;
  tmp_var_expr->MPC_BinaryExpr.Flag.InParentheses=0;
  tmp_var_expr_left->MPC_Expr.TmpName=pExpr->MPC_Expr.TmpName;
  pTmpType=tmp_var_type(pExpr);
  PointerControl(pTmpType);
  tmp_var_expr_left->MPC_Expr.Type=pTmpType;
  if(prt) printf("TmpName=\"%s\"\n",tmp_var_expr_left->MPC_Expr.TmpName);
  end_statement_is_needed=1;
  if(is_basic_function_call(pExpr)) {
    basic_fun_call++;
  }
  c_blank;
  print_Expr(tmp_var_expr);
  basic_fun_call=0;
  if(end_statement_is_needed)
    fputs(";\n",file);
  pExpr->MPC_Expr.Flag.Generated=1;
  parent_expr=old_parent_expr;
  not_check=old_not_check;
}

void fill_ActualEvalNet(tTree pExpr) {
  tTree pNewEvalNet=NoTree;
  int ident=0;
  tExprFlags flag;
  PointerControl(pExpr);
  flag=pExpr->MPC_Expr.Flag;
  if(prt) printf("fill_ActualEvalNet pExpr=%p Kind=%d Asynch=%d SideEff=%d ActualEvalNet=%p\n",
                 pExpr,pExpr->Kind,flag.Asynchr,flag.SideEffects,
                 pExpr->MPC_Expr.ActualEvalNet);
  if(pExpr->Kind == kMPC_NetCastExpr) {
    tTree pIdent=pExpr->MPC_NetCastExpr.Operand;
    PointerControl(pIdent);
    if(pIdent->Kind == kMPC_Ident) ident=1;
  }
  if(pred_gen_is_necessary(pExpr) && pExpr->MPC_Expr.ActualEvalNet == NoTree) {
    pExpr->MPC_Expr.ActualEvalNet=pExpr->MPC_Expr.EvalNet;
    if(prt) printf("fill_ActualEvalNet pExpr=%p ActualEvalNet is EvalNet\n",
           pExpr);
  }
  else {
    pNewEvalNet=pExpr->MPC_Expr.StoreNet;
    PointerControl(pNewEvalNet);
    pExpr->MPC_Expr.ActualEvalNet=pNewEvalNet->MPC_NetOrSubnet.MyList;
    PointerControl(pNewEvalNet->MPC_NetOrSubnet.MyList);
    if(prt) printf("fill_ActualEvalNet pExpr=%p is MyList of the StoreNet\n",
           pExpr);
  }
  if(prt) printf("   ActualEvalList=%p: pNewEvalNet=%p\n",
                 pExpr->MPC_Expr.ActualEvalNet,pNewEvalNet);
  if(pExpr->MPC_Expr.ActualEvalNet == NoTree) {
    fprintf(stderr,"ActualEvalNet == NoTree Store=%p Eval=%p\n",
            pExpr->MPC_Expr.StoreNet,pExpr->MPC_Expr.EvalNet);
    internal_error();
  }
}

void find_something_to_do(tTree pExpr) {
  if(pExpr != NoTree) {
    tExprFlags flag;
    flag=pExpr->MPC_Expr.Flag;
    if(flag.Asynchr) {
      is_enything_to_do=1;
    }
    else if(pExpr->Kind == kMPC_BinaryExpr) {
      
    }
  }
}
