# include "IlpTree.h"
# define yyALLOC(ptr, size)	if ((ptr = (tIlpTree) IlpTree_PoolFreePtr) >= (tIlpTree) IlpTree_PoolMaxPtr) \
  ptr = IlpTree_Alloc (); \
  IlpTree_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
}
# else
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
# endif

# line 22 "ilp.ast"

#include <CocktailIO.h>  

# ifdef getchar
# undef getchar
# endif
# ifdef putchar
# undef putchar
# endif
# include "yyIlpTree.w"

static void yyExit () { Exit (1); }

void (* IlpTree_Exit) () = yyExit;

# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tIlpTree IlpTreeRoot;
unsigned long IlpTree_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoIlpTree;
char * IlpTree_PoolFreePtr	= (char *) NoIlpTree;
char * IlpTree_PoolMaxPtr	= (char *) NoIlpTree;
static unsigned short yyMaxSize	= 0;
unsigned short IlpTree_NodeSize [9 + 1] = { 0,
 sizeof (yReg),
 sizeof (yPointerReg),
 sizeof (yVectorReg),
 sizeof (yScalarReg),
 sizeof (yIlpNode),
 sizeof (yIlpAssignExpr),
 sizeof (yIlpExpr),
 sizeof (yIlpUnaryExpr),
 sizeof (yIlpBinaryExpr),
};
char * IlpTree_NodeName [9 + 1] = {
 "NoIlpTree",
 "Reg",
 "PointerReg",
 "VectorReg",
 "ScalarReg",
 "IlpNode",
 "IlpAssignExpr",
 "IlpExpr",
 "IlpUnaryExpr",
 "IlpBinaryExpr",
};
static IlpTree_tKind yyTypeRange [9 + 1] = { 0,
 kScalarReg,
 kPointerReg,
 kVectorReg,
 kScalarReg,
 kIlpBinaryExpr,
 kIlpAssignExpr,
 kIlpBinaryExpr,
 kIlpUnaryExpr,
 kIlpBinaryExpr,
};

tIlpTree IlpTree_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 9; i ++) {
   IlpTree_NodeSize [i] = (IlpTree_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (IlpTree_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 IlpTree_PoolFreePtr = yyBlockList->yyBlock;
 IlpTree_PoolMaxPtr = IlpTree_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 IlpTree_HeapUsed += yyBlockSize;
 return (tIlpTree) IlpTree_PoolFreePtr;
}

tIlpTree MakeIlpTree
# if defined __STDC__ | defined __cplusplus
 (IlpTree_tKind yyKind)
# else
 (yyKind) IlpTree_tKind yyKind;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool IlpTree_IsType
# if defined __STDC__ | defined __cplusplus
 (register tIlpTree yyt, register IlpTree_tKind yyKind)
# else
 (yyt, yyKind) register tIlpTree yyt; register IlpTree_tKind yyKind;
# endif
{
 return yyt != NoIlpTree && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}

tIlpTree nReg () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kReg])
 yyt->Kind = kReg;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->Reg.num)
 beginint(yyt->Reg.type)
 begintIlpTree(yyt->Reg.next)
 return yyt;
}

tIlpTree nPointerReg () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kPointerReg])
 yyt->Kind = kPointerReg;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->PointerReg.num)
 beginint(yyt->PointerReg.type)
 begintIlpTree(yyt->PointerReg.next)
 return yyt;
}

tIlpTree nVectorReg () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kVectorReg])
 yyt->Kind = kVectorReg;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->VectorReg.num)
 beginint(yyt->VectorReg.type)
 begintIlpTree(yyt->VectorReg.next)
 return yyt;
}

tIlpTree nScalarReg () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kScalarReg])
 yyt->Kind = kScalarReg;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->ScalarReg.num)
 beginint(yyt->ScalarReg.type)
 begintIlpTree(yyt->ScalarReg.next)
 return yyt;
}

tIlpTree nIlpNode () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpNode])
 yyt->Kind = kIlpNode;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpNode.Next)
 return yyt;
}

tIlpTree nIlpAssignExpr () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpAssignExpr])
 yyt->Kind = kIlpAssignExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpAssignExpr.Next)
 begintIlpTree(yyt->IlpAssignExpr.operand)
 begintIlpTree(yyt->IlpAssignExpr.roperand)
 return yyt;
}

tIlpTree nIlpExpr () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpExpr])
 yyt->Kind = kIlpExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpExpr.Next)
 beginint(yyt->IlpExpr.regQuant)
 begintIlpTree(yyt->IlpExpr.regList)
 return yyt;
}

tIlpTree nIlpUnaryExpr () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpUnaryExpr])
 yyt->Kind = kIlpUnaryExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpUnaryExpr.Next)
 beginint(yyt->IlpUnaryExpr.regQuant)
 begintIlpTree(yyt->IlpUnaryExpr.regList)
 beginshort(yyt->IlpUnaryExpr.opCode)
 begintIlpTree(yyt->IlpUnaryExpr.operand)
 return yyt;
}

tIlpTree nIlpBinaryExpr () {
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpBinaryExpr])
 yyt->Kind = kIlpBinaryExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpBinaryExpr.Next)
 beginint(yyt->IlpBinaryExpr.regQuant)
 begintIlpTree(yyt->IlpBinaryExpr.regList)
 beginshort(yyt->IlpBinaryExpr.opCode)
 begintIlpTree(yyt->IlpBinaryExpr.loperand)
 begintIlpTree(yyt->IlpBinaryExpr.roperand)
 return yyt;
}


tIlpTree mReg
# if defined __STDC__ | defined __cplusplus
(int pnum, int ptype)
# else
(pnum, ptype)
int pnum;
int ptype;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kReg])
 yyt->Kind = kReg;
 yyt->yyHead.yyMark = 0;
 yyt->Reg.num = pnum;
 yyt->Reg.type = ptype;
 begintIlpTree(yyt->Reg.next)
 return yyt;
}

tIlpTree mPointerReg
# if defined __STDC__ | defined __cplusplus
(int pnum, int ptype)
# else
(pnum, ptype)
int pnum;
int ptype;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kPointerReg])
 yyt->Kind = kPointerReg;
 yyt->yyHead.yyMark = 0;
 yyt->PointerReg.num = pnum;
 yyt->PointerReg.type = ptype;
 begintIlpTree(yyt->PointerReg.next)
 return yyt;
}

tIlpTree mVectorReg
# if defined __STDC__ | defined __cplusplus
(int pnum, int ptype)
# else
(pnum, ptype)
int pnum;
int ptype;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kVectorReg])
 yyt->Kind = kVectorReg;
 yyt->yyHead.yyMark = 0;
 yyt->VectorReg.num = pnum;
 yyt->VectorReg.type = ptype;
 begintIlpTree(yyt->VectorReg.next)
 return yyt;
}

tIlpTree mScalarReg
# if defined __STDC__ | defined __cplusplus
(int pnum, int ptype)
# else
(pnum, ptype)
int pnum;
int ptype;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kScalarReg])
 yyt->Kind = kScalarReg;
 yyt->yyHead.yyMark = 0;
 yyt->ScalarReg.num = pnum;
 yyt->ScalarReg.type = ptype;
 begintIlpTree(yyt->ScalarReg.next)
 return yyt;
}

tIlpTree mIlpNode
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpNode])
 yyt->Kind = kIlpNode;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpNode.Next)
 return yyt;
}

tIlpTree mIlpAssignExpr
# if defined __STDC__ | defined __cplusplus
(tIlpTree poperand, tIlpTree properand)
# else
(poperand, properand)
tIlpTree poperand;
tIlpTree properand;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpAssignExpr])
 yyt->Kind = kIlpAssignExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpAssignExpr.Next)
 yyt->IlpAssignExpr.operand = poperand;
 yyt->IlpAssignExpr.roperand = properand;
 return yyt;
}

tIlpTree mIlpExpr
# if defined __STDC__ | defined __cplusplus
()
# else
()
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpExpr])
 yyt->Kind = kIlpExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpExpr.Next)
 beginint(yyt->IlpExpr.regQuant)
 begintIlpTree(yyt->IlpExpr.regList)
 return yyt;
}

tIlpTree mIlpUnaryExpr
# if defined __STDC__ | defined __cplusplus
(short popCode, tIlpTree poperand)
# else
(popCode, poperand)
short popCode;
tIlpTree poperand;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpUnaryExpr])
 yyt->Kind = kIlpUnaryExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpUnaryExpr.Next)
 beginint(yyt->IlpUnaryExpr.regQuant)
 begintIlpTree(yyt->IlpUnaryExpr.regList)
 yyt->IlpUnaryExpr.opCode = popCode;
 yyt->IlpUnaryExpr.operand = poperand;
 return yyt;
}

tIlpTree mIlpBinaryExpr
# if defined __STDC__ | defined __cplusplus
(short popCode, tIlpTree ploperand, tIlpTree properand)
# else
(popCode, ploperand, properand)
short popCode;
tIlpTree ploperand;
tIlpTree properand;
# endif
{
 register tIlpTree yyt;
 yyALLOC (yyt, IlpTree_NodeSize [kIlpBinaryExpr])
 yyt->Kind = kIlpBinaryExpr;
 yyt->yyHead.yyMark = 0;
 begintIlpTree(yyt->IlpBinaryExpr.Next)
 beginint(yyt->IlpBinaryExpr.regQuant)
 begintIlpTree(yyt->IlpBinaryExpr.regList)
 yyt->IlpBinaryExpr.opCode = popCode;
 yyt->IlpBinaryExpr.loperand = ploperand;
 yyt->IlpBinaryExpr.roperand = properand;
 return yyt;
}

typedef tIlpTree * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tIlpTree yyt)
# else
 (yyt) register tIlpTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoIlpTree || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kReg:
yyt = yyt->Reg.next; break;
case kPointerReg:
yyt = yyt->PointerReg.next; break;
case kVectorReg:
yyt = yyt->VectorReg.next; break;
case kScalarReg:
yyt = yyt->ScalarReg.next; break;
case kIlpNode:
yyt = yyt->IlpNode.Next; break;
case kIlpAssignExpr:
yyMark (yyt->IlpAssignExpr.Next);
yyMark (yyt->IlpAssignExpr.operand);
yyt = yyt->IlpAssignExpr.roperand; break;
case kIlpExpr:
yyMark (yyt->IlpExpr.Next);
yyt = yyt->IlpExpr.regList; break;
case kIlpUnaryExpr:
yyMark (yyt->IlpUnaryExpr.Next);
yyMark (yyt->IlpUnaryExpr.regList);
yyt = yyt->IlpUnaryExpr.operand; break;
case kIlpBinaryExpr:
yyMark (yyt->IlpBinaryExpr.Next);
yyMark (yyt->IlpBinaryExpr.regList);
yyMark (yyt->IlpBinaryExpr.loperand);
yyt = yyt->IlpBinaryExpr.roperand; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tIlpTree yyTreeStore [yyInitTreeStoreSize];
static tIlpTree * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;

static IlpTree_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tIlpTree));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteIlpTree ARGS((tIlpTree yyt));

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static short yyIndentLevel;

void WriteIlpTree
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tIlpTree yyt)
# else
 (yyyf, yyt) FILE * yyyf; tIlpTree yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteIlpTree (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tIlpTree yyt)
# else
 (yys, yyt) char * yys; tIlpTree yyt;
# endif
{ yyIndentSelector (yys); writetIlpTree (yyt) }

static void yWriteReg
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kReg], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("num"); writeint (yyt->Reg.num) yyWriteNl ();
 yyIndentSelector ("type"); writeint (yyt->Reg.type) yyWriteNl ();
}

static void yWritePointerReg
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kPointerReg], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("num"); writeint (yyt->PointerReg.num) yyWriteNl ();
 yyIndentSelector ("type"); writeint (yyt->PointerReg.type) yyWriteNl ();
}

static void yWriteVectorReg
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kVectorReg], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("num"); writeint (yyt->VectorReg.num) yyWriteNl ();
 yyIndentSelector ("type"); writeint (yyt->VectorReg.type) yyWriteNl ();
}

static void yWriteScalarReg
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kScalarReg], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("num"); writeint (yyt->ScalarReg.num) yyWriteNl ();
 yyIndentSelector ("type"); writeint (yyt->ScalarReg.type) yyWriteNl ();
}

static void yWriteIlpNode
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kIlpNode], yyf); (void) fputc ('\n', yyf);
}

static void yWriteIlpAssignExpr
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kIlpAssignExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Next", yyt->IlpAssignExpr.Next);
 yyIndentSelectorTree ("operand", yyt->IlpAssignExpr.operand);
}

static void yWriteIlpExpr
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kIlpExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Next", yyt->IlpExpr.Next);
 yyIndentSelector ("regQuant"); writeint (yyt->IlpExpr.regQuant) yyWriteNl ();
}

static void yWriteIlpUnaryExpr
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kIlpUnaryExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Next", yyt->IlpUnaryExpr.Next);
 yyIndentSelector ("regQuant"); writeint (yyt->IlpUnaryExpr.regQuant) yyWriteNl ();
 yyIndentSelectorTree ("regList", yyt->IlpUnaryExpr.regList);
 yyIndentSelector ("opCode"); writeshort (yyt->IlpUnaryExpr.opCode) yyWriteNl ();
}

static void yWriteIlpBinaryExpr
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 (void) fputs (IlpTree_NodeName [kIlpBinaryExpr], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Next", yyt->IlpBinaryExpr.Next);
 yyIndentSelector ("regQuant"); writeint (yyt->IlpBinaryExpr.regQuant) yyWriteNl ();
 yyIndentSelectorTree ("regList", yyt->IlpBinaryExpr.regList);
 yyIndentSelector ("opCode"); writeshort (yyt->IlpBinaryExpr.opCode) yyWriteNl ();
 yyIndentSelectorTree ("loperand", yyt->IlpBinaryExpr.loperand);
}

static void yyWriteIlpTree
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoIlpTree) { (void) fputs (" NoIlpTree\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kReg: yWriteReg (yyt); yyIndentSelector ("next"); yyt = yyt->Reg.next; break;
case kPointerReg: yWritePointerReg (yyt); yyIndentSelector ("next"); yyt = yyt->PointerReg.next; break;
case kVectorReg: yWriteVectorReg (yyt); yyIndentSelector ("next"); yyt = yyt->VectorReg.next; break;
case kScalarReg: yWriteScalarReg (yyt); yyIndentSelector ("next"); yyt = yyt->ScalarReg.next; break;
case kIlpNode: yWriteIlpNode (yyt); yyIndentSelector ("Next"); yyt = yyt->IlpNode.Next; break;
case kIlpAssignExpr: yWriteIlpAssignExpr (yyt); yyIndentSelector ("roperand"); yyt = yyt->IlpAssignExpr.roperand; break;
case kIlpExpr: yWriteIlpExpr (yyt); yyIndentSelector ("regList"); yyt = yyt->IlpExpr.regList; break;
case kIlpUnaryExpr: yWriteIlpUnaryExpr (yyt); yyIndentSelector ("operand"); yyt = yyt->IlpUnaryExpr.operand; break;
case kIlpBinaryExpr: yWriteIlpBinaryExpr (yyt); yyIndentSelector ("roperand"); yyt = yyt->IlpBinaryExpr.roperand; break;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

static tIlpTree yyChild;

static void yyReleaseIlpTree
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 if (yyt == NoIlpTree) return;
 switch (yyt->Kind) {
case kReg:
closetIlpTree (yyt->Reg.next)
break;
case kPointerReg:
closetIlpTree (yyt->PointerReg.next)
break;
case kVectorReg:
closetIlpTree (yyt->VectorReg.next)
break;
case kScalarReg:
closetIlpTree (yyt->ScalarReg.next)
break;
case kIlpNode:
closetIlpTree (yyt->IlpNode.Next)
break;
case kIlpAssignExpr:
closetIlpTree (yyt->IlpAssignExpr.Next)
closetIlpTree (yyt->IlpAssignExpr.operand)
closetIlpTree (yyt->IlpAssignExpr.roperand)
break;
case kIlpExpr:
closetIlpTree (yyt->IlpExpr.Next)
closetIlpTree (yyt->IlpExpr.regList)
break;
case kIlpUnaryExpr:
closetIlpTree (yyt->IlpUnaryExpr.Next)
closetIlpTree (yyt->IlpUnaryExpr.regList)
closetIlpTree (yyt->IlpUnaryExpr.operand)
break;
case kIlpBinaryExpr:
closetIlpTree (yyt->IlpBinaryExpr.Next)
closetIlpTree (yyt->IlpBinaryExpr.regList)
closetIlpTree (yyt->IlpBinaryExpr.loperand)
closetIlpTree (yyt->IlpBinaryExpr.roperand)
break;
 default: ;
 }

 if (-- yyt->yyHead.yyMark == 0) {
  switch (yyt->Kind) {
case kReg:
closeint (yyt->Reg.num)
closeint (yyt->Reg.type)
break;
case kPointerReg:
closeint (yyt->PointerReg.num)
closeint (yyt->PointerReg.type)
break;
case kVectorReg:
closeint (yyt->VectorReg.num)
closeint (yyt->VectorReg.type)
break;
case kScalarReg:
closeint (yyt->ScalarReg.num)
closeint (yyt->ScalarReg.type)
break;
case kIlpExpr:
closeint (yyt->IlpExpr.regQuant)
break;
case kIlpUnaryExpr:
closeint (yyt->IlpUnaryExpr.regQuant)
closeshort (yyt->IlpUnaryExpr.opCode)
break;
case kIlpBinaryExpr:
closeint (yyt->IlpBinaryExpr.regQuant)
closeshort (yyt->IlpBinaryExpr.opCode)
break;
  default: ;
  }
  yyFREE (yyt, IlpTree_NodeSize [yyt->Kind])
 }
}

void ReleaseIlpTree
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 yyMark (yyt);
 yyReleaseIlpTree (yyt);
}

static IlpTree_tProcTree yyProc;

static void yyTraverseIlpTreeTD
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 for (;;) {
  if (yyt == NoIlpTree || yyt->yyHead.yyMark == 0) return;
  yyt->yyHead.yyMark = 0;
  yyProc (yyt);

  switch (yyt->Kind) {
case kReg:
yyt = yyt->Reg.next; break;
case kPointerReg:
yyt = yyt->PointerReg.next; break;
case kVectorReg:
yyt = yyt->VectorReg.next; break;
case kScalarReg:
yyt = yyt->ScalarReg.next; break;
case kIlpNode:
yyt = yyt->IlpNode.Next; break;
case kIlpAssignExpr:
yyTraverseIlpTreeTD (yyt->IlpAssignExpr.Next);
yyTraverseIlpTreeTD (yyt->IlpAssignExpr.operand);
yyt = yyt->IlpAssignExpr.roperand; break;
case kIlpExpr:
yyTraverseIlpTreeTD (yyt->IlpExpr.Next);
yyt = yyt->IlpExpr.regList; break;
case kIlpUnaryExpr:
yyTraverseIlpTreeTD (yyt->IlpUnaryExpr.Next);
yyTraverseIlpTreeTD (yyt->IlpUnaryExpr.regList);
yyt = yyt->IlpUnaryExpr.operand; break;
case kIlpBinaryExpr:
yyTraverseIlpTreeTD (yyt->IlpBinaryExpr.Next);
yyTraverseIlpTreeTD (yyt->IlpBinaryExpr.regList);
yyTraverseIlpTreeTD (yyt->IlpBinaryExpr.loperand);
yyt = yyt->IlpBinaryExpr.roperand; break;
  default: return;
  }
 }
}

void TraverseIlpTreeTD
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt, IlpTree_tProcTree yyyProc)
# else
 (yyt, yyyProc) tIlpTree yyt; IlpTree_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseIlpTreeTD (yyt);
}

static void yyTraverseIlpTreeBU
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 if (yyt == NoIlpTree || yyt->yyHead.yyMark == 0) return;
 yyt->yyHead.yyMark = 0;

 switch (yyt->Kind) {
case kReg:
yyTraverseIlpTreeBU (yyt->Reg.next); break;
case kPointerReg:
yyTraverseIlpTreeBU (yyt->PointerReg.next); break;
case kVectorReg:
yyTraverseIlpTreeBU (yyt->VectorReg.next); break;
case kScalarReg:
yyTraverseIlpTreeBU (yyt->ScalarReg.next); break;
case kIlpNode:
yyTraverseIlpTreeBU (yyt->IlpNode.Next); break;
case kIlpAssignExpr:
yyTraverseIlpTreeBU (yyt->IlpAssignExpr.Next);
yyTraverseIlpTreeBU (yyt->IlpAssignExpr.operand);
yyTraverseIlpTreeBU (yyt->IlpAssignExpr.roperand); break;
case kIlpExpr:
yyTraverseIlpTreeBU (yyt->IlpExpr.Next);
yyTraverseIlpTreeBU (yyt->IlpExpr.regList); break;
case kIlpUnaryExpr:
yyTraverseIlpTreeBU (yyt->IlpUnaryExpr.Next);
yyTraverseIlpTreeBU (yyt->IlpUnaryExpr.regList);
yyTraverseIlpTreeBU (yyt->IlpUnaryExpr.operand); break;
case kIlpBinaryExpr:
yyTraverseIlpTreeBU (yyt->IlpBinaryExpr.Next);
yyTraverseIlpTreeBU (yyt->IlpBinaryExpr.regList);
yyTraverseIlpTreeBU (yyt->IlpBinaryExpr.loperand);
yyTraverseIlpTreeBU (yyt->IlpBinaryExpr.roperand); break;
 default: ;
 }
 yyProc (yyt);
}

void TraverseIlpTreeBU
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt, IlpTree_tProcTree yyyProc)
# else
 (yyt, yyyProc) tIlpTree yyt; IlpTree_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseIlpTreeBU (yyt);
}

# define yyInitOldToNewStoreSize 32

typedef struct { tIlpTree yyOld, yyNew; } yytOldToNew;
static unsigned long yyOldToNewStoreSize = yyInitOldToNewStoreSize;
static yytOldToNew yyOldToNewStore [yyInitOldToNewStoreSize];
static yytOldToNew * yyOldToNewStorePtr = yyOldToNewStore;
static int yyOldToNewCount;

static void yyStoreOldToNew
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyOld, tIlpTree yyNew)
# else
 (yyOld, yyNew) tIlpTree yyOld, yyNew;
# endif
{
 if (++ yyOldToNewCount == yyOldToNewStoreSize)
  ExtendArray ((char * *) & yyOldToNewStorePtr, & yyOldToNewStoreSize, sizeof (yytOldToNew));
 yyOldToNewStorePtr [yyOldToNewCount].yyOld = yyOld;
 yyOldToNewStorePtr [yyOldToNewCount].yyNew = yyNew;
}

static tIlpTree yyMapOldToNew
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyOld)
# else
 (yyOld) tIlpTree yyOld;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyOldToNewCount; yyi ++)
  if (yyOldToNewStorePtr [yyi].yyOld == yyOld) return yyOldToNewStorePtr [yyi].yyNew;
 return NoIlpTree;
}

static void yyCopyIlpTree
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt, yyPtrtTree yyNew)
# else
 (yyt, yyNew) tIlpTree yyt; yyPtrtTree yyNew;
# endif
{
 for (;;) {
  if (yyt == NoIlpTree) { * yyNew = NoIlpTree; return; }
  if (yyt->yyHead.yyMark == 0) { * yyNew = yyMapOldToNew (yyt); return; }
  yyALLOC (* yyNew, IlpTree_NodeSize [yyt->Kind])
  if (yyt->yyHead.yyMark > 1) { yyStoreOldToNew (yyt, * yyNew); }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kReg: (* yyNew)->Reg = yyt->Reg;
copyint ((* yyNew)->Reg.num, yyt->Reg.num)
copyint ((* yyNew)->Reg.type, yyt->Reg.type)
yyt = yyt->Reg.next;
yyNew = & (* yyNew)->Reg.next; break;
case kPointerReg: (* yyNew)->PointerReg = yyt->PointerReg;
copyint ((* yyNew)->PointerReg.num, yyt->PointerReg.num)
copyint ((* yyNew)->PointerReg.type, yyt->PointerReg.type)
yyt = yyt->PointerReg.next;
yyNew = & (* yyNew)->PointerReg.next; break;
case kVectorReg: (* yyNew)->VectorReg = yyt->VectorReg;
copyint ((* yyNew)->VectorReg.num, yyt->VectorReg.num)
copyint ((* yyNew)->VectorReg.type, yyt->VectorReg.type)
yyt = yyt->VectorReg.next;
yyNew = & (* yyNew)->VectorReg.next; break;
case kScalarReg: (* yyNew)->ScalarReg = yyt->ScalarReg;
copyint ((* yyNew)->ScalarReg.num, yyt->ScalarReg.num)
copyint ((* yyNew)->ScalarReg.type, yyt->ScalarReg.type)
yyt = yyt->ScalarReg.next;
yyNew = & (* yyNew)->ScalarReg.next; break;
case kIlpNode: (* yyNew)->IlpNode = yyt->IlpNode;
yyt = yyt->IlpNode.Next;
yyNew = & (* yyNew)->IlpNode.Next; break;
case kIlpAssignExpr: (* yyNew)->IlpAssignExpr = yyt->IlpAssignExpr;
copytIlpTree ((* yyNew)->IlpAssignExpr.Next, yyt->IlpAssignExpr.Next)
copytIlpTree ((* yyNew)->IlpAssignExpr.operand, yyt->IlpAssignExpr.operand)
yyt = yyt->IlpAssignExpr.roperand;
yyNew = & (* yyNew)->IlpAssignExpr.roperand; break;
case kIlpExpr: (* yyNew)->IlpExpr = yyt->IlpExpr;
copytIlpTree ((* yyNew)->IlpExpr.Next, yyt->IlpExpr.Next)
copyint ((* yyNew)->IlpExpr.regQuant, yyt->IlpExpr.regQuant)
yyt = yyt->IlpExpr.regList;
yyNew = & (* yyNew)->IlpExpr.regList; break;
case kIlpUnaryExpr: (* yyNew)->IlpUnaryExpr = yyt->IlpUnaryExpr;
copytIlpTree ((* yyNew)->IlpUnaryExpr.Next, yyt->IlpUnaryExpr.Next)
copyint ((* yyNew)->IlpUnaryExpr.regQuant, yyt->IlpUnaryExpr.regQuant)
copytIlpTree ((* yyNew)->IlpUnaryExpr.regList, yyt->IlpUnaryExpr.regList)
copyshort ((* yyNew)->IlpUnaryExpr.opCode, yyt->IlpUnaryExpr.opCode)
yyt = yyt->IlpUnaryExpr.operand;
yyNew = & (* yyNew)->IlpUnaryExpr.operand; break;
case kIlpBinaryExpr: (* yyNew)->IlpBinaryExpr = yyt->IlpBinaryExpr;
copytIlpTree ((* yyNew)->IlpBinaryExpr.Next, yyt->IlpBinaryExpr.Next)
copyint ((* yyNew)->IlpBinaryExpr.regQuant, yyt->IlpBinaryExpr.regQuant)
copytIlpTree ((* yyNew)->IlpBinaryExpr.regList, yyt->IlpBinaryExpr.regList)
copyshort ((* yyNew)->IlpBinaryExpr.opCode, yyt->IlpBinaryExpr.opCode)
copytIlpTree ((* yyNew)->IlpBinaryExpr.loperand, yyt->IlpBinaryExpr.loperand)
yyt = yyt->IlpBinaryExpr.roperand;
yyNew = & (* yyNew)->IlpBinaryExpr.roperand; break;
  default: ;
  }
 }
}

tIlpTree CopyIlpTree
# if defined __STDC__ | defined __cplusplus
 (tIlpTree yyt)
# else
 (yyt) tIlpTree yyt;
# endif
{
 tIlpTree yyNew;
 yyMark (yyt);
 yyOldToNewCount = 0;
 yyCopyIlpTree (yyt, & yyNew);
 return yyNew;
}

void BeginIlpTree ()
{
}

void CloseIlpTree ()
{
}
