# ifndef yyGen
# define yyGen

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# include <stdio.h>
# line 10 "Gen.ast"

#include <Tree.h>


# ifndef bool
# define bool char
# endif
# define NoGen (tGen) 0L
# define kNet 1
# define kNets 2

typedef unsigned char Gen_tKind;
typedef unsigned short Gen_tMark;
typedef unsigned short Gen_tLabel;
typedef union Gen_Node * tGen;
typedef void (* Gen_tProcTree) ARGS((tGen));

# ifndef Gen_NodeHead
# define Gen_NodeHead
# endif
typedef struct { Gen_tKind yyKind; Gen_tMark yyMark; Gen_NodeHead } Gen_tNodeHead;
typedef struct { Gen_tNodeHead yyHead; int Topology; int Kind; bool SingleNode; int Subnet; int Auto; tTree pNet; int Created; int Closed; int Flexible; tTree Block; int Used; tString Name; tGen Children; tGen Parent; int Pred; int Num; tTree Ctrl; int Level; } yNet;
typedef struct { Gen_tNodeHead yyHead; tGen Net; tGen Next; } yNets;

union Gen_Node {
 Gen_tKind Kind;
 Gen_tNodeHead yyHead;
 yNet Net;
 yNets Nets;
};

extern tGen GenRoot;
extern unsigned long Gen_HeapUsed;
extern char * Gen_PoolFreePtr, * Gen_PoolMaxPtr;
extern unsigned short Gen_NodeSize [2 + 1];
extern char * Gen_NodeName [2 + 1];

extern void (* Gen_Exit) ();
extern tGen Gen_Alloc ();
extern tGen MakeGen ARGS((Gen_tKind yyKind));
extern bool Gen_IsType ARGS((register tGen yyt, register Gen_tKind yyKind));

extern tGen nNet ();
extern tGen nNets ();

extern tGen mNet ARGS((int pTopology, int pKind, bool pSingleNode, int pSubnet, int pAuto, tTree ppNet, int pCreated, int pClosed, int pFlexible, tTree pBlock, int pUsed, tString pName, tGen pChildren, tGen pParent, int pPred, int pNum, tTree pCtrl, int pLevel));
extern tGen mNets ARGS((tGen pNet, tGen pNext));

extern void ReleaseGen ARGS((tGen yyt));
extern void WriteGen ARGS((FILE * yyyf, tGen yyt));
extern void TraverseGenTD ARGS((tGen yyt, Gen_tProcTree yyyProc));
extern void TraverseGenBU ARGS((tGen yyt, Gen_tProcTree yyyProc));
extern tGen CopyGen ARGS((tGen yyt));
extern void BeginGen ();
extern void CloseGen ();

# endif
