# include "Gen.h"
# define yyALLOC(ptr, size)	if ((ptr = (tGen) Gen_PoolFreePtr) >= (tGen) Gen_PoolMaxPtr) \
  ptr = Gen_Alloc (); \
  Gen_PoolFreePtr += size;
# define yyFREE(ptr, size)	
# ifdef __cplusplus
extern "C" {
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
}
# else
# include "System.h"
# include "General.h"
# include "Memory.h"
# include "DynArray.h"
# include "StringMem.h"
# include "Idents.h"
# include "Sets.h"
# include "Positions.h"
# endif

# line 14 "Gen.ast"

#include <CocktailIO.h>  

# ifdef getchar
# undef getchar
# endif
# ifdef putchar
# undef putchar
# endif
# include "yyGen.w"

static void yyExit () { Exit (1); }

void (* Gen_Exit) () = yyExit;

# define yyBlockSize 20480

typedef struct yysBlock {
 char yyBlock [yyBlockSize];
 struct yysBlock * yySuccessor;
} yytBlock, * yytBlockPtr;

tGen GenRoot;
unsigned long Gen_HeapUsed = 0;

static yytBlockPtr yyBlockList	= (yytBlockPtr) NoGen;
char * Gen_PoolFreePtr	= (char *) NoGen;
char * Gen_PoolMaxPtr	= (char *) NoGen;
static unsigned short yyMaxSize	= 0;
unsigned short Gen_NodeSize [2 + 1] = { 0,
 sizeof (yNet),
 sizeof (yNets),
};
char * Gen_NodeName [2 + 1] = {
 "NoGen",
 "Net",
 "Nets",
};
static Gen_tKind yyTypeRange [2 + 1] = { 0,
 kNet,
 kNets,
};

tGen Gen_Alloc ()
{
 register yytBlockPtr yyBlockPtr = yyBlockList;
 register int i;

 if (yyMaxSize == 0)
  for (i = 1; i <= 2; i ++) {
   Gen_NodeSize [i] = (Gen_NodeSize [i] + yyMaxAlign - 1) & yyAlignMasks [yyMaxAlign];
   yyMaxSize = Max (Gen_NodeSize [i], yyMaxSize);
  }
 yyBlockList = (yytBlockPtr) Alloc (sizeof (yytBlock));
 yyBlockList->yySuccessor = yyBlockPtr;
 Gen_PoolFreePtr = yyBlockList->yyBlock;
 Gen_PoolMaxPtr = Gen_PoolFreePtr + yyBlockSize - yyMaxSize + 1;
 Gen_HeapUsed += yyBlockSize;
 return (tGen) Gen_PoolFreePtr;
}

tGen MakeGen
# if defined __STDC__ | defined __cplusplus
 (Gen_tKind yyKind)
# else
 (yyKind) Gen_tKind yyKind;
# endif
{
 register tGen yyt;
 yyALLOC (yyt, Gen_NodeSize [yyKind])
 yyt->Kind = yyKind;
 yyt->yyHead.yyMark = 0;
 return yyt;
}

bool Gen_IsType
# if defined __STDC__ | defined __cplusplus
 (register tGen yyt, register Gen_tKind yyKind)
# else
 (yyt, yyKind) register tGen yyt; register Gen_tKind yyKind;
# endif
{
 return yyt != NoGen && yyKind <= yyt->Kind && yyt->Kind <= yyTypeRange [yyKind];
}

tGen nNet () {
 register tGen yyt;
 yyALLOC (yyt, Gen_NodeSize [kNet])
 yyt->Kind = kNet;
 yyt->yyHead.yyMark = 0;
 beginint(yyt->Net.Topology)
 beginint(yyt->Net.Kind)
 beginbool(yyt->Net.SingleNode)
 beginint(yyt->Net.Subnet)
 beginint(yyt->Net.Auto)
 begintTree(yyt->Net.pNet)
 beginint(yyt->Net.Created)
 beginint(yyt->Net.Closed)
 beginint(yyt->Net.Flexible)
 begintTree(yyt->Net.Block)
 beginint(yyt->Net.Used)
 begintString(yyt->Net.Name)
 begintGen(yyt->Net.Children)
 begintGen(yyt->Net.Parent)
 beginint(yyt->Net.Pred)
 beginint(yyt->Net.Num)
 begintTree(yyt->Net.Ctrl)
 beginint(yyt->Net.Level)
 return yyt;
}

tGen nNets () {
 register tGen yyt;
 yyALLOC (yyt, Gen_NodeSize [kNets])
 yyt->Kind = kNets;
 yyt->yyHead.yyMark = 0;
 begintGen(yyt->Nets.Net)
 begintGen(yyt->Nets.Next)
 return yyt;
}


tGen mNet
# if defined __STDC__ | defined __cplusplus
(int pTopology, int pKind, bool pSingleNode, int pSubnet, int pAuto, tTree ppNet, int pCreated, int pClosed, int pFlexible, tTree pBlock, int pUsed, tString pName, tGen pChildren, tGen pParent, int pPred, int pNum, tTree pCtrl, int pLevel)
# else
(pTopology, pKind, pSingleNode, pSubnet, pAuto, ppNet, pCreated, pClosed, pFlexible, pBlock, pUsed, pName, pChildren, pParent, pPred, pNum, pCtrl, pLevel)
int pTopology;
int pKind;
bool pSingleNode;
int pSubnet;
int pAuto;
tTree ppNet;
int pCreated;
int pClosed;
int pFlexible;
tTree pBlock;
int pUsed;
tString pName;
tGen pChildren;
tGen pParent;
int pPred;
int pNum;
tTree pCtrl;
int pLevel;
# endif
{
 register tGen yyt;
 yyALLOC (yyt, Gen_NodeSize [kNet])
 yyt->Kind = kNet;
 yyt->yyHead.yyMark = 0;
 yyt->Net.Topology = pTopology;
 yyt->Net.Kind = pKind;
 yyt->Net.SingleNode = pSingleNode;
 yyt->Net.Subnet = pSubnet;
 yyt->Net.Auto = pAuto;
 yyt->Net.pNet = ppNet;
 yyt->Net.Created = pCreated;
 yyt->Net.Closed = pClosed;
 yyt->Net.Flexible = pFlexible;
 yyt->Net.Block = pBlock;
 yyt->Net.Used = pUsed;
 yyt->Net.Name = pName;
 yyt->Net.Children = pChildren;
 yyt->Net.Parent = pParent;
 yyt->Net.Pred = pPred;
 yyt->Net.Num = pNum;
 yyt->Net.Ctrl = pCtrl;
 yyt->Net.Level = pLevel;
 return yyt;
}

tGen mNets
# if defined __STDC__ | defined __cplusplus
(tGen pNet, tGen pNext)
# else
(pNet, pNext)
tGen pNet;
tGen pNext;
# endif
{
 register tGen yyt;
 yyALLOC (yyt, Gen_NodeSize [kNets])
 yyt->Kind = kNets;
 yyt->yyHead.yyMark = 0;
 yyt->Nets.Net = pNet;
 yyt->Nets.Next = pNext;
 return yyt;
}

typedef tGen * yyPtrtTree;

static FILE * yyf;

static void yyMark
# if defined __STDC__ | defined __cplusplus
 (register tGen yyt)
# else
 (yyt) register tGen yyt;
# endif
{
 for (;;) {
  if (yyt == NoGen || ++ yyt->yyHead.yyMark > 1) return;

  switch (yyt->Kind) {
case kNet:
yyt = yyt->Net.Children; break;
case kNets:
yyMark (yyt->Nets.Net);
yyt = yyt->Nets.Next; break;
  default: return;
  }
 }
}

# define yyInitTreeStoreSize 32
# define yyMapToTree(yyLabel) yyTreeStorePtr [yyLabel]

static unsigned long yyTreeStoreSize = yyInitTreeStoreSize;
static tGen yyTreeStore [yyInitTreeStoreSize];
static tGen * yyTreeStorePtr = yyTreeStore;
static int yyLabelCount;
static short yyRecursionLevel = 0;

static Gen_tLabel yyMapToLabel
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyLabelCount; yyi ++) if (yyTreeStorePtr [yyi] == yyt) return yyi;
 if (++ yyLabelCount == yyTreeStoreSize)
  ExtendArray ((char * *) & yyTreeStorePtr, & yyTreeStoreSize, sizeof (tGen));
 yyTreeStorePtr [yyLabelCount] = yyt;
 return yyLabelCount;
}

static void yyWriteGen ARGS((tGen yyt));

static void yyWriteNl () { (void) putc ('\n', yyf); }

static void yyWriteSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi = 16 - strlen (yys);
 (void) fputs (yys, yyf);
 while (yyi -- > 0) (void) putc (' ', yyf);
 (void) fputs (" = ", yyf);
}

static void yyWriteHex
# if defined __STDC__ | defined __cplusplus
 (unsigned char * yyx, int yysize)
# else
 (yyx, yysize) unsigned char * yyx; int yysize;
# endif
{ register int yyi; for (yyi = 0; yyi < yysize; yyi ++) (void) fprintf (yyf, "%02x ", yyx [yyi]); }

static short yyIndentLevel;

void WriteGen
# if defined __STDC__ | defined __cplusplus
 (FILE * yyyf, tGen yyt)
# else
 (yyyf, yyt) FILE * yyyf; tGen yyt;
# endif
{
 short yySaveLevel = yyIndentLevel;
 yyf = yyyf;
 if (yyRecursionLevel ++ == 0) yyLabelCount = 0;
 yyMark (yyt);
 yyIndentLevel = 0;
 yyWriteGen (yyt);
 yyIndentLevel = yySaveLevel;
 yyRecursionLevel --;
}

static void yyIndentSelector
# if defined __STDC__ | defined __cplusplus
 (char * yys)
# else
 (yys) char * yys;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
 yyWriteSelector (yys);
}

static void yyIndentSelectorTree
# if defined __STDC__ | defined __cplusplus
 (char * yys, tGen yyt)
# else
 (yys, yyt) char * yys; tGen yyt;
# endif
{ yyIndentSelector (yys); writetGen (yyt) }

static void yWriteNet
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 (void) fputs (Gen_NodeName [kNet], yyf); (void) fputc ('\n', yyf);
 yyIndentSelector ("Topology"); writeint (yyt->Net.Topology) yyWriteNl ();
 yyIndentSelector ("Kind"); writeint (yyt->Net.Kind) yyWriteNl ();
 yyIndentSelector ("SingleNode"); writebool (yyt->Net.SingleNode) yyWriteNl ();
 yyIndentSelector ("Subnet"); writeint (yyt->Net.Subnet) yyWriteNl ();
 yyIndentSelector ("Auto"); writeint (yyt->Net.Auto) yyWriteNl ();
 yyIndentSelector ("pNet"); writetTree (yyt->Net.pNet) yyWriteNl ();
 yyIndentSelector ("Created"); writeint (yyt->Net.Created) yyWriteNl ();
 yyIndentSelector ("Closed"); writeint (yyt->Net.Closed) yyWriteNl ();
 yyIndentSelector ("Flexible"); writeint (yyt->Net.Flexible) yyWriteNl ();
 yyIndentSelector ("Block"); writetTree (yyt->Net.Block) yyWriteNl ();
 yyIndentSelector ("Used"); writeint (yyt->Net.Used) yyWriteNl ();
 yyIndentSelector ("Name"); writetString (yyt->Net.Name) yyWriteNl ();
 yyIndentSelector ("Parent"); writetGen (yyt->Net.Parent) yyWriteNl ();
 yyIndentSelector ("Pred"); writeint (yyt->Net.Pred) yyWriteNl ();
 yyIndentSelector ("Num"); writeint (yyt->Net.Num) yyWriteNl ();
 yyIndentSelector ("Ctrl"); writetTree (yyt->Net.Ctrl) yyWriteNl ();
 yyIndentSelector ("Level"); writeint (yyt->Net.Level) yyWriteNl ();
}

static void yWriteNets
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 (void) fputs (Gen_NodeName [kNets], yyf); (void) fputc ('\n', yyf);
 yyIndentSelectorTree ("Net", yyt->Nets.Net);
}

static void yyWriteGen
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{ unsigned short yyLevel = yyIndentLevel;
 for (;;) {
  if (yyt == NoGen) { (void) fputs (" NoGen\n", yyf); goto yyExit;
  } else if (yyt->yyHead.yyMark == 0) { (void) fprintf (yyf, "^%d\n", yyMapToLabel (yyt)); goto yyExit;
  } else if (yyt->yyHead.yyMark > 1) {
   register int yyi;
   (void) fprintf (yyf, "\n%06d:", yyMapToLabel (yyt));
   for (yyi = 8; yyi <= yyIndentLevel; yyi ++) (void) putc (' ', yyf);
  } else (void) putc (' ', yyf);
  yyt->yyHead.yyMark = 0;
  yyIndentLevel += 2;

  switch (yyt->Kind) {
case kNet: yWriteNet (yyt); yyIndentSelector ("Children"); yyt = yyt->Net.Children; break;
case kNets: yWriteNets (yyt); yyIndentSelector ("Next"); yyt = yyt->Nets.Next; break;
  default: goto yyExit;
  }
 }
yyExit:
 yyIndentLevel = yyLevel;
}

# define yyNil	0374
# define yyNoLabel	0375
# define yyLabelDef	0376
# define yyLabelUse	0377

static tGen yyChild;

static void yyReleaseGen
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 if (yyt == NoGen) return;
 switch (yyt->Kind) {
case kNet:
closetGen (yyt->Net.Children)
break;
case kNets:
closetGen (yyt->Nets.Net)
closetGen (yyt->Nets.Next)
break;
 default: ;
 }

 if (-- yyt->yyHead.yyMark == 0) {
  switch (yyt->Kind) {
case kNet:
closeint (yyt->Net.Topology)
closeint (yyt->Net.Kind)
closebool (yyt->Net.SingleNode)
closeint (yyt->Net.Subnet)
closeint (yyt->Net.Auto)
closetTree (yyt->Net.pNet)
closeint (yyt->Net.Created)
closeint (yyt->Net.Closed)
closeint (yyt->Net.Flexible)
closetTree (yyt->Net.Block)
closeint (yyt->Net.Used)
closetString (yyt->Net.Name)
closetGen (yyt->Net.Parent)
closeint (yyt->Net.Pred)
closeint (yyt->Net.Num)
closetTree (yyt->Net.Ctrl)
closeint (yyt->Net.Level)
break;
  default: ;
  }
  yyFREE (yyt, Gen_NodeSize [yyt->Kind])
 }
}

void ReleaseGen
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 yyMark (yyt);
 yyReleaseGen (yyt);
}

static Gen_tProcTree yyProc;

static void yyTraverseGenTD
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 for (;;) {
  if (yyt == NoGen || yyt->yyHead.yyMark == 0) return;
  yyt->yyHead.yyMark = 0;
  yyProc (yyt);

  switch (yyt->Kind) {
case kNet:
yyt = yyt->Net.Children; break;
case kNets:
yyTraverseGenTD (yyt->Nets.Net);
yyt = yyt->Nets.Next; break;
  default: return;
  }
 }
}

void TraverseGenTD
# if defined __STDC__ | defined __cplusplus
 (tGen yyt, Gen_tProcTree yyyProc)
# else
 (yyt, yyyProc) tGen yyt; Gen_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseGenTD (yyt);
}

static void yyTraverseGenBU
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 if (yyt == NoGen || yyt->yyHead.yyMark == 0) return;
 yyt->yyHead.yyMark = 0;

 switch (yyt->Kind) {
case kNet:
yyTraverseGenBU (yyt->Net.Children); break;
case kNets:
yyTraverseGenBU (yyt->Nets.Net);
yyTraverseGenBU (yyt->Nets.Next); break;
 default: ;
 }
 yyProc (yyt);
}

void TraverseGenBU
# if defined __STDC__ | defined __cplusplus
 (tGen yyt, Gen_tProcTree yyyProc)
# else
 (yyt, yyyProc) tGen yyt; Gen_tProcTree yyyProc;
# endif
{
 yyMark (yyt);
 yyProc = yyyProc;
 yyTraverseGenBU (yyt);
}

# define yyInitOldToNewStoreSize 32

typedef struct { tGen yyOld, yyNew; } yytOldToNew;
static unsigned long yyOldToNewStoreSize = yyInitOldToNewStoreSize;
static yytOldToNew yyOldToNewStore [yyInitOldToNewStoreSize];
static yytOldToNew * yyOldToNewStorePtr = yyOldToNewStore;
static int yyOldToNewCount;

static void yyStoreOldToNew
# if defined __STDC__ | defined __cplusplus
 (tGen yyOld, tGen yyNew)
# else
 (yyOld, yyNew) tGen yyOld, yyNew;
# endif
{
 if (++ yyOldToNewCount == yyOldToNewStoreSize)
  ExtendArray ((char * *) & yyOldToNewStorePtr, & yyOldToNewStoreSize, sizeof (yytOldToNew));
 yyOldToNewStorePtr [yyOldToNewCount].yyOld = yyOld;
 yyOldToNewStorePtr [yyOldToNewCount].yyNew = yyNew;
}

static tGen yyMapOldToNew
# if defined __STDC__ | defined __cplusplus
 (tGen yyOld)
# else
 (yyOld) tGen yyOld;
# endif
{
 register int yyi;
 for (yyi = 1; yyi <= yyOldToNewCount; yyi ++)
  if (yyOldToNewStorePtr [yyi].yyOld == yyOld) return yyOldToNewStorePtr [yyi].yyNew;
 return NoGen;
}

static void yyCopyGen
# if defined __STDC__ | defined __cplusplus
 (tGen yyt, yyPtrtTree yyNew)
# else
 (yyt, yyNew) tGen yyt; yyPtrtTree yyNew;
# endif
{
 for (;;) {
  if (yyt == NoGen) { * yyNew = NoGen; return; }
  if (yyt->yyHead.yyMark == 0) { * yyNew = yyMapOldToNew (yyt); return; }
  yyALLOC (* yyNew, Gen_NodeSize [yyt->Kind])
  if (yyt->yyHead.yyMark > 1) { yyStoreOldToNew (yyt, * yyNew); }
  yyt->yyHead.yyMark = 0;

  switch (yyt->Kind) {
case kNet: (* yyNew)->Net = yyt->Net;
copyint ((* yyNew)->Net.Topology, yyt->Net.Topology)
copyint ((* yyNew)->Net.Kind, yyt->Net.Kind)
copybool ((* yyNew)->Net.SingleNode, yyt->Net.SingleNode)
copyint ((* yyNew)->Net.Subnet, yyt->Net.Subnet)
copyint ((* yyNew)->Net.Auto, yyt->Net.Auto)
copytTree ((* yyNew)->Net.pNet, yyt->Net.pNet)
copyint ((* yyNew)->Net.Created, yyt->Net.Created)
copyint ((* yyNew)->Net.Closed, yyt->Net.Closed)
copyint ((* yyNew)->Net.Flexible, yyt->Net.Flexible)
copytTree ((* yyNew)->Net.Block, yyt->Net.Block)
copyint ((* yyNew)->Net.Used, yyt->Net.Used)
copytString ((* yyNew)->Net.Name, yyt->Net.Name)
copytGen ((* yyNew)->Net.Parent, yyt->Net.Parent)
copyint ((* yyNew)->Net.Pred, yyt->Net.Pred)
copyint ((* yyNew)->Net.Num, yyt->Net.Num)
copytTree ((* yyNew)->Net.Ctrl, yyt->Net.Ctrl)
copyint ((* yyNew)->Net.Level, yyt->Net.Level)
yyt = yyt->Net.Children;
yyNew = & (* yyNew)->Net.Children; break;
case kNets: (* yyNew)->Nets = yyt->Nets;
copytGen ((* yyNew)->Nets.Net, yyt->Nets.Net)
yyt = yyt->Nets.Next;
yyNew = & (* yyNew)->Nets.Next; break;
  default: ;
  }
 }
}

tGen CopyGen
# if defined __STDC__ | defined __cplusplus
 (tGen yyt)
# else
 (yyt) tGen yyt;
# endif
{
 tGen yyNew;
 yyMark (yyt);
 yyOldToNewCount = 0;
 yyCopyGen (yyt, & yyNew);
 return yyNew;
}

void BeginGen ()
{
}

void CloseGen ()
{
}
