/*
 * $Id: Expr_print.c,v 3.2 1999/11/10 14:54:53 scheme Exp posypkin $
 */


/* code generation for MPC_Expr and correspond nodes */
/* Coded by A.Kalinov 10.95 - 12.95*/

#include "be_print.h"


char* op_represent[]=
{"",   "",   "",   "",   "[]", "",   "",   ".",
 " -> ", " ++ ", " -- ", " ++ ", " -- ", " & ",  " * ",  " - ",
 " ~ ",  " ! ",  "",   "",   "",   " * ",  " / ",  " % ",
 "",   "",   " + ",  " - ",  " << ", " >> ", " < ",  " > ",
 " <= ", " >= ", " == ", " != ", " & ",  " ^ ",  " | ",  " && ",
 " || ", "",   " = ",  " *= ", " /= ", " %= ", " += ", " -= ",
 " <<= "," >>= "," &= ", " ^= ", " |= ", "",   "", " , "              };

#define STEP_MACRO(pType)    pType->Kind == kMPC_PointerType ? \
                             pType->MPC_PointerType.Step : \
                             pType->MPC_ArrayType.Step

#define STEP_MACRO_MAX_SIZE 32
#define LEFT 1
#define RIGHT 2
                             

static char step_macro_pointer[STEP_MACRO_MAX_SIZE];
static char starStepMacroPointer[STEP_MACRO_MAX_SIZE+1];
static void print_call(tTree );
static int set_change_net(tTree );

static int must_be_lvalue=0;
static int right_part=0, peculiar=0, set_defer_to_0=0;
static int was_net_cast=0;
static int net_param_list=0;
static int variable_array=0;
static tTree go_to_ident_through_indexes(tTree );
static int var_array_depth(tTree );
static void print_Type_in_cast(tTree );
int is_not_c_pointer(tTree );
char* step_macro(tTree);
char* starStepMacro(tTree, int);
static void printGrid(tTree pExpr, int shift);

char* step_macro(tTree pType)
{
tTree pElemType;
if(pType->Kind==kMPC_ArrayType){
  pElemType = pType->MPC_ArrayType.ElementType;
  if(is_dynamic_type(pElemType) || is_dynamic_step(pType))
    sprintf(step_macro_pointer,"%s%s",DataVarName(pType),SHIFT_SIZE_POSTFIX);
  else if(pType->MPC_ArrayType.Step!=1)  sprintf(step_macro_pointer,"%d",pType->MPC_ArrayType.Step);
  else step_macro_pointer[0]=0;
  }
else if(pType->Kind==kMPC_VectorType){
  pElemType = pType->MPC_VectorType.ElementType;
  if(is_dynamic_type(pType))
    sprintf(step_macro_pointer,"%s%s", DataVarName(pType), SHIFT_SIZE_POSTFIX);
}
else if(pType->Kind==kMPC_PointerType){
  pElemType = pType->MPC_PointerType.ElementType;
  if(is_dynamic_type(pElemType) || is_dynamic_step(pType))
    sprintf(step_macro_pointer,"%s%s",DataVarName(pType),SHIFT_SIZE_POSTFIX);
  else if(pType->MPC_PointerType.Step!=1) sprintf(step_macro_pointer,"%d",pType->MPC_PointerType.Step);
  else step_macro_pointer[0]=0;  
  }
else  
    {
    printf("step_macro:  %d:  unrecognized type. \n", pType->Kind);
    internal_error();
    }
return step_macro_pointer;
}

char* starStepMacro(tTree pType, int dir){
  step_macro(pType); 
  if( step_macro_pointer[0] == 0 )
    starStepMacroPointer[0]=0;
  else {
    switch(dir) {
    case LEFT:
      sprintf(starStepMacroPointer,"*%s",step_macro_pointer);
      break;
    case RIGHT:
      sprintf(starStepMacroPointer,"%s*",step_macro_pointer);
      break;
    }
  }
  return starStepMacroPointer;
}


int is_not_c_pointer(tTree pType)
{
if(pType->Kind==kMPC_ArrayType)
  {
  if(is_dynamic_type(pType)) return 1;
  else if(pType->MPC_ArrayType.Step!=1) return 1;
  else return 0;
  }
else if(pType->Kind==kMPC_PointerType)
  {
  if(is_dynamic_type(pType)) return 1;
  else if(pType->MPC_PointerType.Step!=1) return 1;
  else return 0;   
  }
else return 0;
}
 

void print_Exprs(tTree pExprs) {
  tTree pExpr;
  tTree pNext;
  if(pExprs != NoTree) {
    while(pExprs->Kind != kMPC_FreeNode) {
      pExpr=pExprs->MPC_Exprs.Expr;
      PointerControl(pExpr);
      print_Expr(pExpr);
      pNext=pExprs->MPC_Exprs.Next;
      if(pNext->Kind != kMPC_FreeNode) {
	cur_pos+=fputs(",",file);
      }
      pExprs=pNext;
    }
  }
}

void print_Expr(tTree pExpr) {
  tTree pVar;
  tTree pEvalNetList;
  tTree pEvalNet;
  tTree pOperand;
  tTree pLop,pRop;
  tTree pFop,pSop,pTop;
  int OpCode;
  tExprFlags flag;
  tTree old_parent_expr=parent_expr;
  tTree prev_act_net=cur_act_net;
  int old_root_index=root_index;
  int old_expr_index=root_index;
  int old_index_depth=index_depth;
  int old_change_net=not_change_net;
  int i;
  int braces,to_double=0;
  /*variable_array=0;*/
  PointerControl(pExpr);
  Position=pExpr->MPC_Expr.Pos;
  if(prt) printf("       \nprint_Expr begin pExpr=%p parent_expr=%p\n",
         pExpr,parent_expr);
  if(parent_expr != NoTree &&
     parent_expr != pExpr &&
     parent_expr->MPC_Expr.Flag.Generated) {
    if(prt) printf("  print_Expr end pExpr=%p parent_expr=%p nothihg was genereted\n",
           pExpr,parent_expr);
    return;
  }
  parent_expr=pExpr;
  braces=0;
  flag=pExpr->MPC_Expr.Flag;
  basic_fun_call+=(is_basic_function_call(pExpr) && !flag.Generated);
  if(prt) printf("Print_Expr pExpr=%p Kind=%d gen=%d InPar=%d Asyn=%d Pec=%d basic=%d not_change_net=%d\n",
         pExpr,pExpr->Kind,flag.Generated,flag.InParentheses,
                 flag.Asynchr,flag.Peculiarity,basic_fun_call,not_change_net);
  if(!flag.Generated && !not_change_net) {
    braces=set_cur_act_net(pExpr);
    not_change_net=1;
  }
  if(flag.Generated) {
    tString pTmpName=pExpr->MPC_Expr.TmpName;
    tTree pType=pExpr->MPC_Expr.Type;
    int old_end_statement_is_needed=end_statement_is_needed;
    PointerControl(pType);
    end_statement_is_needed=0;
    if(strcmp(pTmpName,"")) {
      if(not_index) cur_pos+=fprintf(file,"%s",pTmpName);
      else {
        if(use_slots) {
          if((global_index_level<=1)||(index_level(pType)==0))  cur_pos+=fprintf(file,"%s",pTmpName);
          else   fprintf(file,"%s%d",TMP_SLOT_PREFIX,pExpr->MPC_Expr.Optm_Attribute.first_slot+global_index_level-2);
        }
        else {
          cur_pos+=fprintf(file,"%s",pTmpName);
        }
        print_index(pType,0,global_shift);
      }
    }
    parent_expr=old_parent_expr;
    if(prt) printf("       print_Expr end pExpr=%p Genereted was equal to 1\n",pExpr);
    end_statement_is_needed=old_end_statement_is_needed;
    return;
  }
  if(pExpr->MPC_Expr.Optm_Attribute.slot&&pExpr->MPC_Expr.Optm_Attribute.generated&&use_slots) {
    int old_end_statement_is_needed=end_statement_is_needed;
    end_statement_is_needed=0;
      cur_pos+=fprintf(file,"%s%d",TMP_SLOT_PREFIX,pExpr->MPC_Expr.Optm_Attribute.slot);
    parent_expr=old_parent_expr;
    end_statement_is_needed=old_end_statement_is_needed;
    return;
  }

  if(braces != 0 || pExpr == old_parent_expr) {
    c_blank;
  }
  {
    tTree pType=pExpr->MPC_Expr.Type;
    PointerControl(pType);
    if(flag.FixPoint) {
      if(pType->Kind == kMPC_BasicType &&
         pType->MPC_BasicType.TypeConstructor == DOUBLE &&
         flag.FixPoint) {
        to_double=1;
      }
    }
  }
  if(to_double) {
    cur_pos+=fprintf(file,"((double)(");
  }    
  if(flag.InParentheses)
    cur_pos+=fprintf(file,"(");
  switch(pExpr->Kind) {
  case kMPC_Const:
  case kMPC_IntConst:
  case kMPC_UIntConst:
  case kMPC_FloatConst:
    cur_pos+=fputs(pExpr->MPC_Const.SymbolicForm,file);
    break;
  case kMPC_StringLiteral:
    {
      tTree pNext=pExpr->MPC_StringLiteral.Next;
      cur_pos+=fprintf(file,"%s",pExpr->MPC_StringLiteral.String);
      if(pNext != NoTree && pNext->Kind != kMPC_FreeNode) {
        print_Expr(pNext);
      }
    }
    break;
  case kMPC_Ident:
    {
      tTree pType=pExpr->MPC_Ident.Type;
      PointerControl(pType);
      pVar=pExpr->MPC_Ident.Store;
      if(pVar != NoTree && pVar->Kind == kMPC_Var) {
        tTree pRealExpr;
        pRealExpr=real_net_type_param(pVar);
        if(pRealExpr != NoTree) {
          if(pRealExpr->Kind != kMPC_Var) {
            print_Expr(pRealExpr);
          }
          else {
            cur_pos+=fprintf(file,"%s",VarName(pRealExpr));
          }
        }
        else {
          cur_pos+=fprintf(file,"%s",VarName(pVar));
        }
      }
      else {
        tIdent Ident=pExpr->MPC_Ident.Ident;
        IdentControl(Ident);
        GetString(Ident,NameBuf);
        cur_pos+=fprintf(file,"%s",NameBuf);
      }
    }
    break;
  case kMPC_CastExpr:
    {
      tTree pType=pExpr->MPC_CastExpr.Type;
      PointerControl(pType);
      /*print_Type_in_sizeof(pType);*/
      print_Type_in_cast(pType);
      pOperand=pExpr->MPC_CastExpr.Operand;
      PointerControl(pOperand);
      print_Expr(pOperand);
    }
    break;
  case kMPC_NetCastExpr:
    {
      tTree pStoreNet=pExpr->MPC_Expr.StoreNet;
      PointerControl(pStoreNet);
      if(is_NetCast_asynch(pExpr)) {
        tTree pOperand=pExpr->MPC_NetCastExpr.Operand;
        PointerControl(pOperand);
        {
          tTree prev_act_net=cur_act_net;
          {
            if(flag.Asynchr) {
              pOperand->MPC_Expr.ActualEvalNet=pOperand->MPC_Expr.EvalNet;
              not_change_net=1;
              print_Expr(pOperand);
            }
            else {
              fill_ActualEvalNet(pOperand);
              cur_act_net=not_change_net ?
                prev_act_net : pOperand->MPC_Expr.ActualEvalNet;
              PointerControl(cur_act_net);
              print_Expr(pOperand);
              cur_act_net=prev_act_net;
            }
          }
        }
      }
      else {
        fprintf(stderr,"Sorry, not bounded NetCast isn't supported\n");
        internal_error();
      }
    }
    break;
  case kMPC_CoordExpr:
    {
      tTree pENet;
      if(net_to_change == NoTree) {
        pEvalNetList=pExpr->MPC_CoordExpr.EvalNet;
        PointerControl(pEvalNetList);
        pEvalNet=SingleRegion(pEvalNetList);
      }
      else {
        pEvalNet=net_to_change;
      }
      PointerControl(pEvalNet);
      pENet=pEvalNet;
      while(pENet->Kind == kMPC_Subnet &&
            pENet->MPC_Subnet.Flexible == 1) {
        pENet=pENet->MPC_Subnet.Distribution;
        PointerControl(pENet);
      }
      cur_pos+=fprintf(file,"%s.coord[%d]",VarName(pENet),
                       pExpr->MPC_CoordExpr.CoordNumber);
      pOperand=pExpr->MPC_CoordExpr.Operand;
    }
    break;
  case kMPC_Size_Of_Value:
  case kMPC_Size_Of_Type:
    {
      int CompileTime=pExpr->MPC_SizeofExpr.CompileTime;
      if(CompileTime) {
        cur_pos+=fprintf(file,"%d",pExpr->MPC_SizeofExpr.Value);
      }
      else if(pExpr->Kind == kMPC_Size_Of_Value) {
        tTree pType;
        pOperand=pExpr->MPC_Size_Of_Value.Operand;
        pType=pOperand->MPC_Expr.Type;
        PointerControl(pOperand);
        PointerControl(pType);
        if(IS_DYN_ARRAY_OR_VECTOR(pType))
          cur_pos+=fprintf(file,"%s.Base.Size",DataVarName(pOperand->MPC_Expr.Type));
        else if(pOperand->MPC_Expr.Flag.Peculiarity) {
          if((pOperand->MPC_Expr.Type->Kind==kMPC_ArrayType)
                  /*&&(pOperand->MPC_Expr.Flag.Lvalue)*/){
            cur_pos+=fprintf(file,"(");
            while(pType->Kind==kMPC_ArrayType){
              if(STEP(pType)==1)
                cur_pos+=fprintf(file,"%d*",NUMBER_OF_COMPONENTS(pType));
              else
                cur_pos+=fprintf(file,"(%d*%d+1)*",NUMBER_OF_COMPONENTS(pType)-1,
                                 STEP(pType));
              pType=element_type(pType);
              PointerControl(pType);
            }
            cur_pos+=fprintf(file,"sizeof(");
            print_Type_in_sizeof(pType);
            cur_pos+=fprintf(file,")");
            cur_pos+=fprintf(file,")");
          }
          else if(pType->Kind==kMPC_VectorType) {
            cur_pos+=fprintf(file,"(");
            while(pType->Kind==kMPC_VectorType){
                cur_pos+=fprintf(file,"%d*",NUMBER_OF_COMPONENTS(pType));
                pType=element_type(pType);
                PointerControl(pType);
            }
            cur_pos+=fprintf(file,"sizeof(");
            print_Type_in_sizeof(pType);
            cur_pos+=fprintf(file,")");
            cur_pos+=fprintf(file,")");
          }
          else if(pType->Kind==kMPC_PointerType) {
            cur_pos+=fprintf(file,"sizeof(void*)");
          }
          else{
            cur_pos+=fprintf(file,"sizeof(");
            print_Type_in_sizeof(pType);
            cur_pos+=fprintf(file,")");
          }
        }
        else {
          cur_pos+=fprintf(file,"sizeof(");
          print_Expr(pOperand);
          cur_pos+=fprintf(file,")");
        }
          
      }
      else {
        pOperand=pExpr->MPC_Size_Of_Type.Operand;
        PointerControl(pOperand);
        if(IS_DYN_ARRAY_OR_VECTOR(pOperand))
          cur_pos+=fprintf(file,"%s.Base.Size",DataVarName(pOperand));
        else if(is_dynamic_type(pOperand)==DYNAMIC_POINTER) {
          cur_pos+=fprintf(file,"sizeof(void*)");
        }
        else {
          cur_pos+=fprintf(file,"sizeof(");
          print_Type_in_sizeof(pOperand);
          cur_pos+=fprintf(file,")");
        }
      }
    }
    break;
  case kMPC_UnaryExpr:
    {
      tTree pType=pExpr->MPC_UnaryExpr.Type;
      char *ope[2]= {"+=","-="};
      int old_print_base_type;
      PointerControl(pType);
      pOperand=pExpr->MPC_UnaryExpr.Operand;
      PointerControl(pOperand);
      OpCode=pExpr->MPC_UnaryExpr.OpCode;
      if(prt) printf("MPC_UnaryExpr OpCode=%d\n",OpCode);
      if(OpCode == POST_INC || OpCode == POST_DEC) {
        if(prt) printf("pExpr->MPC_Expr.Pass=%d not_pecul=%d\n",
                       pExpr->MPC_Expr.Pass,not_pecul);
        /*if(pExpr->MPC_Expr.Pass == 2 || not_pecul) {*/
        if(is_not_c_pointer(pType)) {
            /*
            cur_pos+=fprintf(file,"(");
            print_Expr(pOperand);
            cur_pos+=fprintf(file,"%s%s)",ope[OpCode-POST_INC],
            step_macro(pType));
            */
          old_print_base_type=print_base_type;
          print_base_type=1;
          cur_pos+=fprintf(file,"(MPC_tmp_pp=(void**)&(");
          print_Expr(pOperand);
          cur_pos+=fprintf(file,"), MPC_tmp_pv=*MPC_tmp_pp,((");
          print_Type(pType);
          cur_pos+=fprintf(file,")*MPC_tmp_pp)%s%s,(",
                           ope[OpCode-POST_INC],step_macro(pType));
          print_Type(pType);
          cur_pos+=fprintf(file,")MPC_tmp_pv)");
          print_base_type=old_print_base_type;
          
          }
          else {
            print_Expr(pOperand);
            cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
          }
          /*pExpr->MPC_Expr.Pass=3;
          }
        else {
          print_Expr(pOperand);
        }*/
      }
      else if(OpCode == PRE_INC || OpCode == PRE_DEC) {
        /*if(pExpr->MPC_Expr.Pass == 0) {*/
          if(is_not_c_pointer(pType)) {
            cur_pos+=fprintf(file,"(");
            print_Expr(pOperand);
            cur_pos+=fprintf(file,"%s%s)",ope[OpCode-PRE_INC],
                             step_macro(pType));
          }
          else {
            cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
            print_Expr(pOperand);
          }
          /*}
        else {
          print_Expr(pOperand);
        }*/
      }
      else if(OpCode == STAR){
        if(!is_pointer_on_dynamic(pOperand->MPC_Expr.Type))
            cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
        print_Expr(pOperand);
       }
      else if(OpCode == ADDRESS){
        if(is_dynamic_type(pOperand->MPC_Expr.Type)==DYNAMIC_ARRAY) {
          if((pOperand->MPC_Expr.Flag.Lvalue!=0)&&
             (!(is_dynamic_type(element_type(pOperand->MPC_Expr.Type))==DYNAMIC_ARRAY)))
            cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
        }
        else 
          cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
        print_Expr(pOperand);
       }
      else if((OpCode >= ADDRESS && OpCode <= LOG_NOT) ||
              OpCode == PLUS) {
        cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
        print_Expr(pOperand);
      }
      else if(OpCode == BRACKETS) {
        tTree pType=pExpr->MPC_Expr.Type;
        PointerControl(pType);
        if(use_slots) {
          if((global_index_level-global_shift)==1)  print_Expr(pOperand);
          else   fprintf(file,"%s%d",TMP_SLOT_PREFIX,pExpr->MPC_Expr.Optm_Attribute.first_slot+global_index_level-global_shift-2);
        }
        else
          print_Expr(pOperand);
        if(prt) printf("BRACKETS pExpr=%p is_argument=%d\n",pExpr,is_argument);
        if(!is_argument) print_index(pType,0,global_shift);
      }
      else if(OpCode > LINEAR) {
        print_Expr(pOperand);
      }
      else {
        fprintf(stderr,
                "invalid op code of the unary expression = %d generated=%d\n",
                OpCode,flag.Generated);
        internal_error();
      }
    }
    break;
  case kMPC_BinaryExpr:
    OpCode=pExpr->MPC_BinaryExpr.OpCode;
    if(prt) printf("MPC_BinaryExpr OpCode=%d variable_array=%d\n",
           OpCode,variable_array);
    not_change_net=set_change_net(pExpr);
    if(OpCode >= ASSIGN && OpCode <= INCL_OR_ASSIGN) {
      print_Assign(pExpr);
    }
    else {
      int depth;
      tTree pType=pExpr->MPC_Expr.Type;
      PointerControl(pType);
      pLop=pExpr->MPC_BinaryExpr.Loperand;
      PointerControl(pLop);
      pRop=pExpr->MPC_BinaryExpr.Roperand;
      PointerControl(pRop);
      OpCode=pExpr->MPC_BinaryExpr.OpCode;
      depth=var_array_depth(pExpr);
      if(OpCode == INDEX) {
        tTree pLopType=Strip_Typedef(pLop->MPC_Expr.Type);
        tTree pExprType=Strip_Typedef(pExpr->MPC_Expr.Type);

        if(pLopType->Kind==kMPC_ArrayType) {
          if(is_dynamic_type(pLopType)) {
            if(is_dynamic_type(pExprType)==DYNAMIC_ARRAY) {
              cur_pos+=fprintf(file,"(");
              print_Expr(pLop);
              cur_pos+=fprintf(file,"+%s(", starStepMacro(pLopType, RIGHT));
              print_Expr(pRop);
              cur_pos+=fprintf(file,"))");
            }
            else {
              cur_pos+=fprintf(file,"(*(");
              print_Expr(pLop);
              cur_pos+=fprintf(file,"+%s(",starStepMacro(pLopType, RIGHT));
              print_Expr(pRop);
              cur_pos+=fprintf(file,")))");
            }
          }
          else {
              print_Expr(pLop);
              cur_pos+=fprintf(file,"[");
              print_Expr(pRop);
              if(is_not_c_pointer(pLopType)) fprintf(file,"*%s",step_macro(pLopType));
              cur_pos+=fprintf(file,"]");
          }
        }
        else if(pLopType->Kind==kMPC_PointerType) {
            if(is_pointer_on_dynamic(pLopType)) {
              cur_pos+=fprintf(file,"(");
              print_Expr(pLop);
              cur_pos+=fprintf(file,"+%s%s*(",DataVarName(pLopType),SHIFT_SIZE_POSTFIX);
              print_Expr(pRop);
              cur_pos+=fprintf(file,"))");
            }
            else {
              print_Expr(pLop);
              cur_pos+=fprintf(file,"[");
              print_Expr(pRop);
              if(is_not_c_pointer(pType)) fprintf(file,"*%s",step_macro(pLopType));
              cur_pos+=fprintf(file,"]");
            }
        }
        else {
          /*      internal_error();*/
              print_Expr(pLop);
              cur_pos+=fprintf(file,"[");
              print_Expr(pRop);
              if(is_not_c_pointer(pLopType)) fprintf(file,"*%s",step_macro(pLopType));
              cur_pos+=fprintf(file,"]");
        }
            
      }
      else if((OpCode >= DOT && OpCode <= ARROW) ||
              (OpCode >= MULT && OpCode <= COMMA && 
               OpCode != CONDITION)) {
        tTree pType=pExpr->MPC_BinaryExpr.Type;
        tTree pLType=pLop->MPC_Expr.Type;
        tTree pRType=pRop->MPC_Expr.Type;
        PointerControl(pType);
        PointerControl(pLType);
        PointerControl(pRType);
        if(OpCode == MINUS && (/*(pLType->Kind == kMPC_PointerType &&
                                pLType->MPC_PointerType.Step != 1) ||
                               (pLType->Kind == kMPC_ArrayType &&
                                pLType->MPC_ArrayType.Step != 1)*/is_not_c_pointer(pLType)) &&
           (pRType->Kind == kMPC_PointerType ||
            pRType->Kind == kMPC_ArrayType)) {
          cur_pos+=fprintf(file,"(");
          print_Expr(pLop);
          cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
            print_Expr(pRop);
            cur_pos+=fprintf(file,")/%s",
                             step_macro(pLType));
        }
        else if((OpCode == PLUS ||OpCode == MINUS) &&
                /*pType->Kind == kMPC_PointerType &&
                pType->MPC_PointerType.Step != 1*/is_not_c_pointer(pType)) {
          if(pLType->Kind == kMPC_PointerType ||
             pLType->Kind == kMPC_ArrayType) {
            print_Expr(pLop);
            cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
            cur_pos+=fprintf(file,"(");
            print_Expr(pRop);
            cur_pos+=fprintf(file,")*%s",
                              step_macro(pLType));
          }
          else {
            cur_pos+=fprintf(file,"(");
            print_Expr(pLop);
            cur_pos+=fprintf(file,")*%s",
                             step_macro(pRType));
            cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
            print_Expr(pRop);
          }
        }
        else {
          print_Expr(pLop);
          cur_pos+=fprintf(file,"%s",op_represent[OpCode]);
          print_Expr(pRop);
        }
      }
      else {
	fprintf(stderr,
		"invalid op code of the binary expression = %d\n"
		,OpCode);
	internal_error();
      }
    }
    break;
  case kMPC_TernaryExpr:
    pFop=pExpr->MPC_TernaryExpr.Foperand;
    PointerControl(pFop);
    pSop=pExpr->MPC_TernaryExpr.Soperand;
    PointerControl(pSop);
    pTop=pExpr->MPC_TernaryExpr.Toperand;
    PointerControl(pTop);
    OpCode=pExpr->MPC_TernaryExpr.OpCode;
    if(OpCode == CONDITION) {
      print_Expr(pFop);
      cur_pos+=fputs("?",file);
      print_Expr(pSop);
      cur_pos+=fputs(":",file);
      print_Expr(pTop);
    }
    else {
      fprintf(stderr,
	      "invalid op code of the ternary expression = %d\n"
	      ,OpCode);
      internal_error();
    }
    break;

  case kMPC_QuaternaryExpr:
    {
      /*
      tTree pType;
      tTree pOperand;
      
      pType = Strip_Typedef(pExpr->MPC_Expr.Type);
      PointerControl(pType);
      pOperand = pExpr->MPC_QuaternaryExpr.Operand1;
      PointerControl(pOperand);
      if(use_slots) {
	if((global_index_level-global_shift) == 1)  print_Expr(pOperand);
	else   fprintf(file,"%s%d",
		       TMP_SLOT_PREFIX,
		       pOperand->MPC_Expr.Optm_Attribute.slot);
      }
      else print_Expr(pOperand);
      */
      printGrid(pExpr,global_shift);
    } 
    break;

  case kMPC_CallExpr:
    if(is_basic_function_call(pExpr) &&
       basic_fun_call == 1) basic_fun_call++;
    if(prt) printf(" MPC_CallExpr basic_fun_call=%d\n",basic_fun_call);
    print_call(pExpr);
    basic_fun_call=0;
    break;
  case kMPC_TimeofExpr:
    {
      tTree pNetDecl=pExpr->MPC_TimeofExpr.NetDecl;
      tTree p_net;
      PointerControl(pNetDecl);
      p_net=pNetDecl->MPC_NetDecl.Net;
      PointerControl(p_net);
      /*printf("p_net->MPC_Net.Topology=%d CONST=%d\n",
	     p_net->MPC_Net.Topology,CONST);*/
      /*      if(p_net->MPC_Net.Topology != CONST) {
	tTree pNetTypeSpec=p_net->MPC_Net.NetType;
	tTree pNetType,pArgList,pParamList;
	tTree old_pCurParamList=pCurParamList;
	tTree old_pCurExprs=pCurExprs;
	PointerControl(pNetTypeSpec);
	pNetType=pNetTypeSpec->MPC_NetTypeSpecifier.NetType;
	PointerControl(pNetType);
	pParamList=pNetType->MPC_NetType.ParamList;
	PointerControl(pParamList);
	pCurParamList=pParamList;
	pArgList=pNetTypeSpec->MPC_NetTypeSpecifier.ArgList;
	PointerControl(pArgList);
	pCurExprs=pArgList;
	if(pParamList->Kind != kMPC_FreeNode) {
	  c_blank;
	  fprintf(file,"%s.count=",VarName(p_net));
	  print_ParamNumber(pArgList,-1);
	  fprintf(file,";\n");
	  print_CopyParams(p_net,pNetType,pArgList);
	}
	pCurParamList=old_pCurParamList;
	pCurExprs=old_pCurExprs;
      }*/
      fprintf(file,"MPC_Net_estimate(MPC_Global_rank(),&%s)",
              VarName(p_net));   
    }    
    break;    
  default:
    break;
  }
  if(flag.InParentheses)
    cur_pos+=fprintf(file,")");
  if(to_double) {
    cur_pos+=fprintf(file,"))/MPC_FIXPOINT_SCALE");
  }    
  parent_expr=old_parent_expr;
  if(braces && end_statement_is_needed) {
    fprintf(file,";\n");
    end_statement_is_needed=0;
  }
  for(i=0; i<braces; i++) {
    b_end;
  }
  cur_act_net=prev_act_net;
  root_index=old_root_index;
  expr_index=old_expr_index;
  index_depth=old_index_depth;
  not_change_net=old_change_net;
  if(prt) printf("       print_Expr end pExpr=%p\n",pExpr);
}

tTree element_type(tTree pType) {
  /* like next_type without MPC_FunctionType */
  PointerControl(pType);
  switch(pType->Kind) {
  case kMPC_ArrayType:
    return pType->MPC_ArrayType.ElementType;
  case kMPC_VectorType:
    return pType->MPC_VectorType.ElementType;
  case kMPC_PointerType:
    return pType->MPC_PointerType.ElementType;
  default:
    return NoTree;
  }
}

int index_level(tTree pType) {
  int level=0,go;
  if(prt) printf("index_level pType=%p\n",pType);
  while(pType != NoTree) {
    if(prt) printf("index_level pType=%p pType->Kind=%d\n",
           pType,pType->Kind);
    go=pType->Kind == kMPC_VectorType ||
      pType->Kind == kMPC_ArrayType;
    if( go) {
      level++;
      pType=element_type(pType);
    }
    else break;
  }
  if(prt) printf("index_level level=%d\n",level);
  return level;
}

static void printGrid(tTree pExpr, int shift){
  tTree pType;
  tTree pOpType;
  tTree pArrayType;
  tTree pArrayElemType;
  tTree pOp1;
  tTree pOp2;
  tTree pOp3;
  tTree pOp4;

  pType = pExpr->MPC_Expr.Type;
  PointerControl( pType );
  pOp1 = pExpr->MPC_QuaternaryExpr.Operand1;
  PointerControl( pOp1 );
  pOpType = pOp1->MPC_Expr.Type;
  PointerControl( pOpType );
  pArrayType = get_type_pattern( pOpType, expr_depth(pExpr)-1);
  PointerControl( pArrayType ); 
  if(pArrayType->Kind != kMPC_ArrayType) {
    if(pArrayType->Kind != kMPC_PointerType)
      internal_error();
    pArrayType = pArrayType->MPC_PointerType.GeneratedFrom;
    PointerControl(pArrayType);
    if(pArrayType->Kind != kMPC_ArrayType)
      internal_error();
  }
  pArrayElemType = pArrayType->MPC_ArrayType.ElementType;
  PointerControl( pArrayElemType );
  pOp2 = pExpr->MPC_QuaternaryExpr.Operand2;
  PointerControl( pOp2 );
  pOp3 = pExpr->MPC_QuaternaryExpr.Operand3;
  PointerControl( pOp3 );
  pOp4 = pExpr->MPC_QuaternaryExpr.Operand4;
  PointerControl( pOp4 );

  if(is_dynamic_type( pArrayType )){
    int dyn;
    dyn = is_dynamic_type(pArrayElemType);
    if(!dyn) fprintf(file,"(*");
    fprintf(file,"(");
    if(use_slots) {
      if((global_index_level-global_shift) == 1)  print_Expr(pOp1);
      else   fprintf(file,"%s%d",
		     TMP_SLOT_PREFIX,
		     pOp1->MPC_Expr.Optm_Attribute.slot);
    }
    else print_Expr(pOp1);
    fprintf(file,"+%s(",starStepMacro(pArrayType, RIGHT));
    if( pOp2->Kind != kMPC_FreeNode ){
      print_Expr( pOp2 );
      fprintf(file,"+");
    }
    fprintf(file,"%s",index_name( global_index_level-1 ));
    if( pOp4->Kind != kMPC_FreeNode ) {
      fprintf(file,"*(");
      print_Expr( pOp4 );
      fprintf(file,")");
    }
    fprintf(file,"))");
    if(!dyn) fprintf(file,")");
  }
  else{
    if(use_slots) {
      if((global_index_level-global_shift) == 1)  print_Expr(pOp1);
      else   fprintf(file,"%s%d",
		     TMP_SLOT_PREFIX,
		     pOp1->MPC_Expr.Optm_Attribute.slot);
    }
    else print_Expr(pOp1);
 
    fprintf(file,"[");
    fprintf(file,"(");
    if( pOp2->Kind != kMPC_FreeNode ){
      print_Expr( pOp2 );
      fprintf(file,"+");
    }
    fprintf(file,"%s",index_name( global_index_level-1 ));
    if( pOp4->Kind != kMPC_FreeNode ) {
      fprintf(file,"*(");
      print_Expr( pOp4 );
      fprintf(file,")");
    }
    fprintf(file,")");
    fprintf(file,"%s",starStepMacro( pArrayType, LEFT));
    fprintf(file,"]");
  }
}
  
void print_index(tTree pType, int number_not_generated, int shift) {
  int i=0;
  int step,level;
  int control;
     
  if(prt) printf("print_index pType=%p number_not_generated=%d\n",
         pType,number_not_generated);
  level=index_level(pType);
  control=level-number_not_generated;
  if(control < 0) {
    fprintf(stderr,"wrong index_level=%d, number_not_generated=%d\n",
            level,number_not_generated);
    internal_error();
  }
  if(control > 0) {
    int is_vector_or_array; 
    if(is_dynamic_type(pType)&&(!use_slots)) fprintf(file,"[");
    while(pType != NoTree) {
      tTree myType=pType; 
      if(prt) printf("pType=%p Kind=%d i=%d\n",pType,pType->Kind,i);
      switch(pType->Kind) {
      case kMPC_ArrayType:
        step=pType->MPC_ArrayType.Step;
        is_vector_or_array=1;
        pType=pType->MPC_ArrayType.ElementType;
        break;
      case kMPC_VectorType:
        step=1;
        is_vector_or_array=1;
        pType=pType->MPC_VectorType.ElementType;
        break;
      case kMPC_PointerType:
        pType=pType->MPC_PointerType.ElementType;
        is_vector_or_array=0;
        step=0;
        break;
      default:
        pType=NoTree;
        is_vector_or_array=0;
        step=0;
        break;
      }
      if(is_vector_or_array /*step != 0*/) {
        if(is_dynamic_type(myType)) {
          if(use_slots) {
            if((global_index_level-1)==(shift+i++)) {
              if(i+number_not_generated == level) {
                fprintf(file,"[");
              }
              else {
                if(IS_DYN_ARRAY_OR_VECTOR(pType))
                  fprintf(file,"+");
                else
                  fprintf(file,"[");
              }
              fprintf(file,"%s",index_name(global_index_level-1));
              //fprintf(file,"*%s%s",DataVarName(myType),SHIFT_SIZE_POSTFIX);
              fprintf(file, "%s", starStepMacro(myType, LEFT));
              if(i+number_not_generated == level) {
                fprintf(file,"]");
                break;
              }
              else {
                if(IS_DYN_ARRAY_OR_VECTOR(pType))
                  ;
                else
                  fprintf(file,"]");
              }
            }
          }
          else {
            fprintf(file,"%s",index_name(shift+i++));
            //fprintf(file,"*%s%s",DataVarName(myType),SHIFT_SIZE_POSTFIX);
            fprintf(file, "%s", starStepMacro(myType, LEFT));
            if(i+number_not_generated == level) {
              fprintf(file,"]");
              break;
            }
            else {
              if(IS_DYN_ARRAY_OR_VECTOR(pType))
                fprintf(file,"+");
              else
                fprintf(file,"]");
            }
          }
        }
        else {
          if(use_slots) {
            if((global_index_level-1)==(shift+i++)) {
              fprintf(file,"[%s",index_name(global_index_level-1));
              if(!shift && step != 1) {
                fprintf(file,"%s]", starStepMacro(myType, LEFT));
              }
              else {
                fprintf(file,"]");
              }
            }
          }
          else {
            fprintf(file,"[%s",index_name(shift+i++));
            if(!shift && step != 1) {
              fprintf(file,"%s]", starStepMacro(myType, LEFT));
            }
            else {
              fprintf(file,"]");
            }
          }
        }
      }
      if(i+number_not_generated == level) break;
    }
  }
   
}

void set_index_boundary(tTree pType) {
  if(prt) printf("set_index_boundary\n");
  while(pType != NoTree) {
    if(prt) printf("pType=%p Kind=%d\n",pType,pType->Kind);
    switch(pType->Kind) {
    case kMPC_ArrayType:
      index_boundary[boundary_num].NumberOfComponents=
        pType->MPC_ArrayType.NumberOfComponents;
      index_boundary[boundary_num].Type=pType;       
      steps[boundary_num++] =pType->MPC_ArrayType.Step;
      pType=pType->MPC_ArrayType.ElementType;
      break;
    case kMPC_VectorType:
      index_boundary[boundary_num].NumberOfComponents=
       pType->MPC_VectorType.NumberOfComponents;
      index_boundary[boundary_num].Type=pType;       
      steps[boundary_num++]=1;
      pType=pType->MPC_VectorType.ElementType;
      break;
    case kMPC_PointerType:
      pType=pType->MPC_PointerType.ElementType;
      break;
    default:
      pType=NoTree;
      break;
    }
  }
  if(prt) printf("set_index_boundary end\n");
}

int is_subnet(tTree pFirstNet, tTree pSecondNet) {
  /* returns 1 if First is subnet of Second */
  PointerControl(pFirstNet);
  PointerControl(pSecondNet);
  while(pFirstNet->Kind == kMPC_Subnet) {
    if(pFirstNet == pSecondNet ||
       pFirstNet->MPC_Subnet.Distribution == pSecondNet) return 1;
    pFirstNet=pFirstNet->MPC_Subnet.Distribution;
    PointerControl(pFirstNet);
  }
  return 0;
}

int is_parent(tTree pFirstNet, tTree pSecondNet) {
  /* returns 1 if First is direct parent of Second */
  int ret;
  PointerControl(pFirstNet);
  PointerControl(pSecondNet);
  ret=pSecondNet->Kind == kMPC_Net &&
       pSecondNet->MPC_Net.Distribution == pFirstNet;
  if(prt) printf("is_parent=%d  pFirstNet=%p pSecondNet=%p\n",
         ret,pFirstNet,pSecondNet);
  return ret;
}

int is_NetCast_asynch(tTree pNetCast) {
  int may_be;
  PointerControl(pNetCast);
  {
    tTree pNetCastNet=pNetCast->MPC_Expr.StoreNet;
    tTree pEvalNetList=pNetCast->MPC_Expr.EvalNet;
    tTree pEvalNet;
    PointerControl(pNetCastNet);
    PointerControl(pEvalNetList);
    pEvalNet=SingleRegion(pEvalNetList);
    PointerControl(pEvalNet);
    if(pNetCastNet == pEvalNet ||
       SameList(pEvalNetList,COMPUTING_SPACE_LIST) ||
       SameList(pEvalNetList,CONST_NET_LIST) ||
       SameList(pEvalNetList,SINGLE_NODE_LIST)) {
      may_be=1;
    }
    else {
      may_be=(is_parent(pNetCastNet,pEvalNet) ||
              is_subnet(pNetCastNet,pEvalNet));
    }
  }
  if(prt) printf("may_be=%d\n",may_be);
  return may_be;
}
    
int set_cur_act_net(tTree pExpr) {
  int braces;
  tTree prev_act_net=cur_act_net;
  PointerControl(pExpr);
  if(prt) printf("set_cur_act_net pExpr=%p basic_fun_call=%d\n",pExpr,basic_fun_call);
  /*if(basic_fun_call < 2)*/ fill_ActualEvalNet(pExpr);
  cur_act_net=pExpr->MPC_Expr.ActualEvalNet;
  PointerControl(cur_act_net);
  switch(basic_fun_call) {
  case 1:
    braces=check_enclosed_net(COMPUTING_SPACE_LIST,prev_act_net);
    break;
  case 0:
    if(cur_act_net != CONST_NET_LIST) {
      /*printf("cur_act_net=%p  prev_act_net=%p\n",cur_act_net,prev_act_net);*/
      braces=check_enclosed_net(cur_act_net,prev_act_net);
    }
    else {
     cur_act_net=prev_act_net;
     braces=0;
    }  
    break;
  default:
    braces=0;
  }
  return braces;
}

static tTree right_operand;
static int is_indirection;
static int is_same_array;
static tTree ident_store;

void find_indirection(tTree yyt) {
  if(yyt != NoTree && yyt->Kind == kMPC_UnaryExpr &&
     yyt->MPC_UnaryExpr.OpCode == STAR) {
    is_indirection=1;
  }
}

void find_ident(tTree yyt) {
  if(yyt != NoTree && yyt->Kind == kMPC_Ident &&
     yyt->MPC_Ident.Store == ident_store) {
    is_same_array=1;
  }
}

void find_same_array(tTree yyt) {
  if(yyt != NoTree && yyt->Kind == kMPC_Ident) {
    tTree pType=yyt->MPC_Ident.Type;
    tType p_type;
    tTree pSourceType;
    PointerControl(pType);
    if(prt) printf("find_same_array yyt=%p pType=%p\n",yyt,pType);
    p_type=pType->MPC_Type.pType;
    TypeControl(p_type);
    pSourceType=p_type->Type.Origin;
    PointerControl(pSourceType);
    if(pSourceType->Kind == kMPC_ArrayType) {
      ident_store=yyt->MPC_Ident.Store;
      PointerControl(ident_store);
      Expr_traverse(right_operand,find_ident);
    }
  }
}

int may_be_crossing(tTree pExpr) {
  int ret;
  PointerControl(pExpr);
  if(pExpr->Kind != kMPC_BinaryExpr) {
    fprintf(stderr,"it is finding crossing for not MPC_BinaryExpr\n");
    internal_error();
  }
  else {
    is_indirection=0;
    Expr_traverse(pExpr,find_indirection);
    if(!is_indirection) {
      tTree pLop=pExpr->MPC_BinaryExpr.Loperand;
      right_operand=pExpr->MPC_BinaryExpr.Roperand;
      PointerControl(pLop);
      PointerControl(right_operand);
      is_same_array=0;
      Expr_traverse(pLop,find_same_array);
    }
  }
  ret=is_indirection || is_same_array;
  if(prt) printf("may_be_crossing pExpr=%p ret=%d is_indir=%d is_same_ar=%d\n",
         pExpr,ret,is_indirection,is_same_array);
  return ret;
}


int is_basic_function_call(tTree pCallExpr) {
  tTree pFun,pType;
  PointerControl(pCallExpr);
  if(pCallExpr->Kind == kMPC_CallExpr) {
    pFun=pCallExpr->MPC_CallExpr.Function;
    PointerControl(pFun);
    pType=pFun->MPC_Expr.Type;
    PointerControl(pType);
    if(pType->Kind == kMPC_PointerType) {
      pType=pType->MPC_PointerType.ElementType;
      PointerControl(pType);
    }
    return pType->MPC_FunctionType.Kind == BASIC;
  }
  return 0;
}
  
int is_network_function_call(tTree pCallExpr) {
  tTree pFun,pType;
  PointerControl(pCallExpr);
  if(pCallExpr->Kind == kMPC_CallExpr) {
    pFun=pCallExpr->MPC_CallExpr.Function;
    PointerControl(pFun);
    pType=pFun->MPC_Expr.Type;
    PointerControl(pType);
    if(pType->Kind == kMPC_PointerType) {
      pType=pType->MPC_PointerType.ElementType;
      PointerControl(pType);
    }
    return pType->MPC_FunctionType.Kind == NETWORK;
  }
  return 0;
}
  

/*#define Call(struct,field) yyn=yyt->struct.field; if(yyn != NoTree) {  set_defer_atribute(yyn);   } else  { printf("Call yyn == NoTree\n"); }*/
#define Call(struct,field) yyn=yyt->struct.field; if(yyn != NoTree) {  set_defer_atribute(yyn); } else  { fprintf(stderr,"Call yyn == NoTree\n"); internal_error(); }
void set_pecul(tTree yyt, tTree yyn) {
  /*(yyn->Kind == kMPC_Expr) {
    yyt->MPC_Expr.Flag.Peculiarity= exprs_pecul;
    exprs_pecul=0; }
  else {
    yyt->MPC_Expr.Flag.Peculiarity=yyt->MPC_Expr.Flag.Peculiarity ||
      yyn->MPC_Expr.Flag.Peculiarity;
  }*/
}

void set_defer_atribute(tTree yyt) {
  if(yyt != NoTree) {
    tTree yyn;
    /*yyt->yyHead.yyMark = 0;*/
    if(yyt->Kind == kMPC_Exprs) {
      int old_set_to_0=set_defer_to_0;
      if(prt) printf("pExprs begin \n");
      while(yyt->Kind != kMPC_FreeNode) {
        set_defer_to_0=old_set_to_0;
        if(prt) printf("pExprs=%p pExpr=%p\n",yyt,yyt == NoTree ?
               NoTree : yyt->MPC_Exprs.Expr);
        Call(MPC_Exprs,Expr);
        yyt=yyt->MPC_Exprs.Next;
        PointerControl(yyt);
      }
      if(prt) printf("pExprs end \n");
    }
    if(Tree_IsType(yyt,kMPC_Expr)) {
      int old_defer=yyt->MPC_Expr.Flag.Defer;
      int old_expr_level=expr_level;
      int old_right_part=right_part;
      int old_was_net_cast=was_net_cast;
      tTree old_parent_expr=parent_expr;
      tExprFlags flag=yyt->MPC_Expr.Flag;
      if(prt) printf("pExpr=%p  Kind=%d expr_level=%d  must_be_lvalue=%d right_part=%d set_to_0=%d\n",
             yyt,yyt->Kind,expr_level,must_be_lvalue,right_part,set_defer_to_0);
      if(prt) printf("          Asynchr=%d Peculiarrity=%d Lvalue=%d\n",
             flag.Asynchr,flag.Peculiarity,flag.Lvalue);
      /*if(expr_level) {
        yyt->MPC_Expr.Flag.Defer=1;
      }
      expr_level+=yyt->Kind != kMPC_CastExpr &&
        yyt->Kind != kMPC_NetCastExpr;*/

      /*if(parent_expr != NoTree && parent_expr->Kind != kMPC_FreeNode) {
        tTree pStoreNet=yyt->MPC_Expr.StoreNet;
        tTree pParentStoreNet=parent_expr->MPC_Expr.StoreNet;
        if(pStoreNet != NoTree && pParentStoreNet != NoTree &&
           pStoreNet != pParentStoreNet) {
          yyt->MPC_Expr.Flag.Defer=0;
        }
      }*/
      if(expr_level++) {
        yyt->MPC_Expr.Flag.Defer=1;
      }
      if(must_be_lvalue && !flag.Lvalue) {
        yyt->MPC_Expr.Flag.Defer=0;
        must_be_lvalue=0;
      }
      if(right_part) {
        yyt->MPC_Expr.Flag.Defer=0;
        right_part=0;
      }
      if(set_defer_to_0) {
        yyt->MPC_Expr.Flag.Defer=0;
        set_defer_to_0=0;
      }
      if(was_net_cast) {
        yyt->MPC_Expr.Flag.Defer=0;
        was_net_cast=0;
      }
      parent_expr=yyt;
      switch(yyt->Kind) {
      case kMPC_IntConst:
      case kMPC_UIntConst:
      case kMPC_FloatConst:
      case kMPC_StringLiteral:
      case kMPC_Ident:
        yyt->MPC_Expr.Flag.Defer=1;
        break;
      case kMPC_CastExpr:
        Call(MPC_CastExpr,Operand);
        set_pecul(yyt,yyn);
        break;
      case kMPC_NetCastExpr:
        was_net_cast=1;
        Call(MPC_NetCastExpr,Operand);
        set_pecul(yyt,yyn);
        /*was_net_cast=1;*/
        break;
      case kMPC_CoordExpr:
        Call(MPC_CoordExpr,Operand);
        set_pecul(yyt,yyn);
        break;
      case kMPC_Size_Of_Value:
        Call(MPC_Size_Of_Value,Operand);
        set_pecul(yyt,yyn);
        break;
      case kMPC_UnaryExpr:
        if(yyt->MPC_UnaryExpr.OpCode > LINEAR /*DISTRIBUTED*/) {
          yyt->MPC_Expr.Flag.Defer=0;
          if(yyt->MPC_UnaryExpr.OpCode > DISTRIBUTED) must_be_lvalue=1;
        }
        if(yyt->MPC_UnaryExpr.OpCode == BRACKETS) {
          set_defer_to_0=yyt->MPC_Expr.Flag.Defer == 0;
          yyt->MPC_Expr.Flag.Defer=1;
          /*must_be_lvalue=0;*/
          peculiar=1;
        }
        if(yyt->MPC_UnaryExpr.OpCode == STAR) {
          set_defer_to_0=yyt->MPC_Expr.Flag.Defer == 0;
          yyt->MPC_Expr.Flag.Defer=1;
        }
        Call(MPC_UnaryExpr,Operand);
        set_pecul(yyt,yyn);
        break;
      case kMPC_BinaryExpr:
        if(yyt->MPC_BinaryExpr.OpCode >= ASSIGN &&
           yyt->MPC_BinaryExpr.OpCode <= INCL_OR_ASSIGN) {
          yyt->MPC_Expr.Flag.Defer=0;
          must_be_lvalue=!flag.Asynchr;
          if(prt) printf("   Assign Loperand yyt=%p \n",yyt);
          Call(MPC_BinaryExpr,Loperand);
          set_pecul(yyt,yyn);
          if(prt) printf("   Assign Roperand yyt=%p \n",yyt);
          must_be_lvalue=!flag.Asynchr;
          right_part=flag.Peculiarity && may_be_crossing(yyt);
          Call(MPC_BinaryExpr,Roperand);
          set_pecul(yyt,yyn);
        }
        else if(yyt->MPC_BinaryExpr.OpCode == INDEX) {
          /*PointerControl(old_parent_expr);*/
          if(old_parent_expr != NoTree &&
             old_parent_expr->Kind == kMPC_UnaryExpr &&
             old_parent_expr->MPC_UnaryExpr.OpCode == BRACKETS) {
            yyt->MPC_Expr.Flag.Defer=1;
          }
          if(prt) printf("   INDEX Loperand yyt=%p \n",yyt);
          Call(MPC_BinaryExpr,Loperand);
          set_pecul(yyt,yyn);
          /*mpc_index=1;*/
          if(prt) printf("   INDEX Roperand yyt=%p\n",yyt);
          Call(MPC_BinaryExpr,Roperand);
          set_pecul(yyt,yyn);
        }
        else {
          tTree Lop=yyt->MPC_BinaryExpr.Loperand;
          tTree Rop=yyt->MPC_BinaryExpr.Roperand;
          PointerControl(Lop);
          PointerControl(Rop);
          if(prt) printf("   Loperand yyt=%p \n",yyt);
          if((Lop->MPC_Expr.StoreNet != Rop->MPC_Expr.StoreNet) &&
              Lop->MPC_Expr.Flag.SideEffects) was_net_cast=1;
          Call(MPC_BinaryExpr,Loperand);
          set_pecul(yyt,yyn);
          if(prt) printf("   Roperand yyt=%p\n",yyt);
          if((Lop->MPC_Expr.StoreNet != Rop->MPC_Expr.StoreNet) &&
              Rop->MPC_Expr.Flag.SideEffects) was_net_cast=1;
          Call(MPC_BinaryExpr,Roperand);
          set_pecul(yyt,yyn);
        }          
        break;
      case kMPC_TernaryExpr:
        Call(MPC_TernaryExpr,Foperand);
        set_pecul(yyt,yyn);
        Call(MPC_TernaryExpr,Soperand);
        set_pecul(yyt,yyn);
        Call(MPC_TernaryExpr,Toperand);
        set_pecul(yyt,yyn);
        break;
      case kMPC_CallExpr:
        /*yyt->MPC_Expr.Flag.Defer=0;*/
        /*expr_level=0;*/
        {
          int is_basic_fun;
          is_basic_fun=is_basic_function_call(yyt);
          if(is_basic_fun) set_defer_to_0=1;
          Call(MPC_CallExpr,Function);
          set_pecul(yyt,yyn);
          if(is_basic_fun) set_defer_to_0=1;
          Call(MPC_CallExpr,ArgList);
          set_pecul(yyt,yyn);
          if(is_basic_fun) set_defer_to_0=1;
          if(yyt->MPC_CallExpr.NetworkArgList != NoTree) {
            Call(MPC_CallExpr,NetworkArgList);
            set_pecul(yyt,yyn);
          }
          {
            tTree pType=yyt->MPC_Expr.Type;
            PointerControl(pType);
            if(prt) printf("old_parent_expr=%p old_parent_expr->Kind=%d old_expr_level=%d",
                           old_parent_expr,
                           old_parent_expr == NoTree ? 0 :
                           old_parent_expr->Kind,
                           old_expr_level);
            if((pType->Kind == kMPC_BasicType &&
                pType->MPC_BasicType.TypeConstructor == VOID) ||
               (old_expr_level == 1 &&
                (old_parent_expr != NoTree &&
                 (old_parent_expr->Kind == kMPC_CastExpr /*||
                  old_parent_expr->Kind == kMPC_NetCastExpr*/)))) {
              yyt->MPC_Expr.Flag.Defer=1;
            }
            if(was_net_cast &&
               (is_basic_function_call(yyt) ||
                is_basic_function_call(yyt))) {
              yyt->MPC_Expr.Flag.Defer=0;
            }
              
            if(prt) printf(" Defer=%d\n",yyt->MPC_Expr.Flag.Defer);
          }
          if(prt) printf("end of the CallExpr\n");
        }
        break;
      default:
        break;
      }
      if(yyt->MPC_Expr.Flag.Defer != old_defer) {
        if(prt) printf("      pExpr=%p  Kind=%d old_defer=%d new_defer=%d OpCode=%d\n",
                       yyt,yyt->Kind,old_defer,yyt->MPC_Expr.Flag.Defer,
                       yyt->Kind == kMPC_BinaryExpr ? yyt->MPC_BinaryExpr.OpCode : 0);
        /*        internal_error();*/
      }
      expr_level=old_expr_level;
      parent_expr=old_parent_expr;
      right_part=old_right_part;
      was_net_cast=old_was_net_cast;
    }
  }
  else {
    expr_level=0;
    must_be_lvalue=0;
    parent_expr=NoTree;  
  }
}


int is_built_in_fun(tTree pExpr) {
  int ret=0,i;
  tTree pFun;
  PointerControl(pExpr);
  pFun=pExpr->MPC_CallExpr.Function;
  PointerControl(pFun);
  if(prt) printf("in  is_built_in_fun pFun=%p\n",pFun);
  if(pFun->Kind == kMPC_Ident) {
    tIdent Ident=pFun->MPC_Ident.Ident;
    IdentControl(Ident);
    GetString(Ident,NameBuf);
    if(prt) printf("in  is_built_in_fun fun_name=%s\n",NameBuf);
    for(i=0; i<BUILT_IN_FUN_NUM; i++) {
      if(!strcmp(NameBuf,built_in_source[i])) break;
    }
    if(i != BUILT_IN_FUN_NUM) ret=i+1;
  }
  if(prt) printf("in  is_built_in_fun ret=%d\n",ret);
  return ret;
}

static void print_call(tTree pExpr) {
  tTree pFun,pArg,pNetArgs,pNet,pFunType;
  int pos;
  int old_net_param_list=net_param_list;
  int old_built_in_fun=built_in_fun;
  PointerControl(pExpr);
  pFun=pExpr->MPC_CallExpr.Function;
  PointerControl(pFun);
  pArg=pExpr->MPC_CallExpr.ArgList;
  pNetArgs=pExpr->MPC_CallExpr.NetworkArgList;
  pNet=pExpr->MPC_CallExpr.StoreNet;
  pFunType=pFun->MPC_Expr.Type;
  PointerControl(pFunType);
  if(pFunType->Kind == kMPC_PointerType) {
    pFunType=pFunType->MPC_PointerType.ElementType;
    PointerControl(pFunType);
  }
  if(pFunType->Kind != kMPC_FunctionType) {
    fprintf(stderr,"pFunType isn't MPC_FunctionType\n");
    internal_error();
  }
  net_param_list=0;
  if(prt) printf("in print_call pExpr=%p pFun=%p\n",pExpr,pFun);
  built_in_fun=is_built_in_fun(pExpr);
  if(prt) printf("built_in_fun=%d\n",built_in_fun);
  if(built_in_fun) {
    cur_pos+=fprintf(file,"%s",built_in_dest[built_in_fun-1]);
  }
  else {
    print_Expr(pFun);
  }
  cur_pos+=fputs("(",file);
  pos=cur_pos;
  if(pFunType->MPC_FunctionType.Kind == NETWORK) {
    tTree pNetParam=pFunType->MPC_FunctionType.NetParam;
    tTree pNetParamType=pFunType->MPC_FunctionType.NetParamType;
    tTree pNetworkParamList=pFunType->MPC_FunctionType.NetworkParamList;
    PointerControl(pNetParam);
    if(pNetParamType != NoTree) {
      PointerControl(pNet);
      cur_pos+=fprintf(file,"&%s",VarName(pNet));
      if(!built_in_fun) {
        if(pNetParamType->Kind != kMPC_NetTypeSpecifier) {
          fprintf(stderr,"pNetParamType isn't NetTypeSpecifier\n");
          internal_error();
        }
        if(pNetArgs != NoTree &&
           pNetArgs->Kind != kMPC_FreeNode) {
          if(!(pNetworkParamList != NoTree &&
               pNetworkParamList->Kind != kMPC_FreeNode)) {
            fprintf(stderr,"incorrect network part of the call expression\n");
            internal_error();
          }
          cur_pos+=fprintf(file,",\n");
          blank(pos);
          net_param_list=1;
          while(pNetArgs->Kind != kMPC_FreeNode) {
            tTree pType;
            tTree pNext;
            tTree pNetArg=pNetArgs->MPC_Exprs.Expr;
            int var_len;
            PointerControl(pNetArg);
            while(!ordinar_var(pNetworkParamList)) {
              pNetworkParamList=pNetworkParamList->MPC_Var.Next;
              PointerControl(pNetworkParamList);
            }
            pType=pNetArg->MPC_Expr.Type;
            PointerControl(pType);
            var_len=variable_len_array(pType);
            if(var_len) {
              cur_pos+=fputs("(int*)(",file);
            }
            print_Expr(pNetArg);
            if(var_len) {
              cur_pos+=fputs(")",file);
            }
            pNext=pNetArgs->MPC_Exprs.Next;
            if(pNext->Kind != kMPC_FreeNode) {
              cur_pos+=fputs(",",file);
            }
            pNetArgs=pNext;
          }
          net_param_list=0;
        }
      }
      if(pArg != NoTree && pArg->Kind != kMPC_FreeNode) {
        cur_pos+=fprintf(file,",\n");
        blank(pos);
      }
    }
  }
  if(pArg != NoTree) print_Exprs(pArg);
  if(built_in_fun && with_type[built_in_fun-1]) {
    tTree pType;
    cur_pos+=fprintf(file,",\n");
    blank(pos);
    pType=buffer_type(pArg);
    PointerControl(pType);
    fprintf(file,"(%s)(&%s)",
          DATATYPE,DataVarName(pType));
  }
  cur_pos+=fputs(")",file);
  net_param_list=old_net_param_list;
  built_in_fun=old_built_in_fun;
}

int variable_len_array(tTree pType) {
  int ret=-1,count=0;
  PointerControl(pType);
  while((pType->Kind == kMPC_ArrayType)||(pType->Kind == kMPC_PointerType)) {
    count++;
    /*
    if((pType->MPC_ArrayType.NumberOfComponents == UNDEFINED ||
       pType->MPC_ArrayType.NumberOfComponents == 0) &&
        pType->MPC_ArrayType.ArraySize != NoTree) */
    if(is_dynamic_type(pType)){
      ret=1;
    }
    pType=pType->MPC_ArrayType.ElementType;
    PointerControl(pType);
  }
  if(prt) printf("variable_len_array ret=%d count=%d\n",ret,count);
  return ret*count;
}

static tTree go_to_ident_through_indexes(tTree pExpr) {
  PointerControl(pExpr);
  while(pExpr->Kind == kMPC_BinaryExpr &&
     pExpr->MPC_BinaryExpr.OpCode == INDEX) 
    {
    pExpr=pExpr->MPC_BinaryExpr.Loperand;
    PointerControl(pExpr);
    }
 
  return pExpr/*pExpr->Kind == kMPC_Ident ? pExpr : NoTree*/;
}

static int var_array_depth(tTree pExpr) {
  tTree pId;
  int ret=0;
  PointerControl(pExpr);
  pId=go_to_ident_through_indexes(pExpr);
  if(prt) printf(" result is pId=%p\n",pId);
  if(pId != NoTree) {
    tTree pType=pId->MPC_Expr.Type;
    PointerControl(pType);
    ret=variable_len_array(pType);
  }
  if(prt) printf("var_array_depth pExpr=%p ret=%d\n",pExpr,ret);
  return ret;
}

static int set_change_net(tTree pExpr) {
  int ret=0;
  PointerControl(pExpr);
  if(pExpr->Kind == kMPC_BinaryExpr) {
    int code=pExpr->MPC_BinaryExpr.OpCode;
    if(code != ASSIGN &&
       (code == INDEX ||
        (code >= MULT && code <= INCL_OR_ASSIGN))) ret=1;
  }
  return ret;
}

int calc_pointer_level(tTree yyt, int pointer_level) {
  tTree pChild=NoTree;
  PointerControl(yyt);
  switch(yyt->Kind) {
  case kMPC_Typedef:
    pChild=yyt->MPC_Typedef.Type;
    break;
  case kMPC_PointerType:
    pChild=yyt->MPC_PointerType.ElementType;
    pointer_level++;
    break;
  case kMPC_ArrayType:
    pChild=yyt->MPC_ArrayType.ElementType;
    pointer_level++;
    break;
  case kMPC_VectorType:
    pChild=yyt->MPC_VectorType.ElementType;
    pointer_level++;
    break;
  default:
    break;
  }
  return pChild == NoTree ? pointer_level :
    calc_pointer_level(pChild,pointer_level);
}

static void print_Type_in_cast(tTree yyt) {
  tTree old_pCurDeclSpec=pCurDeclSpec;
  tTypeFlags flag;
  PointerControl(yyt);
  flag=yyt->MPC_Type.Flag;
  if(!flag.DynArray) {
    pCurDeclSpec=NoTree;
    cur_pos+=fprintf(file,"(");
    print_Type_in_sizeof(yyt);
    cur_pos+=fprintf(file,")");
    pCurDeclSpec=old_pCurDeclSpec;
  }
  else {
    int pointer_level=0;
    pointer_level=calc_pointer_level(yyt,pointer_level);
    if(pointer_level != 0) {
      cur_pos+=fprintf(file,"(void ");
      while(pointer_level > 0) {
        cur_pos+=fprintf(file,"*");
        pointer_level--;
      }
      cur_pos+=fprintf(file,")");
    }   
    else {
      fprintf(stderr,"not array type has DynArray flag\n");
      internal_error();
    }     
  }
}
