/*
 * $Id: Communication.c,v 3.1 1999/11/05 14:13:42 posypkin Exp ka $
 */


/* code generation for communications */
/* Coded by A.Kalinov 11.95 -  */

#include "be_print.h"

static int pos;

void print_NodeCoord(tTree pOne, tTree pMany);
tTree parent_of_both(tTree ,tTree );
tTree GetNetType(tTree );
void print_Assign_TrueOneToOne(tTree pExpr);
void print_Assign_QuazyOneToOne(tTree pExpr);

void print_Expr_without_indexes(tTree pExpr) {
  int old_not_index=not_index;
  int old_not_check=not_check;
  not_index=1;
  not_check=1;
  print_Expr(pExpr);
  not_check=old_not_check;
  not_index=old_not_index;
}

void print_Assign_OneToOne(tTree pExpr) {
  if(one_to_one_kind == 0) {
    print_Assign_TrueOneToOne(pExpr);
  }
  else {
    print_Assign_QuazyOneToOne(pExpr);
  }
}

void print_Assign_TrueOneToOne(tTree pExpr) {
  tTree pLop,pRop;
  tTree pLopStore,pRopStore;
  int old_not_check=not_check;
  if(prt) printf("print_Assign_OneToOne pExpr=%p Kind=%d\n",
                 pExpr,pExpr->Kind);
  PointerControl(pExpr);
  pLop=pExpr->MPC_BinaryExpr.Loperand;
  PointerControl(pLop);
  pRop=pExpr->MPC_BinaryExpr.Roperand;
  PointerControl(pRop);
  pLopStore=pLop->MPC_Expr.StoreNet;
  PointerControl(pLopStore);
  pRopStore=pRop->MPC_Expr.StoreNet;
  PointerControl(pRopStore);
  if(pLopStore == pRopStore) {
    asynchr_mode=1;
    c_blank;
    print_Assign(pExpr);
    asynchr_mode=0;
    fprintf(file,";\n");
  }
  else {
    int recv_braces=0,send_braces=0,ext_braces=0;
    int i;
    int coord_max,pos;
    tTree pNetType,pParentNet,pParentList;
    int l_is_parent=0,r_is_parent=0;
    tTree pLType,pRType;
    pRType=pRop->MPC_Expr.Type;
    PointerControl(pRType);
    pLType=pLop->MPC_Expr.Type;
    PointerControl(pLType);
    if(one_to_one_kind == GATHER) {
      if(pLType->Kind == kMPC_ArrayType) {
        pLType=pLType->MPC_ArrayType.ElementType;
        PointerControl(pLType);
      }
      if(pLType->Kind == kMPC_VectorType) {
        pLType=pLType->MPC_VectorType.ElementType;
        PointerControl(pLType);
      }
    }
    else if(one_to_one_kind == SCATTER ) {
      if(pRType->Kind == kMPC_ArrayType) {
        pRType=pRType->MPC_ArrayType.ElementType;
        PointerControl(pRType);
      }
      if(pRType->Kind == kMPC_VectorType) {
        pRType=pRType->MPC_VectorType.ElementType;
        PointerControl(pRType);
      }
    }
    if(!(equal_type(pRType,pLType))) {
      if(prt) printf("one_to_one_kind=%d\n",one_to_one_kind);
      be_error("wrong operand's type of the assignment (one->one)");
    }
    is_argument=1;
    pParentNet=parent_of_both(pLopStore,pRopStore);
    if(pParentNet == NoTree) {
      fprintf(stderr,
              "enclosed region of the two region wasn't found (one->one)\n");
      internal_error();
    }
    if(is_parent(pRopStore,pParentNet)) {
      r_is_parent=1;
    }
    if(is_parent(pLopStore,pParentNet)) {
      l_is_parent=1;
    }
    pNetType=GetNetType(pParentNet);
    PointerControl(pNetType);
    coord_max=coord_number(pNetType);
    pParentList=pParentNet->MPC_NetOrSubnet.MyList;
    PointerControl(pParentList);
    ext_braces=check_enclosed_net(pParentList,cur_act_net);
    not_check=1;
    /* Sender block */
    if(!r_is_parent) {
      send_braces=print_PredicateAndChangeNet(pRopStore,pParentNet);
    }
    else {
      c_blank;
      cur_pos+=fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pParentNet));
      cur_blank+=SKIP;
      send_braces=1;
    }
    if(!l_is_parent) {
      c_blank;
      fprintf(file,"int MPC_ind;\n");
      c_blank;
      print_NodeCoord(pLopStore,pLopStore);
      /* MPC_co[i]=*/
      c_blank;
      fprintf(file,"MPC_ind=MPC_Number(&%s,%s);\n",
              VarName(pParentNet),NODE_COORD);
    }
    c_blank;
    pos=cur_blank+fprintf(file,"MPC_Send_copy_conv(");
    fprintf(file,"&%s,",VarName(pParentNet));
    print_Address(pRop,one_to_one_kind == SCATTER);
    if(pRop->Kind == kMPC_NetCastExpr) {
      tTree pCastOperand=pRop->MPC_NetCastExpr.Operand;
      PointerControl(pCastOperand);
      print_Expr_without_indexes(pCastOperand);
    }
    else {
      print_Expr_without_indexes(pRop);
    }
    if(one_to_one_kind == SCATTER) {
      fprintf(file,"[MPC_send]");
    }
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(");
    if(!l_is_parent) {
      fprintf(file,"MPC_Node_rank(&%s)==\n",
            VarName(pParentNet));
      blank(pos);
      fprintf(file,"MPC_ind)?");
    }
    else {
      fprintf(file,"%s(&%s))?\n",PARENT,VarName(pParentNet));
      blank(pos);
    }
    print_Address(pLop,0);
    if(pLop->Kind == kMPC_NetCastExpr) {
      tTree pCastOperand=pLop->MPC_NetCastExpr.Operand;
      PointerControl(pCastOperand);
      print_Expr_without_indexes(pCastOperand);
    }
    else {
      print_Expr_without_indexes(pLop);
    }
    fprintf(file,":NULL,\n");
    blank(pos);
    fprintf(file,"(%s)(&%s),\n",
            DATATYPE,DataVarName(pRType));
    blank(pos);
    if(!l_is_parent) {
      fprintf(file,"(%s)(&%s),MPC_ind);\n",
              DATATYPE,DataVarName(pLType));
    }
    else {
      fprintf(file,"(%s)(&%s),\n",
              DATATYPE,DataVarName(pLType));
      blank(pos);
      fprintf(file,"MPC_Parent(&%s));\n",VarName(pParentNet));
    }
    for(i=0; i<send_braces; i++) {
      b_end;
    }
    send_braces=0;
    /* Receiver block */
    if(!l_is_parent) {
      recv_braces=print_PredicateAndChangeNet(pLopStore,pParentNet);
    }
    else {
      c_blank;
      cur_pos+=fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pParentNet));
      cur_blank+=SKIP;
      recv_braces=1;
    }
    if(!r_is_parent) {
      c_blank;
      fprintf(file,"int MPC_ind;\n");
      c_blank;
      print_NodeCoord(pRopStore,pRopStore);
        /* MPC_co[i]=*/
      c_blank;
      fprintf(file,"MPC_ind=MPC_Number(&%s,%s);\n",
              VarName(pParentNet),NODE_COORD);
    }
    c_blank;
    pos=cur_blank+fprintf(file,"MPC_Recv_copy(");
    fprintf(file,"&%s,",VarName(pParentNet));
    print_Address(pLop,one_to_one_kind == GATHER);
    if(pLop->Kind == kMPC_NetCastExpr) {
      tTree pCastOperand=pLop->MPC_NetCastExpr.Operand;
      PointerControl(pCastOperand);
      print_Expr_without_indexes(pCastOperand);
    }
    else {
      print_Expr_without_indexes(pLop);
    }
    if(one_to_one_kind == GATHER) {
      fprintf(file,"[MPC_recv]");
    }
    fprintf(file,",\n");
    blank(pos);
    if(!r_is_parent) {
      fprintf(file,"(%s)(&%s),MPC_ind);\n",
              DATATYPE,DataVarName(pLType));
    }
    else {
      fprintf(file,"(%s)(&%s),\n",
              DATATYPE,DataVarName(pLType));
      blank(pos);
      fprintf(file,"MPC_Parent(&%s));\n",VarName(pParentNet));
    }
    for(i=0; i<recv_braces; i++) {
      b_end;
    }
    for(i=0; i<ext_braces; i++) {
      b_end;
    }
    end_statement_is_needed=0;
    is_argument=0;
  }
  not_check=old_not_check;
  if(prt) printf("end print_Assign_OneToOne pExpr=%p\n",pExpr);
}

void print_Assign_QuazyOneToOne(tTree pExpr) {
  tTree pLop,pRop;
  tTree pLopStore,pRopStore;
  int old_not_check=not_check;
  if(prt) printf("print_Assign_OneToOne pExpr=%p Kind=%d\n",
                 pExpr,pExpr->Kind);
  PointerControl(pExpr);
  pLop=pExpr->MPC_BinaryExpr.Loperand;
  PointerControl(pLop);
  pRop=pExpr->MPC_BinaryExpr.Roperand;
  PointerControl(pRop);
  pLopStore=pLop->MPC_Expr.StoreNet;
  PointerControl(pLopStore);
  pRopStore=pRop->MPC_Expr.StoreNet;
  PointerControl(pRopStore);
  if(pLopStore == pRopStore) {
    asynchr_mode=1;
    c_blank;
    print_Assign(pExpr);
    asynchr_mode=0;
    fprintf(file,";\n");
  }
  else {
    int recv_braces=0,send_braces=0,ext_braces=0;
    int i;
    int coord_max,pos;
    tTree pNetType,pParentNet,pParentList;
    int l_is_parent=0,r_is_parent=0;
    tTree pLType,pRType;
    pRType=pRop->MPC_Expr.Type;
    PointerControl(pRType);
    pLType=pLop->MPC_Expr.Type;
    PointerControl(pLType);
    if(one_to_one_kind == GATHER) {
      if(pLType->Kind == kMPC_ArrayType) {
        pLType=pLType->MPC_ArrayType.ElementType;
        PointerControl(pLType);
      }
      if(pLType->Kind == kMPC_VectorType) {
        pLType=pLType->MPC_VectorType.ElementType;
        PointerControl(pLType);
      }
    }
    else if(one_to_one_kind == SCATTER ) {
      if(pRType->Kind == kMPC_ArrayType) {
        pRType=pRType->MPC_ArrayType.ElementType;
        PointerControl(pRType);
      }
      if(pRType->Kind == kMPC_VectorType) {
        pRType=pRType->MPC_VectorType.ElementType;
        PointerControl(pRType);
      }
    }
    if(!(equal_type(pRType,pLType))) {
      if(prt) printf("one_to_one_kind=%d\n",one_to_one_kind);
      be_error("wrong operand's type of the assignment (one->one)");
      /*}
    if(!((equal_type(pRType,pLType) &&
         (!one_to_one_kind || one_to_one_kind == BCAST)) || 
          ((pLType->Kind == kMPC_ArrayType && 
            equal_type(pLType->MPC_ArrayType.ElementType,pRType) &&
            one_to_one_kind == GATHER)) ||
          ((pRType->Kind == kMPC_ArrayType && 
            equal_type(pRType->MPC_ArrayType.ElementType,pLType) &&
            one_to_one_kind == SCATTER)))) {
      if(prt) printf("one_to_one_kind=%d\n",one_to_one_kind);
      be_error("wrong operand's type of the assignment (one->one)");*/
    }
    is_argument=1;
    pParentNet=parent_of_both(pLopStore,pRopStore);
    if(pParentNet == NoTree) {
      fprintf(stderr,
              "enclosed region of the two region wasn't found (one->one)\n");
      internal_error();
    }
    if(is_parent(pRopStore,pParentNet)) {
      r_is_parent=1;
    }
    if(is_parent(pLopStore,pParentNet)) {
      l_is_parent=1;
    }
    pNetType=GetNetType(pParentNet);
    PointerControl(pNetType);
    coord_max=coord_number(pNetType);
    /*pType=pRop->MPC_Expr.Type;
    PointerControl(pType);*/
    /*if(one_to_one_kind == GATHER) pType=pRType;
    else pType=pLType;*/
    pParentList=pParentNet->MPC_NetOrSubnet.MyList;
    PointerControl(pParentList);
    ext_braces=check_enclosed_net(pParentList,cur_act_net);
    not_check=1;
    /* Sender block */
    if(!r_is_parent) {
      send_braces=print_PredicateAndChangeNet(pRopStore,pParentNet);
    }
    else {
      c_blank;
      cur_pos+=fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pParentNet));
      cur_blank+=SKIP;
      send_braces=1;
    }
    if(!l_is_parent) {
      c_blank;
      if(macro) {
        fprintf(file,"MPC_OneToOne_assign_sender_prologue(%s);\n",
                VarName(pParentNet));
      }
      else {
        fprintf(file,
                "int MPC_ind=0,MPC_co[%d],MPC_send=0;\n",
                coord_max);
        c_blank;
        fprintf(file,"int* MPC_old_coord=%s.coord;\n",VarName(pParentNet));
        c_blank;
        fprintf(file,"for(MPC_ind=0; MPC_ind<%s.power; MPC_ind++) {\n",
                VarName(pParentNet));
        cur_blank+=SKIP;
        c_blank;
        fprintf(file,"%s.coord=MPC_co;\n",VarName(pParentNet));
        c_blank;
        fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",
                VarName(pParentNet));
      }
      recv_braces=print_PredicateAndChangeNet(pLopStore,pParentNet);
      c_blank;
      fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pParentNet));
    }
    c_blank;
    pos=cur_blank+fprintf(file,"MPC_Send_copy_conv(");
    fprintf(file,"&%s,",VarName(pParentNet));
    print_Address(pRop,one_to_one_kind == SCATTER);
    if(pRop->Kind == kMPC_NetCastExpr) {
      tTree pCastOperand=pRop->MPC_NetCastExpr.Operand;
      PointerControl(pCastOperand);
      print_Expr_without_indexes(pCastOperand);
    }
    else {
      print_Expr_without_indexes(pRop);
    }
    if(one_to_one_kind == SCATTER) {
      fprintf(file,"[MPC_send]");
    }
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(");
    if(!l_is_parent) {
      fprintf(file,"MPC_Node_rank(&%s)==\n",
            VarName(pParentNet));
      blank(pos);
      fprintf(file,"MPC_ind)?");
    }
    else {
      fprintf(file,"%s(&%s))?\n",PARENT,VarName(pParentNet));
      blank(pos);
    }
    print_Address(pLop,0);
    if(pLop->Kind == kMPC_NetCastExpr) {
      tTree pCastOperand=pLop->MPC_NetCastExpr.Operand;
      PointerControl(pCastOperand);
      print_Expr_without_indexes(pCastOperand);
    }
    else {
      print_Expr_without_indexes(pLop);
    }
    fprintf(file,":NULL,\n");
    blank(pos);
    if(!l_is_parent) {
      fprintf(file,"(%s)(&%s),\n",
              DATATYPE,DataVarName(pRType));
      blank(pos);
      fprintf(file,"(%s)(&%s),MPC_ind);\n",
              DATATYPE,DataVarName(pLType));
      c_blank;
      fprintf(file,"MPC_send++;\n");
      for(i=0; i<recv_braces; i++) {
        b_end;
      }
    }
    else {
      fprintf(file,"(%s)(&%s),\n",
              DATATYPE,DataVarName(pRType));
      blank(pos);
      fprintf(file,"(%s)(&%s),\n",
              DATATYPE,DataVarName(pLType));
      blank(pos);
      fprintf(file,"MPC_Parent(&%s));\n",VarName(pParentNet));
    }
    if(!l_is_parent) {
      if(macro) {
        c_blank;
        fprintf(file,"MPC_OneToOne_assign_sender_epilogue(%s)\n",
                VarName(pParentNet));
      }
      else {
        b_end;
        c_blank;
        cur_pos+=fprintf(file,"if(!MPC_send) {\n");
        cur_blank+=SKIP;
        c_blank;
        cur_pos+=fputs("MPC_Error_raise(\"Correspond receiver not found\");\n",
                       file);
        b_end;
        c_blank;
        fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pParentNet));
      }
    }
    for(i=0; i<send_braces; i++) {
      b_end;
    }
    send_braces=0;
    /* Receiver block */
    if(!l_is_parent) {
      recv_braces=print_PredicateAndChangeNet(pLopStore,pParentNet);
    }
    else {
      c_blank;
      cur_pos+=fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pParentNet));
      cur_blank+=SKIP;
      recv_braces=1;
    }
    if(!r_is_parent) {
      c_blank;
      if(macro) {
        fprintf(file,"MPC_OneToOne_assign_receiver_prologue(%s);\n",
                VarName(pParentNet));
      }
      else {
        fprintf(file,
                "int MPC_ind=0,MPC_co[%d],MPC_recv=0;\n",
                coord_max);
        c_blank;
        fprintf(file,"int* MPC_old_coord=%s.coord;\n",VarName(pParentNet));
        c_blank;
        fprintf(file,"for(MPC_ind=0; MPC_ind<%s.power; MPC_ind++) {\n",
                VarName(pParentNet));
        cur_blank+=SKIP;
        c_blank;
        fprintf(file,"%s.coord=MPC_co;\n",VarName(pParentNet));
        c_blank;
        fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",
                VarName(pParentNet));
      }
      send_braces=print_PredicateAndChangeNet(pRopStore,pParentNet);
      c_blank;
      fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pParentNet));
    }
    c_blank;
    pos=cur_blank+fprintf(file,"MPC_Recv_copy(");
    fprintf(file,"&%s,",VarName(pParentNet));
    print_Address(pLop,one_to_one_kind == GATHER);
    if(pLop->Kind == kMPC_NetCastExpr) {
      tTree pCastOperand=pLop->MPC_NetCastExpr.Operand;
      PointerControl(pCastOperand);
      print_Expr_without_indexes(pCastOperand);
    }
    else {
      print_Expr_without_indexes(pLop);
    }
    if(one_to_one_kind == GATHER) {
      fprintf(file,"[MPC_recv]");
    }
    fprintf(file,",\n");
    blank(pos);
    if(!r_is_parent) {
      fprintf(file,"(%s)(&%s),MPC_ind);\n",
              DATATYPE,DataVarName(pLType));
      c_blank;
      fprintf(file,"MPC_recv++;\n");
      for(i=0; i<send_braces; i++) {
        b_end;
      }
    }
    else {
      fprintf(file,"(%s)(&%s),\n",
              DATATYPE,DataVarName(pLType));
      blank(pos);
      fprintf(file,"MPC_Parent(&%s));\n",VarName(pParentNet));
    }
    if(!r_is_parent) {
      if(macro) {
        c_blank;
        fprintf(file,"MPC_OneToOne_assign_receiver_epilogue(%s)\n",
                VarName(pParentNet));
      }
      else {
        b_end;
        c_blank;
        cur_pos+=fprintf(file,"if(!MPC_recv) {\n");
        cur_blank+=SKIP;
        c_blank;
        cur_pos+=fputs("MPC_Error_raise(\"Correspond sender not found\");\n",
                       file);
        b_end;
        c_blank;
        fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pParentNet));
      }
    }
    for(i=0; i<recv_braces; i++) {
      b_end;
    }
    for(i=0; i<ext_braces; i++) {
      b_end;
    }
    end_statement_is_needed=0;
    is_argument=0;
  }
  not_check=old_not_check;
  if(prt) printf("end print_Assign_OneToOne pExpr=%p\n",pExpr);
}


void print_Assign_ManyToOne(tTree pExpr) {
  tTree pLop,pRop;
  tTree pRopStore;
  tExprFlags flag;
  tTree pNet,pNetList;
  int one_is_parent;
  tTree pLType,pRType;
  int send_braces,i,ext_braces=0;
  int old_not_check=not_check;
  is_argument=1;
  PointerControl(pExpr);
  if(prt) printf("print_Assign_ManyToOne\n");
  pLop=pExpr->MPC_BinaryExpr.Loperand;
  PointerControl(pLop);
  pRop=pExpr->MPC_BinaryExpr.Roperand;
  PointerControl(pRop);
  flag=pExpr->MPC_BinaryExpr.Flag;
  pRopStore=pRop->MPC_Expr.StoreNet;
  PointerControl(pRopStore);
  c_blank;
  pNet=pLop->MPC_Expr.StoreNet;
  PointerControl(pNet);
  one_is_parent=is_first_parent_of_second(pNet,pRopStore);
  if(prt) printf("one_is_parent=%d\n",one_is_parent);
  pRType=pRop->MPC_Expr.Type;
  PointerControl(pRType);
  pLType=pLop->MPC_Expr.Type;
  PointerControl(pLType);
  if(!((pLType->Kind == kMPC_ArrayType && 
        equal_type(pLType->MPC_ArrayType.ElementType,pRType)) ||
       (pLType->Kind == kMPC_VectorType && 
        equal_type(pLType->MPC_VectorType.ElementType,pRType)))) {
    be_error("wrong operand's type of the assignment many->one");
  }
  pNetList=pRopStore->MPC_NetOrSubnet.MyList;
  PointerControl(pNetList);
  ext_braces=check_enclosed_net(pNetList,cur_act_net);
  not_check=1;
  if(one_is_parent) {
    fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pRopStore));
    cur_blank+=SKIP;
    send_braces=1;
  }
  else {
    print_NodeCoord(pNet,pRopStore);
    send_braces=print_PredicateAndChangeNet(pNet,pRopStore);
  }
  c_blank;
  pos=cur_pos+fprintf(file,"MPC_Recv_gather_conv(");
  fprintf(file,"&%s,",
          VarName(pRopStore));
  print_Address(pRop,one_to_one_kind);
  print_Expr_without_indexes(pRop);
  fprintf(file,",");
  print_Address(pLop,one_to_one_kind);
  {
    print_Expr_without_indexes(pLop);
  }
  fprintf(file,",\n");
  blank(pos);
  fprintf(file,"(%s)(&%s),\n",
          DATATYPE,DataVarName(pRType));
  blank(pos);
  fprintf(file,"(%s)(&%s));\n",
          DATATYPE,DataVarName(pLType));
  for(i=0; i<send_braces; i++) {
    b_end;
  }
  c_blank;
  fprintf(file,"else {\n");
  cur_blank+=SKIP;
  c_blank;
  pos=cur_pos+fprintf(file,"MPC_Send_gather(");
  fprintf(file,"&%s,",
          VarName(pRopStore));
  print_Address(pRop,one_to_one_kind);
  print_Expr_without_indexes(pRop);
  fprintf(file,",\n");
  blank(pos);
  fprintf(file,"(%s)(&%s),\n",
          DATATYPE,DataVarName(pRType));
  blank(pos);
  if(one_is_parent) {
    fprintf(file,"MPC_Parent(&%s));\n",VarName(pRopStore));
  }
  else {
    fprintf(file,"MPC_Number(&%s,%s));\n",
            VarName(pRopStore),NODE_COORD);
  }
  b_end;
  if(prt) printf("one_is_parent=%d\n",one_is_parent);
  /*if(one_is_parent == 0) {
    b_end;
  }*/
  for(i=0; i<ext_braces; i++) {
    b_end;
  }
  end_statement_is_needed=0;
  is_argument=0;
  not_check=old_not_check;
  if(prt) printf("print_Assign_ManyToOne end\n");
}

void print_Assign_OneToMany(tTree pExpr) {
  tTree pLop,pRop;
  tTree pLopStore;
  tTree pLType,pRType;
  tExprFlags flag;
  int one_is_parent;
  tTree pNet,pNetList;
  int send_braces,i,ext_braces=0;
  int old_not_check=not_check;
  is_argument=1;
  PointerControl(pExpr);
  if(prt) printf("print_Assign_OneToMany \n");
  pLop=pExpr->MPC_BinaryExpr.Loperand;
  PointerControl(pLop);
  pRop=pExpr->MPC_BinaryExpr.Roperand;
  PointerControl(pRop);
  flag=pExpr->MPC_BinaryExpr.Flag;
  pLopStore=pLop->MPC_Expr.StoreNet;
  PointerControl(pLopStore);
  pRType=pRop->MPC_Expr.Type;
  PointerControl(pRType);
  pLType=pLop->MPC_Expr.Type;
  PointerControl(pLType);
  if(!((pRType->Kind == kMPC_ArrayType && 
        equal_type(pRType->MPC_ArrayType.ElementType,pLType)) ||
       (pRType->Kind == kMPC_VectorType && 
        equal_type(pRType->MPC_VectorType.ElementType,pLType)) ||
       equal_type(pRType,pLType))) {
    printf("pRType->Kind=%d pLType->Kind=%d\n",
           pRType->Kind,pLType->Kind);
    be_error("wrong operand's type of the assignment one->many");
  }
  pNet=pRop->MPC_Expr.StoreNet;
  PointerControl(pNet);
  one_is_parent=is_first_parent_of_second(pNet,pLopStore);
  if(prt) printf("one_is_parent=%d\n",one_is_parent);
  pNetList=pLopStore->MPC_NetOrSubnet.MyList;
  PointerControl(pNetList);
  ext_braces=check_enclosed_net(pNetList,cur_act_net);
  not_check=1;
  if((pRType->Kind == kMPC_ArrayType && 
      pRType->MPC_ArrayType.ElementType == pLType) ||
     (pRType->Kind == kMPC_VectorType && 
      pRType->MPC_VectorType.ElementType == pLType)) {
    if(one_is_parent) {
      c_blank;
      fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pLopStore));
      cur_blank+=SKIP;
      send_braces=1;
    }
    else {
      send_braces=print_PredicateAndChangeNet(pNet,pLopStore);
    }
    /*print_MemberAndPredicate(pNet);*/
    c_blank;
    pos=cur_pos+fprintf(file,"MPC_Send_scatter_conv(");
    fprintf(file,"&%s,",
            VarName(pLopStore));
    print_Address(pRop,one_to_one_kind);
    print_Expr_without_indexes(pRop);
    fprintf(file,",");
    print_Address(pLop,one_to_one_kind);
    print_Expr_without_indexes(pLop);
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(%s)(&%s),\n",
            DATATYPE,DataVarName(pRType));
    blank(pos);
    fprintf(file,"(%s)(&%s));\n",
            DATATYPE,DataVarName(pLType));
    for(i=0; i<send_braces; i++) {
      b_end;
    }
    /*b_end;*/
    c_blank;
    fprintf(file,"else {\n");
    cur_blank+=SKIP;
    if(!one_is_parent) {
      c_blank;
      print_NodeCoord(pNet,pLopStore);
    }
    c_blank;
    pos=cur_pos+fprintf(file,"MPC_Recv_scatter(");
    fprintf(file,"&%s,",
            VarName(pLopStore));
    print_Address(pLop,one_to_one_kind);
    print_Expr_without_indexes(pLop);
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(%s)(&%s),\n",
            DATATYPE,DataVarName(pLType));
    blank(pos);
    if(one_is_parent) {
      fprintf(file,"MPC_Parent(&%s));\n",VarName(pLopStore));
    }
    else {
      fprintf(file,"MPC_Number(&%s,%s));\n",
              VarName(pLopStore),NODE_COORD);
    }
    b_end;
    end_statement_is_needed=0;
  }
  else {
    tTree pNet=pRop->MPC_Expr.StoreNet;
    PointerControl(pNet);
    if(one_is_parent) {
      c_blank;
      fprintf(file,"if(%s(&%s)) {\n",PARENT,VarName(pLopStore));
      cur_blank+=SKIP;
      send_braces=1;
    }
    else {
      send_braces=print_PredicateAndChangeNet(pNet,pLopStore);
    }
    /*print_MemberAndPredicate(pNet);*/
    c_blank;
    pos=cur_pos+fprintf(file,"MPC_Send_all_conv(");
    fprintf(file,"&%s,",
            VarName(pLopStore));
    print_Address(pRop,one_to_one_kind);
    print_Expr_without_indexes(pRop);
    {
      fprintf(file,",");
      print_Address(pLop,one_to_one_kind);
      print_Expr_without_indexes(pLop);
    }
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(%s)(&%s),\n",
            DATATYPE,DataVarName(pRType));
    blank(pos);
    fprintf(file,"(%s)(&%s));\n",
            DATATYPE,DataVarName(pLType));
    for(i=0; i<send_braces; i++) {
      b_end;
    }
    /*c_blank;
    b_end;*/
    c_blank;
    fprintf(file,"else {\n");
    cur_blank+=SKIP;
    if(!one_is_parent) {
      c_blank;
      print_NodeCoord(pNet,pLopStore);
    }
    c_blank;
    pos=cur_pos+fprintf(file,"MPC_Recv_all(");
    fprintf(file,"&%s,",
            VarName(pLopStore));
    print_Address(pLop,one_to_one_kind);
    print_Expr_without_indexes(pLop);
    fprintf(file,",\n");
    blank(pos);
    fprintf(file,"(%s)(&%s),\n",
            DATATYPE,DataVarName(pLType));
    blank(pos);
    if(one_is_parent) {
      fprintf(file,"MPC_Parent(&%s));\n",VarName(pLopStore));
    }
    else {
      fprintf(file,"MPC_Number(&%s,%s));\n",
              VarName(pLopStore),NODE_COORD);
      /*b_end;*/
    }
    b_end;
    end_statement_is_needed=0;
  }
  for(i=0; i<ext_braces; i++) {
    b_end;
  }
  not_check=old_not_check;
  is_argument=0;
}

int print_Assign_ManyToMany(tTree pExpr) {
  int coord_num=0,coord_max,pos;
  tTree old_cur_act_net=cur_act_net;
  tTree pLType,pRType;
  tTree pLop,pRop;
  tTree pLopStore,pRopStore;
  tTree pEvalNet,pNetType,pParentNet,pType,pParentList;
  int recv_braces=0,send_braces=0,braces=0,ext_braces=0;
  int i;
  int old_not_check=not_check;
  PointerControl(pExpr);
  if(prt) printf("print_Assign_ManyToMany \n");
  pLop=pExpr->MPC_BinaryExpr.Loperand;
  PointerControl(pLop);
  pRop=pExpr->MPC_BinaryExpr.Roperand;
  PointerControl(pRop);
  pRType=pRop->MPC_Expr.Type;
  PointerControl(pRType);
  pLType=pLop->MPC_Expr.Type;
  PointerControl(pLType);
  if(!equal_type(pRType,pLType)) {
    be_error("wrong operand's type of the assignment many->many");
  }
  pLopStore=pLop->MPC_Expr.StoreNet;
  PointerControl(pLopStore);
  pRopStore=pRop->MPC_Expr.StoreNet;
  PointerControl(pRopStore);
  if(pLopStore == pRopStore) {
    if(prt) printf("nothihg was generated in print_Assign_ManyToMany Gen=%d\n",
           pExpr->MPC_Expr.Flag.Generated);
    return 0;
  }
  if(pLopStore->Kind != kMPC_Subnet || pRopStore->Kind != kMPC_Subnet) {
    fprintf(stderr,"Invalid store nets of the assign ManyToMany \n");
    internal_error();
  }
  is_argument=1;
  pParentNet=parent_of_both(pLopStore,pRopStore);
  if(pParentNet == NoTree) {
    fprintf(stderr,
            "enclosed region of the two region wasn't found (many->many)\n");
    internal_error();
  }
  pEvalNet=pParentNet;
  pNetType=pParentNet->MPC_Net.NetType;
  PointerControl(pNetType);
  coord_max=coord_number(pNetType);
  pType=pRop->MPC_Expr.Type;
  PointerControl(pType);
  pParentList=pParentNet->MPC_NetOrSubnet.MyList;
  PointerControl(pParentList);
  ext_braces=check_enclosed_net(pParentList,cur_act_net);
  not_check=1;
/* Sender block */
  send_braces=print_PredicateAndChangeNet(pRopStore,pParentNet);
  c_blank;
  if(!macro) {
    fprintf(file,
            "int MPC_ind=0, MPC_co[%d];\n",
            coord_max);
    c_blank;
    fprintf(file,
            "int MPC_own_send_num=0, MPC_recv_num=0;\n");
    c_blank;
    fprintf(file,"int MPC_recv_index;\n");
    c_blank;
    fprintf(file,"int* MPC_old_coord=%s.coord;\n",VarName(pEvalNet));
    c_blank;
    fprintf(file,"%s.coord=MPC_co;\n",VarName(pEvalNet));
    c_blank;
    fprintf(file,"for(; MPC_ind<%s.power; MPC_ind++) {\n",
            VarName(pEvalNet));
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",
            VarName(pEvalNet));
  }
  else {
    fprintf(file,"MPC_ManyToMany_assign_sender_prologue(%s);\n",
            VarName(pEvalNet));
  }
  braces=print_PredicateAndChangeNet(pRopStore,pParentNet);
  c_blank;
  fputs("MPC_own_send_num++;\n",file);
  for(i=0; i<braces; i++) {
    b_end;
  }
  c_blank;
  pos=cur_blank+fputs("if(",file);
  for(coord_num=0; coord_num<coord_max; coord_num++) {
    if(coord_num != 0) {
      fprintf(file," && \n");
      blank(pos);
    }
    fprintf(file,"MPC_co[%d]==MPC_old_coord[%d]",coord_num,coord_num);
  }
  fprintf(file,") break;\n");
  if(!macro) {
    b_end;
    c_blank;
    fprintf(file,"for(MPC_ind=0; MPC_ind<%s.power; MPC_ind++) {\n",
            VarName(pEvalNet));
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",
            VarName(pEvalNet));
  }
  else {
    c_blank;
    fprintf(file,"MPC_ManyToMany_assign_middle_part(%s);\n",
            VarName(pEvalNet));
  }
  braces=print_PredicateAndChangeNet(pLopStore,pParentNet);
  c_blank;
  fputs("MPC_recv_num++;\n",file);
  for(i=0; i<braces; i++) {
    b_end;
  }
  c_blank;
  if(!macro) {
    cur_pos+=fputs("if(MPC_recv_num==MPC_own_send_num) break;\n",file);
    b_end;
    c_blank;
    cur_pos+=fputs("if(MPC_recv_num < MPC_own_send_num) {\n",file);
    cur_blank+=SKIP;
    c_blank;
    cur_pos+=fputs("MPC_Error_raise(\"Correspond receiver not found\");\n",
                   file);
    b_end;
    c_blank;
    cur_pos+=fputs("MPC_recv_index=MPC_ind;\n",file);
    c_blank;
    fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pEvalNet));
  }
  else {
    fprintf(file,"MPC_ManyToMany_assign_sender_epilogue(%s);\n",
            VarName(pEvalNet));
  }
  c_blank;
  pos=cur_blank+fprintf(file,"MPC_Send_copy_conv(");
  fprintf(file,"&%s,",VarName(pEvalNet));
  print_Address(pRop,one_to_one_kind);
  if(pRop->Kind == kMPC_NetCastExpr) {
    tTree pCastOperand=pRop->MPC_NetCastExpr.Operand;
    PointerControl(pCastOperand);
    print_Expr_without_indexes(pCastOperand);
  }
  else {
    print_Expr_without_indexes(pRop);
  }
  fprintf(file,",\n");
  blank(pos);
  fprintf(file,"(MPC_Number(&%s,%s.coord)==\n",
          VarName(pParentNet),VarName(pParentNet));
  blank(pos+1);
  fprintf(file,"MPC_recv_index)?");
  print_Address(pLop,one_to_one_kind);
  if(pLop->Kind == kMPC_NetCastExpr) {
    tTree pCastOperand=pLop->MPC_NetCastExpr.Operand;
    PointerControl(pCastOperand);
    print_Expr_without_indexes(pCastOperand);
  }
  else {
    print_Expr_without_indexes(pLop);
  }
  fprintf(file,":NULL,\n");
  blank(pos);
  fprintf(file,"(%s)(&%s),\n",
          DATATYPE,DataVarName(pRType));
  blank(pos);
  fprintf(file,"(%s)(&%s),MPC_recv_index);\n",
          DATATYPE,DataVarName(pLType));
  for(i=0; i<send_braces; i++) {
    b_end;
  }
  /* Receiver block */
  recv_braces=print_PredicateAndChangeNet(pLopStore,pParentNet);
  c_blank;
  if(!macro) {
    fprintf(file,
            "int MPC_ind=0, MPC_co[%d];\n",
            coord_max);
    c_blank;
    fprintf(file,
            "int MPC_own_recv_num=0, MPC_send_num=0;\n");
    c_blank;
    fprintf(file,"int MPC_send_index;\n");
    c_blank;
    fprintf(file,"int* MPC_old_coord=%s.coord;\n",VarName(pEvalNet));
    c_blank;
    fprintf(file,"%s.coord=MPC_co;\n",VarName(pEvalNet));
    c_blank;
    fprintf(file,"for(; MPC_ind<%s.power; MPC_ind++) {\n",
            VarName(pEvalNet));
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",
            VarName(pEvalNet));
  }
  else {
    fprintf(file,"MPC_ManyToMany_assign_receiver_prologue(%s);\n",
            VarName(pEvalNet));
  }
  braces=print_PredicateAndChangeNet(pLopStore,pParentNet);
  c_blank;
  fputs("MPC_own_recv_num++;\n",file);
  for(i=0; i<braces; i++) {
    b_end;
  }
  c_blank;
  pos=cur_blank+fputs("if(",file);
  for(coord_num=0; coord_num<coord_max; coord_num++) {
    if(coord_num != 0) {
      fprintf(file," && \n");
      blank(pos);
    }
    fprintf(file,"MPC_co[%d]==MPC_old_coord[%d]",coord_num,coord_num);
  }
  fprintf(file,") break;\n");
  if(!macro) {
    b_end;
    c_blank;
    fprintf(file,"for(MPC_ind=0; MPC_ind<%s.power; MPC_ind++) {\n",
            VarName(pEvalNet));
    cur_blank+=SKIP;
    c_blank;
    fprintf(file,"MPC_Coord_set(&%s,MPC_ind);\n",
            VarName(pEvalNet));
  }
  else {
    c_blank;
    fprintf(file,"MPC_ManyToMany_assign_middle_part(%s);\n",
            VarName(pEvalNet));
  }
  braces=print_PredicateAndChangeNet(pRopStore,pParentNet);
  c_blank;
  fputs("MPC_send_num++;\n",file);
  for(i=0; i<braces; i++) {
    b_end;
  }
  c_blank;
  if(!macro) {
    cur_pos+=fputs("if(MPC_send_num==MPC_own_recv_num) break;\n",file);
    b_end;
    c_blank;
    cur_pos+=fputs("if(MPC_send_num < MPC_own_recv_num) {\n",file);
    cur_blank+=SKIP;
    c_blank;
    cur_pos+=fputs("MPC_Error_raise(\"Correspond sender not found\");\n",file);
    b_end;
    c_blank;
    cur_pos+=fputs("MPC_send_index=MPC_ind;\n",file);
    c_blank;
    fprintf(file,"%s.coord=MPC_old_coord;\n",VarName(pEvalNet));
  }
  else {
    fprintf(file,"MPC_ManyToMany_assign_receiver_epilogue(%s);\n",
            VarName(pEvalNet));
  }
  c_blank;
  pos=cur_blank+fprintf(file,"MPC_Recv_copy(");
  fprintf(file,"&%s,",VarName(pEvalNet));
  print_Address(pLop,one_to_one_kind);
  if(pLop->Kind == kMPC_NetCastExpr) {
    tTree pCastOperand=pLop->MPC_NetCastExpr.Operand;
    PointerControl(pCastOperand);
    print_Expr_without_indexes(pCastOperand);
  }
  else {
    print_Expr_without_indexes(pLop);
  }
  cur_act_net=old_cur_act_net;
  fprintf(file,",\n");
  blank(pos);
  fprintf(file,"(%s)(&%s),MPC_send_index);\n",
          DATATYPE,DataVarName(pType));
  for(i=0; i<recv_braces; i++) {
    b_end;
  }
  for(i=0; i<ext_braces; i++) {
    b_end;
  }
  end_statement_is_needed=0;
  not_check=old_not_check;
  is_argument=0;
  return 1;
}

void print_Address(tTree pExpr, int brackets) {
  /*fputs("&",file);*/
  tTree pType;
  int TypeKind;
  PointerControl(pExpr);
  pType=pExpr->MPC_Expr.Type;
  PointerControl(pType);
  while(pType != NoTree && pType->Kind != kMPC_FreeNode) {
    TypeKind=pType->Kind;
    if(TypeKind == kMPC_BasicType ||
       TypeKind == kMPC_EnumType ||
       TypeKind == kMPC_StructType ||
       TypeKind == kMPC_UnionType || brackets) {
      fputs("&",file);
      break;
    }
    else if(TypeKind == kMPC_Typedef) {
      pType=pType->MPC_Typedef.Type;
    }
    else {
      break;
    }
  }
}

void calculate_coord_var(tTree pExpr,int coord_num) {
  tTree old_parent_expr=parent_expr;
  tTree pTmpType;
  char* tmp;
  char* tmp_name=tmp_coord_expr_left->MPC_Expr.TmpName;
  PointerControl(pExpr);
  if(prt) printf("calculate_coord_var pExpr=%p coord_num=%d tmp_coord_expr->Kind=%d\n",
         pExpr,coord_num,tmp_coord_expr->Kind);
  tmp_coord_expr->MPC_BinaryExpr.StoreNet=pExpr->MPC_Expr.StoreNet;
  tmp_coord_expr->MPC_BinaryExpr.EvalNet=pExpr->MPC_Expr.EvalNet;
  tmp_coord_expr->MPC_BinaryExpr.ActualEvalNet=pExpr->MPC_Expr.ActualEvalNet;
  tmp_coord_expr->MPC_BinaryExpr.Roperand=pExpr;
  tmp_coord_expr->MPC_BinaryExpr.Type=pExpr->MPC_Expr.Type;
  tmp_coord_expr->MPC_BinaryExpr.Flag=pExpr->MPC_Expr.Flag;
  tmp_coord_expr->MPC_BinaryExpr.Flag.InParentheses=0;
  if(prt) printf("TmpName=%s strlen(TmpName)=%d\n",
                 tmp_name,strlen(tmp_name));
  tmp=calloc(256,sizeof(char));
  sprintf(tmp,"%s[%d]",NODE_COORD,coord_num);
  if(prt) printf("tmp=%s\n",tmp);
  tmp_coord_expr_left->MPC_Expr.TmpName=tmp;
  pTmpType=tmp_var_type(pExpr);
  PointerControl(pTmpType);
  tmp_coord_expr_left->MPC_Expr.Type=pTmpType;
  if(prt) printf("TmpName=\"%s\"\n",tmp_coord_expr_left->MPC_Expr.TmpName);
  end_statement_is_needed=1;
  pred_print_Expr_begin(tmp_coord_expr);
  parent_expr=tmp_coord_expr;
  print_Expr(tmp_coord_expr);
  if(prt) printf("end_statement_is_needed=%d end_is_needed(pExpr)=%d\n",
         end_statement_is_needed,end_is_needed(tmp_coord_expr));
  if(end_statement_is_needed || end_is_needed(tmp_coord_expr))
    fputs(";\n",file);
  end_statement_is_needed=1;
  pred_print_Expr_end(tmp_coord_expr);
  tmp_coord_expr_left->MPC_Expr.Flag.Generated=1;
  free(tmp);
  parent_expr=old_parent_expr;
}

static void print_coord_predicate(tTree pPredicate) {
  tTree pExpr,pCoord;
  int coord_num;
  PointerControl(pPredicate);
  if(pPredicate->Kind == kMPC_BinaryExpr &&
     pPredicate->MPC_BinaryExpr.OpCode == EQUAL) {
    pExpr=pPredicate->MPC_BinaryExpr.Roperand;
    PointerControl(pExpr);
    pCoord=pPredicate->MPC_BinaryExpr.Loperand;
    PointerControl(pCoord);
    coord_num=pCoord->MPC_CoordExpr.CoordNumber;
    calculate_coord_var(pExpr,coord_num);
  }
  else if(pPredicate->Kind == kMPC_BinaryExpr &&
          pPredicate->MPC_BinaryExpr.OpCode == LOG_AND) {
    tTree pOper=pPredicate->MPC_BinaryExpr.Loperand;
    PointerControl(pOper);
    print_coord_predicate(pOper);
    pOper=pPredicate->MPC_BinaryExpr.Roperand;
    PointerControl(pOper);
    print_coord_predicate(pOper);
  }
  else {
    /*fprintf(stderr,"wrong operand in node predicate\n");
    internal_error();*/
  }
}

void print_NodeCoord(tTree pOne, tTree pMany) {
  int num_of_coord;
  tTree pNetType,pParent;
  tTree pSubnet;
  tTree pPredicate;
  PointerControl(pOne);
  pSubnet=pOne;
  pParent=net_parent(pOne);
  PointerControl(pParent);
  PrintNet(pParent, "parent");
  pNetType=pParent->MPC_Net.NetType;
  PointerControl(pNetType);
  if(pNetType->Kind == kMPC_NetTypeSpecifier) {
    pNetType=pNetType->MPC_NetTypeSpecifier.NetType;
    PointerControl(pNetType);
  }
  num_of_coord=coord_number(pNetType);
  /*c_blank;*/
  fprintf(file,"int %s[%d];\n",NODE_COORD,num_of_coord);
  while(pSubnet->Kind == kMPC_Subnet) {
    pPredicate=pSubnet->MPC_Subnet.Predicate;
    PointerControl(pPredicate);
    if(prt) printf("pPredicate->Kind=%d Opcode=%d\n",
                   pPredicate->Kind,
                   pPredicate->Kind == kMPC_BinaryExpr ?
                   pPredicate->MPC_BinaryExpr.OpCode : 0);
    print_coord_predicate(pPredicate);
    pSubnet=pSubnet->MPC_Subnet.Distribution;
    PointerControl(pSubnet);
  }
}

int compatible_array(tTree pFirst,tTree pSecond) {
  int ret=0;
  tTree pEl1,pEl2;
  PointerControl(pFirst);
  PointerControl(pSecond);
  if(pFirst->Kind == kMPC_ArrayType ||
     pFirst->Kind == kMPC_VectorType) {
    if(pFirst->Kind == kMPC_ArrayType) {
      pEl1=pFirst->MPC_ArrayType.ElementType;
    }
    else {
      pEl1=pFirst->MPC_VectorType.ElementType;
    }
    if(pSecond->Kind == kMPC_ArrayType ||
       pSecond->Kind == kMPC_VectorType) {
      if(pSecond->Kind == kMPC_ArrayType) {
        pEl2=pSecond->MPC_ArrayType.ElementType;
      }
      else {
        pEl2=pSecond->MPC_VectorType.ElementType;
      }
      if(pEl1->MPC_Type.pType == pEl2->MPC_Type.pType) ret=1;
      else {
        if((pEl1->Kind == kMPC_ArrayType || pEl1->Kind == kMPC_VectorType) &&
           (pEl2->Kind == kMPC_ArrayType || pEl2->Kind == kMPC_VectorType)) {
          ret=compatible_array(pEl1,pEl2);
        }
      }
    }
  }
  return ret;
}
                     
int equal_type(tTree pFirst,tTree pSecond) {
  tType pF,pS;
  PointerControl(pFirst);
  PointerControl(pSecond);
  pF=pFirst->MPC_Type.pType;
  TypeControl(pF);
  pS=pSecond->MPC_Type.pType;
  TypeControl(pS);
  return pF == pS || compatible_array(pFirst,pSecond);
}
  
tTree parent_of_both(tTree pOne,tTree pSecond) {
  tTree ret=NoTree;
  tTree p1=pOne,p2=pSecond;
  tTree pNetParentp1=NoTree,pNetParentp2;
  PointerControl(pOne);
  PointerControl(pSecond);
  if(prt) {
    printf("parent_of_both begin %s",VarName(pOne));
    printf(" and %s\n",VarName(pSecond));
  }
  if(pOne->Kind == kMPC_Net && pSecond->Kind == kMPC_Net) {
    fprintf(stderr,"can't find enclosed region to two networks\n");
    internal_error();
  }
  if(pOne == pSecond) {
    fprintf(stderr,
            "I'm enforced to find enclosed region of the same regions\n");
    internal_error();
  }
  if(p2->Kind == kMPC_Subnet) pNetParentp2=net_parent(p2);
  else pNetParentp2=p2;
  PointerControl(pNetParentp2);
  if(is_parent(p1,pNetParentp2)) ret=pNetParentp2;
  else {
    if(p1->Kind == kMPC_Subnet) pNetParentp1=net_parent(p1);
    else pNetParentp1=p1;
    PointerControl(pNetParentp1);
    if(is_parent(p2,pNetParentp1)) ret=pNetParentp1;
    else {
      /* p1 and p1 aren't net and aren't the same */
      while(p1->Kind == kMPC_Subnet) {
        /*if(prt) printf("parent_of_both p1=%s\n",VarName(p1));*/
        p2=pSecond;
        while(p2->Kind == kMPC_Subnet) {
          /*if(prt) printf("parent_of_both p2=%s\n",VarName(p2));*/
          if(p1 == p2) {
            ret=p1;
            break;
          }
          p2=p2->MPC_Subnet.Distribution;
          PointerControl(p2);
        }
        if(ret != NoTree) break;
        p1=p1->MPC_Subnet.Distribution;
        PointerControl(p1);
      }
    }
  }
  if(ret == NoTree && pNetParentp2 == pNetParentp1) ret=pNetParentp1;
  ret=first_not_flexible(ret);
  if(prt) {
    printf("parent_of_both %s",VarName(pOne));
    printf(" and %s",VarName(pSecond));
    printf(" is %s\n",ret == NoTree ? "NULL" : VarName(ret));
  }
  return ret;
}

int print_PredicateAndChangeNet(tTree pNet, tTree pNetToChange) {
  int ret;
  PointerControl(pNet);
  PointerControl(pNetToChange);
  net_to_change=pNetToChange;
  ret=print_Predicate(pNet,1);
  net_to_change=NoTree;
  return ret;
}

tTree GetNetType(tTree pNet) {
  PointerControl(pNet);
  while(pNet->Kind == kMPC_Subnet) {
    pNet=pNet->MPC_Subnet.Distribution;
    PointerControl(pNet);
  }
  return pNet->MPC_Net.NetType;
}
    
