/*
 * $Id: BEprint.c,v 3.1 1999/11/05 14:13:42 posypkin Exp $
 */


#include "be_print.h"


/* NAMES:    cpyName
   PURPOSE:  Creates character string equal to Name
   SYNOPSYS: pName 
   RETURNS:  Pointer to the created string
*/

  char* cpyName(char* pName) {
  char* c=malloc(strlen(pName)+1);
  return strcpy(c,pName);
}
  
/* NAMES:    open_file
   PURPOSE:  Openes file with file_name for writing
   SYNOPSYS: file_name
             file
   RETURNS:  file: pointer to the opened file
   NOTE:     If output=="stdout" file is not opened and 
	     file set equal to the stdout 
*/

void open_file(char* file_name, FILE** c_file) {
  if(prt) printf(" File %s is been opened\n",file_name);
  if(strcmp(output,"stdout")==0) {
    *c_file=stdout;
    return;
  }
  *c_file=fopen(file_name,"w");
  if(*c_file==NULL) {
    fprintf(stderr,"Sorry, I Cannot open file %s \n",file_name);
    exit(1);
  }
  if(prt) printf(" File %s has opened\n",file_name);
}
  
/* NAMES:    open_c_file
   PURPOSE:  Openes output file
   SYNOPSYS: name
             c_f
   RETURNS:  c_f: pointer to the opened file
*/

void open_c_file(char* f_name, FILE** c_f) {
  size_t size;
  char* name=f_name+1;
  char* c_filename;
  char slash='/';
  while(1) {
    char* i_name;
    i_name=strchr(name,(int)slash);
    if(i_name == NULL) break;
    else {
      name=i_name+1;
      if(prt) printf("name=%s slash=%c\n",name,slash);
    }
  }
  if(prt) printf("output file name %s\n",name);
  c_filename=malloc(strlen(name)+40);

  #ifdef __CB_COMPILER__
  size=strlen(name)-strlen(".cb")-1;
  #else
  size=strlen(name)-strlen(".mpc")-1;
  #endif
  
  memcpy(c_filename,name,size);
  if(pass_number == 1) { 
    if(not_host) {
      strcpy(c_filename+size,"_host.c");
    }
    else {
      strcpy(c_filename+size,".c");
    }
  }
  else {
    strcpy(c_filename+size,"_node.c");
  }
  open_file(c_filename,c_f);
  file_names[pass_number-1]=c_filename;
  /*free(c_filename);*/
}

/* NAMES:    blank
   PURPOSE:  Type n space into file
   SYNOPSYS: file
             n
   RETURNS:  void
*/

void blank(int n) {
  int i;
  for(i=0; i<n; i++)
    fprintf(file," ");
  cur_pos=n;
}

void delete_c_file() {
  if(strcmp(output,"stdout")) {
    int i;
    for(i=0; i<pass_number; i++) {
      remove(file_names[i]);
    }
  }
}
    
/* NAMES:    internal_error
   PURPOSE:  Writes into stderr message about internal error
   SYNOPSYS: void
   RETURNS:  void
*/ 

void internal_error() {
  fprintf(stderr,"---------- mpC compiler internal error ----------\n");
  fprintf(stderr,"  source: %s line: %d\n",
          SourceFile(Position),RealPosition(Position).Line);
  fprintf(stderr,"  It is case to contact with mpC compiler group  \n");
  /*  fprintf(stderr,"-- phone              , fax             --\n");*/
  fprintf(stderr,"               e-mail mpc@ispras.ru              \n");
  fprintf(stderr,"-------------------------------------------------\n");
  delete_c_file();
  exit(1);
}
  
void be_error(char* mes) {
  fprintf(stderr,"error in %s: %d,%d -> %s\n",
          SourceFile(Position),RealPosition(Position).Line,
          RealPosition(Position).Column,mes);
  delete_c_file();
  exit(1);
}

    
/* NAMES:    befilename
   PURPOSE:  Defines name of the file with intermediate form
   SYNOPSYS: void
   RETURNS:  pointer to the file with intermediate form
*/

char* befilename() {
  char* n1;
  char* name;
  char* n2=DEFAULT_FILE_NAME;
  if(strncmp(eargv[1],"-",1) != 0) {
    name=malloc(strlen(eargv[1]));
    strcpy(name,eargv[1]);
    n1=strstr(name,".");
    *n1='\0';
    return name;
  }
  if((n1=getenv("MPC"))!=NULL) 
    return n1;
  name= malloc(strlen(n2)+1);
  strcpy(name,n2);
  return name;
}

int dummy_file() {
  int ret=0;
  if(pass_number > 1 && (host_stat || host_expr)) ret=1;
  return ret;
}
