
/*************************************************************************
*                                                                       *
*                 Heterogeneous Data Partitioning Interface             *
*                 =========================================             *
*                                                                       *
*  Copyright (c) 2002          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /************************************************/
   /* Partitioning interfaces for sets             */
   /*                                              */
   /* Revision history                             */
   /* 19-05-2003  --      Initial version          */
   /************************************************/

   #ifndef __HMPI_PARTITIONING_SETS_HH
   #define __HMPI_PARTITIONING_SETS_HH

   #define   USER_SPECIFIED   1
   #define   SYSTEM_DEFINED   2

   typedef double (*User_defined_metric)( 
           int p, 
	   const double *speeds,
           const int *actual, 
	   const int *ideal
   );

   int HMPI_Partition_unordered_set (
           int p, 
           int pn, 
           const double *speeds, 
           const int *psizes, 
           const int *mlimits, 
           int n,  
           const int *w, 
           int type_of_metric, 
           User_defined_metric umf, 
           double *metric, 
           int *np
   );

   int HMPI_Partition_ordered_set (
           int p, 
           int pn, 
           const double *speeds, 
           const int *psizes, 
           const int *mlimits, 
           int n,  
           const int *w, 
           int processor_reordering, 
           int type_of_metric, 
           User_defined_metric umf, 
           double *metric, 
           int *np
   );

   int HMPI_Partition_set(
           int p,
	   int pn,
	   const double *speeds,
	   const int *psizes,
	   const int *mlimits,
	   int n,
	   const int *w,
	   int ordering,
           int processor_ordering,
	   int type_of_metric,
	   User_defined_metric umf,
	   double *metric,
	   int *np
   );

   int HMPI_Get_set_processor(
           int i,
           int n,
           int p,
           int processor_ordering,
           const int *np
   );

   int HMPI_Get_my_partition(
           int i,
           int p,
           const int *speeds,
           int n
   );

   #endif  /* __HMPI_PARTITIONING_SETS_HH */

