/*************************************************************************
*                                                                       *
*                 Heterogeneous Data Partitioning Interface             *
*                 =========================================             *
*                                                                       *
*  Copyright (c) 2002          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /************************************************/
   /* partitioning internal interfaces             */
   /* Revision history                             */
   /* 19-05-2003  --      Initial version          */
   /************************************************/

   #ifndef __HMPI_PARTITIONING_INTERNAL_HH
   #define __HMPI_PARTITIONING_INTERNAL_HH

   int __HMPI_Homogeneous_distribution_with_mlimits
   (
       int p,
       int n,
       const int* mlimits,
       int *np
   );

   int __HMPI_Homogeneous_distribution_with_mlimits_and_weights_ordered_sets
   (
       int p,
       int n,
       const int* mlimits,
       const int* w,
       int *np
   );

   int __HMPI_Partition_set_homogeneous
   (
       int p,
       const int *mlimits,
       int n,
       const int *w,
       int ordering,
       int processor_ordering,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Speeds_are_single_numbers_with_mlimits
   (
       int p,
       const double *speeds,
       const int *bounds,
       int n,
       int *np
   );

   int __HMPI_Number_of_elements_proportional_to_speed
   (
       int p,
       int n,
       const double *speeds,
       int *allocations
   );

   double __HMPI_System_defined_metric
   (
       int p,
       const double *speeds,
       const int *actual,
       const int *ideal
   );

   int __HMPI_Size_of_bins
   (
       int p,
       int n,
       const double *speeds,
       const int *w,
       int *wallocations,
       int *tsum
   );

   int __HMPI_Sum_of_weights_for_ordered_set
   (
       int p,
       int n,
       const double *speeds,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Apply_mlimits_to_ordered_sum_of_weights
   (
       int p,
       int n,
       const double *speeds,
       const int *mlimits,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Sum_of_weights_for_nonordered_set
   (
       int p,
       int n,
       const double *speeds,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Apply_mlimits_to_unordered_sum_of_weights_algo_2
   (
       int p,
       int n,
       const double *speeds,
       const int *mlimits,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Apply_mlimits_to_unordered_sum_of_weights
   (
       int p,
       int n,
       const double *speeds,
       const int *mlimits,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int
   __HMPI_Distribute_with_single_number_for_speed
   (
      int n,
      int p,
      const double *s,
      double *npd
   );

   int __HMPI_Recursive_bisection_middle_region
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       int n,
       double slopei,
       double slopef,
       double *speeds_opt,
       double *npd
   );

   int __HMPI_Speed_function_of_problem_size_with_mlimits
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       const int *bounds,
       int n,
       double *speeds_opt,
       int *np
   );

   int __HMPI_Speed_function_of_problem_size
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       int n,
       double *speeds_opt,
       int *np
   );

   int __HMPI_Sum_of_weights_for_nonordered_set_speed_functions
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       int n,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Sum_of_weights_for_nonordered_set_speed_functions_with_mlimits
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       const int *mlimits,
       int n,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Sum_of_weights_for_ordered_set_speed_functions
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       int n,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Sum_of_weights_for_ordered_set_speed_functions_with_mlimits
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       const int *mlimits,
       int n,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Sum_of_weights_for_ordered_set_speed_functions_processor_reordering
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       int n,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   int __HMPI_Sum_of_weights_for_ordered_set_speed_functions_processor_reordering_with_mlimits
   (
       int p,
       int pn,
       const double *speeds,
       const int *psizes,
       const int *mlimits,
       int n,
       const int *w,
       int type_of_metric,
       User_defined_metric umf,
       double *metric,
       int *np
   );

   #endif
