
/*************************************************************************
*                                                                       *
*                 HMPI Programming Environment                          *
*                 ============================                          *
*                                                                       *
*  Copyright (c) 2002          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /************************************************/
   /* hmpi - Internal helper functions of the      */
   /*        the HeteroMPI library                 */
   /*                                              */
   /* Revision history                             */
   /* 04-10-2007  --      Adding optimal algorithm */
   /*                     parameters to the Network*/
   /************************************************/

   #ifndef __HMPI_INTERNAL_FUNCS_HH
   #define __HMPI_INTERNAL_FUNCS_HH

   /*-----------------------------------------------------*/

   int
   HMPI_Get_process_arrangements_recursively_i
   (
       int d,
       const HMPI_Model* model,
       HMPI_Heuristic_function hfunc,
       const int* model_parameters,
       int model_param_count,
       int gsize,
       int numcoord,
       int *coord,
       int **parr,
       int *nparr,
       int *max_nparr
   );

   /*-----------------------------------------------------*/

   int
   HMPI_Get_process_arrangements_i
   (
       const HMPI_Model* model,
       HMPI_Heuristic_function hfunc,
       const int* model_parameters,
       int model_param_count,
       int **parr,
       int *nparr
   );

   /*-----------------------------------------------------*/

   int
   HMPI_Test_size_i
   (
       int gsize,
       int numcoord,
       const int *dim
   );

   /*-----------------------------------------------------*/

   int
   HMPI_Evaluate_model_recursively_i
   (
       int d,
       const HMPI_Model* model,
       HMPI_Heuristic_function hfunc,
       const int* model_parameters,
       int model_param_count,
       int gsize,
       int numcoord,
       double *mintime,
       int *dim,
       int *optimal_dim,
       int **optimal_speeds
   );

   /*-----------------------------------------------------*/

   int
   HMPI_Group_auto_create_i
   (
       HMPI_Group* gid,
       const HMPI_Model* model,
       HMPI_Heuristic_function hfunc,
       const int* model_parameters,
       int model_param_count
   );

   /*-----------------------------------------------------*/

   int
   HMPI_Test_one_proc_i
   (
       int numcoord,
       const int *dim
   );

   /*-----------------------------------------------------*/

   int
   HMPI_Group_pauto_create_i
   (
       HMPI_Group* gid,
       const HMPI_Model* model,
       HMPI_Heuristic_function hfunc,
       const int* model_parameters,
       int model_param_count
   );

   /*-----------------------------------------------------*/

   #endif
