
/*************************************************************************
*                                                                       *
*                 HeteroMPI Programming Environment                     *
*                 =================================                     *
*                                                                       *
*  Copyright (c) 2005          Department of Computer Science,          *
*                              University College Dublin.               *
*                                                                       *
*  All rights reserved. We assume no responsibility for the use         *
*  or reliability of our software.                                      *
*                                                                       *
*************************************************************************/

   /************************************************/
   /*       Error codes for the HeteroMPI Library  */
   /*                                              */
   /* Revision history                             */
   /* 01-02-2002  --      Initial version          */
   /************************************************/

   #ifndef __HMPI_ERR_HH
   #define __HMPI_ERR_HH

   /*
    * HMPI success and error codes
    */
   #define HMPI_OK                        MPC_OK
   #define HMPI_SUCCESS                   MPC_OK
   #define HMPI_ERR_NOMEM                 MPC_ERR_NOMEM
   #define HMPI_NOT_MEMBER                (MPC_ERR_LAST + 1)
   #define HMPI_NULL_GROUP                (MPC_ERR_LAST + 2)
   #define HMPI_ERR_GROUP_NOT_EXIST       (MPC_ERR_LAST + 3)
   #define HMPI_INVALID_GROUP             (MPC_ERR_LAST + 4)
   #define HMPI_INVALID_PARAMS            (MPC_ERR_LAST + 5)
   #define HMPI_INVALID_OPERAND_TYPE      (MPC_ERR_LAST + 6)
   #define HMPI_INVALID_OPERATOR          (MPC_ERR_LAST + 7)
   #define HMPI_ERROR_CONDITION           (MPC_ERR_LAST + 8)
   #define HMPI_NOT_HOST                  (MPC_ERR_LAST + 9)
   #define HMPI_NOT_HOST_AND_NOT_FREE     (MPC_ERR_LAST + 10)
   #define HMPI_ERR_INTERNAL              (MPC_ERR_LAST + 11)
   #define HMPI_ERR_PARTITION_SET         (MPC_ERR_LAST + 12)
   #define HMPI_ERR_MLIMITS               (MPC_ERR_LAST + 13)
   #define HMPI_ERR_INVALID_DIMP          (MPC_ERR_LAST + 14)
   #define HMPI_ERR_PARTITION_MATRIX      (MPC_ERR_LAST + 15)
   #define HMPI_ERR_PARTITION_NOT_EXISTS  (MPC_ERR_LAST + 16)
   #define HMPI_ERR_PARTITION_GRAPH       (MPC_ERR_LAST + 17)
   #define HMPI_ERR_PARTITION_TREE        (MPC_ERR_LAST + 19)
   #define HMPI_ERR_METRIC                (MPC_ERR_LAST + 20)
   #define HMPI_LAST_ERROR                (MPC_ERR_LAST + 21)

   #define HMPI_UNDEFINED                 -1

   /*
    * Length of HMPI error message
    */
   #define HMPI_MAX_ERROR_STRING          MPI_MAX_ERROR_STRING

   #endif  /* __HMPI_ERR_HH */
