
   #include <stdio.h>
   #include <stdlib.h>
   #include <string.h>
   #include <hmpi.h>

   #define  COMMAND_LENGTH   1024
   #define  HOSTNAMELENGTH   64

   int main(int argc, char **argv)
   {
      int i, rc;
      char *mpc_topo;
      char mpctopo_clean[COMMAND_LENGTH];
      char hostname[HOSTNAMELENGTH];
      int debug_mode = 0;

      rc = HMPI_Init(
               &argc,
               &argv
      );

      if (rc != HMPI_OK)
      {
         printf(
             "Problems initializing HMPI runtime "
             "...Exiting...\n"
         );

         HMPI_Finalize(-1);
      }

      if (!HMPI_Is_member(HMPI_PROC_WORLD_GROUP))
      {
         HMPI_Finalize(0);
      }

      for (i = 1; i < argc; i++)
      {
          if (strcmp(argv[i], "-d") == 0)
          {
             debug_mode = 1;
          }
      }

      //
      // To print the hostname on which the error occurred
      gethostname(
          hostname,
          HOSTNAMELENGTH
      );

      //
      // Get the HMPI installation directory
      // Form the include string
      mpc_topo = getenv("MPCTOPO");

      if (mpc_topo == NULL)
      {
         printf("MPCTOPO not set on machine %s\n", hostname);
         HMPI_Finalize(-2);
      }

      if (debug_mode)
      {
         printf(
            "Cleaning up the contents of the MPCTOPO directory %s on %s\n",
            mpc_topo,
            hostname
         );
      }

      // clean the contents of the 
      // MPCTOPO directory
      strcpy(mpctopo_clean, "/bin/rm -f ");
      strcat(mpctopo_clean, mpc_topo);
      strcat(mpctopo_clean, "/*");

      system(mpctopo_clean);

      HMPI_Finalize(0);
   }
