
    #include <math.h>
    #include "mxm_i.h"
    #include "ParallelAxB.c"

    int InitializeMatrices
    (
        int n,
        double *aa,
        double *bb,
        double *cc 
    )
    {
        int i;

        for (i = 0; i < n; i++)
        {
            aa[i] = MXM_CONSTANT_NUMBER;
            bb[i] = MXM_CONSTANT_NUMBER;            
            cc[i] = 0.0;
        }

        return HMPI_OK; 
    }

    int GetPivotProcessor
    (
        int prow,
        int n,
        int p,
        int *np
    )
    {
        int i, j;
        int *cumnp = (int*)malloc(
                           sizeof(int)
                           *
                           (p+1)
        );

        if (cumnp == NULL)
        {
           printf("Can't allocate cumnp in Function GetPivotProcessor\n");
           return -1;
        }

        for (i = 0; i <= p; i++)
        {
            cumnp[i] = 0;
            for (j = 0; j < i; j++)
            {
                cumnp[i] += np[j];
            }
        }
        
        for (i = 0; i < p; i++)
        {
           if ((prow >= cumnp[i])
               && (prow < cumnp[i+1]
              )
           )
           {
              free(cumnp);
              return i;
           }
        }

        free(cumnp);

        return -1; 
    }

    int
    MyPartition
    (
       int i,
       int p,
       const int *speeds,
       int n
    )
    {
        int ind;
        int rc, myd;
        double *perf;
        int *d = (int*)malloc(
                       sizeof(int)
                       *
                       p
        );

        if (d == NULL)
        {
           printf("No memory to allocate d\n");
           return -1;
        }

        perf = (double*)malloc(
                       sizeof(double)
                       *
                       p
        );

        if (perf == NULL)
        {
           printf("No memory to allocate perf\n");
           return -1;
        }

        for (ind = 0; ind < p; ind++)
        {
           perf[ind] = speeds[ind];
        }

        rc = HMPI_Partition_set(
                 p,
                 1,
                 perf,
                 NULL,
                 NULL,
                 n,
                 NULL,
                 0,
                 0,
                 -1,
                 NULL,
                 NULL,
                 d
        );

        if (rc != HMPI_OK)
        {
           printf("Problems partitioning\n");
           HMPI_Finalize(-5);
        }

        myd = d[i];

        free(d);
        free(perf);
 
        return myd;
    }

    int GetPartitions
    (
       int p,
       const int *speeds,
       int n,
       int *d
    )
    {
        int i, rc;
        double *perf;

        perf = (double*)malloc(
                       sizeof(double)
                       *
                       p
        );

        if (perf == NULL)
        {
           printf("No memory to allocate perf\n");
           return -1;
        }

        for (i = 0; i < p; i++)
        {
           perf[i] = speeds[i];
        }

        rc =   HMPI_Partition_set(
                 p,
                 1,
                 perf,
                 NULL,
                 NULL,
                 n,
                 NULL,
                 0,
                 0,
                 -1,
                 NULL,
                 NULL,
                 d
        );

        if (rc != HMPI_OK)
        {
           printf("Problems partitioning\n");
           HMPI_Finalize(-5);
        }

        free(perf);
 
        return HMPI_OK;
    }
