
   #include <hmpi.h>

   #include "bcast.c"
   #include "counter.h"
   
   #define  ITER  10

   int main
   (
       int argc,
       char **argv
   )
   {
       int p;
       HMPI_Group nid;

       HMPI_Init(
           &argc, 
           &argv
       );

       p = HMPI_Group_size(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_host())
       {
          printf("Total number of processes participating in broadcast = %d\n", p);
       }

       if (HMPI_Is_host())
       {
          int param_count = 4;
          int model_params[4] = {
              p,
              N,
              ITER,
	      root
          };
	  double time;

          time = HMPI_Timeof(
                     &MPC_NetType_bcast,
                     model_params,
                     param_count
          );

          time = (double)time/(double)ITER;

          printf("Number of bytes broadcast = %d, time in seconds=%0.3f\n", N*N*8, time);
       }

       HMPI_Finalize(0);      
   }
