
#include <math.h>
#include <stdio.h>
#include <sys/time.h>

#include <hmpi.h>

#include "f2c.h"
#include "counter.h"
#include "simpleGrid.c"

#include "pmatgeninc.c"
#include "pdmatgen.c"

#define  GENERATE_MATRICES     1
#define  VERBOSE               1

#ifdef  max
#undef  max
#endif  /* max */
#define max(a, b)       ((a) < (b) ? (b) : (a))

static integer nrhs = 1;
static integer nbrhs = 1;

int main( int argc, char **argv)
{
    extern /* Subroutine */descinit_(integer *, integer *, integer *, integer *,
            integer *, integer *, integer *, integer *, integer *, integer *);

    extern /* Subroutine */ int blacs_get__(integer *, integer *, integer *);
    extern /* Subroutine */ int blacs_exit__(integer *);
    extern /* Subroutine */ int blacs_pinfo__(integer *, integer *),
            pdpblasinfo_(char *, integer *, integer *, integer *, integer *,
            integer *, integer *, integer *, doublereal *, integer *, integer
            *, ftnlen);
    extern /* Subroutine */ int pdgemm_(char *, char *, integer *, integer *,
            integer *, doublereal *, doublereal *, integer *, integer *,
            integer *, doublereal *, integer *, integer *, integer *,
            doublereal *, doublereal *, integer *, integer *, integer *,
            ftnlen, ftnlen);

    extern integer numroc_(integer *, integer *, integer *, integer *,
            integer *);
    extern /* Subroutine */ int blacs_gridinit__(integer *, char *, integer *,
             integer *, ftnlen), blacs_gridexit__(integer *);

    static integer i, kp, kq, np, nq, nq1, info, i__1;
    static integer desca[9], descb[9], mycol, ictxt, myrow;

    static integer iaseed, ibseed;
    
    static doublereal *a, *b;
    static integer *ipiv;

    MPI_Comm gesvcomm;

    HMPI_Group gid;
    int param_count, modelp[2];

    struct timeval start, end;

    gettimeofday(&start, NULL);

    // Initialize HMPI runtime
    HMPI_Init(&argc, &argv);

    // Create HMPI group
    if (HMPI_Is_host())
    {
       param_count = 2;
       modelp[0] = p;
       modelp[1] = q;
    }

    if (HMPI_Is_member(HMPI_HOST_GROUP))
    {
       HMPI_Group_create(
           &gid,
           &HMPI_NetType_simpleGrid,
           modelp,
           param_count
       );
    }

    if (HMPI_Is_free())
    {
       HMPI_Group_create(
           &gid,
           &HMPI_NetType_simpleGrid,
           NULL,
           0
       );
    }

    if (HMPI_Is_free())
    {
       HMPI_Finalize(0);
    }

    gesvcomm = *(MPI_Comm*)HMPI_Get_comm(&gid);

    /*
     * Translate algocomm to a BLACS handle
     */
    ictxt = Csys2blacs_handle(gesvcomm);

    /*
     * Form BLACS context based on algocomm
     */
    Cblacs_gridinit(&ictxt, "r", p, q);
    blacs_gridinfo__(&ictxt, &p, &q, &myrow, &mycol);

    np = numroc_(&n, &nb, &myrow, &c__0, &p);
    nq = numroc_(&n, &nb, &mycol, &c__0, &q);
    nq1 = numroc_(&c__1, &nb, &mycol, &c__0, &q);

    // Initialize the array descriptor for the matrix A, and B
    i__1 = max(1,np);
    descinit_(desca, &n, &n, &nb, &nb, &c__0, &c__0, &ictxt, &i__1, &info);
    //descinit_(desca, &m, &n, &nb, &nb, &c__0, &c__0, &ictxt, &llda, &info);
    i__1 = max(1,np);
    descinit_(descb, &n, &nrhs, &nb, &nbrhs, &c__0, &c__0, &ictxt, &i__1, &info);
    //descinit_(descb, &n, &nrhs, &nb, &nbrhs, &c__0, &c__0, &ictxt, &lldb, &info);

    a = (double*)malloc(
                 sizeof(double)
                 *
                 (desca[8]*nq)
    );

    if (a == NULL)
    {
       printf("Cannot allocate a\n");
       HMPI_Finalize(-1);
    }

    b = (double*)malloc(
                 sizeof(double)
                 *
                 (descb[8]*nq1)
    );

    if (b == NULL)
    {
       printf("Cannot allocate b\n");
       HMPI_Finalize(-1);
    }

    ipiv = (integer*)malloc(
                     sizeof(integer)
                     *
                     (np+nb)
    );

    if (ipiv == NULL)
    {
       printf("Cannot allocate ipiv\n");
       HMPI_Finalize(-1);
    }

    //
    // Generate the matrices A, and B
    if (GENERATE_MATRICES)
    {
       iaseed = 100;
       pdmatgen_(&ictxt, "No transpose", "No transpose", &desca[2], &desca[3], 
                 &desca[4], &desca[5], a, &desca[8], &desca[6], &desca[7], 
                 &iaseed, &c__0, &np, &c__0, &nq, &myrow, &mycol, &p, &q, 
                 (ftnlen)12, (ftnlen)12);
       ibseed = 200;
       pdmatgen_(&ictxt, "No transpose", "No transpose", &descb[2], &descb[3], 
                 &descb[4], &descb[5], b, &descb[8], &descb[6], &descb[7], 
                 &ibseed, &c__0, &np, &c__0, &nq1, &myrow, &mycol, &p, &q, 
                 (ftnlen)12, (ftnlen)12);
    }

    //
    // Solve the linear system A * X = B
    pdgesv_(&n, &nrhs, a, &c__1, &c__1, desca, ipiv, 
            b, &c__1, &c__1, descb, &info);

    //
    // Check the results
    if (VERBOSE)
    {
       if (HMPI_Is_host())
       {
          printf("Return code is %d\n", info);
       }
    }

    free(a);
    free(b);

    blacs_gridexit__(&ictxt);

    if (HMPI_Is_member(&gid))
    {
       HMPI_Group_free(
           &gid
       );
    }

    gettimeofday(&end, NULL);

    /*
     * Print Execution time
     */
    if (HMPI_Is_host())
    {
       double tstart = start.tv_sec + (start.tv_usec/pow(10, 6));
       double tend = end.tv_sec + (end.tv_usec/pow(10, 6));
       double speed_mflops = ((double)(2*m*0.0001*m*0.01*m)/(double)(tend - tstart));

       printf(
          "N=%d, g=%d, p=%d, q=%d, t(sec)=%0.9f, speed(MFlops)=%0.6f\n",
          m,
          nb,
          p,
          q,
          (tend - tstart),
          speed_mflops
       );
    }

    HMPI_Finalize(0);
}
