
   #include <hmpi.h>

   int main
   (
       int argc,
       char **argv
   )
   {
       HMPI_Init(
           &argc, 
           &argv
       );

       {
          int num_of_processors = HMPI_Get_number_of_processors();
          double* gperf = (double*)malloc(
                                   sizeof(double)
                                   *
                                   num_of_processors
          );

          HMPI_Get_processors_info(
             gperf
          );            

          if (HMPI_Is_host())
          {
             int i;

             printf("Number of processors is = %d\n", num_of_processors);

             printf("Processor performances are\n");
             
             for (i = 0; i < num_of_processors; i++)
             {
                 printf("%0.1f ", gperf[i]);
             } 
             
             printf("\n");
          }

          free(gperf);
       }

       HMPI_Finalize(0);      
   }

