
   #include <hmpi.h>
   #include "parameters.h"

   int main(int argc, char **argv)
   {
      int i, rc;
      int *np;
      int *w;
      int n;
      int *mlimits;

      mlimits = (int*)malloc(
                      sizeof(int)
                      *
                      p
      );

      if (mlimits == NULL)
      {
         printf("No memory to allocate\n");
         return -1;
      }

      printf("-----------------------------------------------------\n");
      printf("  Testing nonordered sets with nonweighted elements  \n");
      printf("-----------------------------------------------------\n");

      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d, no processor bounds\n", p, p);
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,
                  p,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            for (i = 0; i < p; i++)
            {
               if (np[i] != 1)
               {
                  printf("Test FAILED\n");
                  break;
               }
            }

            if (i == p)
            {
               printf("Test PASSED\n");
               printf("The partitioning is \n");
               for (i = 0; i < p; i++)
               {
                  printf("%d, ", np[i]);
               }
               printf("\n");
            }
         }

         free(np);
      }

      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d, no processor bounds\n", p, p+1);
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,
                  p+1,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            if (np[0] != 2)
            {
               printf("Test FAILED\n");
            }
            else
            {
               for (i = 1; i < p; i++)
               {
                  if (np[i] != 1)
                  {
                     printf("Test FAILED\n");
                     break;
                  }
               }

               if (i == p)
               {
                  printf("Test PASSED\n");
                  printf("The partitioning is \n");
                  for (i = 0; i < p; i++)
                  {
                     printf("%d, ", np[i]);
                  }
                  printf("\n");
               }
            }
         }

         free(np);
      }

      printf("========================================\n");
      printf("Testing partitioning with upper bounds \n");
      printf("========================================\n");
      {
         int sum  = 0;

         for (i = 0; i < p; i++)
         {
            mlimits[i] = 1000;
            sum += mlimits[i];
         }

         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d\n", p, sum);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  sum,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            for (i = 0; i < p; i++)
            {
               if (np[i] != 1000)
               {
                  printf("Test FAILED\n");
                  break;
               }
            }

            if (i == p)
            {
               printf("Test PASSED\n");
               printf("The partitioning is \n");
               for (i = 0; i < p; i++)
               {
                  printf("%d, ", np[i]);
               }
               printf("\n");
            }
         }

         free(np);
      }

      {
         int sum  = 10000;

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               mlimits[i] = 100;
            }
            else
            {
               mlimits[i] = 1000;
            }
         }

         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d\n", p, sum);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  sum,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
      }

      printf("========================================\n");
      printf("Testing nonordered sets with weighted elements \n");
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   p
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
             w[i] = 100;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, weights of elements all 100\n", p, p);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,   
                  p,
                  w,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         double metric;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   p
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
             if ((i%2) == 0) 
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, odd weights = 50, even weights = 100\n", p, p);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,   
                  p,
                  w,
                  0,
                  -1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
            printf("The partitioning metric is %0.6f\n", metric);
         }

         free(np);
         free(w);
      }

      printf("========================================\n");
      printf("Testing nonordered sets with weighted elements with processor element bounds\n");
      printf("========================================\n");
      {
         double metric;

         n = 41;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    n
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = 1;
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = 2;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%2) == 0) 
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, odd weights = 50, even weights = 100\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,   
                  n,
                  w,
                  0,
                  -1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < n; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
            printf("The partitioning metric is %0.6f\n", metric);
         }

         free(np);
         free(w);
      }

      {
         double metric;

         n = 30;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    n
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = 1;
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = 2;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%2) == 0) 
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, odd weights = 50, even weights = 100\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,   
                  n,
                  w,
                  0,
                  -1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < n; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
            printf("The partitioning metric is %0.6f\n", metric);
         }

         free(np);
         free(w);
      }

      printf("--------------------------------------------------\n");
      printf("  Testing ordered sets with nonweighted elements \n");
      printf("--------------------------------------------------\n");

      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d\n", p, p-5);
      printf("========================================\n");
      {
         n = p-5;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,
                  n,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
      }

      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d\n", p, p*2);
      printf("========================================\n");
      {
         n = p*2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,
                  n,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
      }

      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d, all processors have bound of 2 elements\n", p, p*2);
      printf("========================================\n");
      {
         n = p*2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = 2;
         }

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
      }

      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d, processors have upper bounds on elements\n", p, 10000);
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         n = 10000;

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               mlimits[i] = 100;
            }
            else
            {
               mlimits[i] = 1000;
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
      }

      printf("========================================\n");
      printf("Testing ordered sets with weighted elements \n");
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   p
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
             w[i] = 100;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, weights of elements all 100\n", p, p);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,   
                  p,
                  w,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             w[i] = 100;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, weights of elements all 100\n", p, p*2);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,   
                  n,
                  w,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p+10;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%2) == 0)
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, odd weights=50, even weights=100\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  NULL,   
                  n,
                  w,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%2) == 0)
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = 2;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, processors have bound of 2 elements\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         double metric;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%2) == 0)
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               mlimits[i] = 1;
            }
            else
            {
               mlimits[i] = 4;
            }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, processors have bounds\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");

            printf("The metric is %0.6f\n", metric);
         }

         free(np);
         free(w);
      }

      {
         double metric;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%3) == 0)
             {
                w[i] = 150;
             }
             else
             {
                if ((i%2) == 0)
                {
                   w[i] = 50;
                }
                else
                {
                   w[i] = 100;
                }
             }
         }

         for (i = 0; i < p; i++)
         {
            if ((i%3) == 0)
            {
               mlimits[i] = 3;
            }
            else
            {
                if ((i%2) == 0)
                {
                   mlimits[i] = 1;
                }
                else
                {
                   mlimits[i] = 2;
                }
            }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, processors have bounds\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");

            printf("The metric is %0.6f\n", metric);
         }

         free(np);
         free(w);
      }

      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (2*p)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%2) == 0)
             {
                w[i] = 100;
             }
             else
             {
                w[i] = 50;
             }
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = 2;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d, processors have bound of 2 elements and processors can be reordered\n", p, n);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < 2*p; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         double metric;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (2*p)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%3) == 0)
             {
                w[i] = 150;
             }
             else
             {
                if ((i%2) == 0)
                {
                   w[i] = 50;
                }
                else
                {
                   w[i] = 100;
                }
             }
         }

         for (i = 0; i < p; i++)
         {
            if ((i%3) == 0)
            {
               mlimits[i] = 3;
            }
            else
            {
                if ((i%2) == 0)
                {
                   mlimits[i] = 1;
                }
                else
                {
                   mlimits[i] = 2;
                }
            }
         }

         printf("========================================\n");
         printf(
           "Number of processes=%d, Set cardinal=%d, processors have bounds"
           " and processors can be reordered\n",
           p, 
           n
         );
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  1,
                  -1,
                  NULL,
                  NULL,   
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < 2*p; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(w);
      }

      {
         double metric;

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (2*p)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         n = p*2;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate weights\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
             if ((i%3) == 0)
             {
                w[i] = 150;
             }
             else
             {
                if ((i%2) == 0)
                {
                   w[i] = 50;
                }
                else
                {
                   w[i] = 100;
                }
             }
         }

         for (i = 0; i < p; i++)
         {
            if ((i%3) == 0)
            {
               mlimits[i] = 3;
            }
            else
            {
                if ((i%2) == 0)
                {
                   mlimits[i] = 1;
                }
                else
                {
                   mlimits[i] = 2;
                }
            }
         }

         printf("========================================\n");
         printf(
           "Number of processes=%d, Set cardinal=%d, processors have bounds"
           " and processors can be reordered\n",
           p, 
           n
         );
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  0,
                  NULL,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,   
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < 2*p; i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
            printf("The metric of partitioning is %0.6f\n", metric);
         }

         free(np);
         free(w);
      }

      free(mlimits);

      return 0;
   }
