
   #include <hmpi.h>
   #include "parameters.h"

   int main(int argc, char **argv)
   {
      int i, rc;
      int *np;
      int *w;
      int n;
      int *mlimits;
      double *speeds;

      mlimits = (int*)malloc(
                      sizeof(int)
                      *
                      p
      );

      if (mlimits == NULL)
      {
         printf("No memory to allocate\n");
         return -1;
      }

      printf("-----------------------------------------------------\n");
      printf("  Testing ordered sets with weighted elements  \n");
      printf("  speeds are single numbers                       \n");
      printf("-----------------------------------------------------\n");

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds, all speeds are 1\n"
        " All weights 100\n"
        " processor ordering is not permitted\n",
        p, 
        p
      );
      printf("========================================\n");
      {
         double metric;

         n = p;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = 1.0;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = 100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            for (i = 0; i < (p+1); i++)
            {
               if (np[i] != i)
               {
                  printf("Test FAILED\n");
                  break;
               }
            }

            if (i == (p+1))
            {
               printf("Test PASSED\n");
               printf("The partitioning is \n");
               for (i = 0; i < (p+1); i++)
               {
                  printf("%d, ", np[i]);
               }
               printf("\n");
               printf("The partitioning metric is %f\n", metric);
            }
         }

         free(np);
         free(w);
         free(speeds);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n"
        " Weight 1=100, weight 2=200,...\n",
        p, 
        p
      );
      printf("========================================\n");
      {
         double metric;

         n = p;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = (i+1)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n"
        " Weight 1=2700, weight 2= 2600,...\n",
        p, 
        p
      );
      printf("========================================\n");
      {
         double metric;

         n = p;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = (p-i)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        p*2
      );
      printf("========================================\n");
      {
         double metric;

         n = p*2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/2); i++)
         {
            w[i] = (p-i)*100;
         }

         for (i = (n/2); i < n; i++)
         {
            w[i] = (n-i)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Processors can be reordered            \n"
      );
      printf("========================================\n");

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        p
      );
      printf("========================================\n");
      {
         double metric;

         n = p;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (2*p)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = (n-i)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < 2*p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n"
        " Weight 1=100, weight 2= 200,...\n",
        p, 
        p
      );
      printf("========================================\n");
      {
         double metric;

         n = p;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (2*p)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = (i+1)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (2*p); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " processors have upper bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        ((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         double metric;

         n = ((p*(p+1))/2);
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (2*p)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            if ((i%3) == 0)
            {
               speeds[i] = 1.0;
            }
            else
            {
               if ((i%2) == 0)
               {
                  speeds[i] = 3.0;
               }
               else
               {
                  speeds[i] = 2.0;
               }
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            if ((i%3) == 0)
            {
               w[i] = 100;
            }
            else
            {
               if ((i%2) == 0)
               {
                  w[i] = 300;
               }
               else
               {
                  w[i] = 200;
               }
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  w,
                  1,
                  1,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (2*p); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " processors have upper bounds and processors cannot be reordered\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        ((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         double metric;

         n = ((p*(p+1))/2);
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         for (i = 0; i < p; i++)
         {
            mlimits[i] = i+1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = (i+1)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " processors have upper bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        p*2
      );
      printf("========================================\n");
      {
         double metric;

         n = p*2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = 2;
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = 3;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            w[i] = (i+1)*100;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " processors have upper bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        p*2
      );
      printf("========================================\n");
      {
         double metric;

         n = p*2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1.0;
         }

         for (i = 0; i < (p/2); i++)
         {
            mlimits[i] = 1;
         }

         for (i = (p/2); i < p; i++)
         {
            mlimits[i] = 4;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < (n/2); i++)
         {
            w[i] = 100;
         }

         for (i = (n/2); i < n; i++)
         {
            w[i] = 200;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " processors have upper bounds\n"
        " p1 speed = 1.0, p2 speed = 2.0, ..., pp speed = p \n",
        p, 
        ((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         double metric;

         n = ((p*(p+1))/2);
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            if ((i%3) == 0)
            {
               speeds[i] = 1.0;
            }
            else
            {
               if ((i%2) == 0)
               {
                  speeds[i] = 3.0;
               }
               else
               {
                  speeds[i] = 2.0;
               }
            }
         }

         for (i = 0; i < p; i++)
         {
            if ((i%3) == 0)
            {
               mlimits[i] = 14;
            }
            else
            {
               if ((i%2) == 0)
               {
                  mlimits[i] = 16;
               }
               else
               {
                  mlimits[i] = 15;
               }
            }
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   n
         );

         if (w == NULL)
         {
            printf("No memory to allocate w\n");
            return -1;
         }

         for (i = 0; i < n; i++)
         {
            if ((i%3) == 0)
            {
               w[i] = 100;
            }
            else
            {
               if ((i%2) == 0)
               {
                  w[i] = 300;
               }
               else
               {
                  w[i] = 200;
               }
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  n,
                  w,
                  1,
                  0,
                  SYSTEM_DEFINED,
                  NULL,
                  &metric,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
            printf("The partitioning metric is %f\n", metric);
         }

         free(w);
         free(np);
         free(speeds);
      }
      
      free(mlimits);

      return 0;
   }
