
   #include <hmpi.h>
   #include "parameters.h"

   int main(int argc, char **argv)
   {
      int i, rc;
      int *np;
      int *w;
      int n;
      int *mlimits;
      double *speeds;

      mlimits = (int*)malloc(
                      sizeof(int)
                      *
                      p
      );

      if (mlimits == NULL)
      {
         printf("No memory to allocate\n");
         return -1;
      }

      printf("-----------------------------------------------------\n");
      printf("  Testing ordered sets with nonweighted elements  \n");
      printf("-----------------------------------------------------\n");

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d\n"
        " no processor bounds, all speeds are 1\n",
        p, 
        p
      );
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = 1.0;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  p,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            for (i = 0; i < (p+1); i++)
            {
               if (np[i] != i)
               {
                  printf("Test FAILED\n");
                  break;
               }
            }

            if (i == (p+1))
            {
               printf("Test PASSED\n");
               printf("The partitioning is \n");
               for (i = 0; i < (p+1); i++)
               {
                  printf("%d, ", np[i]);
               }
               printf("\n");
            }
         }

         free(np);
         free(speeds);
      }
      
      printf("========================================\n");
      printf("Number of processes=%d, Set cardinal=%d, no processor bounds\n", p, p+1);
      printf("========================================\n");
      {
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = 1.0;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  p+1,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n",
        p, 
        p*2
      );
      printf("========================================\n");
      {
         n = p*2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = 1.0;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n",
        p, 
        (p*(p+1))/2
      );
      printf("========================================\n");
      {
         n = (p*(p+1))/2;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1;
         }

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  NULL,
                  n,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
      }

      printf("========================================\n");
      printf("Testing partitioning with upper bounds \n");
      printf("========================================\n");
      {
         int sum  = 0;

         for (i = 0; i < p; i++)
         {
            mlimits[i] = 1000;
            sum += mlimits[i];
         }

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            speeds[i] = i+1;
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d\n", p, sum);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  sum,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
      }

      {
         int sum  = 10000;

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               mlimits[i] = 100;
            }
            else
            {
               mlimits[i] = 1000;
            }
         }

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               speeds[i] = 1.0;
            }
            else
            {
               speeds[i] = 2.0;
            }
         }

         printf("========================================\n");
         printf("Number of processes=%d, Set cardinal=%d\n", p, sum);
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  sum,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(speeds);
      }

      {
         int sum  = 10000;

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               mlimits[i] = 0;
            }
            else
            {
               mlimits[i] = 10000;
            }
         }

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               speeds[i] = 1.0;
            }
            else
            {
               speeds[i] = 2.0;
            }
         }

         printf("========================================\n");
         printf(
            "Number of processes=%d, Set cardinal=%d, even processors cannot store any elements\n", 
            p, 
            sum
         );
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  sum,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(speeds);
      }

      {
         int sum  = 10000;

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               mlimits[i] = 1000;
            }
            else
            {
               mlimits[i] = 100;
            }
         }

         np = (int*)malloc(
                    sizeof(int)
                    *
                    (p+1)
         ); 
                  
         if (np == NULL)
         {        
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            if ((i%2) == 0)
            {
               speeds[i] = 1.0;
            }
            else
            {
               speeds[i] = .0;
            }
         }

         printf("========================================\n");
         printf(
            "Number of processes=%d, Set cardinal=%d, odd processors have zero speeds\n", 
            p, 
            sum
         );
         printf("========================================\n");

         rc = HMPI_Partition_set(
                  p,
                  1,
                  speeds,
                  NULL,
                  mlimits,
                  sum,
                  NULL,
                  1,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");

            for (i = 0; i < (p+1); i++)
            {
               printf("%d, ", np[i]);
            }

            printf("\n");
         }

         free(np);
         free(speeds);
      }
      
      free(mlimits);

      return 0;
   }
