
   #include <hmpi.h>
   #include "mxm_data.c"
   #include "cholesky_data.c"

   int main(int argc, char **argv)
   {
      int i, j, rc;
      int *np;
      int *w;
      int n, pn;
      int *mlimits, *psizes;
      double *speeds;

      mlimits = (int*)malloc(
                      sizeof(int)
                      *
                      p
      );

      if (mlimits == NULL)
      {
         printf("No memory to allocate\n");
         return -1;
      }

      printf("-----------------------------------------------------\n");
      printf("  Testing nonordered sets with nonweighted elements  \n");
      printf("  Speeds are functions of problem size               \n");
      printf("-----------------------------------------------------\n");

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=2.0,...             \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  NULL,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=27.0, processor2 speed=26.0, ...          \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  NULL,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = 1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  NULL,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n"
        " Speeds are constant functions of problem size              \n"
        " processor1 speed=1.0, processor2 speed=1.0,...             \n"
        " processor14 speed=14.0, processor13 speed=13.0,...         \n",
        p, 
        100*((p*(p+1))/2)
      );
      printf("========================================\n");
      {
         n = 100*((p*(p+1))/2);
         pn = 10;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         for (i = 0; i < (p/2); i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = i+1.0;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         for (i = (p/2); i < p; i++)
         {
            for (j = 0; j < pn; j++)
            {
               speeds[i*pn+j] = p-i;
               psizes[i*pn+j] = 100 + j*100;
            }
         }

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  NULL,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000000
      );
      printf("========================================\n");
      {
         n = 100000000;
         pn = NSTEPS_CHOLESKY;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         cholesky_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  NULL,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }
      
      printf("========================================\n");
      printf(
        "Number of processes=%d, Set cardinal=%d, no processor bounds\n"
        " speeds are non-constant functions of problem size          \n",
        p, 
        100000000
      );
      printf("========================================\n");
      {
         n = 100000000;
         pn = NSTEPS_MXM;
         np = (int*)malloc(
                    sizeof(int)
                    *
                    p
         );

         if (np == NULL)
         {
            printf("No memory to allocate np\n");
            return -1;
         }

         speeds = (double*)malloc(
                    sizeof(double)
                    *
                    p
                    *
                    pn
         );

         if (speeds == NULL)
         {
            printf("No memory to allocate speeds\n");
            return -1;
         }

         psizes = (int*)malloc(
                    sizeof(int)
                    *
                    p
                    *
                    pn
         );

         if (psizes == NULL)
         {
            printf("No memory to allocate psizes\n");
            return -1;
         }

         mxm_fill_input_parameters(
             p,            
             pn,
             speeds,
             psizes
         );

         rc = HMPI_Partition_set(
                  p,
                  pn,
                  speeds,
                  psizes,
                  NULL,
                  n,
                  NULL,
                  0,
                  -1,
                  -1,
                  NULL,
                  NULL,
                  np
         );

         if (rc != HMPI_OK)
         {
            printf("Test FAILED\n");
         }
         else
         {
            printf("Test PASSED\n");
            printf("The partitioning is \n");
            for (i = 0; i < p; i++)
            {
               printf("%d, ", np[i]);
            }
            printf("\n");
         }

         free(np);
         free(speeds);
         free(psizes);
      }

      free(mlimits);

      return 0;
   }

