
   #ifndef _CHOLESKY_DATA_HH
   #define _CHOLESKY_DATA_HH

   #include "parameters.h"

   #define  NSTEPS_CHOLESKY    17

   HMPI_SM cholesky_csserver[NSTEPS_CHOLESKY] = {
	   {4000000, 124.864310565},
	   {16000000, 127.844352005},
	   {36000000, 125.904845303},
	   {64000000, 130.587377668},
	   {100000000, 130.559806143},
	   {144000000, 130.759171387},
	   {145000000, 130.759171387},
	   {146000000, 130.759171387},
	   {147000000, 130.759171387},
	   {148000000, 130.759171387},
	   {149000000, 130.759171387},
	   {150000000, 130.759171387},
	   {151000000, 130.759171387},
	   {196000000, 113.199448251},
	   {256000000, 105.966681367},
	   {259210000, 104.964774681},
	   {262440000, 109.903486610}
   };

   HMPI_SM cholesky_cssparc01[NSTEPS_CHOLESKY] = {
	   {250000, 5.939098548},
	   {1000000, 5.636311683},
	   {2250000, 5.820281197},
	   {4000000, 5.441632874},
	   {6250000, 5.341562597},
	   {9000000, 0.096799476},
	   {11000000, 0.096799476},
	   {12000000, 0.096799476},
	   {13000000, 0.096799476},
	   {14000000, 0.096799476},
	   {15000000, 0.096799476},
	   {16000000, 0.096799476},
	   {17000000, 0.096799476},
	   {18000000, 0.096799476},
	   {19000000, 0.096799476},
	   {20000000, 0.096799476},
	   {21000000, 0.096799476}
   };

   HMPI_SM cholesky_zaphod[NSTEPS_CHOLESKY] = {
        {250000, 21.349315},
        {1000000, 19.515385},
        {2250000, 19.971639},
        {4000000, 19.739508},
        {6250000, 19.649234},
        {9000000, 19.457953},
        {12250000, 19.142401},
        {16000000, 18.692401},
        {20250000, 18.168914},
        {25000000, 18.284344},
        {30250000, 0.928121},
        {36000000, 0.928121},
        {49000000, 0.9281215747},
        {53290000, 0.9281219407},
        {57760000, 0.928121661},
	{62410000, 0.928121441},
	{64000000, 0.928121969}
   };

   HMPI_SM cholesky_csultra01[NSTEPS_CHOLESKY] = {
	   {1000000, 23.764410074},
	   {4000000, 22.145571618},
	   {9000000, 22.102011630},
	   {16000000, 22.052902292},
	   {25000000, 22.028398830},
	   {36000000, 22.001473375},
	   {49000000, 21.900928257},
	   {50410000, 21.832807225},
	   {51840000, 21.857664670},
	   {53290000, 21.843177220},
	   {54760000, 21.824814619},
	   {56250000, 21.734636134},
	   {57760000, 21.739152698},
	   {59290000, 17.366382642},
	   {60840000, 5.800688717},
	   {62410000, 2.825359441},
	   {64000000, 1.610440969}
   };


   HMPI_SM cholesky_csultra02[NSTEPS_CHOLESKY] = {
	   {1000000, 23.764410074},
	   {4000000, 22.145571618},
	   {9000000, 22.102011630},
	   {16000000, 22.052902292},
	   {25000000, 22.028398830},
	   {36000000, 22.001473375},
	   {49000000, 21.900928257},
	   {50410000, 21.832807225},
	   {51840000, 21.857664670},
	   {53290000, 21.843177220},
	   {54760000, 21.824814619},
	   {56250000, 21.734636134},
	   {57760000, 21.739152698},
	   {59290000, 17.366382642},
	   {60840000, 5.800688717},
	   {62410000, 2.825359441},
	   {64000000, 1.610440969}
   };


   HMPI_SM cholesky_csultra03[NSTEPS_CHOLESKY] = {
	   {1000000, 23.764410074},
	   {4000000, 22.145571618},
	   {9000000, 22.102011630},
	   {16000000, 22.052902292},
	   {25000000, 22.028398830},
	   {36000000, 22.001473375},
	   {49000000, 21.900928257},
	   {50410000, 21.832807225},
	   {51840000, 21.857664670},
	   {53290000, 21.843177220},
	   {54760000, 21.824814619},
	   {56250000, 21.734636134},
	   {57760000, 21.739152698},
	   {59290000, 17.366382642},
	   {60840000, 5.800688717},
	   {62410000, 2.825359441},
	   {64000000, 1.610440969}
   };


   HMPI_SM cholesky_csultra04[NSTEPS_CHOLESKY] = {
	   {1000000, 23.764410074},
	   {4000000, 22.145571618},
	   {9000000, 22.102011630},
	   {16000000, 22.052902292},
	   {25000000, 22.028398830},
	   {36000000, 22.001473375},
	   {49000000, 21.900928257},
	   {50410000, 21.832807225},
	   {51840000, 21.857664670},
	   {53290000, 21.843177220},
	   {54760000, 21.824814619},
	   {56250000, 21.734636134},
	   {57760000, 21.739152698},
	   {59290000, 17.366382642},
	   {60840000, 5.800688717},
	   {62410000, 2.825359441},
	   {64000000, 1.610440969}
   };

   HMPI_SM cholesky_csultra05[NSTEPS_CHOLESKY] = {
	   {1000000, 23.764410074},
	   {4000000, 22.145571618},
	   {9000000, 22.102011630},
	   {16000000, 22.052902292},
	   {25000000, 22.028398830},
	   {36000000, 22.001473375},
	   {49000000, 21.900928257},
	   {50410000, 21.832807225},
	   {51840000, 21.857664670},
	   {53290000, 21.843177220},
	   {54760000, 21.824814619},
	   {56250000, 21.734636134},
	   {57760000, 21.739152698},
	   {59290000, 17.366382642},
	   {60840000, 5.800688717},
	   {62410000, 2.825359441},
	   {64000000, 1.610440969}
   };

   HMPI_SM cholesky_csultra06[NSTEPS_CHOLESKY] = {
	   {1000000, 23.768325289},
	   {4000000, 22.131944172},
	   {9000000, 22.091440611},
	   {16000000, 22.041041439},
	   {25000000, 22.011254802},
	   {36000000, 21.952612653},
	   {49000000, 21.889435747},
	   {50410000, 21.810906439},
	   {51840000, 21.861484376},
	   {53290000, 17.633839407},
	   {54760000, 21.372803594},
	   {56250000, 8.842628031},
	   {57760000, 3.868983661},
	   {59290000, 1.981000716},
	   {60840000, 1.980688717},
	   {62410000, 1.985359441},
	   {64000000, 0.692067366}
   };

   HMPI_SM cholesky_csultra07[NSTEPS_CHOLESKY] = {
	   {1000000, 23.747713698},
	   {4000000, 22.136626915},
	   {9000000, 22.094962216},
	   {16000000, 22.035841647},
	   {25000000, 22.030169235},
	   {36000000, 21.983646611},
	   {49000000, 21.896411124},
	   {50410000, 21.829913118},
	   {51840000, 21.860850892},
	   {53290000, 21.780542521},
	   {54760000, 21.825813789},
	   {56250000, 21.786999727},
	   {57760000, 21.766376200},
	   {59290000, 21.344032928},
	   {60840000, 8.171995107},
	   {62410000, 4.510313092},
	   {64000000, 2.164977665}
   };

   HMPI_SM cholesky_csultra08[NSTEPS_CHOLESKY] = {
	   {1000000, 23.778823668},
	   {4000000, 22.106843475},
	   {9000000, 22.054912513},
	   {16000000, 22.013755081},
	   {25000000, 21.993639770},
	   {36000000, 21.945071271},
	   {49000000, 21.845554838},
	   {50410000, 21.791453652},
	   {51840000, 21.803999933},
	   {53290000, 18.954394373},
	   {54760000, 16.428976482},
	   {56250000, 6.737218593},
	   {57760000, 3.343912295},
	   {59290000, 1.781267541},
	   {60840000, 1.781295107},
	   {62410000, 1.781213092},
	   {64000000, 0.640542850}
   };

   HMPI_SM cholesky_csultra09[NSTEPS_CHOLESKY] = {
	   {1000000, 23.778823668},
	   {4000000, 22.106843475},
	   {9000000, 22.054912513},
	   {16000000, 22.013755081},
	   {25000000, 21.993639770},
	   {36000000, 21.945071271},
	   {49000000, 21.845554838},
	   {50410000, 21.791453652},
	   {51840000, 21.803999933},
	   {53290000, 18.954394373},
	   {54760000, 16.428976482},
	   {56250000, 6.737218593},
	   {57760000, 3.343912295},
	   {59290000, 1.781267541},
	   {60840000, 1.781295107},
	   {62410000, 1.781213092},
	   {64000000, 0.640542850}
   };

   HMPI_SM cholesky_csultra10[NSTEPS_CHOLESKY] = {
	   {1000000, 23.778823668},
	   {4000000, 22.106843475},
	   {9000000, 22.054912513},
	   {16000000, 22.013755081},
	   {25000000, 21.993639770},
	   {36000000, 21.945071271},
	   {49000000, 21.845554838},
	   {50410000, 21.791453652},
	   {51840000, 21.803999933},
	   {53290000, 18.954394373},
	   {54760000, 16.428976482},
	   {56250000, 6.737218593},
	   {57760000, 3.343912295},
	   {59290000, 1.781267541},
	   {60840000, 1.781295107},
	   {62410000, 1.781213092},
	   {64000000, 0.640542850}
   };

   HMPI_SM cholesky_pg1cluster01[NSTEPS_CHOLESKY] = {
	   {4000000, 115.245743340},
	   {16000000, 129.237372893},
	   {36000000, 131.366766036},
	   {64000000, 132.453253197},
	   {100000000, 130.311378787},
	   {104040000, 131.908202933},
	   {108160000, 131.550582173},
	   {112360000, 129.607737897},
	   {116640000, 129.775802111},
	   {121000000, 120.943616704},
           {125440000, 120.981827752},
           {129960000, 13.577790582},
           {134560000, 6.473261313},
	   {144000000, 1.582005129},
	   {256000000, 1.58200512967},
	   {259210000, 1.58200512981},
	   {262440000, 1.58200512910}
   };

   HMPI_SM cholesky_pg1cluster02[NSTEPS_CHOLESKY] = {
	   {4000000, 108.982915680},
	   {16000000, 118.939773374},
	   {36000000, 128.094924603},
	   {64000000, 130.744588030},
	   {100000000, 48.804708603},
	   {104040000, 12.694856091},
	   {108160000, 4.104495363},
	   {112360000, 4.10449536397},
	   {116640000, 4.10449536311},
	   {121000000, 4.10449536304},
           {125440000, 4.10449536352},
           {129960000, 4.1044953632},
           {134560000, 4.104495363},
	   {144000000, 4.104495363},
	   {256000000, 4.10449536367},
	   {259210000, 4.10449536381},
	   {262440000, 4.10449536310}
   };

   HMPI_SM cholesky_pg1cluster03[NSTEPS_CHOLESKY] = {
	   {4000000, 119.168936295},
	   {16000000, 130.896311575},
	   {36000000, 130.126494546},
	   {64000000, 130.843268182},
	   {100000000, 131.427796670},
	   {104040000, 112.405889567},
	   {108160000, 106.281639688},
	   {112360000, 130.199829054},
	   {116640000, 129.080379567},
	   {121000000, 126.078559114},
	   {125440000, 121.696608242},
	   {129960000, 11.570738312},
           {134560000, 4.104495363},
	   {144000000, 2.324135954},
	   {256000000, 2.32413595467},
	   {259210000, 2.32413595481},
	   {262440000, 2.32413595410}
   };

   HMPI_SM cholesky_pg1cluster04[NSTEPS_CHOLESKY] = {
	   {4000000, 102.531722285},
	   {16000000, 105.928194018},
	   {36000000, 125.154608976},
	   {64000000, 128.944157230},
	   {100000000, 128.331473503},
	   {104040000, 132.700238374},
	   {108160000, 132.415199370},
	   {112360000, 131.534995916},
	   {116640000, 132.166146217},
	   {121000000, 128.654212634},
	   {125440000, 125.981827752},
	   {129960000, 13.577790582},
	   {134560000, 6.473261313},
	   {144000000, 1.699194395},
	   {256000000, 1.69919439567},
	   {259210000, 1.69919439581},
	   {262440000, 1.69919439510}
   };

#define cholesky_afflatus cholesky_pg1cluster01
#define cholesky_shelbourne2 cholesky_zaphod
#define cholesky_maxft cholesky_cssparc01

int cholesky_bcsserver = 262440000;
int cholesky_bcssparc01 = 6250000;
int cholesky_bzaphod = 30250000;
int cholesky_bcsultra01 = 64000000;
int cholesky_bcsultra02 = 64000000;
int cholesky_bcsultra03 = 64000000;
int cholesky_bcsultra04 = 64000000;
int cholesky_bcsultra05 = 64000000;
int cholesky_bcsultra06 = 64000000;
int cholesky_bcsultra07 = 59290000;
int cholesky_bcsultra08 = 64000000;
int cholesky_bcsultra09 = 59290000;
int cholesky_bcsultra10 = 59290000;
int cholesky_bpg1cluster01 = 144000000;
int cholesky_bpg1cluster02 = 108160000;
int cholesky_bpg1cluster03 = 144000000;
int cholesky_bpg1cluster04 = 144000000;
int cholesky_bafflatus = 67092481;
int cholesky_bshelbourne2 = 12960000;
int cholesky_bmaxft = 55294096;

   void cholesky_fill_input_parameters(
       int p,
       int steps,
       double *speeds,
       int *mlimits
   );

   void cholesky_display_input_parameters(
       int p,
       int steps,
       double *speeds,
       int *mlimits
   );

   #endif
