
   #include "cholesky_data.h"

   void cholesky_fill_input_parameters
   (
       int p,
       int steps,
       double *speeds,
       int *mlimits
   )
   {
       int i;

       for (i = 0; i < steps; i++)
       {
           speeds[i] = cholesky_csserver[i].speed;
           mlimits[i] = cholesky_csserver[i].n;

           speeds[1*steps+i] = cholesky_csserver[i].speed;
           mlimits[1*steps+i] = cholesky_csserver[i].n;

           speeds[2*steps+i] = cholesky_csserver[i].speed;
           mlimits[2*steps+i] = cholesky_csserver[i].n;

           speeds[3*steps+i] = cholesky_csserver[i].speed;
           mlimits[3*steps+i] = cholesky_csserver[i].n;

           speeds[4*steps+i] = cholesky_pg1cluster01[i].speed;
           mlimits[4*steps+i] = cholesky_pg1cluster01[i].n;

           speeds[5*steps+i] = cholesky_pg1cluster01[i].speed;
           mlimits[5*steps+i] = cholesky_pg1cluster01[i].n;

           speeds[6*steps + i] = cholesky_pg1cluster02[i].speed;
           mlimits[6*steps + i] = cholesky_pg1cluster02[i].n;

           speeds[7*steps + i] = cholesky_pg1cluster02[i].speed;
           mlimits[7*steps + i] = cholesky_pg1cluster02[i].n;

           speeds[8*steps + i] = cholesky_pg1cluster03[i].speed;
           mlimits[8*steps + i] = cholesky_pg1cluster03[i].n;

           speeds[9*steps + i] = cholesky_pg1cluster03[i].speed;
           mlimits[9*steps + i] = cholesky_pg1cluster03[i].n;

           speeds[10*steps + i] = cholesky_pg1cluster04[i].speed;
           mlimits[10*steps + i] = cholesky_pg1cluster04[i].n;

           speeds[11*steps + i] = cholesky_pg1cluster04[i].speed;
           mlimits[11*steps + i] = cholesky_pg1cluster04[i].n;

           speeds[12*steps + i] = cholesky_csultra01[i].speed;
           mlimits[12*steps + i] = cholesky_csultra01[i].n;

           speeds[13*steps + i] = cholesky_csultra02[i].speed;
           mlimits[13*steps + i] = cholesky_csultra02[i].n;

           speeds[14*steps + i] = cholesky_csultra03[i].speed;
           mlimits[14*steps + i] = cholesky_csultra03[i].n;

           speeds[15*steps + i] = cholesky_csultra04[i].speed;
           mlimits[15*steps + i] = cholesky_csultra04[i].n;

           speeds[16*steps + i] = cholesky_csultra05[i].speed;
           mlimits[16*steps + i] = cholesky_csultra05[i].n;

           speeds[17*steps + i] = cholesky_csultra06[i].speed;
           mlimits[17*steps + i] = cholesky_csultra06[i].n;

           speeds[18*steps + i] = cholesky_csultra07[i].speed;
           mlimits[18*steps + i] = cholesky_csultra07[i].n;

           speeds[19*steps + i] = cholesky_csultra08[i].speed;
           mlimits[19*steps + i] = cholesky_csultra08[i].n;

           speeds[20*steps + i] = cholesky_csultra09[i].speed;
           mlimits[20*steps + i] = cholesky_csultra09[i].n;

           speeds[21*steps + i] = cholesky_csultra10[i].speed;
           mlimits[21*steps + i] = cholesky_csultra10[i].n;

           speeds[22*steps + i] = cholesky_zaphod[i].speed;
           mlimits[22*steps + i] = cholesky_zaphod[i].n;

           speeds[23*steps + i] = cholesky_cssparc01[i].speed;
           mlimits[23*steps + i] = cholesky_cssparc01[i].n;

           speeds[24*steps + i] = cholesky_afflatus[i].speed;
           mlimits[24*steps + i] = cholesky_afflatus[i].n;

           speeds[25*steps + i] = cholesky_shelbourne2[i].speed;
           mlimits[25*steps + i] = cholesky_shelbourne2[i].n;

           speeds[26*steps + i] = cholesky_maxft[i].speed;
           mlimits[26*steps + i] = cholesky_maxft[i].n;
       }

       return;
   }

   void cholesky_display_input_parameters
   (
       int p,
       int steps,
       double *speeds,
       int *mlimits
   )
   {
       int i;

       printf("======Speeds=====\n");

       for (i = 0; i < (p*steps); i++)
       {
           printf("%0.9f\n", speeds[i]);
       }

       printf("======memory limits=====\n");

       for (i = 0; i < (p*steps); i++)
       {
           printf("%d\n", mlimits[i]);
       }

       return;
   }

