
   #include <hmpi.h>
   #include "parameters.h"

   int main(int argc, char **argv)
   {
      int i, rc;

      printf("-----------------------------------------------------\n");
      printf("  Testing Partitioning of matrices                   \n");
      printf("-----------------------------------------------------\n");
     
      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, p, p, p);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = p;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", q, p, q, p);
      printf("-----------------------------------------------------\n");
      {
         int m = q;
         int n = p;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  q,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 q,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p+1, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p+1;
         int n = q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q+1;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol, 
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p+1, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q+1;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p+1, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q+1;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci, *cj;

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      return 0;
   }
