
   #include <hmpi.h>
   #include "parameters.h"

   int main(int argc, char **argv)
   {
      int i, rc;

      /*
       * The API HMPI_Partition_matrix_1d_dp is used for testing 
       * homogeneous 1D partitioning.
       * The other API HMPI_Partition_matrix_1d_refining and 
       * HMPI_Partition_matrix_1d_iterative can also be used.
       */

      HMPI_Debug(1);

      printf("-----------------------------------------------------\n");
      printf("  Testing Partitioning of matrices                   \n");
      printf("-----------------------------------------------------\n");
     
      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, p, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*p, p, p);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = p;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, q, p);
      printf("-----------------------------------------------------\n");
      {
         int m = q;
         int n = p;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, p+1, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p+1;
         int n = q;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }
      
      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, p, q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q+1;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, 2*p, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, 2*p+1, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, 2*p, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q+1;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      printf("-----------------------------------------------------\n");
      printf("        Homogeneous partitioning of matrices         \n");
      printf("        p=%d, m=%d, n=%d                             \n", p*q, 2*p+1, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q+1;
         int type_of_distribution = -1;
         int formulation = -1;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 0;
         int *w, *h, *trow, *tcol, *ci;

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_1d_dp(
                  p*q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  NULL,
                  NULL,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_1d(
                 p*q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
      }

      return 0;
   }
