
   #include <stdlib.h>
   #include <hmpi.h>
   #include "parameters.h"

   /*
    * These tests can be written to use macros 
    * or functions that perform common code.
    * Same pattern of code exists for each individual
    * test and it can be used in a function, which
    * can be called. Makes maintenance easier.
    */

   int main(int argc, char **argv)
   {
      int i, rc;

      printf("-----------------------------------------------------\n");
      printf("  Testing Partitioning of matrices                   \n");
      printf("  Speeds are single numbers                          \n");
      printf("  There are no upper bounds on the number of elements\n");
      printf("  that a processor can store                         \n");
      printf("-----------------------------------------------------\n");
     
      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q);
      printf("-----------------------------------------------------\n");
      {
         int i;
         int m = p;
         int n = q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q);
      printf("-----------------------------------------------------\n");
      {
         int i;
         int m = p;
         int n = q;
         int type_of_distribution = ROW_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, p, p, p);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = p;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*p)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*p); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, p, p, p);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = p;
         int type_of_distribution = ROW_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*p)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*p); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", q, p, q, p);
      printf("-----------------------------------------------------\n");
      {
         int m = q;
         int n = p;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  q,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 q,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", q, p, q, p);
      printf("-----------------------------------------------------\n");
      {
         int m = q;
         int n = p;
         int type_of_distribution = ROW_BASED;    
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  q,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 q,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p+1, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p+1;
         int n = q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p+1, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p+1;
         int n = q;
         int type_of_distribution = ROW_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q+1;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q+1;
         int type_of_distribution = ROW_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q;
         int type_of_distribution = ROW_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p+1, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q+1;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p+1, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q+1;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        COLUMN BASED                                 \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 100, 100);
      printf("-----------------------------------------------------\n");
      {
         int m = 100;
         int n = 100;
         int type_of_distribution = COLUMN_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = (int)(10.0*rand()/(RAND_MAX+1.0));
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        ROW BASED                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 100, 100);
      printf("-----------------------------------------------------\n");
      {
         int m = 100;
         int n = 100;
         int type_of_distribution = ROW_BASED;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = (int)(10.0*rand()/(RAND_MAX+1.0));
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q);
      printf("-----------------------------------------------------\n");
      {
         int i;
         int m = p;
         int n = q;
         int type_of_distribution = CARTESIAN;   
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, p, p, p);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = p;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*p)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*p); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*p*p*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", q, p, q, p);
      printf("-----------------------------------------------------\n");
      {
         int m = q;
         int n = p;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (q*p*q*p)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (q*p)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  q,
                  p,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 q,
                 p,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p+1, q);
      printf("-----------------------------------------------------\n");
      {
         int m = p+1;
         int n = q;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, p, q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = p;
         int n = q+1;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p, 2*q);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p;
         int n = 2*q;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 2*p+1, 2*q+1);
      printf("-----------------------------------------------------\n");
      {
         int m = 2*p+1;
         int n = 2*q+1;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = 1;
         }

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      printf("-----------------------------------------------------\n");
      printf("        CARTESIAN                                    \n");
      printf("        p=%d, q=%d, m=%d, n=%d                       \n", p, q, 100, 100);
      printf("-----------------------------------------------------\n");
      {
         int m = 100;
         int n = 100;
         int type_of_distribution = CARTESIAN;
         double* speeds = NULL;
         int* psizes = NULL;
         int* mlimits = NULL;
         int pn = 1;
         int *w, *h, *trow, *tcol, *ci, *cj;

         speeds = (double*)malloc(
                           sizeof(double)
                           *
                           (p*q)
         );

         if (speeds == NULL)
         {
            return -1;
         }

         for (i = 0; i < (p*q); i++)
         {
            speeds[i] = (int)(10.0*rand()/(RAND_MAX+1.0));
         }

         printf("Speeds are:\n");

         for (i = 0; i < (p*q); i++)
         {
            printf("%d ", (int)speeds[i]);
         }

         printf("\n");
         printf("\n");

         w = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (w == NULL)
         {
            return -1;
         }

         h = (int*)malloc(
                   sizeof(int)
                   *
                   (p*q*p*q)
         );

         if (h == NULL)
         {
            return -1;
         }

         trow = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (trow == NULL)
         {
            return -1;
         }

         tcol = (int*)malloc(
                      sizeof(int)
                      *
                      (p*q)
         );

         if (tcol == NULL)
         {
            return -1;
         }

         ci = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (ci == NULL)
         {
            return -1;
         }

         cj = (int*)malloc(
                    sizeof(int)
                    *
                    (m*n)
         );

         if (cj == NULL)
         {
            return -1;
         }

         rc = HMPI_Partition_matrix_2d(
                  p,
                  q,
                  pn,
                  speeds,
                  psizes,
                  mlimits,
                  m,
                  n,
                  type_of_distribution,
                  w,
                  h,
                  trow,
                  tcol,
                  ci,
                  cj        
         );

         if (rc != HMPI_OK)
         {
            printf("Test failed\n");
         }
         else
         {
            printf("Test PASSED\n");
            HMPI_Print_rectangle_2d(
                 p,
                 q,
                 m,
                 n,
                 w,
                 h,
                 trow,
                 tcol,
                 ci,
                 cj        
            );
         }

         free(w);
         free(h);
         free(trow);
         free(tcol);
         free(ci);
         free(cj);
      }

      return 0;
   }
