
    #include "mxm_i.h"

    #include <math.h>

    int GetStripes
    (
        int p,
        int n,
        int *bounds,
        int *np 
    )
    {
        int i, j, k, sum = 0;
        double *npp;

        npp = (double*)malloc(
                       sizeof(double)
                       *
                       p
        );

        if (npp == NULL)
        {
           printf("Can't allocate npp in Function Get_stripes\n");
           return -1;
        }
 
        for (i = 0; i < p; i++)
        {
            npp[i] = (double)(np[i])
                     /
                     (double)n;
        }

        for (i = 0; i < p; i++)
        {
            sum += floor(npp[i]);
        }

        if (sum == n)
        {
           for (i = 0; i < p; i++)
           {
               np[i] = floor(npp[i]);
           }

           return HMPI_OK;           
        }

        for (k = 0; k < p; k++)
        {
            for (i = 0; i < p; i++)
            {
                int flr = floor(npp[i]);
                int tmp = flr*n;

                if (tmp >= bounds[i])
                {
                   continue;
                }

                npp[i] = npp[i] + 1;

                flr = floor(npp[i]);
                tmp = flr*n;

                if (tmp >= bounds[i])
                {
                   npp[i] = npp[i] - 1;
                   continue;
                }

                sum = 0;

                for (j = 0; j < p; j++)
                {
                    sum += floor(npp[j]);
                }

                if (sum == n)
                {
                   break;
                }
            }

            sum  = 0;

            for (i = 0; i < p; i++)
            {
                sum += floor(npp[i]);
            }

            if (sum == n)
            {
               break;
            }
        }

        for (i = 0; i < p; i++)
        {
            np[i] = floor(npp[i]);
        }

        free(npp);

        return HMPI_OK;
    }

    int InitializeMatrices
    (
        int n,
        double *a,
        double *b,
        double *c 
    )
    {
        int i;

        for (i = 0; i < n; i++)
        {
            a[i] = MXM_CONSTANT_NUMBER;
            b[i] = MXM_CONSTANT_NUMBER;            
            c[i] = 0.0;
        }

        return HMPI_OK; 
    }

    int GetPivotProcessor
    (
        int prow,
        int n,
        int p,
        int *np
    )
    {
        int i, j;
        int *cumnp = (int*)malloc(
                           sizeof(int)
                           *
                           (p+1)
        );

        if (cumnp == NULL)
        {
           printf("Can't allocate cumnp in Function GetPivotProcessor\n");
           return -1;
        }

        for (i = 0; i <= p; i++)
        {
            cumnp[i] = 0;
            for (j = 0; j < i; j++)
            {
                cumnp[i] += np[j];
            }
        }
        
        for (i = 0; i < p; i++)
        {
           if ((prow >= cumnp[i])
               && (prow < cumnp[i+1]
              )
           )
           {
              free(cumnp);
              return i;
           }
        }

        free(cumnp);

        return -1; 
    }
