
  #include <stdio.h>
  #include <math.h>
  #include <sys/time.h>

  #include "Load_balance.c"
  #include "mxm_i.c"

  int main
  (
     int argc,
     char** argv
  )
  {
     int i, rc, rank, size;
     int color = 0;
     struct timeval start, end;
     struct timeval startb, endb;

     gettimeofday(&start, NULL);

     {
        rc = MPI_Init(&argc, &argv);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems initializing MPI "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -1);
        }
     }

     {
        rc = MPI_Comm_rank(MPI_COMM_WORLD, &rank);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems getting rank "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -2);
        }
     }

     {
        rc = MPI_Comm_size(MPI_COMM_WORLD, &size);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems getting size of MPI_COMM_WORLD "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -3);
        }
     }

     if ((rank == (size - 1))
         || (rank >= (p*q))
     )
     {
        color = MPI_UNDEFINED;
     }

     rc = MPI_Comm_split(
             MPI_COMM_WORLD,
             color,
             rank,
             &algo_comm
     );

     if (rc != MPI_SUCCESS)
     {
        printf("Problems with MPI_Comm_split for MPI_COMM_WORLD\n");

        MPI_Abort(MPI_COMM_WORLD, -4);
     }

     if (rank == (size - 1))
     {
        MPI_Finalize();
        return 0;
     }

     if ((rank != (size - 1))
         && (rank < (p*q))
     )
     {
        double tstart, tend;

        rc = MPI_Comm_rank(algo_comm, &algo_comm_rank);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems getting algo comm rank "
              "...Exiting...\n"
           );

           MPI_Abort(algo_comm, -5);
        }

        gettimeofday(&startb, NULL);

        for (i = 0; i < BARRIER_ITERATIONS; i++)
        {
           rc = MPI_Barrier(algo_comm);

           if (rc != MPI_SUCCESS)
           {
              return rc;
           }
        }

        gettimeofday(&endb, NULL);

        tstart = startb.tv_sec + (startb.tv_usec/pow(10, 6));
        tend = endb.tv_sec + (endb.tv_usec/pow(10, 6));

        /*
         * There is a barrier at the end
         */
        barrier_time = (tend - tstart)/(BARRIER_ITERATIONS+1);

        rc = Execute_algorithm(&algo_comm);

        if (rc != MPI_SUCCESS)
        {
           printf(
              "MAIN:Problems multiplying the matrices A and B "
              "...Exiting...\n"
           );

           MPI_Abort(MPI_COMM_WORLD, -6);
        }

        rc = MPI_Barrier(algo_comm);

        if (rc != MPI_SUCCESS)
        {
           return rc;
        }

        rc = MPI_Comm_free(
                &algo_comm
        );

        if (rc != MPI_SUCCESS)
        {
           return rc;
        }
     }

     gettimeofday(&end, NULL);

     /*
      * Print computation and communication times
      * Print Execution time
      */
     printf(
        "Process %d, computation time=%0.10f, communication_time=%0.10f\n",
        rank,
        computation_time,
        communication_time
     );    

     /*
      * Record the final time and record the elapsed time.
      */
     if (rank == 0)
     {
        double tstart = start.tv_sec + (start.tv_usec/pow(10, 6));
        double tend = end.tv_sec + (end.tv_usec/pow(10, 6));
        double elapsed_time = (tend
                               - tstart
                               - barrier_time
        );

        printf(
           "N=%d, p=%d, q=%d, r=%d, grow=%d, gcol=%d, time(sec)=%0.6f\n",
           N,
           p,
           q,
           r,
           generalised_block_size_row,
           generalised_block_size_col,
           elapsed_time
        );
     }

     MPI_Finalize();

     return 0;
  }
