
  #ifndef _MXM_HH
  #define _MXM_HH

  #include "counter.h"
  #include "ParallelAxB.h"

  #define  recon_n  200
  #define  recon_r  50
  #define  recon_t  20

  /*
   * Verbosity of diagnostics
   */
  static int VERBOSE = 0;

  /*
   * Constant number for MXM multiplication.
   * All the matrix elements are initialized to
   * this number.
   */
  #define  MXM_CONSTANT_NUMBER (double)(2.00)

  /*
   * Matrices for recon
   */
  static double *a, *b, *c;

  /*
   * Matrices used for multiplication.
   */
  static double *A, *B, *C;

  static int n;

  static int *row_allocations;
  static int *column_allocations;

  static int istart = 0;
  static int myialloc = 0; 
  static int jstart = 0;
  static int myjalloc = 0;

  static int number_of_generalized_blocks_row;
  static int number_of_generalized_blocks_col;

  static int myalloc;

  static int Optimal_generalised_block_size_row = 0;
  static int Optimal_generalised_block_size_col = 0;

  /*
   * Global barrier time
   */
  static double barrier_time = 0;
  #define BARRIER_ITERATIONS 10

  static int (*Generalised_block)[2];
  static int *h;
  static int *w;
  static int *trow;
  static int *tcol;

  static int HMPI_Is_recon_required = 1;

  #define HMPI_MSG_TAG  0xff

  /*************************************************
   *                                               *
   *            HELPER FUNCTIONS                   *
   *                                               *
   *************************************************/

  /*
   * Create the net and start multiplying.
   */
  int Execute_algorithm();

  /*
   * Perform the mxm multiplication
   */
  int Perform_mxm
  (
     const HMPI_Group *gid
  );

  /*
   * The routine that creates the 2-D grid network 
   * of processors which are used for matrix 
   * multiplication.
   */
  int
  mxm
  (
     const HMPI_Group *gid,
     const int* my_coordinates,
     double *a,
     double *b,
     double *c
  );

  /*
   * Uses row and column communicators instead 
   * of subnets.
   * This routine has to be enhanced to take into
   * account the granularity.
   */
  int
  Grid_computations
  (
     const HMPI_Group *gid,
     const int* my_coordinates,
     double *a,
     double *b,
     double *c
  );

  int Common_height
  (
      int top_row_1,
      int bottom_row_1,
      int top_row_2,
      int bottom_row_2
  );

  int Determine_distribution_parameters
  (
      int p,
      int q,
      const int *row_allocations,
      const int *column_allocations,
      int *w,
      int *h,
      int *trow,
      int *tcol
  );

  int Distribute_load
  (
      int p,
      int q,
      const int *perf,
      int Generalised_block_size_row,
      int Generalised_block_size_column,
      int *row_allocations,
      int *column_allocations
  );

  int
  Do_recon();

  int Perf_func
  (
      int x,
      int y,
      int z
  );

  int
  Input_recon
  (
     double *a,
     double *b,
     double *c
  );

  void Benchmark_function
  (
     const void* input_p,
     int num_of_p,
     void* output_p
  );

  #endif /* _MXM_HH */
