
  #ifndef _MXM_HH
  #define _MXM_HH

  #include <math.h>

  #include "counter.h"
  #include "ParallelAxB.h"

  #define  recon_n  32
  #define  recon_r  32
  #define  recon_t  32

  /*
   * Verbosity of diagnostics
   */
  static int VERBOSE = 0;

  /*
   * Constant number for MXM multiplication.
   * All the matrix elements are initialized to
   * this number.
   */
  #define  MXM_CONSTANT_NUMBER (double)(2.00)

  /*
   * Matrices for recon
   */
  static double *a, *b, *c;

  /*
   * Matrices used for multiplication.
   */
  static double *A, *B, *C;

  static int *row_allocations;
  static int *column_allocations;

  static int istart = 0;
  static int myialloc = 0; 
  static int jstart = 0;
  static int myjalloc = 0;

  static int number_of_generalized_blocks_row;
  static int number_of_generalized_blocks_col;

  static int myalloc;

  /*
   * Global barrier time
   */
  static double barrier_time = 1;
  #define  BARRIER_ITERATIONS  5

  /*
   * Is recon required
   * Not required when you know the performances of the 
   * processors and network is stable
   */
  static int HMPI_Is_recon_required = 0;

  static int (*Generalised_block)[2];
  static int *h;
  static int *w;
  static int *trow;
  static int *tcol;

  #define HMPI_MSG_TAG  0xff

  /*************************************************
   *                                               *
   *            HELPER FUNCTIONS                   *
   *                                               *
   *************************************************/

  /*
   * Create the group and start multiplying.
   */
  int Execute_algorithm();

  /*
   * Perform the mxm multiplication
   */
  int Perform_mxm
  (
     const HMPI_Group* gid
  );

  int
  mxm
  (
     const HMPI_Group* gid,
     const int* my_coordinates,
     double *a,
     double *b,
     double *c
  );

  int
  Grid_computations
  (
     const HMPI_Group* gid,
     const int* my_coordinates,
     double *a,
     double *b,
     double *c
  );

  int 
  Do_recon();

  int Get_number_of_elements_to_be_transferred
  (
      int top_row_1,
      int bottom_row_1,
      int top_row_2,
      int bottom_row_2,
      int width_1
  );

  int Determine_distribution_parameters
  (
      int p,
      int q,
      const int *row_allocations,
      const int *column_allocations,
      int *w,
      int *h,
      int *trow,
      int *tcol
  );

  int Distribute_load
  (
      int p,
      int q,
      const int *perf,
      int Generalised_block_size_row,
      int Generalised_block_size_column,
      int *row_allocations,
      int *column_allocations
  );

  int Perf_func
  (          
      int x,
      int y,
      int z
  ); 
     
  int    
  Input_recon
  (          
     double *a,
     double *b,
     double *c
  );

   void Benchmark_function
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   );

    int
    GetMyWidth
    (
       int i,
       int p,
       int q,
       const int *speeds,
       int g_x,
       int g_y
    );

    int
    GetMyHeight
    (
       int i,
       int j,
       int k,
       int l,
       int p,
       int q,
       const int *speeds,
       int g_x,
       int g_y
    );

    int GetPartitions
    (
       int p,
       int q,
       int g_x,
       int g_y,
       const int *speeds,
       int *w,
       int *h
    );

  int Common_height
  (
      int top_row_1,
      int bottom_row_1,
      int top_row_2,
      int bottom_row_2
  );


  #endif /* _MXM_HH */

