
  #ifndef _MXM_HH
  #define _MXM_HH

  #include "counter.h"

  #define  recon_n  16
  #define  recon_r  16
  #define  recon_t  16

  /*
   * Verbosity of diagnostics
   */
  static int VERBOSE = 1;

  /*
   * Constant number for MXM multiplication.
   * All the matrix elements are initialized to
   * this number.
   */
  #define  MXM_CONSTANT_NUMBER (double)(2.00)

  /*
   * Matrices for recon
   */
  static double *a, *b, *c;

  /*
   * Matrices used for multiplication.
   */
  static double *A, *B, *C;

  static int n;

  static int *row_allocations;
  static int *column_allocations;

  static int Optimal_generalised_block_size = 0;

  static int istart = 0;
  static int myialloc = 0; 
  static int jstart = 0;
  static int myjalloc = 0;

  /*
   * Global barrier time
   */
  static double barrier_time = 0;
  #define  BARRIER_ITERATIONS  5

  /*
   * Is recon required
   * Not required when you know the performances of the 
   * processors and network is stable
   */
  static int HMPI_Is_recon_required = 1;

  static int (*Generalised_block)[2];
  static int *h;
  static int *w;
  static int *trow;

  #define HMPI_MSG_TAG  0xff

  /*************************************************
   *                                               *
   *            HELPER FUNCTIONS                   *
   *                                               *
   *************************************************/

  /*
   * Create the group and start multiplying.
   */
  int Execute_algorithm();

  /*
   * Perform the mxm multiplication
   */
  int Perform_mxm
  (
     const HMPI_Group* gid
  );

  int
  mxm
  (
     const HMPI_Group* gid,
     double *a,
     double *b,
     double *c
  );

  int
  Grid_computations
  (
     const HMPI_Group* gid,
     const int* my_coordinates,
     double *a,
     double *b,
     double *c
  );

  int 
  Do_recon();

  int Get_number_of_elements_to_be_transferred
  (
      int top_row_1,
      int bottom_row_1,
      int top_row_2,
      int bottom_row_2,
      int width_1
  );

  int Determine_distribution_parameters
  (
      int p,
      const int *row_allocations,
      const int *column_allocations,
      int *w,
      int *h,
      int *trow
  );

  int Distribute_load
  (
      int p,
      const int *perf,
      int Generalised_block_size,
      int *row_allocations,
      int *column_allocations
  );

  int Perf_func
  (          
      int x,
      int y,
      int z
  ); 
     
  int    
  Input_recon
  (          
     double *a,
     double *b,
     double *c
  );

   void Benchmark_function
   (
      const void* input_p,
      int num_of_p,
      void* output_p
   );

  #endif /* _MXM_HH */

