

/* vec.h - Routines to handle vectors.
 */

#ifndef VEC 
#define VEC 1

#include "errors.h"
 /* We return package standard error codes. */

/* What does a matrix look like? */
typedef double vector[];

/* --------------   Routines    ---------------------------- */
/* Note that input and output vectors CAN be the same.
 * So you can scale a vector with: vecscl (6, A, A, scale)
 *
 * All routines in this package can return
 * ERRnil  - You can't pass a nil pointer for a vector.
 * ERRsize - You have to have a positive size for a vector.
 * 
 * In addition, vecscl  and vecadds can return
 * ERRmeaning - Scaling by zero is not meaningful.
 *    (Although they will do the scale anyway)
 */


/* Set a vector to zeros. */
extern error veczero (int size, vector result);

/* Copy */
   /* regular */
extern error veccpy (int size, vector result, vector source);
   /* Swap */
extern error vecswp (int size, vector result, vector source);

/* Scale a vector */
extern error vecscl (int size, vector result, vector given, double scalar);
/* Scale factor must be non-zero.  (ERRmeaning) */

/* Add vectors */
    /* regular */
extern error vecadd (int size, vector result, vector A, vector B);
extern error vecsub (int size, vector result, vector A, vector B);
    /* scaled */
extern error vecadds(int size, vector result, vector A, vector B, double scale);

/* Dot product */
extern error vecdot (int size, double *result, vector A, vector B);

#endif
/* ========================================================================== */
