#ifndef __SIMPLE_GRID_HH
#define __SIMPLE_GRID_HH

#include "hmpi.h"

/* Net type simpleGrid declaration */
extern HMPI_NetType HMPI_NetType_simpleGrid;

int HMPI_NetType_simpleGrid_node 
(
    int pnum,
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
);

int HMPI_NetType_simpleGrid_link 
(
    int pnum1,
    int pnum2,
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
);

int HMPI_NetType_simpleGrid_parent
(
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
);

int HMPI_NetType_simpleGrid_power
(
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
);

void HMPI_NetType_simpleGrid_number2coord
(
     int pnum,
     const int *ppar,
     int *pcoord,
     int ppower,
     int **pnodes,
     int **plinks
);

int HMPI_NetType_simpleGrid_coord2number
(
    const int *pcoord,
    const int *ppar,
    int ppower,
    int **pnodes,
    int **plinks
);

#endif /* __SIMPLE_GRID_HH */
