/* qinv.h - Header file for some quick matrix inverse routines.
 */

#ifndef QINV
#define QINV 1

/* We use the package wide error codes. */
#include "errors.h" 

/* We make use of the matrix package */
#include "mat.h"

/* Inverse of a positive definite matrix. result and given must be
 * distinct arrays.
 * This inverse doesn't attempt pivoting.
 */
extern error invpd (int size, matrix result, matrix given, matrix working);
  /* result and working must be distinct arrays */


/* Inverse of a non-singular matrix.  (attempts pivoting) */
extern error invns (int size, matrix result, matrix given, matrix working);
  /* result and working must be distinct arrays. */
#endif

