
  #ifndef _CHOLESKY_HH
  #define _CHOLESKY_HH

  #include "counter.h"

  #define  recon_n  64

  /*
   * Verbosity of diagnostics
   */
  static int VERBOSE = 0;

  /*
   * Constant number for CHOLESKY Factorization.
   * All the matrix elements are initialized to
   * this number.
   */
  #define  CHOLESKY_CONSTANT_NUMBER (10.00)

  static int n = 0;

  /*
   * Matrices used for recon CHOLESKY Factorization.
   */
  static double *a;

  /*
   * Matrices used for CHOLESKY Factorization.
   */
  static double *A;

  /*
   * Heterogeneous row and column distributions
   * The block panel that is cyclically block
   * distributed shouldn't have more than this
   * number rows and columns each.
   */
  static int *row_allocations;
  static int *column_allocations;

  static int (*Generalised_block)[2];

  static int istart = 0;
  static int myialloc = 0; 
  static int jstart = 0;
  static int myjalloc = 0;

  /*
   * Global barrier time
   */
  static double barrier_time = 0;
  #define BARRIER_ITERATIONS 10

  /*
   * Is recon required
   * Not required when you know the performances of the 
   * processors and network is stable
   */
  static int HMPI_Is_recon_required = 0;

  #define HMPI_MSG_TAG  0xff

  /*************************************************
   *                                               *
   *            HELPER FUNCTIONS                   *
   *                                               *
   *************************************************/

  /*
   * Create the net and start multiplying.
   */
  int Execute_algorithm();

  /*
   * Perform the mxm multiplication
   */
  int Perform_cholesky
  (
     const HMPI_Group* nid
  );

  /*
   * The routine that creates the 2-D grid network 
   * of processors which are used for matrix 
   * multiplication.
   */
  int
  cholesky
  (
     const HMPI_Group* nid,
     double *a
  );

  /*
   * Uses row and column communicators instead 
   * of subnets.
   * This routine has to be enhanced to take into
   * account the granularity.
   */
  int
  Grid_computations
  (
     const HMPI_Group* nid,
     const int* my_coordinates,
     double *a
  );

  int 
  Do_recon();

  int
  LowerCholesky
  (
    int num,
    double *l11
  );

  int     
  Distribute_load
  (
     int p,      
     int q,      
     const int *perf,
     int generalised_block_size_row,
     int generalised_block_size_column,
     int *row_allocations,
     int *column_allocations
  );       

  typedef struct {int i; int j;} Block;

  void
  GetBlock(int x, int y, Block *b);

  void
  GetProcessor(Block *b, Processor *p);

  int Perf_func
  (
      int x
  );

  void Benchmark_function
  (
     const void* input_p,
     int num_of_p,
     void* output_p
  );

  #endif /* _CHOLESKY_HH */
