
  #include "HMPI_em3d.h"

  void
  Construct_recon_params
  (
     int rk,
     Body *rb
  )
  {
     int i, j;

     for (i = 0; i < rk; i++)
     {
        rb->nnum = rk;

        if (i && (i%2))
        {
           rb->ntype = H;
        }
        else
        {
           rb->ntype = E;
        }

        rb->value = 10000000.00;
        rb->edge_count = RECON_NEDGES;
        rb->dbodies = NULL;
        rb->dnodes = NULL;

        rb->coeffs = (double*)malloc(
                              sizeof(double)
                              *
                              rb->edge_count
        );

        if (rb->coeffs == NULL)
        {
           printf("Can't allocate memory(Recon coefficients), hostname is %s\n", hostName); 
	   HMPI_Finalize(-16);
        }

        rb->values = (double*)malloc(
                              sizeof(double)
                              *
                              rb->edge_count
        );

        if (rb->values == NULL)
        {
           printf("Can't allocate memory(Recon values), hostname is %s\n", hostName); 
	   HMPI_Finalize(-16);
        }

        for (j = 0; j < RECON_NEDGES; j++)
        {
           rb->coeffs[j] = RECON_COEFF_VALUE;
           rb->values[j] = RECON_DEP_VALUE;
        }

        rb->next = (Body*)malloc(sizeof(Body));

        if (rb->next == NULL)
        {
           printf("Can't allocate memory(Recon next), hostname is %s\n", hostName); 
	   HMPI_Finalize(-16);
        }

        rb = rb->next;
     }

     return;
  }

  void
  Destroy_recon_params
  (
     int rk,
     Body *rb
  )
  {
     int i;

     for (i = 0, rb = rb->next; i < rk; i++)
     {
         Body* tmp = rb;
         free(rb->coeffs);
         free(rb->values);
         rb = rb->next;
         free(tmp);
     }

     return;
  }

  void
  Serial_em3d
  (
     const void *reconp,
     int num_of_parameters,
     void* outputp
  )
  {
     int i, j;
     Body* rb = (Body*)reconp;

     for (i = 0; i < rb->nnum; i++)
     {
         for (j = 0; j < rb->edge_count; j++)
         {
            rb->value -= (rb->values[j])*(rb->coeffs[j]);
         }
         rb = rb->next;
     }

     *(int*)outputp = 0;

     return;
  }
