
  int
  Construct_model_params(
     int p,
     const double *perf,
     int *d,
     int *dep
  )
  {
     int i, j, k;
     
     for (i = 0; i < p; i++)
     {
         d[i] = (HMPI_NUM_NODES)*perf[i];
     }

     for (i = 0; i < p*p; i++)
     {
         dep[i] = dependencies[i];
     }

     return HMPI_OK;
  }

  int Print_dependencies(int p, int me)
  {
     int i, j, k;
     int dep[p*p];
     int numbodies;
    
     if ((me == 0) || (me == (p-1)))
     {
        numbodies = 2;
     }
     else
     {
        numbodies = 3;
     }

     printf("Me=%d, My dependencies are: \n", me);

     for (i = 0; i < p*p; i++)
     {
         dep[i] = 0;
     }

     for (i = 0; i < numbodies; i++)
     {
         Body* b = bodies[i];

         for (j = 0; j < b->nnum; j++)
         {
             for (k = 0; k < b->edge_count; k++)
             {
                 int tmp = b->dbodies[k];
                 if (i != tmp)
                 {
                    dep[i*p + tmp]++;
                 }
             }
             b = b->next;
         }
     }

     printf("dep[]:\n");
     for (i = 0; i < numbodies; i++)
     {
         for (j = 0; j < numbodies; j++)
         {
             printf("%d, ", dep[i*p + j]);
         }
         printf("\n");
     }
     printf("\n");

     return 0;
  }

  int
  Dependency
  (
    int nedges,
    int *proc,
    int me
  )
  {
    int i;
    for (i = 0; i < nedges; i++)
    {
       if (proc[i] == me)
       {
          return 1;
       }
    }
    return 0;
  }

  double
  GetNodalValue
  (
     int node,
     const Body* b
  )
  {
     Body* n = (Body*)(&((b->next)[node]));
     return n->value;
  }

  int
  Destroy_system
  (
     int p,
     int me
  )
  {
     int i, j;
     int numbodies;
    
     if ((me == 0) || (me == (p-1)))
     {
        numbodies = 2;
     }
     else
     {
        numbodies = 3;
     }

     for (i = 0; i < numbodies; i++)
     {
         int tnum;
         Body* b = bodies[i];
         tnum = b->nnum;

         for (j = 0; j < tnum; j++)
         {
             Body* tmp = b;
             free(b->coeffs);
             free(b->values);
             free(b->dbodies);
             free(b->dnodes);
             b = b->next;
             free(tmp);
         }
     }

     free(bodies);

     return HMPI_OK;
  }

  int
  Print_body
  (
     int bn
  )
  {
     int i, j, k;
     Body* b = bodies[bn];
 
     {
         printf("========BODY%d, NODES=%d========\n\n", bn, b->nnum);
         for (j = 0; j < b->nnum; j++)
         {
             printf("****Node=%d****\n", j);
             for (k = 0; k < b->edge_count; k++)
             {
                 printf("edge=%d, proc=%d, dnode=%d\n", k, b->dbodies[k], b->dnodes[k]);
             }
             b = b->next;
         }
     }

     return HMPI_OK;
  }

  int
  Initialize_system
  (
     int me,
     int p,
     const double *perf
  )
  {
     int i, j, k, start, ind, kind, numbodies;
     Body *b;

     if ((me == 0) || (me == (p-1)))
     {
        numbodies = 2;
     }
     else
     {
        numbodies = 3;
     }

     bodies = (Body**)malloc(
                      sizeof(Body*)
                      *
                      numbodies
     );

     if (bodies == NULL)
     {
        printf("Can't allocate memory(Alloc bodies) hostname is %s\n", hostName);
        return -1;
     }

     for (i = 0; i < numbodies; i++)
     {
         bodies[i] = (Body*)malloc(
                            sizeof(Body)
         );

         if (bodies[i] == NULL)
         {
            printf("Can't allocate memory(Alloc body) hostname is %s\n", hostName);
            return -1;
         }
     }

     if (me == 0)
     {
        for (i = 0; i < numbodies; i++)
        {
            b = bodies[i];
            b->nnum = (HMPI_NUM_NODES)*(perf[i]);
        }
     }

     if (me > 0)
     {
        for (i = 0; i < numbodies; i++)
        {
            b = bodies[i];
            b->nnum = (HMPI_NUM_NODES)*(perf[me - 1 + i]);
        }
     }

     dependencies = (int*)malloc(
                          sizeof(int)
                          *
                          (p*p)
     );

     if (dependencies == NULL)
     {
        printf("Can't allocate dependencies; hostname is %s\n", hostName);
        return -1;
     }

     for (i = 0; i < (p*p); i++)
     {
        dependencies[i] = 0;
     }

     if (me == 0)
     {
        start  = 0;
     }

     if (me > 0)
     {
        start  = me - 1;
     }

     for (i = 0; i < p; i++)
     {
         if (i == 0)
         {
            for (j = 0; j < 2; j++)
            {
               dependencies[j] = RECON_NEDGES/2;
            }
         }

         if (i == (p-1))
         {
            for (j = 0; j < 2; j++)
            {
               dependencies[(p-1)*p + p - 2 + j] = RECON_NEDGES/2;
            }
         }

         if (i == 1)
         {
            dependencies[p + 0] = RECON_NEDGES/2;
            dependencies[p + 2] = RECON_NEDGES/3;
            dependencies[p + 1] = RECON_NEDGES - (dependencies[p+0] + dependencies[p+2]);
         }

         if (i == (p-2))
         {
            dependencies[(p-2)*p + p - 3] = RECON_NEDGES/3;
            dependencies[(p-2)*p + p - 1] = RECON_NEDGES/2;
            dependencies[(p-2)*p + p - 2] = RECON_NEDGES - (dependencies[(p-2)*p+p-1] + dependencies[(p-2)*p+p-3]);
         }

         if ((i > 1) && (i < (p-2)))
         {
            for (j = 0; j < 3; j++)
            {
               dependencies[i*p + i - 1 + j] = RECON_NEDGES/3;
            }
         }
     }

     if (me == 0)
     {
        for (i = 0; i < p; i++)
        {
            int ti, di;

            ti = (HMPI_NUM_NODES)*(perf[i]);
            Total_number_of_nodes += ti;

            for (j = 0, di = 0; j < p; j++)
            {
               if (j != i)
               {
                  di += dependencies[i*p + j];
               }
            }

            Total_number_of_dependencies += di*ti;
        }
     }

     if ((HMPI_Is_host())
         && (VERBOSE > 0
        )
     )
     
     {
        for (i = 0; i < p; i++)
        {
           for (j = 0; j < p; j++)
           {
               printf("%d ", dependencies[i*p + j]);
           }

           printf("\n");
        }
     }

     for (i = 0; i < numbodies; i++)
     {
	 int tnum;
         b = bodies[i];
         tnum = b->nnum;

         for (j = 0; j < tnum; j++)
         {
             b->nnum = tnum;
             b->value = 10000000.00;
             b->edge_count = RECON_NEDGES;

             if (j && (j%2))
             {
                b->ntype = H;               
             }
             else
             {
                b->ntype = E;
             }

             b->coeffs = (double*)malloc(
                                  sizeof(double)
                                  *
                                  b->edge_count
             );

             if (b->coeffs == NULL)
             {
                printf("Can't allocate memory(Alloc coeffs) hostname is %s\n", hostName);
                return -1;
             }

             b->dbodies = (int*)malloc(
                                sizeof(int)
                                *
                                b->edge_count
             );

             if (b->dbodies == NULL)
             {
                printf("Can't allocate memory(Alloc dbodies) hostname is %s\n", hostName);
                return -1;
             }

             b->dnodes = (int*)malloc(
                               sizeof(int)
                               *
                               b->edge_count
             );

             if (b->dnodes == NULL)
             {
                printf("Can't allocate memory(Alloc dnodes) hostname is %s\n", hostName);
                return -1;
             }

             if (me == 0)
             {
                for (k = 0, kind = 0, ind = 0; k < b->edge_count; k++, kind++)
                {
                    if (kind >= dependencies[i*p + ind])
                    {
                       kind = 0;
                       ind++;
                    }

                    b->dbodies[k] = ind;

                    if (b->ntype == H)
                    {
                       b->dnodes[k] = k*2;
                    }
                    else
                    {
                       b->dnodes[k] = k*2+1;
                    }
                }
             }

             if (me == 1)
             {
                int startx;
                if (i == 0)
                {
                   startx  = 0;
                }

                if (i == 1)
                {
                   startx  = 0;
                }

                if (i == 2)
                {
                   startx  = 1;
                }

                for (k = 0, kind = 0, ind = 0; k < b->edge_count; k++, kind++)
                {
                    if (kind >= dependencies[i*p + startx + ind])
                    {
                       kind = 0;
                       ind++;
                    }

                    b->dbodies[k] = startx + ind;

                    if (b->ntype == H)
                    {
                       b->dnodes[k] = k*2;
                    }
                    else
                    {
                       b->dnodes[k] = k*2+1;
                    }
                }
             }

             if (me > 1)
             {
                for (k = 0, kind = 0, ind = 0; k < b->edge_count; k++, kind++)
                {
                    if (kind >= dependencies[(start+i)*p + start + i - 1 + ind])
                    {
                       kind = 0;
                       ind++;
                    }

                    b->dbodies[k] = start + i - 1 + ind;

                    if (b->ntype == H)
                    {
                       b->dnodes[k] = k*2;
                    }
                    else
                    {
                       b->dnodes[k] = k*2+1;
                    }
                }
             }

             b->values = (double*)malloc(
                                  sizeof(double)
                                  *
                                  b->edge_count
             );

             if (b->values == NULL)
             {
                printf("Can't allocate memory(Alloc values) hostname is %s\n", hostName);
                return -1;
             }

             for (k = 0; k < b->edge_count; k++)
             {
                 b->coeffs[k] = RECON_COEFF_VALUE;
                 b->values[k] = RECON_DEP_VALUE;
             }

             b->next = (Body*)malloc(sizeof(Body));

             if (b->next == NULL)
             {
                printf("Can't allocate memory(Alloc next) hostname is %s\n", hostName);
                return -1;
             }

             b = b->next;
         }
     }

     return HMPI_OK;
  }

  /*-----------------------------------------------------*/

   int
   Translate_from_rank
   (
      int pij,
      MPI_Comm* grid_comm,
      MPI_Comm* local_comm,
      int* root
   )
   {
      MPI_Group grid_group;
      MPI_Group local_group;

      int rc = MPI_Comm_group(
                  *grid_comm,
                  &grid_group
      );

      if (rc != MPI_SUCCESS)
      {
         HMPI_Printf(
             "Problems with getting the group of grid communicator\n"
         );
         return rc;
      }

      rc = MPI_Comm_group(
              *local_comm,
              &local_group
      );

      if (rc != MPI_SUCCESS)
      {
         HMPI_Printf(
             "Problems with getting the group of local communicator\n"
         );
         return rc;
      }

      rc =  MPI_Group_translate_ranks(
               grid_group,
               1,
               &pij,
               local_group,
               root
      );

      if (rc != MPI_SUCCESS)
      {
         HMPI_Printf(
             "Problems with translating ranks, problems with pij\n"
         );
         return rc;
      }

      rc = MPI_Group_free(&grid_group);

      if (rc != MPI_SUCCESS)
      {
         return rc;
      }

      rc = MPI_Group_free(&local_group);

      if (rc != MPI_SUCCESS)
      {
         return rc;
      }

      return HMPI_OK;
   }

  /*-----------------------------------------------------*/

