
  #ifndef _HMPI_EM3D_H
  #define _HMPI_EM3D_H

  #include "counter.h"
  #include "em3d.c"

  #define HOSTNAMELENGTH   1024

  #define VERBOSE            0
  #define HMPI_MSG_TAG       999
  #define BARRIER_ITERATIONS 10

  #define E  0
  #define H  1
  typedef struct _em3d_node_t {
    int nnum;            /* Number of nodes */
    int ntype;           /* Node type: E or H */
    double value;        /* Field value */
    int edge_count;      /* Number of edges */
    double *coeffs;      /* Edge weights */
    int* dbodies;        /* Body dependency list */
    int* dnodes;         /* Dependent nodes in remote bodies */
    double *values;      /* Values of the dependency nodes */
    struct _em3d_node_t *next; /* Link to the next similar node */
  } Body;

  Body** bodies;

  static int RECON_NUM_NODES = 1000;
  static double RECON_COEFF_VALUE = 10.00;
  static double RECON_DEP_VALUE = 100.00;
  static int HMPI_Is_recon_required = 1;

  static char hostName[HOSTNAMELENGTH];
  static int Total_number_of_nodes = 0;
  static int Total_number_of_dependencies = 0;

  static int *dependencies;

  void
  Construct_recon_params
  (
     int rk,
     Body *recon_body
  );

  void
  Destroy_recon_params
  (
     int rk,
     Body *rb
  );

  void
  Serial_em3d
  (
     const void *reconp,
     int num_of_parameters,
     void* outputp
  );

  int
  Dependency
  (
    int negdes,
    int *proc,
    int me
  );

  int
  Initialize_system
  (
     int me,
     int p,
     const double *perf
  );

  int
  Destroy_system(int p, int me);

  int
  Print_dependencies
  (
     int p,
     int me
  );

  double
  GetNodalValue
  (
     int node,
     const Body* b
  );

  int
  Construct_model_params(
     int p,
     const double *perf,
     int *d,
     int *dep
  );

  int
  Translate_from_rank
  (
     int pij,
     MPI_Comm* grid_comm,
     MPI_Comm* local_comm,
     int* root
  );

  #endif
