
   #include <hmpi.h>

   int main
   (
       int argc,
       char **argv
   )
   {
       int gme, gsize;

       HMPI_Init(
           &argc, 
           &argv
       );

       gsize = HMPI_Group_size(HMPI_COMM_WORLD_GROUP);
       gme = HMPI_Group_rank(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          printf(
             "===================================================================\n"
          );
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          int hsize = HMPI_Group_size(HMPI_HOST_GROUP);
          printf(
             "I'm a member of HMPI_HOST_GROUP, My Global rank is %d, Group size is %d\n",
             gme,
             hsize
          );
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          printf(
             "===================================================================\n"
          );
       }

       if (HMPI_Is_member(HMPI_COMM_WORLD_GROUP))
       {
          printf(
             "I'm a member of HMPI_COMM_WORLD_GROUP, My Global rank is %d, Group size is %d\n",
             gme,
             gsize
          );
       }

       HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          printf(
             "===================================================================\n"
          );
       }

       HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_FREE_GROUP))
       {
          int fsize = HMPI_Group_size(HMPI_FREE_GROUP);
          printf(
             "I'm a member of Group of Free Processes HMPI_FREE_GROUP, My Global rank is %d, Group size is %d\n",
             gme,
             fsize
          );
       }

       HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          printf(
             "===================================================================\n"
          );
       }

       HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          printf(
             "===================================================================\n"
          );
       }

       HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_PROC_WORLD_GROUP))
       {
          int fsize = HMPI_Group_size(HMPI_PROC_WORLD_GROUP);
          printf(
             "I'm a member of HMPI_PROC_WORLD_GROUP, My Global rank is %d, Group size is %d\n",
             gme,
             fsize
          );
       }

       HMPI_Barrier(HMPI_COMM_WORLD_GROUP);

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          printf(
             "===================================================================\n"
          );
       }

       HMPI_Finalize(0);      
   }
