
   #include <math.h>
   #include <stdio.h>
   #include <sys/time.h>

   #include <hmpi.h>
   #include "simpleGrid.c"

   int main
   (
       int argc,
       char **argv
   )
   {
       HMPI_Group gid;
       int net_params[2];
       int param_count;

       HMPI_Init(
           &argc, 
           &argv
       );

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          int gsize, p, q;

          param_count = 2;

          gsize = HMPI_Group_size(
                      HMPI_COMM_WORLD_GROUP
          );

          p = q = sqrt(gsize);

          if ((p == 0)
              && (q == 0
             )
          )
          {
             p = q = 1;
          }

          net_params[0] = p;
          net_params[1] = q;

          printf("Total number of processes available for computation is = %d\n", gsize);
          printf("Creating a grid (%d, %d) of processes\n", p, q);
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       if (HMPI_Is_free())
       {
          HMPI_Group_create(
               &gid,
               &HMPI_NetType_simpleGrid,
               net_params,
               param_count
          );
       }

       if (HMPI_Is_host())
       {
          printf("Testing HMPI_Group_rank\n");
       }

       HMPI_Barrier(&gid);

       if (HMPI_Is_member(&gid))
       {
          int grank = HMPI_Group_rank(&gid);
          int globalrank = HMPI_Group_rank(HMPI_COMM_WORLD_GROUP);
          printf(
             "My global rank is %d, My Group rank is %d, My group parameters are (%d, %d), param_count is %d\n",
             globalrank,
             grank,
             net_params[0],
             net_params[1],
             param_count            
          );
       }

       HMPI_Barrier(&gid);

       if (HMPI_Is_host())
       {
          printf("Testing HMPI_Group_topology\n");
       }

       HMPI_Barrier(&gid);

       if (HMPI_Is_member(&gid))
       {
          int nd;
          int *d;

          int rc = HMPI_Group_topology(
                       &gid,
                       &nd,
                       &d
          );

          printf(
             "My global rank is %d, Number of dimensions in the topology=%d, Grid topology=(%d,%d)\n",
             HMPI_Group_rank(HMPI_COMM_WORLD_GROUP),
             nd,
             d[0],
             d[1]
          );

          free(d);
       }

       HMPI_Barrier(&gid);

       if (HMPI_Is_member(&gid))
       {
          HMPI_Group_free(
             &gid
          );
       }

       HMPI_Finalize(0);      
   }
