
   #include <hmpi.h>
   #include "simpleGrid.c"

   int main
   (
       int argc,
       char **argv
   )
   {
       HMPI_Group gid1, gid2;
       int net_params[2];
       int param_count;

       HMPI_Init(
           &argc, 
           &argv
       );

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {  
          int gsize, p, q; 
       
          param_count = 2;
       
          gsize = HMPI_Group_size(
                      HMPI_COMM_WORLD_GROUP
          );   
               
          p = q = sqrt(gsize);
               
          if ((p == 0)
              && (q == 0
             )
          )
          {
             p = q = 1;
          }

          net_params[0] = p;
          net_params[1] = q;

          printf("Total number of processes available for computation is = %d\n", gsize);
          printf("Creating a grid (%d, %d) of processes\n", p, q);
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          HMPI_Group_create(
              &gid1,
              &HMPI_NetType_simpleGrid,
              net_params,
              param_count
          );
       }

       if (HMPI_Is_free())
       {
          HMPI_Group_create(
              &gid1,
              &HMPI_NetType_simpleGrid,
              net_params,
              param_count
          );
       }

       if (HMPI_Is_member(&gid1))
       {
          HMPI_Printf("Group1:Hello, My node rank is %d,"
                     " My Global rank is %d\n ",
                     HMPI_Group_rank(&gid1),
                     HMPI_Group_rank(HMPI_COMM_WORLD_GROUP)
          );
       }

       if (HMPI_Is_member(&gid1))
       {
          HMPI_Group_free(
              &gid1
          );
       }

       if (HMPI_Is_member(HMPI_HOST_GROUP))
       {
          HMPI_Group_create(
              &gid2,
              &HMPI_NetType_simpleGrid,
              net_params,
              param_count
          );
       }

       if (HMPI_Is_free())
       {
          HMPI_Group_create(
              &gid2,
              &HMPI_NetType_simpleGrid,
              net_params,
              param_count
          );
       }

       if (HMPI_Is_member(&gid2))
       {
          HMPI_Printf("Group2:Hello, My node rank is %d,"
                     " My Global rank is %d\n ",
                     HMPI_Group_rank(&gid2),
                     HMPI_Group_rank(HMPI_COMM_WORLD_GROUP)
          );
       }

       if (HMPI_Is_member(&gid2))
       {
          HMPI_Group_free(
              &gid2
          );
       }

       HMPI_Finalize(0);      
   }

