
   #include <math.h>
   #include <stdio.h>
   #include <sys/time.h>

   #include <hmpi.h>
   #include "simpleGrid.c"

   int main
   (
       int argc,
       char **argv
   )
   {
       int i;
       int NUM_OF_NETS = 3;
       HMPI_Group gid[3];
       int net_params[2];
       int param_count;

       HMPI_Init(
           &argc, 
           &argv
       );

       for (i = 0; i < NUM_OF_NETS; i++)
       {
           if (HMPI_Is_member(HMPI_HOST_GROUP))
           {
              int gsize, p, q;
 
              param_count = 2;
 
              gsize = HMPI_Group_size(
                          HMPI_COMM_WORLD_GROUP
              );
 
              p = q = sqrt(gsize);
 
              if ((p == 0)
                  && (q == 0
                 )
              )
              {
                 p = q = 1;
              }
 
              net_params[0] = p;
              net_params[1] = q;
 
              printf("Total number of processes available for computation is = %d\n", gsize);
              printf("Creating a grid (%d, %d) of processes\n", p, q);
           }

           if (HMPI_Is_member(HMPI_HOST_GROUP))
           {
              HMPI_Group_create(
                  &(gid[i]),
                  &HMPI_NetType_simpleGrid,
                  net_params,
                  2
              );
           }

           if (HMPI_Is_free())
           {
              HMPI_Group_create(
                  &(gid[i]),
                  &HMPI_NetType_simpleGrid,
                  net_params,
                  2
              );
           }

           if (HMPI_Is_member(&(gid[i])))
           {
              int grank = HMPI_Group_rank(&(gid[i]));
              int globalrank = HMPI_Group_rank(HMPI_COMM_WORLD_GROUP);
              printf(
                 "My global rank is %d, My Group rank is %d, My group parameters are (%d, %d), param_count is %d\n",
                 globalrank,
                 grank,
                 net_params[0],
                 net_params[1],
                 param_count
              );
           }

           if (HMPI_Is_member(&(gid[i])))
           {
              HMPI_Group_free(
                  &(gid[i])
              );
           }
       }
       
       HMPI_Finalize(0);      
   }

