/* Necessary functions */
extern double sqrt(double);
 
/* Necessary macroses */
#define Mpc_sqrt sqrt

/* Variable names macroces */

#define CYCLE_TIME_M "Mpc_tcycle"
#define MEMLEVELS_M "Mpc_memlevels"
#define L1CACHE_LEVEL_M "Mpc_L1CACHE_LEVEL"
#define MAINMEMORY_LEVEL_M "Mpc_MAIN_MEMORY_LEVEL"
#define READ_TIME_M "Mpc_tread"
#define WRITE_TIME_M "Mpc_twrite"
#define BLOCK_TIME_M "Mpc_block"
#define OPER_TIME_M "Mpc_toper"

/* Base C types */

#define MAX_TYPES 16

# define    Mpc_NO_TYPE          0   
# define    Mpc_VOID             1
# define    Mpc_CHAR             2
# define    Mpc_SIGNED_CHAR      3
# define    Mpc_UNSIGNED_CHAR    4
# define    Mpc_SHORT            5
# define    Mpc_UNSIGNED_SHORT   6
# define    Mpc_INT              7
# define    Mpc_UNSIGNED         8
# define    Mpc_LONG             9
# define    Mpc_UNSIGNED_LONG    10
# define    Mpc_FLOAT            11
# define    Mpc_DOUBLE           12
# define    Mpc_LONG_DOUBLE      13

/* C[] operators */

#define MAX_OPERS 64

#define   Mpc_NO_OPERATOR          0     /*  empty   */
#define   Mpc_VECT_CONCAT          1     /*   <+> ------------------------   */
#define   Mpc_VECT_EVAL            2     /*   [#] ------------------------   */
#define   Mpc_VECT_VALUE           3     /*  {[ ]} -----------------------   */
#define   Mpc_BRACKETS             4     /*    []    */
#define   Mpc_INDEX                5     /* op1[op2] */
#define   Mpc_GRID                 6     /*   [:] ------------------------   */
#define   Mpc_DOT                  7     /*    .     */
#define   Mpc_ARROW                8     /*    ->    */
#define   Mpc_POST_INC             9     /*   op++   */
#define   Mpc_POST_DEC            10     /*   op--   */
#define   Mpc_PRE_INC             11     /*   ++op   */
#define   Mpc_PRE_DEC             12     /*   --dec  */
#define   Mpc_ADDRESS             13     /*    &     */
#define   Mpc_STAR                14     /*    *     */
#define   Mpc_NEG                 15     /*   -op    */
#define   Mpc_NOT                 16     /*    ~     */
#define   Mpc_LOG_NOT             17     /*    !     */
#define   Mpc_MULT                21     /*    *     */
#define   Mpc_DIV                 22     /*    /     */
#define   Mpc_MOD                 23     /*    %     */
#define   Mpc_MAX                24      /*    ?>    */
#define   Mpc_MIN                25      /*    ?<    */
#define   Mpc_PLUS                26     /*    +     */
#define   Mpc_MINUS               27     /*    -     */
#define   Mpc_LEFT_SHIFT          28     /*    <<    */
#define   Mpc_RIGHT_SHIFT         29     /*    >>    */
#define   Mpc_LESS_THEN           30     /*    <     */
#define   Mpc_GREAT_THEN          31     /*    >     */
#define   Mpc_LESS_OR_EQ          32     /*    <=    */
#define   Mpc_GREAT_OR_EQ         33     /*    >=    */
#define   Mpc_EQUAL               34     /*    ==    */
#define   Mpc_NOT_EQUAL           35     /*    !=    */
#define   Mpc_AND                 36     /*    &     */
#define   Mpc_EXCL_OR             37     /*    ^     */
#define   Mpc_INCL_OR             38     /*    |     */
#define   Mpc_LOG_AND             39     /*    &&    */
#define   Mpc_LOG_OR              40     /*    ||    */
#define   Mpc_CONDITION           41     /*    ?:    */
#define   Mpc_ASSIGN              42     /*    =     */
#define   Mpc_MULT_ASSIGN         43     /*    *=    */
#define   Mpc_DIV_ASSIGN          44     /*    /=    */
#define   Mpc_MOD_ASSIGN          45     /*    %=    */
#define   Mpc_PLUS_ASSIGN         46     /*    +=    */
#define   Mpc_MINUS_ASSIGN        47     /*    -=    */
#define   Mpc_LSHIFT_ASSIGN       48     /*    <<=   */
#define   Mpc_RSHIFT_ASSIGN       49     /*    >>=   */
#define   Mpc_AND_ASSIGN          50     /*    &=    */
#define   Mpc_EXCL_OR_ASSIGN      51     /*    ^=    */
#define   Mpc_INCL_OR_ASSIGN      52     /*    |=    */
#define   Mpc_COMMA               53     /*    ,     */

