#ifndef MPC_macro
#define MPC_macro

#define MPC_Subnet_create_prologue(ParentNet)\
int MPC_ind=0, MPC_sub_pow=0, MPC_co[1024]; \
int* MPC_old_coord=ParentNet.coord; \
int* MPC_map; \
MPC_map=MPC_Malloc(ParentNet.power*sizeof(int)); \
ParentNet.coord=MPC_co; \

#define MPC_Subnet_create_not_flexible_epilogue(Net,ParentNet)\
ParentNet.coord=MPC_old_coord;\
if(MPC_sub_pow) {\
  MPC_map=MPC_Realloc(MPC_map,MPC_sub_pow*sizeof(int));\
  Net.mapping=MPC_map;\
  Net.power=MPC_sub_pow;\
  MPC_Subnet_create(&Net,MPC_NOT_FLEXIBLE);\
}\
else {\
  MPC_Warning_raise("Empty subnet");\
}\

#define MPC_Subnet_create_flexible_epilogue(Net,ParentNet)\
ParentNet.coord=MPC_old_coord;\
if(MPC_sub_pow) {\
  MPC_map=MPC_Realloc(MPC_map,MPC_sub_pow*sizeof(int));\
  Net.mapping=MPC_map;\
  Net.power=MPC_sub_pow;\
  MPC_Subnet_create(&Net,MPC_FLEXIBLE);\
}\
else {\
  MPC_Warning_raise("Empty subnet");\
}\

#define MPC_ManyToMany_assign_sender_prologue(ParentNet)\
int MPC_ind=0, MPC_co[1024]; \
int MPC_own_send_num=0, MPC_recv_num=0; \
int MPC_recv_index; \
int* MPC_old_coord=ParentNet.coord; \
ParentNet.coord=MPC_co; \
for(; MPC_ind<ParentNet.power; MPC_ind++) { \
  MPC_Coord_set(&ParentNet,MPC_ind); \

#define MPC_ManyToMany_assign_middle_part(ParentNet)\
} \
for(MPC_ind=0; MPC_ind<ParentNet.power; MPC_ind++) { \
   MPC_Coord_set(&ParentNet,MPC_ind); \

#define MPC_ManyToMany_assign_sender_epilogue(ParentNet)\
 if(MPC_recv_num==MPC_own_send_num) break; \
} \
if(MPC_recv_num < MPC_own_send_num) { \
  MPC_Error_raise("Correspond receiver not found"); \
} \
MPC_recv_index=MPC_ind; \
ParentNet.coord=MPC_old_coord; \
                                        
#define MPC_ManyToMany_assign_receiver_prologue(ParentNet)\
int MPC_ind=0, MPC_co[1024]; \
int MPC_own_recv_num=0, MPC_send_num=0; \
int MPC_send_index; \
int* MPC_old_coord=ParentNet.coord; \
ParentNet.coord=MPC_co; \
for(; MPC_ind<ParentNet.power; MPC_ind++) { \
  MPC_Coord_set(&ParentNet,MPC_ind); \
 
#define MPC_ManyToMany_assign_receiver_epilogue(ParentNet)\
 if(MPC_send_num==MPC_own_recv_num) break; \
} \
if(MPC_send_num < MPC_own_recv_num) { \
  MPC_Error_raise("Correspond sender not found"); \
} \
MPC_send_index=MPC_ind; \
ParentNet.coord=MPC_old_coord; \
                                        
#define MPC_OneToOne_assign_sender_prologue(ParentNet) \
int MPC_ind=0,MPC_co[1024],MPC_send=0; \
int* MPC_old_coord=ParentNet.coord; \
for(MPC_ind=0; MPC_ind<ParentNet.power; MPC_ind++) { \
  ParentNet.coord=MPC_co; \
  MPC_Coord_set(&ParentNet,MPC_ind); \
                                                                 
#define MPC_OneToOne_assign_sender_epilogue(ParentNet) \
} \
 if(!MPC_send) { \
  MPC_Error_raise("Correspond receiver not found"); \
} \
ParentNet.coord=MPC_old_coord; \


#define MPC_OneToOne_assign_receiver_prologue(ParentNet) \
int MPC_ind=0,MPC_co[1024],MPC_recv=0; \
int* MPC_old_coord=ParentNet.coord; \
for(MPC_ind=0; MPC_ind<ParentNet.power; MPC_ind++) { \
  ParentNet.coord=MPC_co; \
  MPC_Coord_set(&ParentNet,MPC_ind); \
                                                                 
#define MPC_OneToOne_assign_receiver_epilogue(ParentNet)\
} \
 if(!MPC_recv) { \
  MPC_Error_raise("Correspond sender not found"); \
} \
ParentNet.coord=MPC_old_coord; \


                                       
#endif
