#ifndef _MPC_TREE
#define _MPC_TREE
/*****************************************************************************/
/* mpCtree.h - contains type structure, used in C files generated by mpcc    */
/*             compiler.                                                     */
/* Coded by Dm. Arapov and A.Kalinov for A.Lastovtsky 1995-1996              */
/* Release 1.10.96                                                           */
/*****************************************************************************/

#define NoMPC_Type (tMPC_Type) 0L
#define kMPC_Type 1
#define kMPC_Basic 2
#define kMPC_Enum 3
#define kMPC_Typedef 4
#define kMPC_BitField 5
#define kMPC_Array 6
#define kMPC_Pointer 7
#define kMPC_Struct 8
#define kMPC_Union 9
#define kMPC_Function 10
#define kMPC_List 11

#define MPC_UNDEFINED_COUNT -1
#define MPC_UNDEFINED_SIZE  -1

typedef unsigned char MPC_TypeKind;
typedef union MPC_Type_Node * tMPC_Type;

typedef struct {
  MPC_TypeKind Kind;
  char* Name;
  int UniqueNumber;
  int Size;
  int blindCopy;
  MPC_Rts_datatype Datatype;
} MPC_Type;

typedef struct {
  MPC_Type Base;
  int Constructor;
} MPC_Basic;

typedef MPC_Type MPC_Enum;

typedef struct {
  MPC_Type Base;
  tMPC_Type Type;
} MPC_Typedef;

typedef struct {
  MPC_Type Base;
  int Length;
  tMPC_Type Type;
} MPC_BitField;

typedef struct {
  MPC_Type Base;
  int Step;
  int Number;
  tMPC_Type Type;
  int Bit;
} MPC_Array;

typedef struct {
  MPC_Type Base;
  int Step;
  tMPC_Type Type;
} MPC_Pointer;

typedef struct {
  MPC_Type Base;
  tMPC_Type List;
} MPC_Struct;

typedef MPC_Struct MPC_Union;
typedef MPC_Type MPC_Function;

typedef struct {
  tMPC_Type Type;
  tMPC_Type Next;
} MPC_List;


union MPC_Type_Node {
 MPC_TypeKind Kind;
 MPC_Type Base;
 MPC_Basic MPC_basic;
 MPC_Enum MPC_enum;
 MPC_Typedef MPC_typedef;
 MPC_BitField MPC_bitField;
 MPC_Array MPC_array;
 MPC_Pointer MPC_pointer;
 MPC_Struct MPC_struct;
 MPC_Union MPC_union;
 MPC_Function MPC_function;
 MPC_List MPC_list;
};

typedef tMPC_Type MPC_Datatype;

# endif
